package com.bcxin.ars.dao;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.PersonDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonPolicyDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.appeal.Appeal;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface SecurityPersonDao {

	//查询保全list数据
	List<Map<Object,Object>> querySercurityPersonList(Map<Object, Object> p);

	int queryAllCnt(Map<Object, Object> p);

	Map queryInitCnt(Map<Object, Object> p);

	int queryNotInitCnt(Map<Object, Object> p);

	int queryIidentityCnt(Map<Object, Object> p);

	int queryNotIidentityCnt(Map<Object, Object> p);

	int queryNewAddCnt(Map<Object, Object> p);

	int queryLevelCnt(Map<Object, Object> p);

	SecurityPerson findById(Long id);

	SecurityPerson findByIdWithOutCache(Long id);
	/**
	 *
	 * @Decription:根据人员id批量查询
	 * @author：zhongjianhui
	 * @method  findByBetchId
	 * @date：2018/11/16 10:49
	 * @params： * @param list
	 * @return java.util.List<com.bcxin.ars.model.SecurityPerson>
	 */
	List<SecurityPerson> findByBatchId(@Param("list")List<SecurityPersonDTO> securityPersonList);

	List<SecurityPerson> findByBatchIdWithOutCache(@Param("list")List<SecurityPersonDTO> securityPersonList);

	List<SecurityPerson> findByAppeals(@Param("list")List<Appeal> list);

	List<SecurityPerson> findByAppealsWithOutCache(@Param("list")List<Appeal> list);

	List<SecurityPerson> findAllBJ(@Param("start")int start,@Param("numPerPage")int numPerPage);

	List<SecurityPerson> findByCompanyId(Long companyId);

	List<SecurityPerson> findByCompanyIdForInsurance(Long companyId);
	/**
	 *
	 * @Decription:查寻人员信息
	 * @author：zhongjianhui
	 * @method  findByCompanyIdReturnDTO
	 * @date：2018/6/19 9:47
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
	 */
	List<SecurityPersonReturnDTO> findByCompanyIdReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);
	/**
	 *
	 * @Decription:查寻人员总数
	 * @author：zhongjianhui
	 * @method  findByCompanyIdReturnDTO
	 * @date：2018/6/19 9:47
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
	 */
	Long countByCompanyIdReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);

	/*********************北京*****************************/
	/**
	 *
	 * @Decription:查寻人员信息
	 * @author：zhongjianhui
	 * @method  findByCompanyIdReturnDTO
	 * @date：2018/6/19 9:47
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
	 */
	List<SecurityPersonReturnDTO> findByCompanyIdReturnDTOForBj(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);
	/**
	 *
	 * @Decription:查寻人员总数
	 * @author：zhongjianhui
	 * @method  findByCompanyIdReturnDTO
	 * @date：2018/6/19 9:47
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
	 */
	Long countByCompanyIdReturnDTOForBj(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);

	/*********************宁夏*****************************/
	/**
	 *
	 * @Decription:查寻人员信息
	 * @author：zhongjianhui
	 * @method  findByCompanyIdReturnDTO
	 * @date：2018/6/19 9:47
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
	 */
	List<SecurityPersonReturnDTO> findByCompanyIdReturnDTOForNx(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);
	/**
	 *
	 * @Decription:查寻人员总数
	 * @author：zhongjianhui
	 * @method  findByCompanyIdReturnDTO
	 * @date：2018/6/19 9:47
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
	 */
	Long countByCompanyIdReturnDTOForNx(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);

	/**
	 *
	 * @Decription:查询特定公司人员且身份证正确
	 * @author：zhongjianhui
	 * @method  findByCompanyIdForInsuranceAndCheckId
	 * @date：2018/5/2 10:21
	 * @params： * @param companyId
	 * @return java.util.List<com.bcxin.ars.model.SecurityPerson>
	 * @param personSearchDto
	 */
	List<SecurityPerson> findByCompanyIdForInsuranceAndCheckId(PersonSearchDto personSearchDto);

	Long save(SecurityPerson person);

	void update(SecurityPerson person);

	void updateSelective(SecurityPerson person);
	/**
	 *
	 * @Decription:批量更新
	 * @author：zhongjianhui
	 * @method  batchUpdate
	 * @date：2018/11/16 17:10
	 * @params： * @param securityPersonList
	 * @return void
	 */
	void updateBatch(@Param("securityPersonList")List<SecurityPerson> securityPersonList);

	/**
	 * 批量离职人员
	 * @param idArray  人员ID列表
	 * @param updateTime 更新时间
	 * @param updateBy 更新者
	 * @param leaveDate 离职时间
	 * @author：subh
	 */
	void updateDeletePerson(@Param("idArray") Long[] idArray, @Param("updateTime") Date updateTime,@Param("updateBy")String updateBy,@Param("leaveDate")Date leaveDate);

	/**
	 * 更新人员投保状态
	 * @param idArray
	 * @param status
	 */
	void updatePersonInsuredState(@Param("ids") Long[] idArray, @Param("status") String status);

	List<SecurityPerson> search(PersonSearchDto dto);

	List<SecurityPerson> searchForExport(PersonPageSearchDto dto);

	List<SecurityPerson> searchForMap(PersonSearchDto dto);

	List<SecurityPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	Long searchCount(PersonSearchDto dto);

	Long searchForMapCount(PersonSearchDto dto);

	Long searchAllCount(PersonSearchDto dto);

	List<ReportData> findLevelReport(SecurityCompany company);

	List<ReportData> findAgeReport(SecurityCompany company);

	List<ReportData> findGenderReport(SecurityCompany company);

	List<ReportData> findNativeReport(SecurityCompany company);

	Map<String, Integer> findAbilityReport(Long id);

	List<ReportData> findTaskTypeReport(Long id);

	List<ReportData> findTaskCatalogReport(Long id);

	List<ReportData> findTaskLevelReport(Long id);

	PersonStudyDTO findPersonStudyReport(PersonStudySearchDTO dto);

	List<Long> getAllPersonStudy();

	/**
	 * 查询在线人员或应急人员
	 */
	List<SecurityPerson> findOnlineOrUrgentPersons(PersonSearchDto dto);
	/***
	 * 搜索紧急人员列表
	 * @param dto
	 * @return
	 */
	List<SecurityPerson> searchUrgentPerson(PersonSearchDto dto);

	/***
	 * 获取在线人员
	 * @param dto
	 * @return
	 */
	List<SecurityPerson> findOnlinePersons(PersonSearchDto dto);
	/***
	 * 获取紧急人员
	 * @param dto
	 * @return
	 */
	List<SecurityPerson> findUrgentPersons(PersonSearchDto dto);

	/***
	 * 批量更新人员身份认证状态
	 * @param personList 人员列表信息
	 */
	void updatePersonidentityAuthStateBatch(@Param("personList")List<SecurityPersonDTO> personList);
	/***
	 * 批量更新人员身份认证状态用于更新头像
	 * @param personList 人员列表信息
	 */
	void updatePersonidentityAuthStateBatchForPhoto(@Param("personList")List<SecurityPersonDTO> personList);

	SecurityPerson findByIdCard(String idCard);
	SecurityPerson findByIdCardAndActive(String idCard);

	String findIdPhotoByIdCard(@Param("idCard") String idCard);

	SecurityPerson findByPhone(String idCard);
	/**
	 * 根据公司id查询保安人员人数
	 * @param companyid
	 * @return
	 */
	Long countPersonByCompanyId(Long companyid);

	/**
	 * 根据公司查询已投保人数
	 * @param companyid
	 * @return
	 */
	Long countIsuredByCompanyId(Long companyid);

	Long countManByCompanyId(Long companyid);

	Long countArmPersonByCompanyId(Long companyid);

	Long countGunByCompanyId(Long companyid);

	Long countHtByCompanyId(Long companyid);

	List<PersonStudyDTO> getStudyListDesc(PersonStudySearchDTO dto);

	Long findUnPolicyByCompanyId(Long companyId);

	List<SecurityPerson> searchForTrain(PersonSearchDto dto);

	List<SecurityPerson> findForUnPolicy(Long companyId);

	List<SecurityPerson> findPolicyForLeave(Long companyId);

	List<SecurityPerson> searchForManage(PersonSearchDto dto);

	Long searchCountForManage(PersonSearchDto dto);

	List<SecurityPersonAppDto> findAppByCompanyId(Long companyId);

	Long dataStatisticsAuthReport(ReportDataSearchDto searchDto);

	Long dataStatisticsAddReport(ReportDataSearchDto searchDto);

	Long[] findUnPolicyPersonIdByCompanyId(Long companyId);

	Long countInitPersonByCompanyId(Long companyId);

	Long countAuthPersonByCompanyId(Long companyId);

	Long countUnAuthPersonByCompanyId(Long companyId);

	Long countSocialSecurityPersonByCompanyId(Long companyId);

	Long countQuotaPersonByCompanyId(Long companyId);

	List<SecurityPerson> findAll(DataSynchronizationSearchDto dto);

	SecurityPerson findActiveByIdCard(String idNum);

	SecurityPerson findActiveByPhone(String phone);

	SecurityPerson findByIdCardAndCompanyId(String idNum, Long companyId);

	SecurityPerson findByPhoneAndCompanyId(String phone, Long companyId);

	PersonLevelDto dataStatisticsLevelCountReport(Long companyId);

	Long countCertificateByCompanyId(Long companyId);

	PersonPolicyDto getPersonPolicyReportByCompanyId(Long companyId);

	Long findPolicyByCompanyId(Long companyId);


	/**
	 * 查询securityPerson有而personimg表中没有的身份证id
	 */
	List<String> findIdNumberList();


	/***
	 * 根据参数获取对象
	 * @param person 人员信息参数
	 * @return 人员信息
	 */
	SecurityPerson find(SecurityPerson person);

	/***
	 * 通过公司的areaCode同步人员的areaCode
	 * @param company
	 * @return null
	 * by llc 2018-08-01
	 */
	void updateAreaCodeByCompany(SecurityCompany company);

	/**
	 * author wjb
	 * @time 2018年8月9日14:14:16
	 * @param listSecurityPerson
	 * 批量更新相关保险信息
	 */
	void updateBXBatch(@Param("list") List<SecurityPerson> listSecurityPerson);

	/**
	 * author wjb
	 * @time 2018年8月9日14:14:16
	 * @param personIds
	 * @return
	 * 根据id数组返回保安员信息
	 */
	List<SecurityPerson> findBatch(Long[] personIds);

	List<SecurityPerson> findBatchWithOutCache(Long[] personIds);

	/****
	 * 查询未背景筛查人员
	 * @return 人员列表
	 */
	List<SecurityPerson> findUnCensor();
	/****
	 * 查询未背景筛查人员(背景筛查通过人员)
	 * @return 人员列表
	 */
	List<SecurityPerson> findRefreshUnCensor();

	/****
	 * 查询未背景筛查人员
	 * @return 人员列表
	 */
	List<SecurityPerson> findUnCensorForTest();



	//分页
	int queryAllCntPersonListtable(Map<Object, Object> p);

	List<Map<Object,Object>> queryPersonListtable(Map<Object, Object> p);

	/****
	 * 查询背景筛查不通过人员，重新背景筛查
	 * @return 人员列表
	 */
	List<SecurityPerson> findNoPassCensorStatus();

	/**
	 * 查询好人好事人员信息
	 * @param id
	 * @return
	 */
	SecurityPerson findByIdGoodThing(Long id);

	List<PersonDto> searchForPage(PersonPageSearchDto dto);

	Long searchForPageCount(PersonPageSearchDto dto);

	//保安员现实表现
	List<PersonDto> searchForReality(PersonPageSearchDto dto);
	Long searchForRealityCount(PersonPageSearchDto dto);

	List<PersonDto> searchForFrequently(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page);


	/****
	 * 旧数据同时查询
	 * @param dto
	 * @return
	 */
	Long searchForPageForOldCount(PersonPageSearchDto dto);
	/****
	 * 新数据同时查询
	 * @param dto
	 * @return
	 */
	Long searchForPageForNewCount(PersonPageSearchDto dto);


	/****
	 * 查询异常数据投资人
	 * @return 列表
	 */
	List<SecurityPerson> findExceptionData();

	void batchUpdateCertificate(@Param("list")List<SecurityPerson> updateList);

	/***
	 * 将背景筛查通过人员重置重新背景筛查
	 */
	void refreshPersonCensorStatus();
    void refreshPersonCensorCriminalStatus();
	/***
	 * 查询未持证人员
	 */
	Long getOutTimeListCount(PersonPageSearchDto dto);

	void updateBatchAuthState(@Param("list") List<Appeal> passList);

	/**
	 * 根据部门id获取人员列表包含部门id
	 * @param orgId
	 * @return
	 */
    List<SecurityPerson> findByOrgId(Long orgId);

    /**
     * 根据personId查询工作经历
     * @param id
     * @param relationId
     * @return
     */
	List<PersonDto> selectExperienceById(@Param("id") Long id, @Param("relationId") Long relationId, AjaxPageResponse<PersonDto> page);

	/**
	 * 批量更新保安员背景筛查状态
	 *
	 * @param successPersonList
	 */
	void updateCensorStatusList(@Param("lists") List<SecurityPerson> successPersonList);

	void delIdPhoto(SecurityPerson person);

	SecurityPerson findUsedByIdNum(String idnum);

	/**
	 * 查询传入集合中所有在职
	 *
	 * @param idNumbers 身份证号集合
	 * @return 在职身份证集合
	 */
	List<String> listIdNumbers(@Param("idNumbers") List<String> idNumbers);

    List<SecurityPerson> findReCensor(@Param("backGroupFrequency") int backGroupFrequency);
}
