package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SecurityCompanyInsuranceSearchDto;
import com.bcxin.ars.model.SecurityCompanyInsurance;

import java.util.List;

public interface SecurityCompanyInsuranceDao {

	/**
	 * 查询
	 * @param securityCompanyInsuranceSearchDto
	 * @return
	 */
	List<SecurityCompanyInsurance> search(SecurityCompanyInsuranceSearchDto securityCompanyInsuranceSearchDto);

	/**
	 * 保存
	 * @param securityCompanyInsurance
	 * @return
	 */
	Long save(SecurityCompanyInsurance securityCompanyInsurance);

	/**
	 * 删除
	 * @param securityCompanyInsurance
	 * @return
	 */
	Long delete(SecurityCompanyInsurance securityCompanyInsurance);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	SecurityCompanyInsurance findById(Long id);
	/**
	 * 根据company_ID查询
	 * @param id
	 * @return
	 */
	List<SecurityCompanyInsurance> findByCompanyId(Long id);
	/**
	 * 统计
	 * @return
	 */
	long count(SecurityCompanyInsuranceSearchDto dto);

	/**
	 * 更新保安奖励信息
	 * @param securityCompanyInsurance
	 */
	void update(SecurityCompanyInsurance securityCompanyInsurance);

	void deleteBySid(long company_id);

	List<SecurityCompanyInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void updateForDS(SecurityCompanyInsurance securityCompanyInsurance);

	void saveForDS(SecurityCompanyInsurance securityCompanyInsurance);


}
