package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;

import java.util.List;

public interface SbPunishDao {

	/**
	 * 查询
	 * @param sbPunishSearchDto
	 * @return
	 */
	List<SbPunish> search(SbPunishSearchDto sbPunishSearchDto);

	/**
	 * 保存
	 * @param sbPunish
	 * @return
	 */
	Long save(SbPunish sbPunish);

	/**
	 * 删除
	 * @param sbPunish
	 * @return
	 */
	Long delete(SbPunish sbPunish);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	SbPunish findById(Long id);

	/**
	 * 统计
	 * @return
	 */
	long count(SbPunishSearchDto dto);

	/**
	 * 更新保安奖励信息
	 * @param sbPunish
	 */
	void update(SbPunish sbPunish);

	List<SbPunish> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(SbPunish sbPunish);


	/**
	 * 与saas对接 根据saas主键查询
	 * @param id
	 * @return
	 */
    List<SbPunish> findByPenaltyId(Long id);

	/**
	 * 根据身份证查询
	 * @param idNum
	 * @return
	 */
	List<SbPunish> findByIdNum(String idNum);
	/**
	 * 与saas对接 根据saas主键更新
	 * @param sbPunish
	 * @return
	 */
	void updateByPenaltyId(SbPunish sbPunish);

	/**
	 * 与saas对接 根据saas主键删除
	 * @param penaltyId
	 * @return
	 */
	void deleteByPenaltyId(Long penaltyId);
}
