package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ProblemDetailReportDto;
import com.bcxin.ars.dto.ProblemPersonReportDto;
import com.bcxin.ars.dto.ProblemPersonSearchDto;
import com.bcxin.ars.model.ProblemPerson;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/***
 * 问题人员DAO层
 */
public interface ProblemPersonDao {

	ProblemPerson findById(Long id);

	ProblemPerson findByIdWithOutCache(Long id);

    /***
     * 保安
     * @param problemPerson
     */
	void save(ProblemPerson problemPerson);

    /***
     * 删除
     * @param problemPerson
     */
	void delete(ProblemPerson problemPerson);

    /***
     * 内网更新，不用更新 ：阅读状态、更新时候、更新标识、单位处理状态、单位处理意见，SaaS消息ID
     * @param problemPerson
     */
	void update(ProblemPerson problemPerson);

    /***
     * 外网更新，只更新 ：更新时候、更新标识、单位处理状态、单位处理意见
     * @param problemPerson
     */
    void updateForCompany(ProblemPerson problemPerson);
	/***
	 * 外到内同步更新
     * 外网更新到内网，更新字段有：阅读状态、更新时候、更新标识、单位处理状态、单位处理意见，SaaS消息ID
	 * @param problemPerson 问题人员信息
	 */
	void updateDS(ProblemPerson problemPerson);
	/***
	 * 问题人员查询
	 * @param searchDto 查询参数
	 * @param page 返回对象
	 */
	List<ProblemPerson> search(ProblemPersonSearchDto searchDto, AjaxPageResponse page);

	/***
	 * 公安已处理，企业未处理问题人员查询
	 * @param searchDto 查询参数
	 * @param page 返回对象
	 */
	List<ProblemPerson> searchall(ProblemPersonSearchDto searchDto, AjaxPageResponse page);

	/***
	 * 统计问题人员个数用户
	 * @return
	 */
	Long getProblemTotalCount(ProblemPersonSearchDto dto);
	/***
	 * 统计问题人员个数超过12小时
	 * @return
	 */
	Long getProblemTotalOver12(ProblemPersonSearchDto dto);

	Long getProblemFirmTotalOver12(ProblemPersonSearchDto dto);

	List<ProblemDetailReportDto> getCZReport();

	List<ProblemDetailReportDto> getXDReport();

	List<ProblemDetailReportDto> getZTReport();

	List<ProblemDetailReportDto> getWFReport();

	List<ProblemPerson> findProblemPersonList();

	ProblemPersonReportDto getProblemPersonReport(ProblemPersonSearchDto searchDto);

	/**
	 * @Decription:搜索有修改待同步到外网的数据
     * @param startDate 开始时间
     * @return
     */

	List<ProblemPerson> searchForExport(String startDate);

	/**
	 * @Decription:通过saas的消息id批量查询
	 * @param newIds
	 * @return
	 */
	List<ProblemPerson> findByNewIdArr(@Param("newIds") Long[] newIds);

	List<ProblemPerson> findByNewIdArrWithOutCache(@Param("newIds") Long[] newIds);

	/**
	 * @Decription:通过主键id批量查询
	 * @param list
	 * @return
	 */
	List<ProblemPerson> findByBatchId(@Param("list")List<ProblemPerson> list);

	List<ProblemPerson> findByBatchIdWithOutCache(@Param("list")List<ProblemPerson> list);

	/**
	 * @Decription:批量保存
	 * @param list
	 */
	void saveBatch(@Param("list")List<ProblemPerson> list);

	/***
	 * 查询问题人员类型
	 * @return
	 */
	List<String> queryProblemType(@Param("personType")String personType);
    /***
     * 查询问题人员类型企业查询
     * @param companyId 企业ID
     * @return
     */
    List<String> queryProblemTypeForCompanyId(Long companyId);
	/***
	 * 更新关联机构信息
	 * @param problemPerson  参数
	 */
	void updateOrgInfo(ProblemPerson problemPerson);
	/***
	 * 更新关联公司信息
	 * @param problemPerson  参数
	 */
	void updateCompanyInfo(ProblemPerson problemPerson);
    /***
     * 外到内数据摆渡查询
     * @param dto
     * @return
     */
    List<ProblemPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);
	/**
	 * 根据saas的消息id列表批量更新已读状态
	 * @param newIds
	 */
	void updateReadstateByidArr(@Param("newIds") Long[] newIds);

	/***
	 * 根据人员ID获取问题人员信息
	 * @param peronId 人员ID
	 * @return
	 */
	List findByPersonId(Long peronId);


    /***
     * 根据人员ID获取未处理的人员列表
     * @param problemPerson 问题人员
     * @return
     */
    List findByPersonIdForUnDispose(ProblemPerson problemPerson);
    /***
     * 查询最新背景筛查的一条
     * @param problemPerson 问题人员
     * @return
     */
    List findByPersonIdForMax(ProblemPerson problemPerson);

	/**
	 * 保存更新
	 * @param detail
	 */
	void saveSingle(ProblemPerson detail);

    /**
     * 更新消息ID
     * @param detail
     */
    void updateNewId(ProblemPerson detail);

    Long getUnDisposeQty(Long comId);
}
