package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.OrderPersonSearchDto;
import com.bcxin.ars.model.OrderPerson;

/**
 * 订单与保安人员关系数据访问类
 * @author Ethan
 */
public interface OrderPersonDao {
	
	void save(OrderPerson orderPerson);

	public OrderPerson findById(Long id);

	List<OrderPerson> findListByOrderId(OrderPersonSearchDto dto);

	List<OrderPerson> findAll();

	void removeByOrderId(OrderPerson orderPerson);

	void updateTrainInfo(OrderPerson orderPerson);

	long countByOrderId(OrderPersonSearchDto dto);

	List<OrderPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void delete(OrderPerson orderPerson);

	void saveForDS(OrderPerson orderPerson);

	void update(OrderPerson orderPerson);

	Long countByCompanyIdAndTrainType(Long companyId, String trainType);

	/**
	 * author wjb
	 * @time 2018年8月9日14:14:16
	 * @param orderPersonList
	 * 批量新增订单人员信息
	 */
    void saveBatch(List<OrderPerson> orderPersonList);
}