package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.model.Module;
import com.bcxin.ars.model.Permission;
import org.apache.ibatis.annotations.Param;

/**
 * 业务模块数据访问类
 * @author Ethan
 */
public interface ModuleDao {

	/**
	 * 获取所有业务模块
	 * @return
	 */
	List<Module> findAll();


	List<Module> findAllPerson();
	List<Module> findByUserId(Long userid);

	List<Module> findByRole(Long roleid);
	
	List<Module> findByType(Module module);

	/**
	 * 获取角色权限树形
	 * @param module
	 * @return
	 */
    List<ZTree> getModuleTree(Module module);

	/**
	 * 获取角色权限树形用于管理员
	 * @param module
	 * @return
	 */
	List<ZTree> getModuleTreeForAdmin(Module module);
    /**
     * 批量获取权限列表
     * @param ids id列表
     * @return 模块列表
     * @author subh
     */
    List<Module> findByIdArray(@Param("ids")List<Long> ids);
}
