package com.bcxin.ars.dao;

import com.bcxin.ars.dto.sb.FilerecordStatusSearchDto;
import com.bcxin.ars.model.FilerecordStatus;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface FilerecordStatusDao {
	

	/**
	 * 保存
	 * @param filerecordStatus
	 * @return
	 */
	Long save(FilerecordStatus filerecordStatus);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	FilerecordStatus findById(Long id);


	/**
	 *
	 * @Decription:查询一段日期内同步文件记录
	 * @author：wjb
	 * @method  findFilerecordStatusByTime
	 * @date：2018年9月14日09:37:18
	 * @params： * @param startDate
	 * @param endDate
	 * @return java.util.List<com.bcxin.ars.model.FilerecordStatus>
	 */
    List<FilerecordStatus> findFilerecordStatusByTime(String startDate, String endDate);

	/**
	 *
	 * @Decription:查询一段日期内同步日志记录
	 * @author：wjb
	 * @method  findFilerecordStatusByTime
	 * @date：2018年9月14日10:31:08
	 * @params： * @param filerecordStatusList,startDate,endDate
	 * @return java.util.List<com.bcxin.ars.model.FilerecordStatus>
	 */
	List<FilerecordStatus> findFilerecordStatusByTime(@Param("filerecordStatusList") List<FilerecordStatus> filerecordStatusList,@Param("startDate") String startDate, @Param("endDate") String endDate);

	/**
	 *
	 * @Decription:批量保存
	 * @author：wjb
	 * @method  saveBatch
	 * @date：2018年9月14日10:30:28
	 * @params： * @param filerecordStatusList
	 */
	void saveBatch(@Param("filerecordStatusList") List<FilerecordStatus> filerecordStatusList);

	/**
	 *
	 * @Decription:批量更新
	 * @author：wjb
	 * @method  updateBatch
	 * @date：2018年9月14日10:30:28
	 * @params： * @param filerecordStatusList
	 */
	void updateBatch(@Param("filerecordStatusList") List<FilerecordStatus> filerecordStatusList);

	List<FilerecordStatus> search(FilerecordStatusSearchDto filerecordStatus);

	Long count(FilerecordStatusSearchDto dto);
}
