package com.bcxin.ars.dao;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.DatasyncSearchDto;
import com.bcxin.ars.model.Datasync;

import java.util.List;

public interface DatasyncDao {
	
	/**
	 * 保存
	 * @param datasync
	 * @return
	 */
	Long save(Datasync datasync);

	/**
	 * 删除
	 * @param datasync
	 * @return
	 */
	Long delete(Datasync datasync);

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	Datasync findById(Long id);

	/**
	 * 根据bid查询
	 * @param bid
	 * @return
	 */
	Datasync findByBid(Long bid);
	

	/**
	 * 更新信息
	 * @param datasync
	 */
	void update(Datasync datasync);

	/**
	 * 查询
	 * @param datasyncSearchDto
	 * @return
	 */
	List<Datasync> search(DatasyncSearchDto datasyncSearchDto);

	/**
	 * 统计
	 * @return
	 */
	long count(DatasyncSearchDto dto);

	List<Datasync> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/***
	 * 保存审批信息 for数据同步
	 */
	void saveForDS(Datasync datasync);


}
