package com.bcxin.ars.dao;

import java.util.List;
import com.bcxin.ars.model.ComStateChangeLog;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ComStateChangeLogPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

/**
 * 自招单位状态变更日志Dao接口
 * 
 * @author lin
 * @date 2020-11-04
 */
public interface ComStateChangeLogDao{

    /****
     * 删除
     * @param comStateChangeLog
     * @return
     */
    int delete(ComStateChangeLog ComStateChangeLog);

    /****
     * 保存
     * @param comStateChangeLog
     * @return
     */
    int save(ComStateChangeLog comStateChangeLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
        ComStateChangeLog findById(Long id);

    /****
     * 选择修改
     * @param comStateChangeLog
     * @return
     */
    int updateSelective(ComStateChangeLog comStateChangeLog);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<ComStateChangeLog> searchForPage(ComStateChangeLogPageSearchDto searchDto, AjaxPageResponse<ComStateChangeLog> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComStateChangeLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComStateChangeLog> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComStateChangeLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComStateChangeLog> findByBatchId(@Param("list") List<ComStateChangeLog> list);


}
