package com.bcxin.backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.backend.dao.mapper.BgScreeningUserResultMapper;
import com.bcxin.backend.entity.BgScreeningUser;
import com.bcxin.backend.entity.BgScreeningUserResult;
import com.bcxin.backend.service.BgScreeningUserResultService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description: 背筛问题记录表service
 * author: linchunpeng
 * date:  2023-07-13 14:30
 */
@Slf4j
@Service
public class BgScreeningUserResultServiceImpl extends ServiceImpl<BgScreeningUserResultMapper, BgScreeningUserResult> implements BgScreeningUserResultService {

    /**
     * description：根据身份证列表，查询问题记录
     * author：linchunpeng
     * date：2023/7/18
     */
    @Override
    public List<BgScreeningUserResult> findByIdnumList(List<String> idnumList) {
        QueryWrapper<BgScreeningUserResult> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("DOCUMENTID", idnumList);//身份证列表
        queryWrapper.orderBy(true, true, "created");
        return this.list(queryWrapper);
    }

}
