package com.bcxin.backend.controller;


import com.bcxin.backend.dto.request.ManualBgRequest;
import com.bcxin.backend.service.BgScreeningService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

@Slf4j
@RestController
@RequestMapping("/bg/screening")
public class BgScreeningController {

    @Autowired
    private BgScreeningService bgScreeningService;

    /**
     * description：手动背筛
     * author：linchunpeng
     * date：2023/7/19
     */
    @PostMapping("/manual")
    public void manual(@RequestBody ManualBgRequest request) throws IOException {
        if (request.getManualType() == 1) {
            bgScreeningService.runManual(request.getIdnumList());
        } else if (request.getManualType() == 2) {
            bgScreeningService.runNewRecruit();
        } else if (request.getManualType() == 3) {
            bgScreeningService.runIntervals();
        }
    }

}
