/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.components;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collection;

public interface JsonProvider {
    public <T> String getJson(T var1);

    public <T> T toObject(Class<T> var1, String var2);

    public <T> Collection<T> toObjects(Class<T> var1, String var2);

    public static class DefaultJsonProvider
    implements JsonProvider {
        @Override
        public <T> String getJson(T data) {
            if (data == null) {
                return null;
            }
            return JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }

        @Override
        public <T> T toObject(Class<T> tClass, String json) {
            return (T)JSON.parseObject((String)json, tClass);
        }

        @Override
        public <T> Collection<T> toObjects(Class<T> tClass, String json) {
            return JSON.parseArray((String)json, tClass);
        }
    }
}

