/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.signature.config.FileWriteConfig;
import com.bcxin.signature.util.ftp.FtpWriteConnection;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpWriteFactory {
    private static final Logger log = LoggerFactory.getLogger(FtpWriteFactory.class);
    private static final ArrayBlockingQueue<FtpWriteConnection> arrayBlockingQueue = new ArrayBlockingQueue(FileWriteConfig.ftpConnectionSize);

    protected FtpWriteFactory() {
        log.info("init ftpConnectionSize " + FileWriteConfig.ftpConnectionSize);
        for (int i = 0; i < FileWriteConfig.ftpConnectionSize; ++i) {
            arrayBlockingQueue.offer(new FtpWriteConnection());
        }
    }

    public FtpWriteConnection getFtp() {
        FtpWriteConnection poll = null;
        try {
            poll = (FtpWriteConnection)arrayBlockingQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return poll;
    }

    public boolean relase(FtpWriteConnection ftp) {
        return arrayBlockingQueue.offer(ftp);
    }

    public void remove(FtpWriteConnection ftp) {
        arrayBlockingQueue.remove(ftp);
    }

    public void close() {
        for (FtpWriteConnection connection : arrayBlockingQueue) {
            try {
                connection.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

