/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.scheduling;

import com.bcxin.signature.components.DocumentPushProvider;
import com.bcxin.signature.scheduling.ScheduleJobAbstract;
import com.bcxin.signature.service.SignatureService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class CertificateScheduleJob
extends ScheduleJobAbstract {
    private static final Logger logger = LoggerFactory.getLogger(CertificateScheduleJob.class);
    private final SignatureService signatureService;
    private final DocumentPushProvider documentPushProvider;

    public CertificateScheduleJob(SignatureService signatureService, DocumentPushProvider documentPushProvider) {
        this.signatureService = signatureService;
        this.documentPushProvider = documentPushProvider;
    }

    @Scheduled(fixedRate=180000L)
    public void step1_push() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String traceId = UUID.randomUUID().toString();
        logger.error("{} begin to execute step1_push", (Object)traceId);
        try {
            this.documentPushProvider.push(DocumentPushProvider.DocumentType.Certificate);
        }
        finally {
            stopWatch.stop();
            logger.error("{} done for executing step1_push, cost {} seconds", (Object)traceId, (Object)stopWatch.getTotalTimeSeconds());
        }
    }

    @Scheduled(fixedRate=180000L)
    public void signatureJTLZDocument() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String traceId = UUID.randomUUID().toString();
        logger.error("{} begin to execute signatureJTLZDocument", (Object)traceId);
        try {
            this.documentPushProvider.push(DocumentPushProvider.DocumentType.Document);
        }
        finally {
            stopWatch.stop();
            logger.error("{} done for executing signatureJTLZDocument, cost {} seconds", (Object)traceId, (Object)stopWatch.getTotalTimeSeconds());
        }
    }

    @Deprecated
    @Scheduled(fixedRate=300000L)
    public void signatureJTLZ_FZ() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String traceId = UUID.randomUUID().toString();
        logger.error("{} begin to execute cancel_push", (Object)traceId);
        try {
            this.documentPushProvider.cancel_push();
        }
        finally {
            stopWatch.stop();
            logger.error("{} done for executing cancel_push, cost {} seconds", (Object)traceId, (Object)stopWatch.getTotalTimeSeconds());
        }
    }
}

