/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    public static final int RESCODE_SUCCESS = 1000;
    public static final int RESCODE_SUCCESS_MSG = 1001;
    public static final int RESCODE_EXCEPTION = 1002;
    public static final int RESCODE_NOLOGIN = 1003;
    public static final int RESCODE_NOEXIST = 1004;
    public static final int RESCODE_NOAUTH = 1005;
    public static final String JWT_ID = "blb";
    public static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";
    public static final int JWT_TTL_HOUR = 3600000;
    public static final int JWT_TTL = 1471228928;
    public static final int JWT_REFRESH_INTERVAL = 3300000;
    public static final int JWT_REFRESH_TTL = 604800000;

    private static SecretKey generalKey(String stringKey) {
        byte[] encodedKey = Base64.decodeBase64((String)stringKey);
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(new Date(System.currentTimeMillis())).setSubject(subject).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String createJWT(Map<Object, Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String createJWT(Map<String, Object> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWT(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(subject).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 3600000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWT(Map<String, Object> subject, String jwt_secret) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(jwt_secret));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWTObject(Object subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString((Object)subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static Claims parseJWT(String jwttoken, String stringKey) throws Exception {
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)JwtUtil.generalKey(stringKey)).parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static String parseData(String jwttoken) {
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)JwtUtil.generalKey(JWT_SECRET)).parseClaimsJws(jwttoken).getBody();
        return claims.getSubject();
    }

    public static boolean isTokenExpired(String jwttoken) {
        try {
            Claims claims = JwtUtil.parseJWT(jwttoken, JWT_SECRET);
            Date expiredDate = claims.getExpiration();
            return expiredDate.before(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap p = Maps.newHashMap();
        p.put("sealUrl", "http://test2.pss360.cn/getResource.do?path=2019-06-18/156084108649591506.jpg");
        p.put("sealUrl1", "http://test2.pss360.cn/getResource.do?path=2019-06-18/156084108649591506.jpg");
        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJvbmVJbWciOiJodHRwczovL2JjeGluLXNhYXMtcHJvZC5vYnMuY24tbm9ydGgtMS5teWh1YXdlaWNsb3VkLmNvbTo0NDMvdXBsb2FkJTJGMjAyMS0wMi0yNCUyRjE2MTQxNDY2NzM5NDE1MTc5NzAuanBnIiwidHdvSW1nIjoiaHR0cHM6Ly9iY3hpbi1zYWFzLXByb2Qub2JzLmNuLW5vcnRoLTEubXlodWF3ZWljbG91ZC5jb206NDQzL3VwbG9hZCUyRjIwMjEtMDItMjQlMkYxNjE0MTQ2NjczOTQxNTE3OTcwLmpwZyJ9";
        Claims claims = JwtUtil.parseJWT(token, JWT_SECRET);
        String subject = claims.getSubject();
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String response = HttpUtil.post((String)"http://localhost:8888/api/gate/companyRegister", (Map)requestMap);
        Console.log((String)"response:{}", (Object[])new Object[]{response});
        Console.log((Object)DateUtil.currentSeconds());
    }
}

