/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.models;

import com.bcxin.runtime.domain.messages.enums.ProcessesStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import com.bcxin.saas.core.models.EntityBase;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="shared_messages")
public class MessageEntity
extends EntityBase<String>
implements IAggregate {
    private static final long serialVersionUID = -4836070850643712525L;
    @Id
    @Column(length=50)
    private String id;
    @Column(name="title", length=500)
    private String title;
    @Column(name="content", nullable=false, length=5000)
    private String content;
    @Column(name="parameter_json", length=2000)
    private String parameterJson;
    @Column(name="sender_id", nullable=false, length=100)
    private String senderId;
    @Column(name="receiver", nullable=false, length=100)
    private String receiver;
    @Column(name="message_type", nullable=false)
    private MessageType messageType;
    @Column(name="receiver_type", nullable=false)
    private ReceiverType receiverType;
    @Column(name="status", nullable=false)
    private ProcessesStatus status;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="last_processed_time")
    private Timestamp lastProcessedTime;
    @Column(name="business_number", length=500)
    private String businessNumber;
    @Column(name="unique_id", nullable=false, length=200)
    private String uniqueId;

    public void makeStatus(boolean isSuccess) {
        this.setStatus(isSuccess ? ProcessesStatus.Done : ProcessesStatus.Error);
        this.setLastProcessedTime(Timestamp.from(Instant.now()));
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getParameterJson() {
        return this.parameterJson;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public ReceiverType getReceiverType() {
        return this.receiverType;
    }

    public ProcessesStatus getStatus() {
        return this.status;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    public String getBusinessNumber() {
        return this.businessNumber;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setParameterJson(String parameterJson) {
        this.parameterJson = parameterJson;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setReceiverType(ReceiverType receiverType) {
        this.receiverType = receiverType;
    }

    public void setStatus(ProcessesStatus status) {
        this.status = status;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setLastProcessedTime(Timestamp lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }

    public void setBusinessNumber(String businessNumber) {
        this.businessNumber = businessNumber;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEntity)) {
            return false;
        }
        MessageEntity other = (MessageEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$parameterJson = this.getParameterJson();
        String other$parameterJson = other.getParameterJson();
        if (this$parameterJson == null ? other$parameterJson != null : !this$parameterJson.equals(other$parameterJson)) {
            return false;
        }
        String this$senderId = this.getSenderId();
        String other$senderId = other.getSenderId();
        if (this$senderId == null ? other$senderId != null : !this$senderId.equals(other$senderId)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        ReceiverType this$receiverType = this.getReceiverType();
        ReceiverType other$receiverType = other.getReceiverType();
        if (this$receiverType == null ? other$receiverType != null : !this$receiverType.equals(other$receiverType)) {
            return false;
        }
        ProcessesStatus this$status = this.getStatus();
        ProcessesStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Timestamp this$lastProcessedTime = this.getLastProcessedTime();
        Timestamp other$lastProcessedTime = other.getLastProcessedTime();
        if (this$lastProcessedTime == null ? other$lastProcessedTime != null : !((Object)this$lastProcessedTime).equals(other$lastProcessedTime)) {
            return false;
        }
        String this$businessNumber = this.getBusinessNumber();
        String other$businessNumber = other.getBusinessNumber();
        if (this$businessNumber == null ? other$businessNumber != null : !this$businessNumber.equals(other$businessNumber)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        return !(this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $parameterJson = this.getParameterJson();
        result = result * 59 + ($parameterJson == null ? 43 : $parameterJson.hashCode());
        String $senderId = this.getSenderId();
        result = result * 59 + ($senderId == null ? 43 : $senderId.hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        ReceiverType $receiverType = this.getReceiverType();
        result = result * 59 + ($receiverType == null ? 43 : $receiverType.hashCode());
        ProcessesStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Timestamp $lastProcessedTime = this.getLastProcessedTime();
        result = result * 59 + ($lastProcessedTime == null ? 43 : ((Object)$lastProcessedTime).hashCode());
        String $businessNumber = this.getBusinessNumber();
        result = result * 59 + ($businessNumber == null ? 43 : $businessNumber.hashCode());
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        return result;
    }

    public String toString() {
        return "MessageEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", parameterJson=" + this.getParameterJson() + ", senderId=" + this.getSenderId() + ", receiver=" + this.getReceiver() + ", messageType=" + this.getMessageType() + ", receiverType=" + this.getReceiverType() + ", status=" + this.getStatus() + ", createdTime=" + this.getCreatedTime() + ", lastProcessedTime=" + this.getLastProcessedTime() + ", businessNumber=" + this.getBusinessNumber() + ", uniqueId=" + this.getUniqueId() + ")";
    }
}

