package com.bcxin.backend.domain.utils;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @program: yesign
 * @description:
 * @author: yuzhiqiang
 * @create: 2019-08-23 15:10
 **/
public class HttpClientUtilSsl {

    /**
     * 发送post请求
     * @param url
     * @param map
     * @param charset
     * @return
     */
    public static String doPost(String url, Map<String,String> map, String charset){
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try{
            httpClient = new SSLClient();
            httpPost = new HttpPost(url);
            //设置参数
            List<NameValuePair> list = new ArrayList<NameValuePair>();
            Iterator iterator = map.entrySet().iterator();
            while(iterator.hasNext()){
                Map.Entry<String,String> elem = (Map.Entry<String, String>) iterator.next();
                list.add(new BasicNameValuePair(elem.getKey(),elem.getValue()));
            }
            if(list.size() > 0){
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list,charset);
                httpPost.setEntity(entity);
            }
            HttpResponse response = httpClient.execute(httpPost);
            if(response != null){
                HttpEntity resEntity = response.getEntity();
                if(resEntity != null){
                    result = EntityUtils.toString(resEntity,charset);
                }
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return result;
    }

    /**
     * 发送get请求
     * @param url       链接地址
     * @param charset   字符编码，若为null则默认utf-8
     * @return
     */
    public static String doGet(String url,String charset){
        if(null == charset){
            charset = "utf-8";
        }
        HttpClient httpClient = null;
        HttpGet httpGet= null;
        String result = null;

        try {
            httpClient = new SSLClient();
            httpGet = new HttpGet(url);

            HttpResponse response = httpClient.execute(httpGet);
            if(response != null){
                HttpEntity resEntity = response.getEntity();
                if(resEntity != null){
                    result = EntityUtils.toString(resEntity,charset);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }
    public static String doPostOfJson(String url, String json) {
        // 创建Httpclient对象
       // CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            httpClient = new SSLClient();
            // 创建Http Post请求
            HttpPost httpPost = new HttpPost(url);
            // 创建请求内容
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity(entity);
            // 执行http请求
            response = (CloseableHttpResponse) httpClient.execute(httpPost);
            resultString = EntityUtils.toString(response.getEntity(), "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();

        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return resultString;
    }
    public static void main(String[] args) throws Exception {
        // demo:代理访问
		/*String url = "http://111.20.164.182:9870/cloudSign/getPublicKey";
		String para = "{\"thirdUserId\": \"test\",\"command\":\"delayCert\",\"pin\":\"8888888\",\"alg\":\"SM2\",\"len\":\"256\",\"CN\":\"commonName\",\"OU\":\"organizationUnit\",\"O\":\"organizationName\",\"L\":\"localityName\",\"S\":\"陕西省\",\"C\":\"西安市\"}";
		String sr = sendJsonPost(url, para, false);
		System.out.println(sr);*/
        //String url = "https://localhost:8080/esm/services/r/WebSign/GetSealJson";
        String url = "https://localhost:8080/esm/v1/findSealsByAccount";
        String param="{\"signerAccount\":\""+"zaixian"+"\"}";
        String sr = HttpClientUtilSsl.doPostOfJson(url, param);
        /*Map<String,String> para = new HashedMap();
        para.put("sercode","zaixian");
        //String para = "{\"sercode\":\"zaixian\"}";
        String sr = doPost(url,para,"utf-8");*/
        System.out.println(sr);
    }
}
