package com.bcxin.backend.domain.system.dispatch.snapshots;

import lombok.Data;

import java.util.Map;

@Data
public abstract class ValueSnapshot {
    private Map<String, Object> additionalParams;

    protected abstract PriorityValue getPriority();

    static enum PriorityValue {
        Domain(100),
        Depart(90),
        User(80),
        Normal(1);
        private final int value;

        PriorityValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }
}
