package com.bcxin.backend.domain.system.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.Map;

/**
 * 配置各地区调用摆渡服务次数
 */
@Data
@Configuration
@ConfigurationProperties("saas.backend")
public class SyncLimiterConfig {
    private int interval;
    private int defaultMax;
    private Map<String, Collection<Limiter>> replenishRate;

    @Data
    public static class Limiter {
        private int max;
        private String targetUrl;
        private String ftpUrl;
    }
}
