package com.bcxin.backend.domain.approval.services.impl;
import com.bcxin.backend.core.utils.RetryUtil;
import com.bcxin.backend.domain.approval.entities.source.BjApprovalDataEntity;
import com.bcxin.backend.domain.approval.entities.dest.BjGaServiceStatisticOdsEntity;
import com.bcxin.backend.domain.approval.repositories.dest.BjGaServiceStatisticOdsRepository;
import com.bcxin.backend.domain.approval.services.BjApprovalDataPushService;
import com.bcxin.backend.domain.approval.utils.DataTransformUtil;
import com.bcxin.backend.domain.approval.repositories.source.BjApprovalDataRepository;

import io.jsonwebtoken.lang.Collections;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;

@Slf4j
@Service
@ConditionalOnProperty(prefix = "myapps.bj-approval-data-push", name = "enable", havingValue = "true")
public class BjApprovalDataPushServiceImpl implements BjApprovalDataPushService {

    private BjApprovalDataRepository approvalDataRepository;
    private BjGaServiceStatisticOdsRepository gaServiceStatisticOdsRepository;
    public BjApprovalDataPushServiceImpl(BjApprovalDataRepository approvalDataRepository,
                                         BjGaServiceStatisticOdsRepository gaServiceStatisticOdsRepository){
        this.approvalDataRepository = approvalDataRepository;
        this.gaServiceStatisticOdsRepository = gaServiceStatisticOdsRepository;
    }



    @Override
    public void pushApprovalDataFromDate(Date startDate) {
        try {
            RetryUtil.execute(()->{
                Collection<BjApprovalDataEntity> approvalDataEntities = approvalDataRepository.findFromDate(startDate);
                Collection<BjGaServiceStatisticOdsEntity> bjGaServiceStatisticOdsEntities =
                        DataTransformUtil.trans2BjGaServiceStatisticOdsEntity(approvalDataEntities);
                pushData(bjGaServiceStatisticOdsEntities);
                return true;
            },3);
            log.info("日期：{}，推送审批数据成功！",startDate);
        }catch (Exception e){
            log.error("日期：{}，推送审批数据异常：{}",startDate,e);
            throw e;
        }
    }

    /**
     * 初始化数据，提交时间从某天开始（这里的created目前当做提交时间）
     * @param startDate
     */
    @Override
    public void pushApprovalDataInit(Date startDate) {
        try {
            Collection<BjApprovalDataEntity> approvalDataEntities = approvalDataRepository.findCreatedFromDate(startDate);
            Collection<BjGaServiceStatisticOdsEntity> bjGaServiceStatisticOdsEntities =
                    DataTransformUtil.trans2BjGaServiceStatisticOdsEntity(approvalDataEntities);
            pushData(bjGaServiceStatisticOdsEntities);
            log.info("日期：{}，初始化推送审批数据成功！", startDate);
        }catch(Exception e){
            log.info("日期：{}，初始化推送审批数据异常：{}！", e);
        }
    }

    @Override
    public void pushData(Collection<BjGaServiceStatisticOdsEntity> bjGaServiceStatisticOdsEntities) {
        if (!Collections.isEmpty(bjGaServiceStatisticOdsEntities)) {
            gaServiceStatisticOdsRepository.saveAll(bjGaServiceStatisticOdsEntities);
        }
    }
}
