/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.enums.SxCertDn;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import com.bcxin.backend.domain.utils.FileUtils;
import com.bcxin.backend.domain.utils.MD5Util;
import com.bcxin.backend.domain.utils.SM.SM3Utils;
import io.jsonwebtoken.lang.Collections;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ShanXiInSignatureToPDFCompare
implements QzSignatureStrategy {
    private static final Logger log = LoggerFactory.getLogger(ShanXiInSignatureToPDFCompare.class);
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.signature.unSignaturePDF}")
    String unSignatureSignatureToPDFServiceImplPDF;
    @Value(value="${myapps.signature.signaturePDF}")
    String signaturePDF;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Value(value="${myapps.signature.cgiApi}")
    String cgiApi;
    @Value(value="${myapps.storage.root}")
    String rootPath;
    @Autowired
    private ConvertServiceImpl convertService;
    @Autowired
    private Environment cenv;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    @Override
    public void cerPDF() {
        this.createPDF();
    }

    private boolean activateXMPSignQuicklyExCGI() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject json = new JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001009256");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in");
            json.put("out", (Object)"/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", (Object)405);
            pos.put("centerY", (Object)312);
            pos.put("page", (Object)1);
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            String ret = HttpUtil.post((String)this.cgiApi, (String)json.toJSONString());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return false;
            }
            JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            return "1".equals(String.valueOf(result.get((Object)"code")));
        }
        catch (Exception e) {
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI message:" + e.getMessage());
            return false;
        }
    }

    private static String handleSignParam(String path, String fileName) {
        SxCertDn sxCertDn = SxCertDn.getByAreaName(fileName, true, "com-prod");
        if (sxCertDn == null) {
            return "";
        }
        LinkedHashMap<String, HashMap> m1 = new LinkedHashMap<String, HashMap>();
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        byte[] base = FileUtils.readFileTobytes(path);
        content.put("fileData", Base64.encodeBase64String((byte[])base));
        content.put("appId", sxCertDn.getAppId());
        content.put("certId", sxCertDn.getCertId());
        content.put("fileName", fileName);
        ArrayList list = new ArrayList();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("sealId", sxCertDn.getSealId());
        data.put("pageNum", "1");
        data.put("zx", "96");
        data.put("zy", "193");
        data.put("certDN", sxCertDn.getCertDN());
        data.put("secretKey", sxCertDn.getSecretKey());
        data.put("keyPin", "");
        list.add(data);
        content.put("signList", list);
        m1.put("message_header", ShanXiInSignatureToPDFCompare.handleHeader1(content, sxCertDn.getAppKey()));
        m1.put("message_content", content);
        JSONObject o1 = new JSONObject(m1);
        String re = o1.toJSONString();
        return re;
    }

    private static HashMap handleHeader1(HashMap content, String appKey) {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("sign", "");
        header.put("ctime", DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        header.put("version", "1.0");
        JSONObject o = new JSONObject((Map)content);
        String re1 = o.toJSONString();
        String mac = null;
        try {
            mac = SM3Utils.hmac(appKey, re1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        header.put("hmac", mac);
        return header;
    }

    private static HashMap handleHeader(String re1, String key) {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("sign", "");
        header.put("ctime", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        header.put("version", "1.0");
        String mac = null;
        try {
            mac = SM3Utils.hmac(key, re1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        header.put("hmac", mac);
        return header;
    }

    private void createPDF() {
        String sql = "select id,template_url,`data`,status,business_id,last_processed_time,certificatedate,last_processed_result from obpm2_security.signature_queues where `status`=0 order by certificatedate desc limit 0,300";
        List queues = null;
        try {
            queues = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<SignatureQueuesDTO>(){

                public SignatureQueuesDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aResultSet:" + rs);
                    SignatureQueuesDTO dto = new SignatureQueuesDTO();
                    dto.setId(rs.getString("id"));
                    dto.setTemplate_url(rs.getString("template_url"));
                    dto.setData(rs.getString("data"));
                    dto.setStatus(rs.getString("status"));
                    dto.setBusiness_id(rs.getString("business_id"));
                    dto.setLast_processed_time(rs.getDate("last_processed_time"));
                    dto.setCertificatedate(rs.getDate("certificatedate"));
                    dto.setLast_processed_result(rs.getString("last_processed_result"));
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aSignatureQueuesDTO:" + JSON.toJSONString((Object)dto));
                    return dto;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Collections.isEmpty(queues)) {
            return;
        }
        for (SignatureQueuesDTO queuesDTO : queues) {
            this.accept(queuesDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFileMultiPart(String url, Map<String, ContentBody> reqParam) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        System.err.println("=======> existsPdfCopy.signPdf.postFileMultiPart.url:" + url);
        try {
            HttpPost httppost = new HttpPost(url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(15000).setConnectionRequestTimeout(15000).setSocketTimeout(115000).build();
            httppost.setConfig(defaultRequestConfig);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            for (Map.Entry<String, ContentBody> param : reqParam.entrySet()) {
                multipartEntityBuilder.addPart(param.getKey(), param.getValue());
            }
            HttpEntity reqEntity = multipartEntityBuilder.build();
            httppost.setEntity(reqEntity);
            System.err.println("got response");
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    return string;
                }
            }
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void signPdf(String url, String fileName) throws IOException {
        HashMap<String, ContentBody> reqParam = new HashMap<String, ContentBody>();
        File file = new File(this.rootPath + this.tempPDF.replace("temp", "in") + "/" + fileName);
        String token = MD5Util.string2MD5("BCXIN" + fileName + DateUtil.today());
        reqParam.put("token", (ContentBody)new StringBody(token, ContentType.MULTIPART_FORM_DATA));
        reqParam.put("fileName", (ContentBody)new StringBody(fileName, ContentType.MULTIPART_FORM_DATA));
        reqParam.put("signpdf", (ContentBody)new FileBody(file, ContentType.MULTIPART_FORM_DATA));
        System.err.println("=======> existsPdfCopy.signPdf.reqParam:" + reqParam);
        String res = ShanXiInSignatureToPDFCompare.postFileMultiPart(url, reqParam);
        Map re = (Map)JSONObject.parseObject((String)res, Map.class);
        System.err.println("=======> existsPdfCopy.signPdf.re:" + re);
        if (null != re && !re.isEmpty()) {
            String errorCode = (String)re.get("errorCode");
            if ("0".equals(errorCode)) {
                String base64 = (String)re.get("file");
                base64 = base64.replace("&#43;", "+");
                byte[] fileData = org.bouncycastle.util.encoders.Base64.decode((String)base64);
                FileUtils.write(fileData, this.rootPath + this.tempPDF.replace("temp", "out") + "/" + fileName);
                System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signPdf.ret\uff1a\u5b8c\u6210");
            } else {
                System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signPdf.ret\uff1a" + re.get("errorText"));
            }
        } else {
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signPdf.ret\uff1a\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public static void main(String[] args) throws IOException {
    }

    private void accept(SignatureQueuesDTO queue) {
        Long a = System.currentTimeMillis();
        SignatureData data = (SignatureData)JSONObject.parseObject((String)queue.getData(), SignatureData.class);
        SxCertDn sxCertDn = SxCertDn.getByAreaName(data.getCertificatefrom(), false, this.cenv.getProperty("spring.profiles.active"));
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aaccept.sxCertDn:" + (Object)((Object)sxCertDn));
        if (sxCertDn == null || StringUtils.isEmpty((CharSequence)sxCertDn.getSealId())) {
            String sql = "UPDATE obpm2_security.signature_queues s SET s.status=2,s.last_processed_time=NOW(),s.last_processed_result='\u8bc1\u4e66\u6240\u5c5e\u533a\u57df\u65e0\u6709\u6548\u7535\u5b50\u5370\u7ae0' WHERE s.id=" + queue.getId() + ";";
            this.jdbcTemplate.update(sql);
            return;
        }
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aaccept.sxCertDn.SealId:" + sxCertDn.getSealId());
        data.setUnSignaturePDF(this.tempPDF + "/" + sxCertDn.toString() + "queueId_" + queue.getId() + ".temp");
        String toDay = data.getFzDate();
        if (StringUtils.isEmpty((CharSequence)toDay)) {
            toDay = DateUtil.today();
        }
        data.setZYear(toDay.split("-")[0]);
        data.setZMonth(toDay.split("-")[1]);
        data.setZDay(toDay.split("-")[2]);
        data.setHeadphoto(data.getHeadphoto().startsWith("http") ? data.getHeadphoto() : this.urlHead + data.getHeadphoto());
        String result = "";
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(queue.getTemplate_url());
        sharedConvertDto.setFormData(data);
        try {
            result = this.convertService.execConvertHtmltopdfForTemp(sharedConvertDto);
        }
        catch (IOException e) {
            result = "";
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
        }
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\uff08\u65e0\u7ae0PDF\u751f\u6210\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1aaccept.result:" + result);
        String sql = StringUtils.isNotEmpty((CharSequence)result) ? "UPDATE obpm2_security.signature_queues s SET s.status=3,s.last_processed_time=NOW(),s.last_processed_result='PDF\u5df2\u751f\u6210\u5f85\u7b7e\u7ae0' WHERE s.id=" + queue.getId() + ";" : "UPDATE obpm2_security.signature_queues s SET s.status=2,s.last_processed_time=NOW(),s.last_processed_result='PDF\u751f\u6210\u5931\u8d25' WHERE s.id=" + queue.getId() + ";";
        this.jdbcTemplate.update(sql);
        System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u751f\u6210\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    @Override
    public void delInPDF() {
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(this.tempPDF);
        this.convertService.delInPDF(sharedConvertDto);
    }

    @Override
    public void signQuicklyExCGI() {
        Long a = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tempUrl", (Object)this.tempPDF);
        jsonObject.put("formData", (Object)230);
        try {
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            String tempUrl = jsonObject.getString("tempUrl");
            String formData = jsonObject.getString("formData");
            sharedConvertDto.setTempUrl(tempUrl);
            sharedConvertDto.setFormData(formData);
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u524d\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            this.convertService.existsPdfCopy(sharedConvertDto);
            this.convertService.delInPDF(this.tempPDF);
            File[] fis = this.convertService.findInFile(sharedConvertDto.getTempUrl());
            System.err.println("=======> existsPdfCopy.fis:" + fis);
            if (fis != null) {
                for (File file : fis) {
                    new Thread(() -> {
                        try {
                            System.err.println("=======> existsPdfCopy.signPdf:star");
                            this.signPdf(this.cgiApi, file.getName());
                        }
                        catch (IOException e) {
                            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signPdf error\uff1a" + e.getMessage());
                        }
                    }).start();
                    Thread.sleep(500L);
                }
            }
            System.err.println("=======> existsPdfCopy.signPdf:end");
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u540e\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.\u7b7e\u7ae0\u63a5\u53e3\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeStatus() {
        String updateSql = "update security_flow.signature_queues set status = '0' where status = '3' and TIMESTAMPDIFF(HOUR, last_processed_time, NOW()) > 3";
        this.jdbcTemplate.update(updateSql);
    }

    @Override
    public void scan() {
        StringBuilder sb = new StringBuilder();
        try {
            String[] failS;
            Long a = System.currentTimeMillis();
            String pdfFile = "/uploads/pdf/dianziqianzhangout/out";
            String dayFilePath = pdfFile.replace("/out", "/" + DateUtil.today());
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            sharedConvertDto.setTempUrl(pdfFile);
            sharedConvertDto.setFormData(null);
            String result = this.convertService.existsScanSignatureByDayFile(sharedConvertDto);
            if (StringUtils.isEmpty((CharSequence)result)) {
                System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.result\uff1a\u7a7a");
                return;
            }
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.\u6279\u91cf\u526a\u5207\u5230\u65e5\u671f\u76ee\u5f55\u7ed3\u675f\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
            JSONObject json = JSONObject.parseObject((String)result);
            Object success = json.get((Object)"success");
            Object fail = json.get((Object)"fail");
            List<String> failList = null;
            String successFile = "";
            String failFile = "";
            if (success != null) {
                successFile = (String)success;
            }
            if (fail != null && StringUtils.isNotEmpty((CharSequence)(failFile = (String)fail)) && (failS = failFile.replace(".pdf", "").replace("queueId_", "").split(",")).length > 0) {
                failList = Arrays.asList(failS);
            }
            String fileNames = successFile + failFile;
            new Thread(() -> {
                try {
                    this.convertService.delSetFtpFile(this.tempPDF, fileNames);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.\u526a\u5207\u5230\u65e5\u671f\u76ee\u5f55\u64cd\u4f5c\u8fc7\u7684\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            if (StringUtils.isNotEmpty((CharSequence)successFile)) {
                String[] successSplit;
                for (String string : successSplit = successFile.split(",")) {
                    String successFilePath = dayFilePath + "/" + string;
                    String id = string.split("queueId_")[1].replace(".pdf", "");
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.id:" + id);
                    String sqlqueue = "select business_id from obpm2_security.signature_queues where id=" + id + ";";
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.sqlqueue:" + sqlqueue);
                    Map map = this.jdbcTemplate.queryForMap(sqlqueue);
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.map:" + map);
                    String business_id = map.get("business_id") == null ? "" : map.get("business_id").toString();
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.business_id:" + business_id);
                    if (StringUtils.isEmpty((CharSequence)business_id)) {
                        String sql = "UPDATE obpm2_security.signature_queues s SET s.status=2,s.last_processed_time=NOW(),s.last_processed_result='\u7b7e\u7ae0\u5bf9\u8c61\u4e1a\u52a1\u6765\u6e90\u4e0d\u5b58\u5728' WHERE s.id =" + id + ";";
                        System.out.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.sql:" + sql);
                        this.jdbcTemplate.update(sql);
                        continue;
                    }
                    String updateSql = "UPDATE security_flow.tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"2\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_CERTIFICATEDATE=IFNULL(ITEM_CERTIFICATEDATE,NOW()),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u5b8c\u6210\",ITEM_ATTACHMENT=\"" + successFilePath + "\" WHERE ID=\"" + business_id + "\";";
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.updateSql:" + updateSql);
                    this.jdbcTemplate.update(updateSql);
                    business_id = business_id.replace("__TTeElnX8IULbf7iTxsM", "__jlNfVcjppSliMYH6FkJ");
                    String detailSql = "UPDATE obpm2.tenant_user_credential_details SET update_time=NOW(),electronCerUrl=\"" + successFilePath + "\" WHERE ID=\"" + business_id + "\";";
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.detailSql:" + detailSql);
                    this.jdbcTemplate.update(detailSql);
                    String sql = "DELETE FROM obpm2_security.signature_queues WHERE id=" + id + ";";
                    System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.successSplit.sql:" + sql);
                    this.jdbcTemplate.update(sql);
                }
            }
            if (failList != null) {
                String sql = "UPDATE obpm2_security.signature_queues s SET s.status=2,s.last_processed_time=NOW(),s.last_processed_result='\u672a\u6210\u529f\u7b7e\u7ae0' WHERE s.id in (" + failList + ");";
                System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.failList.sql:" + sql);
                this.jdbcTemplate.update(sql);
            }
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.50\u4e2aPDF\u5df2\u7b7e\u7ae0\u6587\u4ef6\u5b58\u65e5\u671f\u76ee\u5f55\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            System.err.println("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.updateSql error\uff1a" + ExceptionUtils.getStackMessage((Throwable)e));
        }
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ShanXiInSignatureToPDFCompare.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String certificatefrom;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getCertificatefrom() {
            return this.certificatefrom;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setCertificatefrom(String certificatefrom) {
            this.certificatefrom = certificatefrom;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$certificatefrom = this.getCertificatefrom();
            String other$certificatefrom = other.getCertificatefrom();
            if (this$certificatefrom == null ? other$certificatefrom != null : !this$certificatefrom.equals(other$certificatefrom)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $certificatefrom = this.getCertificatefrom();
            result = result * 59 + ($certificatefrom == null ? 43 : $certificatefrom.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "ShanXiInSignatureToPDFCompare.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", certificatefrom=" + this.getCertificatefrom() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

