/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.components.impls;

import com.bcxin.signature.components.DocumentPushProvider;
import com.bcxin.signature.components.JTLZPendingQueueComponent;
import com.bcxin.signature.components.JTLZPushComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component
public class DocumentPushProviderImpl
implements DocumentPushProvider {
    private static final Logger logger = LoggerFactory.getLogger(DocumentPushProvider.class);
    private final JTLZPendingQueueComponent pendingQueueComponent;
    private final JTLZPushComponent jtlzPushComponent;
    private final ThreadPoolTaskExecutor taskExecutor;

    public DocumentPushProviderImpl(JTLZPendingQueueComponent pendingQueueComponent, JTLZPushComponent jtlzPushComponent, ThreadPoolTaskExecutor taskExecutor) {
        this.pendingQueueComponent = pendingQueueComponent;
        this.jtlzPushComponent = jtlzPushComponent;
        this.taskExecutor = taskExecutor;
    }

    public void push(DocumentPushProvider.DocumentType documentType) {
        String filePrefixMeta = "INJTLZ-";
        if (documentType == DocumentPushProvider.DocumentType.Document) {
            filePrefixMeta = "INJTLZDOCUMENT-";
        }
        this.execute(filePrefixMeta, false);
    }

    public void cancel_push() {
        this.execute("INJTLZFZ-", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMetaFile(String traceId, Collection<String> pendingFileNames) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean isEmpty = false;
        logger.error("{} prepare to process the pendingFileNames:{}", new Object[]{traceId, isEmpty, pendingFileNames.size()});
        Exception lastException = null;
        try {
            List<CompletableFuture> resultFutures = pendingFileNames.stream().map(rfn -> CompletableFuture.runAsync(() -> this.jtlzPushComponent.execute(traceId, rfn), (Executor)this.taskExecutor)).collect(Collectors.toList());
            Void rt = CompletableFuture.allOf(resultFutures.toArray(new CompletableFuture[resultFutures.size()])).join();
            logger.error("success:{}", (Object)rt);
        }
        catch (Exception ex) {
            try {
                lastException = ex;
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                logger.error("{}-({}) Done for signatureJTLZ cost {} seconds - pendingFileSize={}", new Object[]{traceId, lastException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), pendingFileNames.size()});
                throw throwable;
            }
            stopWatch.stop();
            logger.error("{}-({}) Done for signatureJTLZ cost {} seconds - pendingFileSize={}", new Object[]{traceId, lastException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), pendingFileNames.size()});
        }
        stopWatch.stop();
        logger.error("{}-({}) Done for signatureJTLZ cost {} seconds - pendingFileSize={}", new Object[]{traceId, lastException == null ? "SUCCESS" : "ERROR", stopWatch.getTotalTimeSeconds(), pendingFileNames.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String filePrefix, boolean isFz) {
        String traceId = UUID.randomUUID().toString();
        Collection pendingFileNames = null;
        StopWatch metaStopWatch = new StopWatch();
        Exception topException = null;
        try {
            metaStopWatch.start();
            pendingFileNames = this.pendingQueueComponent.getMetaFilesWithPrefix(filePrefix, 20);
        }
        catch (Exception ex) {
            try {
                topException = ex;
            }
            catch (Throwable throwable) {
                metaStopWatch.stop();
                logger.error("{} geting pending files-{}:{}; cost {} seconds", new Object[]{traceId, filePrefix, pendingFileNames == null ? "EMPTY" : Integer.valueOf(pendingFileNames.size()), metaStopWatch.getTotalTimeSeconds(), topException});
                throw throwable;
            }
            metaStopWatch.stop();
            logger.error("{} geting pending files-{}:{}; cost {} seconds", new Object[]{traceId, filePrefix, pendingFileNames == null ? "EMPTY" : Integer.valueOf(pendingFileNames.size()), metaStopWatch.getTotalTimeSeconds(), topException});
        }
        metaStopWatch.stop();
        logger.error("{} geting pending files-{}:{}; cost {} seconds", new Object[]{traceId, filePrefix, pendingFileNames == null ? "EMPTY" : Integer.valueOf(pendingFileNames.size()), metaStopWatch.getTotalTimeSeconds(), topException});
        Collection directlyFiles = new ArrayList();
        directlyFiles = !isFz ? this.pendingQueueComponent.getPendingContentFiles("IN-JTLZ-") : this.pendingQueueComponent.getPendingContentFiles("IN-JTLZFZ-");
        if (directlyFiles == null) {
            directlyFiles = new ArrayList();
        }
        Exception exception = null;
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            this.jtlzPushComponent.execute(traceId, directlyFiles.toArray(new String[directlyFiles.size()]), isFz);
        }
        catch (Exception ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                watch.stop();
                logger.error("{}-Done for directly execute cost {} seconds[pendingFileNames={}] size={}", new Object[]{exception == null ? "SUCCESS" : "ERROR", watch.getTotalTimeSeconds(), CollectionUtils.isEmpty((Collection)pendingFileNames) ? "Empty" : pendingFileNames.stream().collect(Collectors.joining(",")), directlyFiles == null ? "EMPTY" : Integer.valueOf(directlyFiles.size()), exception});
                throw throwable;
            }
            watch.stop();
            logger.error("{}-Done for directly execute cost {} seconds[pendingFileNames={}] size={}", new Object[]{exception == null ? "SUCCESS" : "ERROR", watch.getTotalTimeSeconds(), CollectionUtils.isEmpty((Collection)pendingFileNames) ? "Empty" : pendingFileNames.stream().collect(Collectors.joining(",")), directlyFiles == null ? "EMPTY" : Integer.valueOf(directlyFiles.size()), exception});
        }
        watch.stop();
        logger.error("{}-Done for directly execute cost {} seconds[pendingFileNames={}] size={}", new Object[]{exception == null ? "SUCCESS" : "ERROR", watch.getTotalTimeSeconds(), CollectionUtils.isEmpty((Collection)pendingFileNames) ? "Empty" : pendingFileNames.stream().collect(Collectors.joining(",")), directlyFiles == null ? "EMPTY" : Integer.valueOf(directlyFiles.size()), exception});
        if (CollectionUtils.isEmpty((Collection)pendingFileNames)) {
            return;
        }
        this.executeMetaFile(traceId, pendingFileNames);
    }
}

