package com.baichuanxin.openrestapi.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.With;

import java.util.Date;

/***
 *@Author duxiangyun
 *@Description 自行招用保安员单位备案
 *@Date 2024/8/24
 */
@Data
@TableName("tlk_recruitment")
public class SelfRecruitmentFiling {
    //办件数据
    //数据taskId
    @TableField("taskId")
    private String taskId;
    //表单需求数据
    //表单需求数据
    @TableId("ID")
    private String id;
    //创建时间
    @TableField("CREATED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date created;
    @TableField("LASTMODIFIED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date lastmodified;
    @TableField("FORMNAME")
    private String formname ;
    @TableField("FORMID")
    private String formid;
    @TableField("ISTMP")
    private boolean istmp;
    @TableField("APPLICATIONID")
    private String applicationid;
    @TableField("DOMAINID")
    private String domainid;
    @TableField("ITEM_REGION")
    private String itemRegion;
    /**
     *1、选择办事区域
     */
    //所属监管机构
    @TableField("item_officePoliceAddress")
    private String itemOfficePoliceAddress;
    @TableField("ITEM_OFFICEPOLICEADDRESSID")
    private String itemitemOfficePoliceAddressid;
    @TableField("ITEM_OFFICEPOLICEIDINDEX")
    private String itemOfficePoliceidindex;
    /**
     * 2、填写单位信息
     */
    //单位名称
    @TableField(value = "item_companyName")
    private String itemCompanyName;
    //单位地址
    @TableField(value = "item_address")
    private String itemAddress;
    //单位类型
    @TableField(value = "item_unit_type")
    private String itemUnitType;
    //统一社会信用代码
    @TableField(value = "item_creditCode")
    private String itemCreditCode;
    //所服务项目名称
    @TableField(value = "item_serviceArea")
    private String itemServiceArea;
    //开展保安服务地点
    @TableField(value = "item_service_place")
    private String itemServicePlace;
    //保安员数
    @TableField(value = "item_RecordPeronNum")
    private String itemRecordPeronNum;
    /**
     * 3、填写法人信息
     */
    //姓名
    @TableField(value = "item_legal_name")
    private String itemLegalName;
    //联系电话
    @TableField(value = "item_legal_phone")
    private String itemLegalPhone;
    //证件类型
    @TableField(value = "item_legal_type")
    private String itemLegalType;
    //证件号码
    @TableField(value = "item_legai_number")
    private String itemLegaiNumber;
    /**
     * 4、填写分管保安负责人信息
     */
    //姓名
    @TableField(value = "item_chargeName")
    private String itemChargeName;
    //身份证号码
    @TableField(value = "item_chargeCardNumber")
    private String itemChargeCardNumber;
    //手机号
    @TableField(value = "item_chargePhone")
    private String itemChargePhone;

    /**
     * 5、经办人信息
     */
    //姓名
    @TableField(value = "item_applicant_name")
    private String itemApplicantName;
    //身份证号
    @TableField(value = "item_applicant_card_num")
    private String itemApplicantCardNum;
    //联系电话
    @TableField(value = "item_applicant_phone")
    private String itemApplicantPhone;

    /**
     * 6、承诺上述填报信息真实有效
     */
    //承诺上述填报信息真实有效
    @TableField(value = "item_permit")
    private String itemPermit;

    /**
     * 7、上传电子版材料（模版下载）
     */
    /**
     *@Author duxiangyun
     *@Description   审核状态数据
     *@Date 2024/8/26
     */

    //审核状态
    @TableField("ITEM_AUDITSTATUS")
    private String itemAuditStatus;
    //审核时间
    @TableField("item_over_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date itemOverTime;
    //审核意见
    @TableField("item_apply_remark")
    private String  itemApplyRemark;
    //审核文书
    @TableField("item_service_file")
    private String itemServiceFile;
    @TableField("isdelivery")
    private String isdelivery;

}
