package com.baichuanxin.openrestapi.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/***
 *@Author duxiangyun
 *@Description 保安服务公司设立
 *@Date 2024/8/24
 */
@Data
@TableName("tlk_securitysevicek")
public class SecurityServicek {

    //办件数据
    @TableField("taskId")
    private String taskId;

    //表单需求数据
    @TableId("ID")
    private String ID;
    //创建时间
    @TableField("CREATED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date created;
    @TableField("LASTMODIFIED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date lastmodified;
    @TableField("FORMNAME")
    private String formname ;
    @TableField("FORMID")
    private String formid;
    @TableField("ISTMP")
    private boolean istmp;
    @TableField("APPLICATIONID")
    private String applicationid;
    @TableField("DOMAINID")
    private String domainid;
    @TableField("ITEM_REGION")
    private String itemRegion;


    /**
     * 办事区域
     */
    //所属监管机构
    @TableField(value = "item_officePoliceAddress")
    private String itemOfficePoliceAddress;
    @TableField("ITEM_OFFICEPOLICEADDRESSID")
    private String itemOfficePoliceAddressid;
    @TableField("ITEM_OFFICEPOLICEIDINDEX")
    private String itemOfficePoliceidindex;
    //公司类型  1保安服务公司设立，2武装守护押运保安服务公司设立许可
    @TableField(value = "item_sevicepermittype")
    private String itemSevicepermittype;
    /**
     * 单位基本信息
     */
    //申请单位名称
    @TableField(value = "item_companyName")
    private String itemCompanyName;
    //办公住所
    @TableField(value = "item_address")
    private String itemAddress;
    //注册资本（万元）
    @TableField(value = "item_registeredCapital")
    private String itemRegisteredCapital;
    //申请服务范围  03;07;10
    @TableField(value = "item_businessScope")
    private String itemBusinessScope;

    /**
     * 法定代表人信息
     */
    //姓名
    @TableField(value = "item_legalName")
    private String itemLegalName;
    //性别
    @TableField(value = "item_sex")
    private String  itemSex;
    //民族
    @TableField(value = "item_nation")
    private String itemNation;
    //政治面貌
    @TableField(value = "item_identity")
    private String itemIdentity;
    //文化程度
    @TableField(value = "item_education")
    private String itemEducation;
    //保安师资格证编号
    @TableField(value = "item_vocational_certificate")
    private String  itemVocationalCertificate;
    //联系方式
    @TableField(value ="item_legalPhone")
    private String  itemLegalPhone;
    //证件类型
    @TableField(value = "item_documentType")
    private String itemDocumentType;
    //证件号码
    @TableField(value = "item_legalCardnumber")
    private String  itemLegalCardnumber;

    /**
     * 股东信息  股东信息存另外一张表
     * tlk_companypermitshareholder
     */

    /**
     * 主要管理人员及技术人员信息另外存一张表
     *  tlk_companypermitmanagementlayer
     */


    /**
     * 许可证领取方式
     */
    //新证领取方式
    @TableField(value = "item_claim_way")
    private String itemClaimWay;
//    //领取地址
//    @TableField(value = "ITEM_RECIPIENT_ADDRESS")
//    private String  itemRecipientAddress;
    //收件人
    @TableField("ITEM_RECIPIENT")
    private String itemRecipient;
    //手机号
    @TableField("ITEM_RECIPIENT_PHONE")
    private String itemRecipientPhone;
    //收件地址
    @TableField("ITEM_RECIPIENT_ADDRESS")
    private String itemRecipientAddress;

    /**
     * 填写经办人信息
     */
    //姓名****************************************************
    @TableField("ITEM_APPLICANT_NAME")
    private String itemApplicantName;
    //联系电话****************************************************
    @TableField("ITEM_APPLICANT_PHONE")
    private String itemApplicantPhone;


    /**
     * 承诺上述填报信息真实有效
     */
    @TableField("ITEM_PERMIT")
    private String itemPermit;

    /**
     * 上传电子版材料（模版下载）   附件另外一张表
     */



    /**
     *@Author duxiangyun
     *@Description   审核状态数据
     *@Date 2024/8/26
     */
    //审核状态
    @TableField("ITEM_AUDITSTATUS")
    private String itemAuditStatus;
    //保安服务许可证编码
    @TableField("ITEM_SERVICE_NUMBER")
    private String itemServiceNumber;
    //统一社会信用代码
    @TableField("ITEM_USCC")
    private String itemUscc;
    //批准文号
    @TableField("item_code_number")
    private String itemCodeNumber;
    //审核时间
    @TableField("item_over_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date itemOverTime;
    //受理情况文件---许可情况
    @TableField("item_acceptance_file")
    private String itemAcceptanceFile;
    //许可情况
    @TableField("item_notice_file")
    private String itemNoticeFile;
    //保安服务许可证
    @TableField("item_service_file")
    private String itemServiceFile;
    //公安下发办结告知书
    @TableField("item_public_completion_file")
    private String itemPublicCompletionFile;
    //公安下发回传行政许可文书送达回证
    @TableField("item_public_reach_file")
    private String itemPublicReachFile;


    //审核意见
    @TableField("item_apply_remark")
    private String  itemApplyRemark;
    @TableField("isdelivery")
    private String isdelivery;


}
