package com.baichuanxin.openrestapi.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 *@Author duxiangyun
 *@Description 跨区域经营备案
 *@Date 2024/8/24
 */
@Data
@TableName("tlk_crosscompany")
public class CrossRegionalFiling {
    //办件数据
    @TableField("taskId")
    private String taskId;

    //表单需求数据
    @TableId("ID")
    private String id;
    //创建时间
    @TableField("CREATED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date created;
    @TableField("LASTMODIFIED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date lastmodified;
    @TableField("FORMNAME")
    private String formname ;
    @TableField("FORMID")
    private String formid;
    @TableField("ISTMP")
    private boolean istmp;
    @TableField("APPLICATIONID")
    private String applicationid;
    @TableField("DOMAINID")
    private String domainid;
    @TableField("ITEM_REGION")
    private String itemRegion;
    /**
     *1、选择办事区域
     */
    //所属监管机构
    @TableField("item_officePoliceAddress")
    private String itemOfficePoliceAddress;
    @TableField("ITEM_OFFICEPOLICEADDRESSID")
    private String itemitemOfficePoliceAddressid;
    @TableField("ITEM_OFFICEPOLICEIDINDEX")
    private String itemOfficePoliceidindex;
    /**
     * 2、填写公司信息
     */
    //公司名称
    @TableField("item_companyName")
    private String itemCompanyName;
    //公司地址
    @TableField("item_address")
    private String itemAddress;
    //统一社会信用代码
    @TableField("item_creditCode")
    private String itemCreditCode;
    //联系电话
    @TableField("item_phone")
    private String itemPhone;
    //总公司保安服务许可证号
    @TableField("item_licenceNum")
    private String itemLicenceNum;
    //公司类型
    @TableField("item_company_type")
    private String itemCompanyType;
    //经营范围
    @TableField("item_businessScope")
    private String itemBusinessScope;
    //办公地址
    @TableField("item_work_address")
    private String itemWorkAddress;

    /**
     * 3、填写法人信息
     */
    //姓名
    @TableField("item_legalName")
    private String itemLegalName;
    //手机号码
    @TableField("item_legalPhone")
    private String itemLegalPhone;
    //证件类型
    @TableField("item_legalType")
    private String  itemLegalType;
    //证件号码
    @TableField("item_legalCardnumber")
    private String itemLegalCardnumber;

    /**
     * 4、填写拟开展保安服务项目信息
     */
    //拟跨区域经营的保安服务项目
    @TableField("item_managerproject")
    private String itemManagerproject;
    //项目地址
    @TableField("item_sonAddress")
    private String itemSonAddress;
    //合同期限
    @TableField("item_contract_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date itemContractEndDate;
    //合同金额
    @TableField("item_contract_amount")
    private String itemContractAmount;
    //保安员数
    @TableField("item_sonPersonNum")
    private String itemSonPersonNum;

    /**
     * 保安员信息内网表：  SecurityMan
     * tlk_securityinformation
     */
    /**
     * 5、填写项目负责人信息
     */
    //姓名
    @TableField("item_chargeName")
    private String itemChargeName;
    //手机号码
    @TableField("item_chargePhone")
    private String itemChargePhone;
    //职务
    @TableField("item_chargePost")
    private String itemChargePost;
    //证件号码
    @TableField("item_chargeCardnumber")
    private String itemChargeCardnumber;
    //证件类型
    @TableField("item_chargeCardType")
    private String itemChargeCardType;
    //性别
    @TableField("item_charge_sex")
    private String itemChargeSex;
    //年龄
    @TableField("item_charge_age")
    private String  itemChargeAge;
    //籍贯
    @TableField("item_charge_household")
    private String itemChargeHousehold;
    //民族
    @TableField("item_charge_nation")
    private String itemChargeNation;
    //现住址
    @TableField("item_charge_address")
    private String itemChargeAddress;
    //工作简历
    @TableField("item_job_resume")
    private String itemJobResume;

    /**
     *6、经办人信息
     */
    //姓名
    @TableField("item_applicant_name")
    private String itemApplicantName;
    //联系电话
    @TableField("item_applicant_phone")
    private String itemApplicantPhone;
    /**
     * 承诺上述填报信息真实有效
     */
    @TableField("item_permit")
    private String itemPermit;


    /**
     *@Author duxiangyun
     *@Description   审核状态数据
     *@Date 2024/8/26
     */
    //审核状态
    @TableField("ITEM_AUDITSTATUS")
    private String itemAuditStatus;
    //审核时间
    @TableField("item_over_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date itemOverTime;
    //审核意见
    @TableField("item_apply_remark")
    private String  itemApplyRemark;
    //审核文书
    @TableField("item_service_file")
    private String itemServiceFile;
    @TableField("isdelivery")
    private String isdelivery;
}
