package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.SecurityMan;
import lombok.Data;

import java.util.Date;

/**
 * 跨区预计经营备案、设立公公司，  保安员信息
 */
@Data
public class SecurityManDto {

    //姓名
    private String item_name;
    //性别
    private String item_sex;
    //民族
    private String item_nation;
    //身份证号码
    private String item_id_card_num;
    //保安员证号
    private String item_certificate_no;
    //联系号码
    private String item_phone;
//    //保安员数量 +++++++++++++++++++++++++ 疑问字段  不需要使用
    private Integer item_person_num;

    public SecurityMan convert(){
        Date now = new Date();
        SecurityMan securityMan = new SecurityMan();
        securityMan.setCreated(now);
        securityMan.setLastmodified(now);
        securityMan.setFormname("");
        securityMan.setFormid(OnlineTaskConstant.SECURITY_MAN);
        securityMan.setIstmp(true);
        securityMan.setApplicationid("__wGomeHJBz6CpLFCCl4y");
        securityMan.setDomainid("__UDa4uPMdcOYgP7HETaf");

        //表单数据
        securityMan.setItemSex(this.getItem_sex());
        securityMan.setItemName(this.getItem_name());
        securityMan.setItemNation(this.getItem_nation());
        securityMan.setItemIdCardNum(OnlineTaskUtil.decrypt(this.getItem_id_card_num()));
        securityMan.setItemCertificateNo(this.getItem_certificate_no());
        securityMan.setItemPhone(this.getItem_phone());
        return securityMan;
    }

}
