/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.XMStringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Subscription
extends HttpBase {
    public Subscription(String security) {
        super(Subscription.nonNull(security));
    }

    public Subscription(String security, Region region) {
        super(Subscription.nonNull(security), region);
    }

    protected static String joinString(List<String> stringList, char sep) {
        StringBuffer sb = new StringBuffer();
        for (String s : stringList) {
            sb.append(sep).append(s);
        }
        return sb.substring(1);
    }

    public Result subscribeTopic(List<String> regIds, String topic, String category, int retries) throws IOException, ParseException {
        return this.topicSubscribeBase(regIds, topic, category, retries, true);
    }

    public Result subscribeTopic(List<String> regIds, String topic, String packageName, String category, int retries) throws IOException, ParseException {
        return this.topicSubscribeBase(regIds, topic, packageName, category, retries, true);
    }

    public Result subscribeTopic(List<String> regIds, String topic, String category) throws IOException, ParseException {
        return this.subscribeTopic(regIds, topic, category, 1);
    }

    public Result subscribeTopic(String regId, String topic, String category, int retries) throws IOException, ParseException {
        ArrayList<String> regIds = new ArrayList<String>();
        regIds.add(regId);
        return this.subscribeTopic(regIds, topic, category, retries);
    }

    public Result subscribeTopic(String regId, String topic, String packageName, String category, int retries) throws IOException, ParseException {
        ArrayList<String> regIds = new ArrayList<String>();
        regIds.add(regId);
        return this.subscribeTopic(regIds, topic, packageName, category, retries);
    }

    public Result subscribeTopic(String regId, String topic, String category) throws IOException, ParseException {
        return this.subscribeTopic(regId, topic, category, 1);
    }

    public Result subscribeTopic(String regId, String topic, String packageName, String category) throws IOException, ParseException {
        return this.subscribeTopic(regId, topic, packageName, category, 1);
    }

    public Result unsubscribeTopic(List<String> regIds, String topic, String category, int retries) throws IOException, ParseException {
        return this.topicSubscribeBase(regIds, topic, category, retries, false);
    }

    public Result unsubscribeTopic(List<String> regIds, String topic, String category) throws IOException, ParseException {
        return this.unsubscribeTopic(regIds, topic, category, 1);
    }

    public Result unsubscribeTopic(List<String> regIds, String topic, String packageName, String category, int retries) throws IOException, ParseException {
        return this.topicSubscribeBase(regIds, topic, packageName, category, retries, false);
    }

    public Result unsubscribeTopic(String regId, String topic, String category, int retries) throws IOException, ParseException {
        ArrayList<String> regIds = new ArrayList<String>();
        regIds.add(regId);
        return this.unsubscribeTopic(regIds, topic, category, retries);
    }

    public Result unsubscribeTopic(String regId, String topic, String packageName, String category, int retries) throws IOException, ParseException {
        ArrayList<String> regIds = new ArrayList<String>();
        regIds.add(regId);
        return this.unsubscribeTopic(regIds, topic, packageName, category, retries);
    }

    public Result unsubscribeTopic(String regId, String topic, String category) throws IOException, ParseException {
        return this.unsubscribeTopic(regId, topic, category, 1);
    }

    public Result unsubscribeTopic(String regId, String topic, String packageName, String category) throws IOException, ParseException {
        return this.unsubscribeTopic(regId, topic, packageName, category, 1);
    }

    public Result subscribeTopicByAlias(String topic, List<String> aliases, String category, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to subscribe topic " + topic + " for aliases " + aliases);
            }
            StringBuilder body = Subscription.newBody("aliases", URLEncoder.encode(Subscription.joinString(aliases, ','), "UTF-8"));
            Subscription.addParameter(body, "topic", URLEncoder.encode(topic, "UTF-8"));
            if (category != null) {
                Subscription.addParameter(body, "category", URLEncoder.encode(category, "UTF-8"));
            }
            boolean bl = tryAgain = (result = this.sendMessage(Constants.XmPushRequestPath.V2_SUBSCRIBE_TOPIC_BY_ALIAS, bodyStr = body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not subscribe topic after " + attempt + " attempts");
        }
        return result;
    }

    public Result subscribeTopicByAlias(String topic, List<String> aliases, String packageName, String category, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to subscribe topic " + topic + " for aliases " + aliases);
            }
            StringBuilder body = Subscription.newBody("aliases", URLEncoder.encode(Subscription.joinString(aliases, ','), "UTF-8"));
            if (!XMStringUtils.isBlank(packageName)) {
                Subscription.addParameter(body, "restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            }
            Subscription.addParameter(body, "topic", URLEncoder.encode(topic, "UTF-8"));
            if (category != null) {
                Subscription.addParameter(body, "category", URLEncoder.encode(category, "UTF-8"));
            }
            boolean bl = tryAgain = (result = this.sendMessage(Constants.XmPushRequestPath.V2_SUBSCRIBE_TOPIC_BY_ALIAS, bodyStr = body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not subscribe topic after " + attempt + " attempts");
        }
        return result;
    }

    public Result unsubscribeTopicByAlias(String topic, List<String> aliases, String category, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to unsubscribe topic " + topic + " for aliases " + aliases);
            }
            StringBuilder body = Subscription.newBody("aliases", URLEncoder.encode(Subscription.joinString(aliases, ','), "UTF-8"));
            Subscription.addParameter(body, "topic", URLEncoder.encode(topic, "UTF-8"));
            if (category != null) {
                Subscription.addParameter(body, "category", URLEncoder.encode(category, "UTF-8"));
            }
            boolean bl = tryAgain = (result = this.sendMessage(Constants.XmPushRequestPath.V2_UNSUBSCRIBE_TOPIC_BY_ALIAS, bodyStr = body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not unsubscribe topic after " + attempt + " attempts");
        }
        return result;
    }

    public Result unsubscribeTopicByAlias(String topic, List<String> aliases, String packageName, String category, int retries) throws IOException, ParseException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to unsubscribe topic " + topic + " for aliases " + aliases);
            }
            StringBuilder body = Subscription.newBody("aliases", URLEncoder.encode(Subscription.joinString(aliases, ','), "UTF-8"));
            if (!XMStringUtils.isBlank(packageName)) {
                Subscription.addParameter(body, "restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            }
            Subscription.addParameter(body, "topic", URLEncoder.encode(topic, "UTF-8"));
            if (category != null) {
                Subscription.addParameter(body, "category", URLEncoder.encode(category, "UTF-8"));
            }
            boolean bl = tryAgain = (result = this.sendMessage(Constants.XmPushRequestPath.V2_UNSUBSCRIBE_TOPIC_BY_ALIAS, bodyStr = body.toString())) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not unsubscribe topic after " + attempt + " attempts");
        }
        return result;
    }

    protected Result topicSubscribeBase(List<String> regIds, String topic, String category, int retries, boolean isSubscribe) throws IOException, ParseException {
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        boolean tryAgain = false;
        String regIdsString = Subscription.joinString(regIds, ',');
        String type = isSubscribe ? "subscribe" : "unsubscribe";
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send " + type + " topic " + topic + " to regIds " + regIdsString);
            }
            StringBuilder body = Subscription.newBody("registration_id", URLEncoder.encode(regIdsString, "UTF-8"));
            Subscription.addParameter(body, "topic", URLEncoder.encode(topic, "UTF-8"));
            if (category != null) {
                Subscription.addParameter(body, "category", URLEncoder.encode(category, "UTF-8"));
            }
            if ((bodyStr = body.toString()).charAt(0) == '&') {
                bodyStr = body.toString().substring(1);
            }
            Constants.XmPushRequestPath requestPath = isSubscribe ? Constants.XmPushRequestPath.V2_SUBSCRIBE_TOPIC : Constants.XmPushRequestPath.V2_UNSUBSCRIBE_TOPIC;
            result = this.sendMessage(requestPath, bodyStr);
            boolean bl = tryAgain = result == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not " + type + " topic after " + attempt + " attempts");
        }
        return result;
    }

    protected Result topicSubscribeBase(List<String> regIds, String topic, String packageName, String category, int retries, boolean isSubscribe) throws IOException, ParseException {
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        boolean tryAgain = false;
        String regIdsString = Subscription.joinString(regIds, ',');
        String type = isSubscribe ? "subscribe" : "unsubscribe";
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send " + type + " topic " + topic + " to regIds " + regIdsString);
            }
            StringBuilder body = Subscription.newBody("registration_id", URLEncoder.encode(regIdsString, "UTF-8"));
            if (!XMStringUtils.isBlank(packageName)) {
                Subscription.addParameter(body, "restricted_package_name", URLEncoder.encode(packageName, "UTF-8"));
            }
            Subscription.addParameter(body, "topic", URLEncoder.encode(topic, "UTF-8"));
            if (category != null) {
                Subscription.addParameter(body, "category", URLEncoder.encode(category, "UTF-8"));
            }
            if ((bodyStr = body.toString()).charAt(0) == '&') {
                bodyStr = body.toString().substring(1);
            }
            Constants.XmPushRequestPath requestPath = isSubscribe ? Constants.XmPushRequestPath.V2_SUBSCRIBE_TOPIC : Constants.XmPushRequestPath.V2_UNSUBSCRIBE_TOPIC;
            result = this.sendMessage(requestPath, bodyStr);
            boolean bl = tryAgain = result == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not " + type + " topic after " + attempt + " attempts");
        }
        return result;
    }

    protected Result sendMessage(Constants.RequestPath requestPath, String message) throws IOException, ParseException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.fine("post to: " + requestPath.getPath());
            conn = this.doPost(requestPath, message);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException send message: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Subscription.getAndClose(conn.getErrorStream());
                logger.finest("Plain post error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Subscription.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            throw new IOException("Invalid response from XmPush: " + responseBody);
        }
    }
}

