
/***
CRMEB Java 多商户 v1.2 版本sql
平台管理 admin / 123456
商户 18292417675 / 000000
用户 自己注册 建议使用小程序
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for eb_activity_product
-- ----------------------------
DROP TABLE IF EXISTS `eb_activity_product`;
CREATE TABLE `eb_activity_product`  (
  `aid` int(11) NOT NULL COMMENT '活动id',
  `pro_id` int(11) NOT NULL COMMENT '商品id',
  `pro_image` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '活动商品图片',
  `sort` int(5) NOT NULL DEFAULT 999 COMMENT '排序',
  PRIMARY KEY (`aid`, `pro_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '活动商品关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_activity_style
-- ----------------------------
DROP TABLE IF EXISTS `eb_activity_style`;
CREATE TABLE `eb_activity_style`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '活动名称',
  `type` bit(1) NOT NULL COMMENT '活动类型0=活动边框，1=活动背景',
  `starttime` datetime(0) NOT NULL COMMENT '开始时间',
  `endtime` datetime(0) NOT NULL COMMENT '结束时间',
  `style` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '活动边框素材地址',
  `status` bit(1) NOT NULL COMMENT '状态 0=关闭1=开启',
  `method` int(11) NULL DEFAULT NULL COMMENT '商品参与类型 0=全部商品参与，1=指定商品参与，2=指定品牌参与，3=指定商品分类参与,4=指定商户产品',
  `products` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参与活动商品',
  `createtime` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updatetime` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_ali_pay_callback
-- ----------------------------
DROP TABLE IF EXISTS `eb_ali_pay_callback`;
CREATE TABLE `eb_ali_pay_callback`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `notify_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通知的类型',
  `notify_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通知校验 ID',
  `app_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付宝分配给开发者的应用 ID',
  `charset` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码格式，如 utf-8、gbk、gb2312 等',
  `version` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调用的接口版本，固定为：1.0',
  `sign_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商户生成签名字符串所使用的签名算法类型，目前支持 RSA2 和 RSA，推荐使用 RSA2',
  `sign` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签名',
  `trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付宝交易凭证号',
  `out_trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原支付请求的商户订单号',
  `trade_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '交易目前所处的状态:WAIT_BUYER_PAY-交易创建，等待买家付款,TRADE_CLOSED-未付款交易超时关闭，或支付完成后全额退款,3-交易支付成功,4-交易结束，不可退款',
  `total_amount` decimal(9, 2) NULL DEFAULT NULL COMMENT '本次交易支付的订单金额，单位为人民币（元）',
  `receipt_amount` decimal(9, 2) NULL DEFAULT NULL COMMENT '商家在交易中实际收到的款项，单位为人民币（元）',
  `refund_fee` decimal(9, 2) NULL DEFAULT NULL COMMENT '退款通知中，返回总退款金额，单位为人民币（元），支持两位小数',
  `subject` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品的标题/交易标题/订单标题/订单关键字等，是请求时对应的参数，原样通知回来',
  `body` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '该订单的备注、描述、明细等。对应请求时的 body 参数，原样通知回来',
  `passback_params` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公共回传参数，如果请求时传递了该参数，则返回给商户时会在异步通知时将该参数原样返回。本参数必须进行UrlEncode之后才可以发送给支付宝。',
  `notify_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '通知的发送时间。格式为 yyyy-MM-dd HH:mm:ss',
  `add_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `out_trade_no`(`out_trade_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '支付宝回调表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_ali_pay_info
-- ----------------------------
DROP TABLE IF EXISTS `eb_ali_pay_info`;
CREATE TABLE `eb_ali_pay_info`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付宝分配给开发者的应用ID',
  `timestamp` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发送请求的时间，格式yyyy-MM-dd HH:mm:ss',
  `body` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单描述',
  `subject` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单标题',
  `out_trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商户订单号',
  `timeout_express` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单相对超时时间',
  `time_expire` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单绝对超时时间',
  `total_amount` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单总金额。单位为元，精确到小数点后两位',
  `passback_params` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公用回传参数,本参数必须进行UrlEncode之后才可以发送给支付宝',
  `code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '网关返回码',
  `msg` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '网关返回码描述',
  `sub_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务返回码',
  `sub_msg` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务返回码描述',
  `sign` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签名',
  `trade_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '该交易在支付宝系统中的交易流水号',
  `seller_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收款支付宝账号对应的支付宝唯一用户号',
  `notify_url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付宝服务器主动通知商户服务器里指定的页面http/https路径',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `out_trade_no`(`out_trade_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '支付宝订单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_article
-- ----------------------------
DROP TABLE IF EXISTS `eb_article`;
CREATE TABLE `eb_article`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `cid` int(11) NOT NULL DEFAULT 0 COMMENT '分类id',
  `title` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文章标题',
  `author` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文章作者',
  `cover` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文章封面',
  `synopsis` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '文章简介',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '文章内容',
  `visit` bigint(15) NOT NULL DEFAULT 0 COMMENT '浏览次数',
  `is_hot` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否轮播图(小程序)',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态，0-关闭，1-开启',
  `sort` int(6) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `product_id` int(11) NOT NULL DEFAULT 0 COMMENT '商品关联id',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid`(`cid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '文章管理表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_article_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_article_category`;
CREATE TABLE `eb_article_category`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章分类ID',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类图标',
  `sort` int(6) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态，0-关闭，1-开启',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否删除，0-未删除，1-删除',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '文章分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_bill
-- ----------------------------
DROP TABLE IF EXISTS `eb_bill`;
CREATE TABLE `eb_bill`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '帐单id',
  `uid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户uid',
  `mer_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商户id',
  `link_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联id',
  `order_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '关联订单',
  `pm` int(2) UNSIGNED NOT NULL DEFAULT 0 COMMENT '0 = 支出 1 = 获得',
  `amount` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '金额',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '类型：pay_order-订单支付,refund_order-订单退款，recharge_user-用户充值，yue_pay-余额支付,merchant_collect-商户分账，brokerage-分佣,system-系统',
  `mark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '备注',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  INDEX `pm`(`pm`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '平台帐单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_browse_record
-- ----------------------------
DROP TABLE IF EXISTS `eb_browse_record`;
CREATE TABLE `eb_browse_record`  (
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '用户id',
  `product_id` int(11) NOT NULL DEFAULT 0 COMMENT '商品id',
  `date` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '日期：年-月-日',
  `create_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  PRIMARY KEY (`uid`, `product_id`) USING BTREE,
  INDEX `date`(`date`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '浏览记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for eb_cart
-- ----------------------------
DROP TABLE IF EXISTS `eb_cart`;
CREATE TABLE `eb_cart`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '购物车表ID',
  `uid` int(11) UNSIGNED NOT NULL COMMENT '用户ID',
  `mer_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商户Id',
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品ID',
  `product_attr_unique` int(11) NOT NULL DEFAULT 0 COMMENT '商品规格属性ID',
  `cart_num` int(5) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品数量',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '购物车状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_id`(`uid`) USING BTREE,
  INDEX `search_id`(`id`, `uid`, `mer_id`, `status`) USING BTREE,
  INDEX `product_id`(`product_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '购物车表' ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for eb_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_category`;
CREATE TABLE `eb_category`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级ID',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '/0/' COMMENT '路径',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '分类名称',
  `type` smallint(2) NULL DEFAULT 1 COMMENT '类型，2 附件分类, 4 设置分类， 5 菜单分类，6 配置分类， 7 秒杀配置',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '地址',
  `extra` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '扩展字段 Jsos格式',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态, 1正常，0失效',
  `sort` int(6) NOT NULL DEFAULT 99999 COMMENT '排序',
  `owner` int(11) NOT NULL DEFAULT -1 COMMENT '分类所属：-1 - 平台，其他-商户',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status+pid`(`pid`, `status`) USING BTREE,
  INDEX `id+status+url`(`path`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 76 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of eb_category
-- ----------------------------
INSERT INTO `eb_category` VALUES (5, 0, '', '应用配置', 6, '应用配置', NULL, 1, 7, -1, '2022-08-01 10:05:45', '2023-05-05 09:44:25');
INSERT INTO `eb_category` VALUES (7, 0, '/0/', '文件上传配置', 6, '文件上传配置', NULL, 1, 1, -1, '2022-08-01 10:06:10', '2022-08-01 10:06:10');
INSERT INTO `eb_category` VALUES (8, 0, '', '第三方配置', 6, '第三方配置', NULL, 1, 1, -1, '2022-08-01 10:06:22', '2022-11-09 10:03:15');
INSERT INTO `eb_category` VALUES (9, 0, '/0/', '商户设置', 6, '商户设置', NULL, 1, 9, -1, '2022-08-01 10:06:47', '2022-08-01 16:55:10');
INSERT INTO `eb_category` VALUES (10, 0, '/0/', '商城设置/移动端配置', 6, '商城设置/移动端配置', NULL, 1, 8, -1, '2022-08-01 10:07:08', '2022-08-01 16:55:19');
INSERT INTO `eb_category` VALUES (11, 0, '', '支付/充值', 6, '支付/充值', NULL, 1, 6, -1, '2022-08-01 10:07:21', '2023-05-05 09:44:41');
INSERT INTO `eb_category` VALUES (12, 5, '/0/5/', '公众号配置', 6, '公众号配置', '公众号配置', 1, 1, -1, '2022-08-01 12:14:55', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (13, 5, '/0/5/', '小程序配置', 6, '小程序配置', '小程序配置', 1, 1, -1, '2022-08-01 12:15:05', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (14, 7, '/0/7/', '基础配置', 6, '基础配置', '文件上传-基础配置', 1, 1, -1, '2022-08-01 12:16:13', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (15, 7, '/0/7/', '阿里云配置', 6, '阿里云配置', '阿里云配置', 1, 1, -1, '2022-08-01 12:16:21', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (16, 7, '/0/7/', '七牛云配置', 6, '七牛云配置', '七牛云配置', 1, 1, -1, '2022-08-01 12:16:28', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (17, 7, '/0/7/', '腾讯云配置', 6, '腾讯云配置', '腾讯云配置', 1, 1, -1, '2022-08-01 12:16:35', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (18, 8, '/0/8/', ' 短信配置', 6, ' 短信配置', '短信设置', 1, 1, -1, '2022-08-01 12:17:09', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (19, 8, '/0/8/', ' 采集商品配置', 6, ' 采集商品配置', '采集商品配置', 1, 1, -1, '2022-08-01 12:17:15', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (20, 8, '/0/8/', '物流查询', 6, '物流查询', '物流查询', 1, 1, -1, '2022-08-01 12:17:31', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (21, 8, '8/', ' 电子面单', 6, ' 电子面单', '电子面单', 0, 1, -1, '2022-08-01 12:17:42', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (23, 9, '/0/9/', '商户登录页配置', 6, '商户登录页配置', '商户登录页配置', 1, 1, -1, '2022-08-01 12:18:41', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (24, 11, '/0/11/', ' 公众号支付配置', 6, ' 公众号支付配置', '公众号支付配置', 1, 1, -1, '2022-08-01 12:19:29', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (25, 11, '/0/11/', '小程序支付配置', 6, '小程序支付配置', '小程序支付配置', 1, 1, -1, '2022-08-01 12:19:34', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (26, 11, '/0/11/', ' 余额支付', 6, ' 余额支付', '余额支付', 1, 1, -1, '2022-08-01 12:19:39', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (27, 11, '/0/11/', '微信APP支付', 6, '微信APP支付', 'app微信支付配置', 1, 1, -1, '2022-08-01 12:19:45', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (28, 11, '/0/11/', '支付宝支付(h5/App)', 6, '支付宝支付(h5/App)', '支付宝支付', 1, 1, -1, '2022-08-01 12:19:58', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (29, 10, '/0/10/', 'H5', 6, 'H5', 'H5配置', 1, 1, -1, '2022-08-01 14:36:38', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (30, 11, '/0/11/', '支付回调地址(域名)', 6, '支付回调地址(域名)', '支付回调地址(域名)', 1, 1, -1, '2022-08-01 15:10:15', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (31, 0, '', '平台配置', 6, '平台配置', '充值套餐', 1, 10, -1, '2022-08-01 16:50:15', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (32, 31, '31/', '登录页配置', 6, '登录页配置', '平台登录页配置', 1, 1, -1, '2022-08-01 16:51:24', '2023-05-09 09:35:06');
INSERT INTO `eb_category` VALUES (33, 31, '/0/31/', '订单配置', 6, '订单配置', '订单配置', 1, 1, -1, '2022-08-01 16:51:51', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (35, 31, '/0/31/', '物流配置', 6, '物流配置', '物流配置', 1, 1, -1, '2022-08-01 16:52:49', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (36, 31, '/0/31/', '客服配置', 6, '客服配置', '客服配置', 1, 1, -1, '2022-08-01 16:53:13', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (37, 0, '/0/', '七夕素材', 2, 'url', NULL, 0, 1, -1, '2022-08-04 11:40:02', '2022-08-04 11:40:02');
INSERT INTO `eb_category` VALUES (38, 0, '/0/', '服装', 1, '', 'crmebimage/public/maintain/2022/08/04/b908b2b0034343458ba3649c7d1084383u7xxcc3ji.png', 1, 0, -1, '2022-08-09 09:47:56', '2022-08-09 09:47:56');
INSERT INTO `eb_category` VALUES (39, 11, '/0/11/', '充值配置', 6, '充值配置', '充值配置', 1, 1, -1, '2022-08-31 09:48:20', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (41, 0, '', '衣服', 2, 'url', NULL, 0, 1, 1, '2022-10-10 14:46:12', '2022-10-10 14:46:12');
INSERT INTO `eb_category` VALUES (42, 0, '', '商品图', 2, 'url', NULL, 0, 2, 2, '2022-10-10 18:05:19', '2023-04-11 15:24:23');
INSERT INTO `eb_category` VALUES (43, 0, '', '商品图', 2, 'url', NULL, 0, 1, -1, '2022-10-11 11:16:36', '2022-10-11 11:16:36');
INSERT INTO `eb_category` VALUES (44, 0, '', '商品图', 2, 'url', NULL, 0, 1, 1, '2022-10-11 12:18:45', '2022-10-11 12:18:45');
INSERT INTO `eb_category` VALUES (45, 0, '', '店铺图1', 2, 'url', NULL, 0, 1, 1, '2022-10-11 17:20:15', '2022-11-08 11:11:33');
INSERT INTO `eb_category` VALUES (46, 42, '42/', '店铺', 2, 'url', NULL, 0, 3, 2, '2022-10-11 17:24:27', '2023-04-11 15:26:39');
INSERT INTO `eb_category` VALUES (47, 0, '', 'banner', 2, 'url', NULL, 0, 1, -1, '2022-10-11 17:26:11', '2022-10-11 17:26:11');
INSERT INTO `eb_category` VALUES (48, 0, '', '店铺配置', 2, 'url', NULL, 0, 1, 3, '2022-10-13 17:03:50', '2022-10-13 17:03:50');
INSERT INTO `eb_category` VALUES (49, 0, '', '数码', 2, 'url', NULL, 0, 1, -1, '2022-10-15 10:25:04', '2022-10-15 10:25:04');
INSERT INTO `eb_category` VALUES (50, 0, '', '3C', 2, 'url', NULL, 0, 1, 3, '2022-10-15 10:34:47', '2022-10-15 10:34:47');
INSERT INTO `eb_category` VALUES (51, 0, '', '微信视频号类目审核资质', 2, 'url', NULL, 0, 1, -1, '2022-10-29 16:05:50', '2022-10-29 16:05:50');
INSERT INTO `eb_category` VALUES (54, 0, '', '测试分类', 2, 'url', NULL, 0, 1, -1, '2022-11-02 15:22:17', '2022-11-02 15:22:17');
INSERT INTO `eb_category` VALUES (57, 0, '', 'cs', 2, 'url', NULL, 0, 1, 7, '2022-11-02 16:12:45', '2022-11-02 16:12:45');
INSERT INTO `eb_category` VALUES (59, 0, '', '添加分类', 2, 'url', NULL, 0, 1, 7, '2022-11-09 09:31:15', '2022-11-09 09:31:15');
INSERT INTO `eb_category` VALUES (61, 0, '', '图标素材', 2, 'url', NULL, 0, 9, -1, '2022-11-11 11:20:37', '2022-11-11 11:20:37');
INSERT INTO `eb_category` VALUES (62, 61, '61/', '金刚区', 2, 'url', NULL, 0, 1, -1, '2022-11-11 11:21:59', '2022-11-11 11:21:59');
INSERT INTO `eb_category` VALUES (63, 61, '61/', '服务中心', 2, 'url', NULL, 0, 1, -1, '2022-11-11 11:22:25', '2022-11-11 11:22:25');
INSERT INTO `eb_category` VALUES (64, 5, '/0/5/', '微信App配置', 6, '微信App配置', '微信app配置', 1, 1, -1, '2022-11-26 20:01:23', '2023-04-28 17:04:35');
INSERT INTO `eb_category` VALUES (65, 0, '', '活动边框', 2, 'url', NULL, 0, 1, -1, '2023-01-11 15:24:57', '2023-01-11 15:24:57');
INSERT INTO `eb_category` VALUES (66, 0, '', '氛围图', 2, 'url', NULL, 0, 1, -1, '2023-01-11 17:38:19', '2023-01-11 17:38:19');
INSERT INTO `eb_category` VALUES (67, 61, '61/', '底部tab', 2, 'url', NULL, 0, 1, -1, '2023-02-10 10:05:33', '2023-02-10 10:05:33');
INSERT INTO `eb_category` VALUES (68, 0, '', 'tabBar', 2, 'url', NULL, 0, 1, -1, '2023-02-13 10:22:54', '2023-02-13 10:22:54');
INSERT INTO `eb_category` VALUES (69, 0, '', '分享素材', 2, 'url', NULL, 0, 1, -1, '2023-02-24 10:14:01', '2023-02-24 10:14:01');
INSERT INTO `eb_category` VALUES (70, 0, '', '阀门', 2, 'url', NULL, 0, 1, -1, '2023-03-20 11:53:03', '2023-03-20 11:53:03');
INSERT INTO `eb_category` VALUES (74, 0, '', '是的', 2, 'url', NULL, 0, 1, 2, '2023-04-18 21:19:37', '2023-04-18 21:19:37');
INSERT INTO `eb_category` VALUES (75, 7, '/0/7/', '京东云配置', 6, '京东云配置', 'jdCloudConfig', 1, 1, -1, '2023-04-01 11:26:32', '2023-04-01 11:27:54');

-- ----------------------------
-- Table structure for eb_city_region
-- ----------------------------
DROP TABLE IF EXISTS `eb_city_region`;
CREATE TABLE `eb_city_region`  (
  `region_id` int(11) NOT NULL DEFAULT 0 COMMENT '区域id',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT '父区域id',
  `region_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '区域名称',
  `region_type` tinyint(2) NOT NULL DEFAULT 0 COMMENT '区域类型，0-国家、1-省、2-市、3-区、4-街道',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`region_id`) USING BTREE,
  INDEX `parent_id`(`parent_id`) USING BTREE,
  INDEX `region_type`(`region_type`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '城市区域表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of eb_city_region
-- ----------------------------
INSERT INTO `eb_city_region` VALUES (110000, 1, '北京市', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (110100, 110000, '北京市', 2, '2022-11-09 10:07:58', '2022-11-17 11:48:49');
INSERT INTO `eb_city_region` VALUES (110101, 110100, '东城区', 3, '2022-11-09 10:32:30', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110102, 110100, '西城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110105, 110100, '朝阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110106, 110100, '丰台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110107, 110100, '石景山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110108, 110100, '海淀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110109, 110100, '门头沟区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110111, 110100, '房山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110112, 110100, '通州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110113, 110100, '顺义区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110114, 110100, '昌平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110115, 110100, '大兴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110116, 110100, '怀柔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110117, 110100, '平谷区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110118, 110100, '密云区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110119, 110100, '延庆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120000, 1, '天津市', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (120100, 120000, '天津市', 2, '2022-11-09 10:07:58', '2022-11-17 11:49:02');
INSERT INTO `eb_city_region` VALUES (120101, 120100, '和平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120102, 120100, '河东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120103, 120100, '河西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120104, 120100, '南开区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120105, 120100, '河北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120106, 120100, '红桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120110, 120100, '东丽区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120111, 120100, '西青区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120112, 120100, '津南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120113, 120100, '北辰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120114, 120100, '武清区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120115, 120100, '宝坻区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120116, 120100, '滨海新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120117, 120100, '宁河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120118, 120100, '静海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (120119, 120100, '蓟州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130000, 1, '河北省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (130100, 130000, '石家庄市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130101, 130100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130102, 130100, '长安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130104, 130100, '桥西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130105, 130100, '新华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130107, 130100, '井陉矿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130108, 130100, '裕华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130109, 130100, '藁城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130110, 130100, '鹿泉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130111, 130100, '栾城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130121, 130100, '井陉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130123, 130100, '正定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130125, 130100, '行唐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130126, 130100, '灵寿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130127, 130100, '高邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130128, 130100, '深泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130129, 130100, '赞皇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130130, 130100, '无极县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130131, 130100, '平山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130132, 130100, '元氏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130133, 130100, '赵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130171, 130100, '石家庄高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130172, 130100, '石家庄循环化工园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130181, 130100, '辛集市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130183, 130100, '晋州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130184, 130100, '新乐市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130200, 130000, '唐山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130201, 130200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130202, 130200, '路南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130203, 130200, '路北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130204, 130200, '古冶区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130205, 130200, '开平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130207, 130200, '丰南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130208, 130200, '丰润区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130209, 130200, '曹妃甸区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130224, 130200, '滦南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130225, 130200, '乐亭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130227, 130200, '迁西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130229, 130200, '玉田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130271, 130200, '河北唐山芦台经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130272, 130200, '唐山市汉沽管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130273, 130200, '唐山高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130274, 130200, '河北唐山海港经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130281, 130200, '遵化市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130283, 130200, '迁安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130284, 130200, '滦州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130300, 130000, '秦皇岛市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130301, 130300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130302, 130300, '海港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130303, 130300, '山海关区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130304, 130300, '北戴河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130306, 130300, '抚宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130321, 130300, '青龙满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130322, 130300, '昌黎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130324, 130300, '卢龙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130371, 130300, '秦皇岛市经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130372, 130300, '北戴河新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130400, 130000, '邯郸市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130401, 130400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130402, 130400, '邯山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130403, 130400, '丛台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130404, 130400, '复兴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130406, 130400, '峰峰矿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130407, 130400, '肥乡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130408, 130400, '永年区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130423, 130400, '临漳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130424, 130400, '成安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130425, 130400, '大名县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130426, 130400, '涉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130427, 130400, '磁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130430, 130400, '邱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130431, 130400, '鸡泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130432, 130400, '广平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130433, 130400, '馆陶县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130434, 130400, '魏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130435, 130400, '曲周县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130471, 130400, '邯郸经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130473, 130400, '邯郸冀南新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130481, 130400, '武安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130500, 130000, '邢台市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130501, 130500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130502, 130500, '襄都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130503, 130500, '信都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130505, 130500, '任泽区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130506, 130500, '南和区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130522, 130500, '临城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130523, 130500, '内丘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130524, 130500, '柏乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130525, 130500, '隆尧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130528, 130500, '宁晋县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130529, 130500, '巨鹿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130530, 130500, '新河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130531, 130500, '广宗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130532, 130500, '平乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130533, 130500, '威县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130534, 130500, '清河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130535, 130500, '临西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130571, 130500, '河北邢台经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130581, 130500, '南宫市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130582, 130500, '沙河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130600, 130000, '保定市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130601, 130600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130602, 130600, '竞秀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130606, 130600, '莲池区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130607, 130600, '满城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130608, 130600, '清苑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130609, 130600, '徐水区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130623, 130600, '涞水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130624, 130600, '阜平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130626, 130600, '定兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130627, 130600, '唐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130628, 130600, '高阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130629, 130600, '容城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130630, 130600, '涞源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130631, 130600, '望都县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130632, 130600, '安新县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130633, 130600, '易县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130634, 130600, '曲阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130635, 130600, '蠡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130636, 130600, '顺平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130637, 130600, '博野县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130638, 130600, '雄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130671, 130600, '保定高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130672, 130600, '保定白沟新城', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130681, 130600, '涿州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130682, 130600, '定州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130683, 130600, '安国市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130684, 130600, '高碑店市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130700, 130000, '张家口市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130701, 130700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130702, 130700, '桥东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130703, 130700, '桥西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130705, 130700, '宣化区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130706, 130700, '下花园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130708, 130700, '万全区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130709, 130700, '崇礼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130722, 130700, '张北县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130723, 130700, '康保县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130724, 130700, '沽源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130725, 130700, '尚义县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130726, 130700, '蔚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130727, 130700, '阳原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130728, 130700, '怀安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130730, 130700, '怀来县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130731, 130700, '涿鹿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130732, 130700, '赤城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130771, 130700, '张家口经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130772, 130700, '张家口市察北管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130773, 130700, '张家口市塞北管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130800, 130000, '承德市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130801, 130800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130802, 130800, '双桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130803, 130800, '双滦区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130804, 130800, '鹰手营子矿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130821, 130800, '承德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130822, 130800, '兴隆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130824, 130800, '滦平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130825, 130800, '隆化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130826, 130800, '丰宁满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130827, 130800, '宽城满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130828, 130800, '围场满族蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130871, 130800, '承德高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130881, 130800, '平泉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130900, 130000, '沧州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (130901, 130900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130902, 130900, '新华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130903, 130900, '运河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130921, 130900, '沧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130922, 130900, '青县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130923, 130900, '东光县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130924, 130900, '海兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130925, 130900, '盐山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130926, 130900, '肃宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130927, 130900, '南皮县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130928, 130900, '吴桥县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130929, 130900, '献县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130930, 130900, '孟村回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130971, 130900, '河北沧州经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130972, 130900, '沧州高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130973, 130900, '沧州渤海新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130981, 130900, '泊头市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130982, 130900, '任丘市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130983, 130900, '黄骅市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (130984, 130900, '河间市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131000, 130000, '廊坊市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (131001, 131000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131002, 131000, '安次区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131003, 131000, '广阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131022, 131000, '固安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131023, 131000, '永清县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131024, 131000, '香河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131025, 131000, '大城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131026, 131000, '文安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131028, 131000, '大厂回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131071, 131000, '廊坊经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131081, 131000, '霸州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131082, 131000, '三河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131100, 130000, '衡水市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (131101, 131100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131102, 131100, '桃城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131103, 131100, '冀州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131121, 131100, '枣强县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131122, 131100, '武邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131123, 131100, '武强县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131124, 131100, '饶阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131125, 131100, '安平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131126, 131100, '故城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131127, 131100, '景县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131128, 131100, '阜城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131171, 131100, '河北衡水高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131172, 131100, '衡水滨湖新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (131182, 131100, '深州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140000, 1, '山西省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (140100, 140000, '太原市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140101, 140100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140105, 140100, '小店区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140106, 140100, '迎泽区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140107, 140100, '杏花岭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140108, 140100, '尖草坪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140109, 140100, '万柏林区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140110, 140100, '晋源区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140121, 140100, '清徐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140122, 140100, '阳曲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140123, 140100, '娄烦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140171, 140100, '山西转型综合改革示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140181, 140100, '古交市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140200, 140000, '大同市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140201, 140200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140212, 140200, '新荣区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140213, 140200, '平城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140214, 140200, '云冈区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140215, 140200, '云州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140221, 140200, '阳高县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140222, 140200, '天镇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140223, 140200, '广灵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140224, 140200, '灵丘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140225, 140200, '浑源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140226, 140200, '左云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140271, 140200, '山西大同经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140300, 140000, '阳泉市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140301, 140300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140302, 140300, '城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140303, 140300, '矿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140311, 140300, '郊区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140321, 140300, '平定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140322, 140300, '盂县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140400, 140000, '长治市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140401, 140400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140403, 140400, '潞州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140404, 140400, '上党区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140405, 140400, '屯留区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140406, 140400, '潞城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140423, 140400, '襄垣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140425, 140400, '平顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140426, 140400, '黎城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140427, 140400, '壶关县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140428, 140400, '长子县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140429, 140400, '武乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140430, 140400, '沁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140431, 140400, '沁源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140471, 140400, '山西长治高新技术产业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140500, 140000, '晋城市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140501, 140500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140502, 140500, '城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140521, 140500, '沁水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140522, 140500, '阳城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140524, 140500, '陵川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140525, 140500, '泽州县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140581, 140500, '高平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140600, 140000, '朔州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140601, 140600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140602, 140600, '朔城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140603, 140600, '平鲁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140621, 140600, '山阴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140622, 140600, '应县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140623, 140600, '右玉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140671, 140600, '山西朔州经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140681, 140600, '怀仁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140700, 140000, '晋中市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140701, 140700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140702, 140700, '榆次区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140703, 140700, '太谷区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140721, 140700, '榆社县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140722, 140700, '左权县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140723, 140700, '和顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140724, 140700, '昔阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140725, 140700, '寿阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140727, 140700, '祁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140728, 140700, '平遥县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140729, 140700, '灵石县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140781, 140700, '介休市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140800, 140000, '运城市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140801, 140800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140802, 140800, '盐湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140821, 140800, '临猗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140822, 140800, '万荣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140823, 140800, '闻喜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140824, 140800, '稷山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140825, 140800, '新绛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140826, 140800, '绛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140827, 140800, '垣曲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140828, 140800, '夏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140829, 140800, '平陆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140830, 140800, '芮城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140881, 140800, '永济市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140882, 140800, '河津市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140900, 140000, '忻州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (140901, 140900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140902, 140900, '忻府区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140921, 140900, '定襄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140922, 140900, '五台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140923, 140900, '代县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140924, 140900, '繁峙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140925, 140900, '宁武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140926, 140900, '静乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140927, 140900, '神池县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140928, 140900, '五寨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140929, 140900, '岢岚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140930, 140900, '河曲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140931, 140900, '保德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140932, 140900, '偏关县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140971, 140900, '五台山风景名胜区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (140981, 140900, '原平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141000, 140000, '临汾市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (141001, 141000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141002, 141000, '尧都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141021, 141000, '曲沃县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141022, 141000, '翼城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141023, 141000, '襄汾县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141024, 141000, '洪洞县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141025, 141000, '古县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141026, 141000, '安泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141027, 141000, '浮山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141028, 141000, '吉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141029, 141000, '乡宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141030, 141000, '大宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141031, 141000, '隰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141032, 141000, '永和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141033, 141000, '蒲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141034, 141000, '汾西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141081, 141000, '侯马市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141082, 141000, '霍州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141100, 140000, '吕梁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (141101, 141100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141102, 141100, '离石区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141121, 141100, '文水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141122, 141100, '交城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141123, 141100, '兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141124, 141100, '临县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141125, 141100, '柳林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141126, 141100, '石楼县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141127, 141100, '岚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141128, 141100, '方山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141129, 141100, '中阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141130, 141100, '交口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141181, 141100, '孝义市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (141182, 141100, '汾阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150000, 1, '内蒙古自治区', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (150100, 150000, '呼和浩特市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150101, 150100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150102, 150100, '新城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150103, 150100, '回民区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150104, 150100, '玉泉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150105, 150100, '赛罕区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150121, 150100, '土默特左旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150122, 150100, '托克托县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150123, 150100, '和林格尔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150124, 150100, '清水河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150125, 150100, '武川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150172, 150100, '呼和浩特经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150200, 150000, '包头市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150201, 150200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150202, 150200, '东河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150203, 150200, '昆都仑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150204, 150200, '青山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150205, 150200, '石拐区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150206, 150200, '白云鄂博矿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150207, 150200, '九原区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150221, 150200, '土默特右旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150222, 150200, '固阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150223, 150200, '达尔罕茂明安联合旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150271, 150200, '包头稀土高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150300, 150000, '乌海市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150301, 150300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150302, 150300, '海勃湾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150303, 150300, '海南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150304, 150300, '乌达区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150400, 150000, '赤峰市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150401, 150400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150402, 150400, '红山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150403, 150400, '元宝山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150404, 150400, '松山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150421, 150400, '阿鲁科尔沁旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150422, 150400, '巴林左旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150423, 150400, '巴林右旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150424, 150400, '林西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150425, 150400, '克什克腾旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150426, 150400, '翁牛特旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150428, 150400, '喀喇沁旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150429, 150400, '宁城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150430, 150400, '敖汉旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150500, 150000, '通辽市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150501, 150500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150502, 150500, '科尔沁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150521, 150500, '科尔沁左翼中旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150522, 150500, '科尔沁左翼后旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150523, 150500, '开鲁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150524, 150500, '库伦旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150525, 150500, '奈曼旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150526, 150500, '扎鲁特旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150571, 150500, '通辽经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150581, 150500, '霍林郭勒市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150600, 150000, '鄂尔多斯市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150601, 150600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150602, 150600, '东胜区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150603, 150600, '康巴什区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150621, 150600, '达拉特旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150622, 150600, '准格尔旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150623, 150600, '鄂托克前旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150624, 150600, '鄂托克旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150625, 150600, '杭锦旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150626, 150600, '乌审旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150627, 150600, '伊金霍洛旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150700, 150000, '呼伦贝尔市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150701, 150700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150702, 150700, '海拉尔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150703, 150700, '扎赉诺尔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150721, 150700, '阿荣旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150722, 150700, '莫力达瓦达斡尔族自治旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150723, 150700, '鄂伦春自治旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150724, 150700, '鄂温克族自治旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150725, 150700, '陈巴尔虎旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150726, 150700, '新巴尔虎左旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150727, 150700, '新巴尔虎右旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150781, 150700, '满洲里市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150782, 150700, '牙克石市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150783, 150700, '扎兰屯市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150784, 150700, '额尔古纳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150785, 150700, '根河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150800, 150000, '巴彦淖尔市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150801, 150800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150802, 150800, '临河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150821, 150800, '五原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150822, 150800, '磴口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150823, 150800, '乌拉特前旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150824, 150800, '乌拉特中旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150825, 150800, '乌拉特后旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150826, 150800, '杭锦后旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150900, 150000, '乌兰察布市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (150901, 150900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150902, 150900, '集宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150921, 150900, '卓资县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150922, 150900, '化德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150923, 150900, '商都县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150924, 150900, '兴和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150925, 150900, '凉城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150926, 150900, '察哈尔右翼前旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150927, 150900, '察哈尔右翼中旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150928, 150900, '察哈尔右翼后旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150929, 150900, '四子王旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (150981, 150900, '丰镇市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152200, 150000, '兴安盟', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (152201, 152200, '乌兰浩特市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152202, 152200, '阿尔山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152221, 152200, '科尔沁右翼前旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152222, 152200, '科尔沁右翼中旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152223, 152200, '扎赉特旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152224, 152200, '突泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152500, 150000, '锡林郭勒盟', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (152501, 152500, '二连浩特市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152502, 152500, '锡林浩特市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152522, 152500, '阿巴嘎旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152523, 152500, '苏尼特左旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152524, 152500, '苏尼特右旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152525, 152500, '东乌珠穆沁旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152526, 152500, '西乌珠穆沁旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152527, 152500, '太仆寺旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152528, 152500, '镶黄旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152529, 152500, '正镶白旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152530, 152500, '正蓝旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152531, 152500, '多伦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152571, 152500, '乌拉盖管委会', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152900, 150000, '阿拉善盟', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (152921, 152900, '阿拉善左旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152922, 152900, '阿拉善右旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152923, 152900, '额济纳旗', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (152971, 152900, '内蒙古阿拉善高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210000, 1, '辽宁省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (210100, 210000, '沈阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210101, 210100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210102, 210100, '和平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210103, 210100, '沈河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210104, 210100, '大东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210105, 210100, '皇姑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210106, 210100, '铁西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210111, 210100, '苏家屯区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210112, 210100, '浑南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210113, 210100, '沈北新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210114, 210100, '于洪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210115, 210100, '辽中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210123, 210100, '康平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210124, 210100, '法库县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210181, 210100, '新民市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210200, 210000, '大连市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210201, 210200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210202, 210200, '中山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210203, 210200, '西岗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210204, 210200, '沙河口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210211, 210200, '甘井子区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210212, 210200, '旅顺口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210213, 210200, '金州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210214, 210200, '普兰店区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210224, 210200, '长海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210281, 210200, '瓦房店市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210283, 210200, '庄河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210300, 210000, '鞍山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210301, 210300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210302, 210300, '铁东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210303, 210300, '铁西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210304, 210300, '立山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210311, 210300, '千山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210321, 210300, '台安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210323, 210300, '岫岩满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210381, 210300, '海城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210400, 210000, '抚顺市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210401, 210400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210402, 210400, '新抚区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210403, 210400, '东洲区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210404, 210400, '望花区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210411, 210400, '顺城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210421, 210400, '抚顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210422, 210400, '新宾满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210423, 210400, '清原满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210500, 210000, '本溪市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210501, 210500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210502, 210500, '平山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210503, 210500, '溪湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210504, 210500, '明山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210505, 210500, '南芬区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210521, 210500, '本溪满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210522, 210500, '桓仁满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210600, 210000, '丹东市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210601, 210600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210602, 210600, '元宝区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210603, 210600, '振兴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210604, 210600, '振安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210624, 210600, '宽甸满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210681, 210600, '东港市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210682, 210600, '凤城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210700, 210000, '锦州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210701, 210700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210702, 210700, '古塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210703, 210700, '凌河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210711, 210700, '太和区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210726, 210700, '黑山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210727, 210700, '义县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210781, 210700, '凌海市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210782, 210700, '北镇市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210800, 210000, '营口市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210801, 210800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210802, 210800, '站前区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210803, 210800, '西市区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210804, 210800, '鲅鱼圈区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210811, 210800, '老边区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210881, 210800, '盖州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210882, 210800, '大石桥市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210900, 210000, '阜新市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (210901, 210900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210902, 210900, '海州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210903, 210900, '新邱区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210904, 210900, '太平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210905, 210900, '清河门区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210911, 210900, '细河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210921, 210900, '阜新蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (210922, 210900, '彰武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211000, 210000, '辽阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (211001, 211000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211002, 211000, '白塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211003, 211000, '文圣区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211004, 211000, '宏伟区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211005, 211000, '弓长岭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211011, 211000, '太子河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211021, 211000, '辽阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211081, 211000, '灯塔市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211100, 210000, '盘锦市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (211101, 211100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211102, 211100, '双台子区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211103, 211100, '兴隆台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211104, 211100, '大洼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211122, 211100, '盘山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211200, 210000, '铁岭市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (211201, 211200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211202, 211200, '银州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211204, 211200, '清河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211221, 211200, '铁岭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211223, 211200, '西丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211224, 211200, '昌图县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211281, 211200, '调兵山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211282, 211200, '开原市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211300, 210000, '朝阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (211301, 211300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211302, 211300, '双塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211303, 211300, '龙城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211321, 211300, '朝阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211322, 211300, '建平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211324, 211300, '喀喇沁左翼蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211381, 211300, '北票市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211382, 211300, '凌源市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211400, 210000, '葫芦岛市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (211401, 211400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211402, 211400, '连山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211403, 211400, '龙港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211404, 211400, '南票区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211421, 211400, '绥中县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211422, 211400, '建昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (211481, 211400, '兴城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220000, 1, '吉林省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (220100, 220000, '长春市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220101, 220100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220102, 220100, '南关区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220103, 220100, '宽城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220104, 220100, '朝阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220105, 220100, '二道区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220106, 220100, '绿园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220112, 220100, '双阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220113, 220100, '九台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220122, 220100, '农安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220171, 220100, '长春经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220172, 220100, '长春净月高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220173, 220100, '长春高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220174, 220100, '长春汽车经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220182, 220100, '榆树市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220183, 220100, '德惠市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220184, 220100, '公主岭市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220200, 220000, '吉林市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220201, 220200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220202, 220200, '昌邑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220203, 220200, '龙潭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220204, 220200, '船营区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220211, 220200, '丰满区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220221, 220200, '永吉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220271, 220200, '吉林经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220272, 220200, '吉林高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220273, 220200, '吉林中国新加坡食品区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220281, 220200, '蛟河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220282, 220200, '桦甸市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220283, 220200, '舒兰市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220284, 220200, '磐石市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220300, 220000, '四平市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220301, 220300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220302, 220300, '铁西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220303, 220300, '铁东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220322, 220300, '梨树县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220323, 220300, '伊通满族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220382, 220300, '双辽市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220400, 220000, '辽源市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220401, 220400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220402, 220400, '龙山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220403, 220400, '西安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220421, 220400, '东丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220422, 220400, '东辽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220500, 220000, '通化市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220501, 220500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220502, 220500, '东昌区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220503, 220500, '二道江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220521, 220500, '通化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220523, 220500, '辉南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220524, 220500, '柳河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220581, 220500, '梅河口市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220582, 220500, '集安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220600, 220000, '白山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220601, 220600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220602, 220600, '浑江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220605, 220600, '江源区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220621, 220600, '抚松县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220622, 220600, '靖宇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220623, 220600, '长白朝鲜族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220681, 220600, '临江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220700, 220000, '松原市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220701, 220700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220702, 220700, '宁江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220721, 220700, '前郭尔罗斯蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220722, 220700, '长岭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220723, 220700, '乾安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220771, 220700, '吉林松原经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220781, 220700, '扶余市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220800, 220000, '白城市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (220801, 220800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220802, 220800, '洮北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220821, 220800, '镇赉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220822, 220800, '通榆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220871, 220800, '吉林白城经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220881, 220800, '洮南市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (220882, 220800, '大安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222400, 220000, '延边朝鲜族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (222401, 222400, '延吉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222402, 222400, '图们市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222403, 222400, '敦化市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222404, 222400, '珲春市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222405, 222400, '龙井市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222406, 222400, '和龙市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222424, 222400, '汪清县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (222426, 222400, '安图县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230000, 1, '黑龙江省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (230100, 230000, '哈尔滨市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230101, 230100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230102, 230100, '道里区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230103, 230100, '南岗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230104, 230100, '道外区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230108, 230100, '平房区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230109, 230100, '松北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230110, 230100, '香坊区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230111, 230100, '呼兰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230112, 230100, '阿城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230113, 230100, '双城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230123, 230100, '依兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230124, 230100, '方正县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230125, 230100, '宾县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230126, 230100, '巴彦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230127, 230100, '木兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230128, 230100, '通河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230129, 230100, '延寿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230183, 230100, '尚志市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230184, 230100, '五常市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230200, 230000, '齐齐哈尔市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230201, 230200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230202, 230200, '龙沙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230203, 230200, '建华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230204, 230200, '铁锋区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230205, 230200, '昂昂溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230206, 230200, '富拉尔基区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230207, 230200, '碾子山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230208, 230200, '梅里斯达斡尔族区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230221, 230200, '龙江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230223, 230200, '依安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230224, 230200, '泰来县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230225, 230200, '甘南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230227, 230200, '富裕县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230229, 230200, '克山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230230, 230200, '克东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230231, 230200, '拜泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230281, 230200, '讷河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230300, 230000, '鸡西市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230301, 230300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230302, 230300, '鸡冠区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230303, 230300, '恒山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230304, 230300, '滴道区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230305, 230300, '梨树区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230306, 230300, '城子河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230307, 230300, '麻山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230321, 230300, '鸡东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230381, 230300, '虎林市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230382, 230300, '密山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230400, 230000, '鹤岗市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230401, 230400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230402, 230400, '向阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230403, 230400, '工农区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230404, 230400, '南山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230405, 230400, '兴安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230406, 230400, '东山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230407, 230400, '兴山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230421, 230400, '萝北县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230422, 230400, '绥滨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230500, 230000, '双鸭山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230501, 230500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230502, 230500, '尖山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230503, 230500, '岭东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230505, 230500, '四方台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230506, 230500, '宝山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230521, 230500, '集贤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230522, 230500, '友谊县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230523, 230500, '宝清县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230524, 230500, '饶河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230600, 230000, '大庆市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230601, 230600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230602, 230600, '萨尔图区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230603, 230600, '龙凤区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230604, 230600, '让胡路区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230605, 230600, '红岗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230606, 230600, '大同区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230621, 230600, '肇州县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230622, 230600, '肇源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230623, 230600, '林甸县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230624, 230600, '杜尔伯特蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230671, 230600, '大庆高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230700, 230000, '伊春市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230701, 230700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230717, 230700, '伊美区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230718, 230700, '乌翠区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230719, 230700, '友好区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230722, 230700, '嘉荫县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230723, 230700, '汤旺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230724, 230700, '丰林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230725, 230700, '大箐山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230726, 230700, '南岔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230751, 230700, '金林区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230781, 230700, '铁力市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230800, 230000, '佳木斯市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230801, 230800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230803, 230800, '向阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230804, 230800, '前进区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230805, 230800, '东风区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230811, 230800, '郊区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230822, 230800, '桦南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230826, 230800, '桦川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230828, 230800, '汤原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230881, 230800, '同江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230882, 230800, '富锦市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230883, 230800, '抚远市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230900, 230000, '七台河市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (230901, 230900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230902, 230900, '新兴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230903, 230900, '桃山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230904, 230900, '茄子河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (230921, 230900, '勃利县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231000, 230000, '牡丹江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (231001, 231000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231002, 231000, '东安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231003, 231000, '阳明区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231004, 231000, '爱民区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231005, 231000, '西安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231025, 231000, '林口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231071, 231000, '牡丹江经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231081, 231000, '绥芬河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231083, 231000, '海林市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231084, 231000, '宁安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231085, 231000, '穆棱市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231086, 231000, '东宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231100, 230000, '黑河市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (231101, 231100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231102, 231100, '爱辉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231123, 231100, '逊克县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231124, 231100, '孙吴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231181, 231100, '北安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231182, 231100, '五大连池市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231183, 231100, '嫩江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231200, 230000, '绥化市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (231201, 231200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231202, 231200, '北林区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231221, 231200, '望奎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231222, 231200, '兰西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231223, 231200, '青冈县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231224, 231200, '庆安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231225, 231200, '明水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231226, 231200, '绥棱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231281, 231200, '安达市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231282, 231200, '肇东市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (231283, 231200, '海伦市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232700, 230000, '大兴安岭地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (232701, 232700, '漠河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232721, 232700, '呼玛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232722, 232700, '塔河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232761, 232700, '加格达奇区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232762, 232700, '松岭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232763, 232700, '新林区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (232764, 232700, '呼中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310000, 1, '上海市', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (310100, 310000, '市辖区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (310101, 310100, '黄浦区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310104, 310100, '徐汇区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310105, 310100, '长宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310106, 310100, '静安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310107, 310100, '普陀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310109, 310100, '虹口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310110, 310100, '杨浦区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310112, 310100, '闵行区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310113, 310100, '宝山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310114, 310100, '嘉定区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310115, 310100, '浦东新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310116, 310100, '金山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310117, 310100, '松江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310118, 310100, '青浦区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310120, 310100, '奉贤区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (310151, 310100, '崇明区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320000, 1, '江苏省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (320100, 320000, '南京市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320101, 320100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320102, 320100, '玄武区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320104, 320100, '秦淮区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320105, 320100, '建邺区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320106, 320100, '鼓楼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320111, 320100, '浦口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320113, 320100, '栖霞区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320114, 320100, '雨花台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320115, 320100, '江宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320116, 320100, '六合区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320117, 320100, '溧水区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320118, 320100, '高淳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320200, 320000, '无锡市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320201, 320200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320205, 320200, '锡山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320206, 320200, '惠山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320211, 320200, '滨湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320213, 320200, '梁溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320214, 320200, '新吴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320281, 320200, '江阴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320282, 320200, '宜兴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320300, 320000, '徐州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320301, 320300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320302, 320300, '鼓楼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320303, 320300, '云龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320305, 320300, '贾汪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320311, 320300, '泉山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320312, 320300, '铜山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320321, 320300, '丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320322, 320300, '沛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320324, 320300, '睢宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320371, 320300, '徐州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320381, 320300, '新沂市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320382, 320300, '邳州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320400, 320000, '常州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320401, 320400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320402, 320400, '天宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320404, 320400, '钟楼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320411, 320400, '新北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320412, 320400, '武进区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320413, 320400, '金坛区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320481, 320400, '溧阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320500, 320000, '苏州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320501, 320500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320505, 320500, '虎丘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320506, 320500, '吴中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320507, 320500, '相城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320508, 320500, '姑苏区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320509, 320500, '吴江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320571, 320500, '苏州工业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320581, 320500, '常熟市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320582, 320500, '张家港市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320583, 320500, '昆山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320585, 320500, '太仓市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320600, 320000, '南通市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320601, 320600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320612, 320600, '通州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320613, 320600, '崇川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320614, 320600, '海门区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320623, 320600, '如东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320671, 320600, '南通经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320681, 320600, '启东市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320682, 320600, '如皋市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320685, 320600, '海安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320700, 320000, '连云港市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320701, 320700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320703, 320700, '连云区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320706, 320700, '海州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320707, 320700, '赣榆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320722, 320700, '东海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320723, 320700, '灌云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320724, 320700, '灌南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320771, 320700, '连云港经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320772, 320700, '连云港高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320800, 320000, '淮安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320801, 320800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320803, 320800, '淮安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320804, 320800, '淮阴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320812, 320800, '清江浦区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320813, 320800, '洪泽区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320826, 320800, '涟水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320830, 320800, '盱眙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320831, 320800, '金湖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320871, 320800, '淮安经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320900, 320000, '盐城市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (320901, 320900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320902, 320900, '亭湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320903, 320900, '盐都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320904, 320900, '大丰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320921, 320900, '响水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320922, 320900, '滨海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320923, 320900, '阜宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320924, 320900, '射阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320925, 320900, '建湖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320971, 320900, '盐城经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (320981, 320900, '东台市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321000, 320000, '扬州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (321001, 321000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321002, 321000, '广陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321003, 321000, '邗江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321012, 321000, '江都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321023, 321000, '宝应县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321071, 321000, '扬州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321081, 321000, '仪征市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321084, 321000, '高邮市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321100, 320000, '镇江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (321101, 321100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321102, 321100, '京口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321111, 321100, '润州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321112, 321100, '丹徒区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321171, 321100, '镇江新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321181, 321100, '丹阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321182, 321100, '扬中市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321183, 321100, '句容市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321200, 320000, '泰州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (321201, 321200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321202, 321200, '海陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321203, 321200, '高港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321204, 321200, '姜堰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321271, 321200, '泰州医药高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321281, 321200, '兴化市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321282, 321200, '靖江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321283, 321200, '泰兴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321300, 320000, '宿迁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (321301, 321300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321302, 321300, '宿城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321311, 321300, '宿豫区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321322, 321300, '沭阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321323, 321300, '泗阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321324, 321300, '泗洪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (321371, 321300, '宿迁经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330000, 1, '浙江省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (330100, 330000, '杭州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330101, 330100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330102, 330100, '上城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330105, 330100, '拱墅区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330106, 330100, '西湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330108, 330100, '滨江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330109, 330100, '萧山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330110, 330100, '余杭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330111, 330100, '富阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330112, 330100, '临安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330113, 330100, '临平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330114, 330100, '钱塘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330122, 330100, '桐庐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330127, 330100, '淳安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330182, 330100, '建德市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330200, 330000, '宁波市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330201, 330200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330203, 330200, '海曙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330205, 330200, '江北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330206, 330200, '北仑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330211, 330200, '镇海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330212, 330200, '鄞州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330213, 330200, '奉化区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330225, 330200, '象山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330226, 330200, '宁海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330281, 330200, '余姚市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330282, 330200, '慈溪市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330300, 330000, '温州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330301, 330300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330302, 330300, '鹿城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330303, 330300, '龙湾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330304, 330300, '瓯海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330305, 330300, '洞头区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330324, 330300, '永嘉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330326, 330300, '平阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330327, 330300, '苍南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330328, 330300, '文成县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330329, 330300, '泰顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330371, 330300, '温州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330381, 330300, '瑞安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330382, 330300, '乐清市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330383, 330300, '龙港市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330400, 330000, '嘉兴市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330401, 330400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330402, 330400, '南湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330411, 330400, '秀洲区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330421, 330400, '嘉善县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330424, 330400, '海盐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330481, 330400, '海宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330482, 330400, '平湖市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330483, 330400, '桐乡市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330500, 330000, '湖州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330501, 330500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330502, 330500, '吴兴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330503, 330500, '南浔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330521, 330500, '德清县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330522, 330500, '长兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330523, 330500, '安吉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330600, 330000, '绍兴市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330601, 330600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330602, 330600, '越城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330603, 330600, '柯桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330604, 330600, '上虞区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330624, 330600, '新昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330681, 330600, '诸暨市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330683, 330600, '嵊州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330700, 330000, '金华市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330701, 330700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330702, 330700, '婺城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330703, 330700, '金东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330723, 330700, '武义县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330726, 330700, '浦江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330727, 330700, '磐安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330781, 330700, '兰溪市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330782, 330700, '义乌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330783, 330700, '东阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330784, 330700, '永康市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330800, 330000, '衢州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330801, 330800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330802, 330800, '柯城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330803, 330800, '衢江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330822, 330800, '常山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330824, 330800, '开化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330825, 330800, '龙游县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330881, 330800, '江山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330900, 330000, '舟山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (330901, 330900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330902, 330900, '定海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330903, 330900, '普陀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330921, 330900, '岱山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (330922, 330900, '嵊泗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331000, 330000, '台州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (331001, 331000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331002, 331000, '椒江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331003, 331000, '黄岩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331004, 331000, '路桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331022, 331000, '三门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331023, 331000, '天台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331024, 331000, '仙居县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331081, 331000, '温岭市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331082, 331000, '临海市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331083, 331000, '玉环市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331100, 330000, '丽水市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (331101, 331100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331102, 331100, '莲都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331121, 331100, '青田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331122, 331100, '缙云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331123, 331100, '遂昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331124, 331100, '松阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331125, 331100, '云和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331126, 331100, '庆元县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331127, 331100, '景宁畲族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (331181, 331100, '龙泉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340000, 1, '安徽省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (340100, 340000, '合肥市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340101, 340100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340102, 340100, '瑶海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340103, 340100, '庐阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340104, 340100, '蜀山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340111, 340100, '包河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340121, 340100, '长丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340122, 340100, '肥东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340123, 340100, '肥西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340124, 340100, '庐江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340171, 340100, '合肥高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340172, 340100, '合肥经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340173, 340100, '合肥新站高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340181, 340100, '巢湖市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340200, 340000, '芜湖市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340201, 340200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340202, 340200, '镜湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340207, 340200, '鸠江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340209, 340200, '弋江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340210, 340200, '湾沚区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340212, 340200, '繁昌区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340223, 340200, '南陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340271, 340200, '芜湖经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340272, 340200, '安徽芜湖三山经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340281, 340200, '无为市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340300, 340000, '蚌埠市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340301, 340300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340302, 340300, '龙子湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340303, 340300, '蚌山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340304, 340300, '禹会区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340311, 340300, '淮上区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340321, 340300, '怀远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340322, 340300, '五河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340323, 340300, '固镇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340371, 340300, '蚌埠市高新技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340372, 340300, '蚌埠市经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340400, 340000, '淮南市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340401, 340400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340402, 340400, '大通区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340403, 340400, '田家庵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340404, 340400, '谢家集区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340405, 340400, '八公山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340406, 340400, '潘集区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340421, 340400, '凤台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340422, 340400, '寿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340500, 340000, '马鞍山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340501, 340500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340503, 340500, '花山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340504, 340500, '雨山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340506, 340500, '博望区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340521, 340500, '当涂县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340522, 340500, '含山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340523, 340500, '和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340600, 340000, '淮北市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340601, 340600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340602, 340600, '杜集区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340603, 340600, '相山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340604, 340600, '烈山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340621, 340600, '濉溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340700, 340000, '铜陵市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340701, 340700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340705, 340700, '铜官区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340706, 340700, '义安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340711, 340700, '郊区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340722, 340700, '枞阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340800, 340000, '安庆市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (340801, 340800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340802, 340800, '迎江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340803, 340800, '大观区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340811, 340800, '宜秀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340822, 340800, '怀宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340825, 340800, '太湖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340826, 340800, '宿松县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340827, 340800, '望江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340828, 340800, '岳西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340871, 340800, '安徽安庆经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340881, 340800, '桐城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (340882, 340800, '潜山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341000, 340000, '黄山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341001, 341000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341002, 341000, '屯溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341003, 341000, '黄山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341004, 341000, '徽州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341021, 341000, '歙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341022, 341000, '休宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341023, 341000, '黟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341024, 341000, '祁门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341100, 340000, '滁州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341101, 341100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341102, 341100, '琅琊区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341103, 341100, '南谯区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341122, 341100, '来安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341124, 341100, '全椒县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341125, 341100, '定远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341126, 341100, '凤阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341171, 341100, '中新苏滁高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341172, 341100, '滁州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341181, 341100, '天长市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341182, 341100, '明光市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341200, 340000, '阜阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341201, 341200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341202, 341200, '颍州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341203, 341200, '颍东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341204, 341200, '颍泉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341221, 341200, '临泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341222, 341200, '太和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341225, 341200, '阜南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341226, 341200, '颍上县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341271, 341200, '阜阳合肥现代产业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341272, 341200, '阜阳经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341282, 341200, '界首市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341300, 340000, '宿州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341301, 341300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341302, 341300, '埇桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341321, 341300, '砀山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341322, 341300, '萧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341323, 341300, '灵璧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341324, 341300, '泗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341371, 341300, '宿州马鞍山现代产业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341372, 341300, '宿州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341500, 340000, '六安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341501, 341500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341502, 341500, '金安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341503, 341500, '裕安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341504, 341500, '叶集区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341522, 341500, '霍邱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341523, 341500, '舒城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341524, 341500, '金寨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341525, 341500, '霍山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341600, 340000, '亳州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341601, 341600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341602, 341600, '谯城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341621, 341600, '涡阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341622, 341600, '蒙城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341623, 341600, '利辛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341700, 340000, '池州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341701, 341700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341702, 341700, '贵池区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341721, 341700, '东至县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341722, 341700, '石台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341723, 341700, '青阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341800, 340000, '宣城市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (341801, 341800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341802, 341800, '宣州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341821, 341800, '郎溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341823, 341800, '泾县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341824, 341800, '绩溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341825, 341800, '旌德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341871, 341800, '宣城市经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341881, 341800, '宁国市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (341882, 341800, '广德市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350000, 1, '福建省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (350100, 350000, '福州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350101, 350100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350102, 350100, '鼓楼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350103, 350100, '台江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350104, 350100, '仓山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350105, 350100, '马尾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350111, 350100, '晋安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350112, 350100, '长乐区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350121, 350100, '闽侯县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350122, 350100, '连江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350123, 350100, '罗源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350124, 350100, '闽清县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350125, 350100, '永泰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350128, 350100, '平潭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350181, 350100, '福清市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350200, 350000, '厦门市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350201, 350200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350203, 350200, '思明区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350205, 350200, '海沧区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350206, 350200, '湖里区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350211, 350200, '集美区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350212, 350200, '同安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350213, 350200, '翔安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350300, 350000, '莆田市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350301, 350300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350302, 350300, '城厢区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350303, 350300, '涵江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350304, 350300, '荔城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350305, 350300, '秀屿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350322, 350300, '仙游县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350400, 350000, '三明市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350401, 350400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350404, 350400, '三元区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350405, 350400, '沙县区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350421, 350400, '明溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350423, 350400, '清流县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350424, 350400, '宁化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350425, 350400, '大田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350426, 350400, '尤溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350428, 350400, '将乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350429, 350400, '泰宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350430, 350400, '建宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350481, 350400, '永安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350500, 350000, '泉州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350501, 350500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350502, 350500, '鲤城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350503, 350500, '丰泽区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350504, 350500, '洛江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350505, 350500, '泉港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350521, 350500, '惠安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350524, 350500, '安溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350525, 350500, '永春县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350526, 350500, '德化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350527, 350500, '金门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350581, 350500, '石狮市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350582, 350500, '晋江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350583, 350500, '南安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350600, 350000, '漳州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350601, 350600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350602, 350600, '芗城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350603, 350600, '龙文区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350604, 350600, '龙海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350605, 350600, '长泰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350622, 350600, '云霄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350623, 350600, '漳浦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350624, 350600, '诏安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350626, 350600, '东山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350627, 350600, '南靖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350628, 350600, '平和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350629, 350600, '华安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350700, 350000, '南平市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350701, 350700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350702, 350700, '延平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350703, 350700, '建阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350721, 350700, '顺昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350722, 350700, '浦城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350723, 350700, '光泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350724, 350700, '松溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350725, 350700, '政和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350781, 350700, '邵武市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350782, 350700, '武夷山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350783, 350700, '建瓯市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350800, 350000, '龙岩市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350801, 350800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350802, 350800, '新罗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350803, 350800, '永定区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350821, 350800, '长汀县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350823, 350800, '上杭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350824, 350800, '武平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350825, 350800, '连城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350881, 350800, '漳平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350900, 350000, '宁德市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (350901, 350900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350902, 350900, '蕉城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350921, 350900, '霞浦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350922, 350900, '古田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350923, 350900, '屏南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350924, 350900, '寿宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350925, 350900, '周宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350926, 350900, '柘荣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350981, 350900, '福安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (350982, 350900, '福鼎市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360000, 1, '江西省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (360100, 360000, '南昌市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360101, 360100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360102, 360100, '东湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360103, 360100, '西湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360104, 360100, '青云谱区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360111, 360100, '青山湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360112, 360100, '新建区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360113, 360100, '红谷滩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360121, 360100, '南昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360123, 360100, '安义县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360124, 360100, '进贤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360200, 360000, '景德镇市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360201, 360200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360202, 360200, '昌江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360203, 360200, '珠山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360222, 360200, '浮梁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360281, 360200, '乐平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360300, 360000, '萍乡市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360301, 360300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360302, 360300, '安源区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360313, 360300, '湘东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360321, 360300, '莲花县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360322, 360300, '上栗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360323, 360300, '芦溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360400, 360000, '九江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360401, 360400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360402, 360400, '濂溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360403, 360400, '浔阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360404, 360400, '柴桑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360423, 360400, '武宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360424, 360400, '修水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360425, 360400, '永修县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360426, 360400, '德安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360428, 360400, '都昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360429, 360400, '湖口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360430, 360400, '彭泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360481, 360400, '瑞昌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360482, 360400, '共青城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360483, 360400, '庐山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360500, 360000, '新余市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360501, 360500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360502, 360500, '渝水区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360521, 360500, '分宜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360600, 360000, '鹰潭市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360601, 360600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360602, 360600, '月湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360603, 360600, '余江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360681, 360600, '贵溪市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360700, 360000, '赣州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360701, 360700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360702, 360700, '章贡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360703, 360700, '南康区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360704, 360700, '赣县区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360722, 360700, '信丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360723, 360700, '大余县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360724, 360700, '上犹县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360725, 360700, '崇义县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360726, 360700, '安远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360728, 360700, '定南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360729, 360700, '全南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360730, 360700, '宁都县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360731, 360700, '于都县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360732, 360700, '兴国县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360733, 360700, '会昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360734, 360700, '寻乌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360735, 360700, '石城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360781, 360700, '瑞金市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360783, 360700, '龙南市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360800, 360000, '吉安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360801, 360800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360802, 360800, '吉州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360803, 360800, '青原区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360821, 360800, '吉安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360822, 360800, '吉水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360823, 360800, '峡江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360824, 360800, '新干县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360825, 360800, '永丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360826, 360800, '泰和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360827, 360800, '遂川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360828, 360800, '万安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360829, 360800, '安福县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360830, 360800, '永新县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360881, 360800, '井冈山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360900, 360000, '宜春市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (360901, 360900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360902, 360900, '袁州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360921, 360900, '奉新县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360922, 360900, '万载县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360923, 360900, '上高县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360924, 360900, '宜丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360925, 360900, '靖安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360926, 360900, '铜鼓县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360981, 360900, '丰城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360982, 360900, '樟树市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (360983, 360900, '高安市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361000, 360000, '抚州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (361001, 361000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361002, 361000, '临川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361003, 361000, '东乡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361021, 361000, '南城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361022, 361000, '黎川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361023, 361000, '南丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361024, 361000, '崇仁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361025, 361000, '乐安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361026, 361000, '宜黄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361027, 361000, '金溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361028, 361000, '资溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361030, 361000, '广昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361100, 360000, '上饶市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (361101, 361100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361102, 361100, '信州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361103, 361100, '广丰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361104, 361100, '广信区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361123, 361100, '玉山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361124, 361100, '铅山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361125, 361100, '横峰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361126, 361100, '弋阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361127, 361100, '余干县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361128, 361100, '鄱阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361129, 361100, '万年县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361130, 361100, '婺源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (361181, 361100, '德兴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370000, 1, '山东省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (370100, 370000, '济南市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370101, 370100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370102, 370100, '历下区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370103, 370100, '市中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370104, 370100, '槐荫区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370105, 370100, '天桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370112, 370100, '历城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370113, 370100, '长清区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370114, 370100, '章丘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370115, 370100, '济阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370116, 370100, '莱芜区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370117, 370100, '钢城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370124, 370100, '平阴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370126, 370100, '商河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370171, 370100, '济南高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370200, 370000, '青岛市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370201, 370200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370202, 370200, '市南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370203, 370200, '市北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370211, 370200, '黄岛区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370212, 370200, '崂山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370213, 370200, '李沧区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370214, 370200, '城阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370215, 370200, '即墨区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370271, 370200, '青岛高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370281, 370200, '胶州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370283, 370200, '平度市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370285, 370200, '莱西市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370300, 370000, '淄博市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370301, 370300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370302, 370300, '淄川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370303, 370300, '张店区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370304, 370300, '博山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370305, 370300, '临淄区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370306, 370300, '周村区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370321, 370300, '桓台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370322, 370300, '高青县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370323, 370300, '沂源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370400, 370000, '枣庄市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370401, 370400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370402, 370400, '市中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370403, 370400, '薛城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370404, 370400, '峄城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370405, 370400, '台儿庄区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370406, 370400, '山亭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370481, 370400, '滕州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370500, 370000, '东营市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370501, 370500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370502, 370500, '东营区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370503, 370500, '河口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370505, 370500, '垦利区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370522, 370500, '利津县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370523, 370500, '广饶县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370571, 370500, '东营经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370572, 370500, '东营港经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370600, 370000, '烟台市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370601, 370600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370602, 370600, '芝罘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370611, 370600, '福山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370612, 370600, '牟平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370613, 370600, '莱山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370614, 370600, '蓬莱区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370671, 370600, '烟台高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370672, 370600, '烟台经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370681, 370600, '龙口市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370682, 370600, '莱阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370683, 370600, '莱州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370685, 370600, '招远市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370686, 370600, '栖霞市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370687, 370600, '海阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370700, 370000, '潍坊市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370701, 370700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370702, 370700, '潍城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370703, 370700, '寒亭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370704, 370700, '坊子区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370705, 370700, '奎文区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370724, 370700, '临朐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370725, 370700, '昌乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370772, 370700, '潍坊滨海经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370781, 370700, '青州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370782, 370700, '诸城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370783, 370700, '寿光市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370784, 370700, '安丘市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370785, 370700, '高密市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370786, 370700, '昌邑市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370800, 370000, '济宁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370801, 370800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370811, 370800, '任城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370812, 370800, '兖州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370826, 370800, '微山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370827, 370800, '鱼台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370828, 370800, '金乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370829, 370800, '嘉祥县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370830, 370800, '汶上县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370831, 370800, '泗水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370832, 370800, '梁山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370871, 370800, '济宁高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370881, 370800, '曲阜市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370883, 370800, '邹城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370900, 370000, '泰安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (370901, 370900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370902, 370900, '泰山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370911, 370900, '岱岳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370921, 370900, '宁阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370923, 370900, '东平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370982, 370900, '新泰市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (370983, 370900, '肥城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371000, 370000, '威海市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371001, 371000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371002, 371000, '环翠区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371003, 371000, '文登区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371071, 371000, '威海火炬高技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371072, 371000, '威海经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371073, 371000, '威海临港经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371082, 371000, '荣成市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371083, 371000, '乳山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371100, 370000, '日照市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371101, 371100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371102, 371100, '东港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371103, 371100, '岚山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371121, 371100, '五莲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371122, 371100, '莒县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371171, 371100, '日照经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371300, 370000, '临沂市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371301, 371300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371302, 371300, '兰山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371311, 371300, '罗庄区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371312, 371300, '河东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371321, 371300, '沂南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371322, 371300, '郯城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371323, 371300, '沂水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371324, 371300, '兰陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371325, 371300, '费县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371326, 371300, '平邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371327, 371300, '莒南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371328, 371300, '蒙阴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371329, 371300, '临沭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371371, 371300, '临沂高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371400, 370000, '德州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371401, 371400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371402, 371400, '德城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371403, 371400, '陵城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371422, 371400, '宁津县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371423, 371400, '庆云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371424, 371400, '临邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371425, 371400, '齐河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371426, 371400, '平原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371427, 371400, '夏津县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371428, 371400, '武城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371471, 371400, '德州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371472, 371400, '德州运河经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371481, 371400, '乐陵市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371482, 371400, '禹城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371500, 370000, '聊城市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371501, 371500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371502, 371500, '东昌府区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371503, 371500, '茌平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371521, 371500, '阳谷县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371522, 371500, '莘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371524, 371500, '东阿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371525, 371500, '冠县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371526, 371500, '高唐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371581, 371500, '临清市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371600, 370000, '滨州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371601, 371600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371602, 371600, '滨城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371603, 371600, '沾化区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371621, 371600, '惠民县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371622, 371600, '阳信县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371623, 371600, '无棣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371625, 371600, '博兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371681, 371600, '邹平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371700, 370000, '菏泽市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (371701, 371700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371702, 371700, '牡丹区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371703, 371700, '定陶区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371721, 371700, '曹县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371722, 371700, '单县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371723, 371700, '成武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371724, 371700, '巨野县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371725, 371700, '郓城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371726, 371700, '鄄城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371728, 371700, '东明县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371771, 371700, '菏泽经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (371772, 371700, '菏泽高新技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410000, 1, '河南省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (410100, 410000, '郑州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410101, 410100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410102, 410100, '中原区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410103, 410100, '二七区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410104, 410100, '管城回族区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410105, 410100, '金水区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410106, 410100, '上街区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410108, 410100, '惠济区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410122, 410100, '中牟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410171, 410100, '郑州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410172, 410100, '郑州高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410173, 410100, '郑州航空港经济综合实验区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410181, 410100, '巩义市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410182, 410100, '荥阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410183, 410100, '新密市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410184, 410100, '新郑市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410185, 410100, '登封市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410200, 410000, '开封市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410201, 410200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410202, 410200, '龙亭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410203, 410200, '顺河回族区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410204, 410200, '鼓楼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410205, 410200, '禹王台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410212, 410200, '祥符区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410221, 410200, '杞县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410222, 410200, '通许县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410223, 410200, '尉氏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410225, 410200, '兰考县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410300, 410000, '洛阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410301, 410300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410302, 410300, '老城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410303, 410300, '西工区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410304, 410300, '瀍河回族区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410305, 410300, '涧西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410307, 410300, '偃师区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410308, 410300, '孟津区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410311, 410300, '洛龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410323, 410300, '新安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410324, 410300, '栾川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410325, 410300, '嵩县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410326, 410300, '汝阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410327, 410300, '宜阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410328, 410300, '洛宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410329, 410300, '伊川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410371, 410300, '洛阳高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410400, 410000, '平顶山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410401, 410400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410402, 410400, '新华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410403, 410400, '卫东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410404, 410400, '石龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410411, 410400, '湛河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410421, 410400, '宝丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410422, 410400, '叶县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410423, 410400, '鲁山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410425, 410400, '郏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410471, 410400, '平顶山高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410472, 410400, '平顶山市城乡一体化示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410481, 410400, '舞钢市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410482, 410400, '汝州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410500, 410000, '安阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410501, 410500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410502, 410500, '文峰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410503, 410500, '北关区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410505, 410500, '殷都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410506, 410500, '龙安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410522, 410500, '安阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410523, 410500, '汤阴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410526, 410500, '滑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410527, 410500, '内黄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410571, 410500, '安阳高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410581, 410500, '林州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410600, 410000, '鹤壁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410601, 410600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410602, 410600, '鹤山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410603, 410600, '山城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410611, 410600, '淇滨区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410621, 410600, '浚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410622, 410600, '淇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410671, 410600, '鹤壁经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410700, 410000, '新乡市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410701, 410700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410702, 410700, '红旗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410703, 410700, '卫滨区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410704, 410700, '凤泉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410711, 410700, '牧野区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410721, 410700, '新乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410724, 410700, '获嘉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410725, 410700, '原阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410726, 410700, '延津县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410727, 410700, '封丘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410771, 410700, '新乡高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410772, 410700, '新乡经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410773, 410700, '新乡市平原城乡一体化示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410781, 410700, '卫辉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410782, 410700, '辉县市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410783, 410700, '长垣市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410800, 410000, '焦作市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410801, 410800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410802, 410800, '解放区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410803, 410800, '中站区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410804, 410800, '马村区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410811, 410800, '山阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410821, 410800, '修武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410822, 410800, '博爱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410823, 410800, '武陟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410825, 410800, '温县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410871, 410800, '焦作城乡一体化示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410882, 410800, '沁阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410883, 410800, '孟州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410900, 410000, '濮阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (410901, 410900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410902, 410900, '华龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410922, 410900, '清丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410923, 410900, '南乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410926, 410900, '范县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410927, 410900, '台前县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410928, 410900, '濮阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410971, 410900, '河南濮阳工业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (410972, 410900, '濮阳经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411000, 410000, '许昌市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411001, 411000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411002, 411000, '魏都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411003, 411000, '建安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411024, 411000, '鄢陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411025, 411000, '襄城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411071, 411000, '许昌经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411081, 411000, '禹州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411082, 411000, '长葛市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411100, 410000, '漯河市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411101, 411100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411102, 411100, '源汇区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411103, 411100, '郾城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411104, 411100, '召陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411121, 411100, '舞阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411122, 411100, '临颍县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411171, 411100, '漯河经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411200, 410000, '三门峡市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411201, 411200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411202, 411200, '湖滨区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411203, 411200, '陕州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411221, 411200, '渑池县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411224, 411200, '卢氏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411271, 411200, '河南三门峡经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411281, 411200, '义马市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411282, 411200, '灵宝市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411300, 410000, '南阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411301, 411300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411302, 411300, '宛城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411303, 411300, '卧龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411321, 411300, '南召县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411322, 411300, '方城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411323, 411300, '西峡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411324, 411300, '镇平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411325, 411300, '内乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411326, 411300, '淅川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411327, 411300, '社旗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411328, 411300, '唐河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411329, 411300, '新野县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411330, 411300, '桐柏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411371, 411300, '南阳高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411372, 411300, '南阳市城乡一体化示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411381, 411300, '邓州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411400, 410000, '商丘市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411401, 411400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411402, 411400, '梁园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411403, 411400, '睢阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411421, 411400, '民权县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411422, 411400, '睢县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411423, 411400, '宁陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411424, 411400, '柘城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411425, 411400, '虞城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411426, 411400, '夏邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411471, 411400, '豫东综合物流产业聚集区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411472, 411400, '河南商丘经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411481, 411400, '永城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411500, 410000, '信阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411501, 411500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411502, 411500, '浉河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411503, 411500, '平桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411521, 411500, '罗山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411522, 411500, '光山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411523, 411500, '新县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411524, 411500, '商城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411525, 411500, '固始县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411526, 411500, '潢川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411527, 411500, '淮滨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411528, 411500, '息县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411571, 411500, '信阳高新技术产业开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411600, 410000, '周口市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411601, 411600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411602, 411600, '川汇区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411603, 411600, '淮阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411621, 411600, '扶沟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411622, 411600, '西华县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411623, 411600, '商水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411624, 411600, '沈丘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411625, 411600, '郸城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411627, 411600, '太康县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411628, 411600, '鹿邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411671, 411600, '河南周口经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411681, 411600, '项城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411700, 410000, '驻马店市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (411701, 411700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411702, 411700, '驿城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411721, 411700, '西平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411722, 411700, '上蔡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411723, 411700, '平舆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411724, 411700, '正阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411725, 411700, '确山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411726, 411700, '泌阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411727, 411700, '汝南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411728, 411700, '遂平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411729, 411700, '新蔡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (411771, 411700, '河南驻马店经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (419000, 410000, '省直辖县级行政区划', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (419001, 419000, '济源市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420000, 1, '湖北省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (420100, 420000, '武汉市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420101, 420100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420102, 420100, '江岸区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420103, 420100, '江汉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420104, 420100, '硚口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420105, 420100, '汉阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420106, 420100, '武昌区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420107, 420100, '青山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420111, 420100, '洪山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420112, 420100, '东西湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420113, 420100, '汉南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420114, 420100, '蔡甸区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420115, 420100, '江夏区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420116, 420100, '黄陂区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420117, 420100, '新洲区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420200, 420000, '黄石市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420201, 420200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420202, 420200, '黄石港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420203, 420200, '西塞山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420204, 420200, '下陆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420205, 420200, '铁山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420222, 420200, '阳新县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420281, 420200, '大冶市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420300, 420000, '十堰市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420301, 420300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420302, 420300, '茅箭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420303, 420300, '张湾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420304, 420300, '郧阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420322, 420300, '郧西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420323, 420300, '竹山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420324, 420300, '竹溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420325, 420300, '房县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420381, 420300, '丹江口市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420500, 420000, '宜昌市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420501, 420500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420502, 420500, '西陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420503, 420500, '伍家岗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420504, 420500, '点军区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420505, 420500, '猇亭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420506, 420500, '夷陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420525, 420500, '远安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420526, 420500, '兴山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420527, 420500, '秭归县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420528, 420500, '长阳土家族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420529, 420500, '五峰土家族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420581, 420500, '宜都市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420582, 420500, '当阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420583, 420500, '枝江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420600, 420000, '襄阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420601, 420600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420602, 420600, '襄城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420606, 420600, '樊城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420607, 420600, '襄州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420624, 420600, '南漳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420625, 420600, '谷城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420626, 420600, '保康县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420682, 420600, '老河口市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420683, 420600, '枣阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420684, 420600, '宜城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420700, 420000, '鄂州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420701, 420700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420702, 420700, '梁子湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420703, 420700, '华容区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420704, 420700, '鄂城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420800, 420000, '荆门市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420801, 420800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420802, 420800, '东宝区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420804, 420800, '掇刀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420822, 420800, '沙洋县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420881, 420800, '钟祥市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420882, 420800, '京山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420900, 420000, '孝感市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (420901, 420900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420902, 420900, '孝南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420921, 420900, '孝昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420922, 420900, '大悟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420923, 420900, '云梦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420981, 420900, '应城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420982, 420900, '安陆市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (420984, 420900, '汉川市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421000, 420000, '荆州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (421001, 421000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421002, 421000, '沙市区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421003, 421000, '荆州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421022, 421000, '公安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421024, 421000, '江陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421071, 421000, '荆州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421081, 421000, '石首市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421083, 421000, '洪湖市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421087, 421000, '松滋市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421088, 421000, '监利市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421100, 420000, '黄冈市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (421101, 421100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421102, 421100, '黄州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421121, 421100, '团风县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421122, 421100, '红安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421123, 421100, '罗田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421124, 421100, '英山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421125, 421100, '浠水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421126, 421100, '蕲春县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421127, 421100, '黄梅县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421171, 421100, '龙感湖管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421181, 421100, '麻城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421182, 421100, '武穴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421200, 420000, '咸宁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (421201, 421200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421202, 421200, '咸安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421221, 421200, '嘉鱼县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421222, 421200, '通城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421223, 421200, '崇阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421224, 421200, '通山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421281, 421200, '赤壁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421300, 420000, '随州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (421301, 421300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421303, 421300, '曾都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421321, 421300, '随县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (421381, 421300, '广水市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422800, 420000, '恩施土家族苗族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (422801, 422800, '恩施市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422802, 422800, '利川市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422822, 422800, '建始县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422823, 422800, '巴东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422825, 422800, '宣恩县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422826, 422800, '咸丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422827, 422800, '来凤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (422828, 422800, '鹤峰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (429000, 420000, '省直辖县级行政区划', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (429004, 429000, '仙桃市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (429005, 429000, '潜江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (429006, 429000, '天门市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (429021, 429000, '神农架林区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430000, 1, '湖南省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (430100, 430000, '长沙市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430101, 430100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430102, 430100, '芙蓉区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430103, 430100, '天心区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430104, 430100, '岳麓区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430105, 430100, '开福区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430111, 430100, '雨花区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430112, 430100, '望城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430121, 430100, '长沙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430181, 430100, '浏阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430182, 430100, '宁乡市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430200, 430000, '株洲市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430201, 430200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430202, 430200, '荷塘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430203, 430200, '芦淞区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430204, 430200, '石峰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430211, 430200, '天元区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430212, 430200, '渌口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430223, 430200, '攸县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430224, 430200, '茶陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430225, 430200, '炎陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430271, 430200, '云龙示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430281, 430200, '醴陵市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430300, 430000, '湘潭市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430301, 430300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430302, 430300, '雨湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430304, 430300, '岳塘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430321, 430300, '湘潭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430371, 430300, '湖南湘潭高新技术产业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430372, 430300, '湘潭昭山示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430373, 430300, '湘潭九华示范区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430381, 430300, '湘乡市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430382, 430300, '韶山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430400, 430000, '衡阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430401, 430400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430405, 430400, '珠晖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430406, 430400, '雁峰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430407, 430400, '石鼓区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430408, 430400, '蒸湘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430412, 430400, '南岳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430421, 430400, '衡阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430422, 430400, '衡南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430423, 430400, '衡山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430424, 430400, '衡东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430426, 430400, '祁东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430471, 430400, '衡阳综合保税区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430472, 430400, '湖南衡阳高新技术产业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430473, 430400, '湖南衡阳松木经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430481, 430400, '耒阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430482, 430400, '常宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430500, 430000, '邵阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430501, 430500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430502, 430500, '双清区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430503, 430500, '大祥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430511, 430500, '北塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430522, 430500, '新邵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430523, 430500, '邵阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430524, 430500, '隆回县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430525, 430500, '洞口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430527, 430500, '绥宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430528, 430500, '新宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430529, 430500, '城步苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430581, 430500, '武冈市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430582, 430500, '邵东市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430600, 430000, '岳阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430601, 430600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430602, 430600, '岳阳楼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430603, 430600, '云溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430611, 430600, '君山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430621, 430600, '岳阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430623, 430600, '华容县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430624, 430600, '湘阴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430626, 430600, '平江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430671, 430600, '岳阳市屈原管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430681, 430600, '汨罗市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430682, 430600, '临湘市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430700, 430000, '常德市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430701, 430700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430702, 430700, '武陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430703, 430700, '鼎城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430721, 430700, '安乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430722, 430700, '汉寿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430723, 430700, '澧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430724, 430700, '临澧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430725, 430700, '桃源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430726, 430700, '石门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430771, 430700, '常德市西洞庭管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430781, 430700, '津市市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430800, 430000, '张家界市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430801, 430800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430802, 430800, '永定区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430811, 430800, '武陵源区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430821, 430800, '慈利县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430822, 430800, '桑植县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430900, 430000, '益阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (430901, 430900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430902, 430900, '资阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430903, 430900, '赫山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430921, 430900, '南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430922, 430900, '桃江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430923, 430900, '安化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430971, 430900, '益阳市大通湖管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430972, 430900, '湖南益阳高新技术产业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (430981, 430900, '沅江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431000, 430000, '郴州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (431001, 431000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431002, 431000, '北湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431003, 431000, '苏仙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431021, 431000, '桂阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431022, 431000, '宜章县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431023, 431000, '永兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431024, 431000, '嘉禾县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431025, 431000, '临武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431026, 431000, '汝城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431027, 431000, '桂东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431028, 431000, '安仁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431081, 431000, '资兴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431100, 430000, '永州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (431101, 431100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431102, 431100, '零陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431103, 431100, '冷水滩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431122, 431100, '东安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431123, 431100, '双牌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431124, 431100, '道县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431125, 431100, '江永县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431126, 431100, '宁远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431127, 431100, '蓝山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431128, 431100, '新田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431129, 431100, '江华瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431171, 431100, '永州经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431173, 431100, '永州市回龙圩管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431181, 431100, '祁阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431200, 430000, '怀化市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (431201, 431200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431202, 431200, '鹤城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431221, 431200, '中方县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431222, 431200, '沅陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431223, 431200, '辰溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431224, 431200, '溆浦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431225, 431200, '会同县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431226, 431200, '麻阳苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431227, 431200, '新晃侗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431228, 431200, '芷江侗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431229, 431200, '靖州苗族侗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431230, 431200, '通道侗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431271, 431200, '怀化市洪江管理区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431281, 431200, '洪江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431300, 430000, '娄底市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (431301, 431300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431302, 431300, '娄星区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431321, 431300, '双峰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431322, 431300, '新化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431381, 431300, '冷水江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (431382, 431300, '涟源市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433100, 430000, '湘西土家族苗族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (433101, 433100, '吉首市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433122, 433100, '泸溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433123, 433100, '凤凰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433124, 433100, '花垣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433125, 433100, '保靖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433126, 433100, '古丈县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433127, 433100, '永顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (433130, 433100, '龙山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440000, 1, '广东省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (440100, 440000, '广州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440101, 440100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440103, 440100, '荔湾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440104, 440100, '越秀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440105, 440100, '海珠区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440106, 440100, '天河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440111, 440100, '白云区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440112, 440100, '黄埔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440113, 440100, '番禺区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440114, 440100, '花都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440115, 440100, '南沙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440117, 440100, '从化区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440118, 440100, '增城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440200, 440000, '韶关市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440201, 440200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440203, 440200, '武江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440204, 440200, '浈江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440205, 440200, '曲江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440222, 440200, '始兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440224, 440200, '仁化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440229, 440200, '翁源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440232, 440200, '乳源瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440233, 440200, '新丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440281, 440200, '乐昌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440282, 440200, '南雄市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440300, 440000, '深圳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440301, 440300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440303, 440300, '罗湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440304, 440300, '福田区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440305, 440300, '南山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440306, 440300, '宝安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440307, 440300, '龙岗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440308, 440300, '盐田区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440309, 440300, '龙华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440310, 440300, '坪山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440311, 440300, '光明区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440400, 440000, '珠海市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440401, 440400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440402, 440400, '香洲区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440403, 440400, '斗门区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440404, 440400, '金湾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440500, 440000, '汕头市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440501, 440500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440507, 440500, '龙湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440511, 440500, '金平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440512, 440500, '濠江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440513, 440500, '潮阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440514, 440500, '潮南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440515, 440500, '澄海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440523, 440500, '南澳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440600, 440000, '佛山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440601, 440600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440604, 440600, '禅城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440605, 440600, '南海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440606, 440600, '顺德区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440607, 440600, '三水区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440608, 440600, '高明区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440700, 440000, '江门市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440701, 440700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440703, 440700, '蓬江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440704, 440700, '江海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440705, 440700, '新会区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440781, 440700, '台山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440783, 440700, '开平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440784, 440700, '鹤山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440785, 440700, '恩平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440800, 440000, '湛江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440801, 440800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440802, 440800, '赤坎区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440803, 440800, '霞山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440804, 440800, '坡头区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440811, 440800, '麻章区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440823, 440800, '遂溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440825, 440800, '徐闻县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440881, 440800, '廉江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440882, 440800, '雷州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440883, 440800, '吴川市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440900, 440000, '茂名市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (440901, 440900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440902, 440900, '茂南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440904, 440900, '电白区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440981, 440900, '高州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440982, 440900, '化州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (440983, 440900, '信宜市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441200, 440000, '肇庆市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441201, 441200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441202, 441200, '端州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441203, 441200, '鼎湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441204, 441200, '高要区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441223, 441200, '广宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441224, 441200, '怀集县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441225, 441200, '封开县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441226, 441200, '德庆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441284, 441200, '四会市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441300, 440000, '惠州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441301, 441300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441302, 441300, '惠城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441303, 441300, '惠阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441322, 441300, '博罗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441323, 441300, '惠东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441324, 441300, '龙门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441400, 440000, '梅州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441401, 441400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441402, 441400, '梅江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441403, 441400, '梅县区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441422, 441400, '大埔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441423, 441400, '丰顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441424, 441400, '五华县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441426, 441400, '平远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441427, 441400, '蕉岭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441481, 441400, '兴宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441500, 440000, '汕尾市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441501, 441500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441502, 441500, '城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441521, 441500, '海丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441523, 441500, '陆河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441581, 441500, '陆丰市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441600, 440000, '河源市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441601, 441600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441602, 441600, '源城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441621, 441600, '紫金县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441622, 441600, '龙川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441623, 441600, '连平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441624, 441600, '和平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441625, 441600, '东源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441700, 440000, '阳江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441701, 441700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441702, 441700, '江城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441704, 441700, '阳东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441721, 441700, '阳西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441781, 441700, '阳春市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441800, 440000, '清远市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (441801, 441800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441802, 441800, '清城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441803, 441800, '清新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441821, 441800, '佛冈县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441823, 441800, '阳山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441825, 441800, '连山壮族瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441826, 441800, '连南瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441881, 441800, '英德市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441882, 441800, '连州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (441900, 440000, '东莞市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (442000, 440000, '中山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (445100, 440000, '潮州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (445101, 445100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445102, 445100, '湘桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445103, 445100, '潮安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445122, 445100, '饶平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445200, 440000, '揭阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (445201, 445200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445202, 445200, '榕城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445203, 445200, '揭东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445222, 445200, '揭西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445224, 445200, '惠来县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445281, 445200, '普宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445300, 440000, '云浮市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (445301, 445300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445302, 445300, '云城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445303, 445300, '云安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445321, 445300, '新兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445322, 445300, '郁南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (445381, 445300, '罗定市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450000, 1, '广西壮族自治区', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (450100, 450000, '南宁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450101, 450100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450102, 450100, '兴宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450103, 450100, '青秀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450105, 450100, '江南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450107, 450100, '西乡塘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450108, 450100, '良庆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450109, 450100, '邕宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450110, 450100, '武鸣区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450123, 450100, '隆安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450124, 450100, '马山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450125, 450100, '上林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450126, 450100, '宾阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450181, 450100, '横州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450200, 450000, '柳州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450201, 450200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450202, 450200, '城中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450203, 450200, '鱼峰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450204, 450200, '柳南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450205, 450200, '柳北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450206, 450200, '柳江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450222, 450200, '柳城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450223, 450200, '鹿寨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450224, 450200, '融安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450225, 450200, '融水苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450226, 450200, '三江侗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450300, 450000, '桂林市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450301, 450300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450302, 450300, '秀峰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450303, 450300, '叠彩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450304, 450300, '象山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450305, 450300, '七星区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450311, 450300, '雁山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450312, 450300, '临桂区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450321, 450300, '阳朔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450323, 450300, '灵川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450324, 450300, '全州县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450325, 450300, '兴安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450326, 450300, '永福县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450327, 450300, '灌阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450328, 450300, '龙胜各族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450329, 450300, '资源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450330, 450300, '平乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450332, 450300, '恭城瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450381, 450300, '荔浦市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450400, 450000, '梧州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450401, 450400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450403, 450400, '万秀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450405, 450400, '长洲区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450406, 450400, '龙圩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450421, 450400, '苍梧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450422, 450400, '藤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450423, 450400, '蒙山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450481, 450400, '岑溪市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450500, 450000, '北海市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450501, 450500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450502, 450500, '海城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450503, 450500, '银海区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450512, 450500, '铁山港区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450521, 450500, '合浦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450600, 450000, '防城港市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450601, 450600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450602, 450600, '港口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450603, 450600, '防城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450621, 450600, '上思县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450681, 450600, '东兴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450700, 450000, '钦州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450701, 450700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450702, 450700, '钦南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450703, 450700, '钦北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450721, 450700, '灵山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450722, 450700, '浦北县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450800, 450000, '贵港市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450801, 450800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450802, 450800, '港北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450803, 450800, '港南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450804, 450800, '覃塘区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450821, 450800, '平南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450881, 450800, '桂平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450900, 450000, '玉林市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (450901, 450900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450902, 450900, '玉州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450903, 450900, '福绵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450921, 450900, '容县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450922, 450900, '陆川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450923, 450900, '博白县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450924, 450900, '兴业县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (450981, 450900, '北流市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451000, 450000, '百色市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (451001, 451000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451002, 451000, '右江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451003, 451000, '田阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451022, 451000, '田东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451024, 451000, '德保县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451026, 451000, '那坡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451027, 451000, '凌云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451028, 451000, '乐业县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451029, 451000, '田林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451030, 451000, '西林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451031, 451000, '隆林各族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451081, 451000, '靖西市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451082, 451000, '平果市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451100, 450000, '贺州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (451101, 451100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451102, 451100, '八步区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451103, 451100, '平桂区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451121, 451100, '昭平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451122, 451100, '钟山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451123, 451100, '富川瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451200, 450000, '河池市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (451201, 451200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451202, 451200, '金城江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451203, 451200, '宜州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451221, 451200, '南丹县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451222, 451200, '天峨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451223, 451200, '凤山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451224, 451200, '东兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451225, 451200, '罗城仫佬族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451226, 451200, '环江毛南族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451227, 451200, '巴马瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451228, 451200, '都安瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451229, 451200, '大化瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451300, 450000, '来宾市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (451301, 451300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451302, 451300, '兴宾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451321, 451300, '忻城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451322, 451300, '象州县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451323, 451300, '武宣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451324, 451300, '金秀瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451381, 451300, '合山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451400, 450000, '崇左市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (451401, 451400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451402, 451400, '江州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451421, 451400, '扶绥县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451422, 451400, '宁明县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451423, 451400, '龙州县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451424, 451400, '大新县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451425, 451400, '天等县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (451481, 451400, '凭祥市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460000, 1, '海南省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (460100, 460000, '海口市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (460101, 460100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460105, 460100, '秀英区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460106, 460100, '龙华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460107, 460100, '琼山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460108, 460100, '美兰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460200, 460000, '三亚市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (460201, 460200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460202, 460200, '海棠区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460203, 460200, '吉阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460204, 460200, '天涯区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460205, 460200, '崖州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460300, 460000, '三沙市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (460321, 460300, '西沙群岛', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460322, 460300, '南沙群岛', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460323, 460300, '中沙群岛的岛礁及其海域', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (460400, 460000, '儋州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (469000, 460000, '省直辖县级行政区划', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (469001, 469000, '五指山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469002, 469000, '琼海市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469005, 469000, '文昌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469006, 469000, '万宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469007, 469000, '东方市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469021, 469000, '定安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469022, 469000, '屯昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469023, 469000, '澄迈县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469024, 469000, '临高县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469025, 469000, '白沙黎族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469026, 469000, '昌江黎族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469027, 469000, '乐东黎族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469028, 469000, '陵水黎族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469029, 469000, '保亭黎族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (469030, 469000, '琼中黎族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500000, 1, '重庆市', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (500100, 500000, '市辖区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (500101, 500100, '万州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500102, 500100, '涪陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500103, 500100, '渝中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500104, 500100, '大渡口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500105, 500100, '江北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500106, 500100, '沙坪坝区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500107, 500100, '九龙坡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500108, 500100, '南岸区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500109, 500100, '北碚区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500110, 500100, '綦江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500111, 500100, '大足区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500112, 500100, '渝北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500113, 500100, '巴南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500114, 500100, '黔江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500115, 500100, '长寿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500116, 500100, '江津区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500117, 500100, '合川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500118, 500100, '永川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500119, 500100, '南川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500120, 500100, '璧山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500151, 500100, '铜梁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500152, 500100, '潼南区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500153, 500100, '荣昌区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500154, 500100, '开州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500155, 500100, '梁平区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500156, 500100, '武隆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500200, 500000, '县', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (500229, 500200, '城口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500230, 500200, '丰都县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500231, 500200, '垫江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500233, 500200, '忠县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500235, 500200, '云阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500236, 500200, '奉节县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500237, 500200, '巫山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500238, 500200, '巫溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500240, 500200, '石柱土家族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500241, 500200, '秀山土家族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500242, 500200, '酉阳土家族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (500243, 500200, '彭水苗族土家族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510000, 1, '四川省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (510100, 510000, '成都市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510101, 510100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510104, 510100, '锦江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510105, 510100, '青羊区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510106, 510100, '金牛区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510107, 510100, '武侯区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510108, 510100, '成华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510112, 510100, '龙泉驿区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510113, 510100, '青白江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510114, 510100, '新都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510115, 510100, '温江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510116, 510100, '双流区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510117, 510100, '郫都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510118, 510100, '新津区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510121, 510100, '金堂县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510129, 510100, '大邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510131, 510100, '蒲江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510181, 510100, '都江堰市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510182, 510100, '彭州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510183, 510100, '邛崃市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510184, 510100, '崇州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510185, 510100, '简阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510300, 510000, '自贡市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510301, 510300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510302, 510300, '自流井区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510303, 510300, '贡井区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510304, 510300, '大安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510311, 510300, '沿滩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510321, 510300, '荣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510322, 510300, '富顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510400, 510000, '攀枝花市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510401, 510400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510402, 510400, '东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510403, 510400, '西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510411, 510400, '仁和区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510421, 510400, '米易县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510422, 510400, '盐边县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510500, 510000, '泸州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510501, 510500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510502, 510500, '江阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510503, 510500, '纳溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510504, 510500, '龙马潭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510521, 510500, '泸县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510522, 510500, '合江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510524, 510500, '叙永县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510525, 510500, '古蔺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510600, 510000, '德阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510601, 510600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510603, 510600, '旌阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510604, 510600, '罗江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510623, 510600, '中江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510681, 510600, '广汉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510682, 510600, '什邡市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510683, 510600, '绵竹市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510700, 510000, '绵阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510701, 510700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510703, 510700, '涪城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510704, 510700, '游仙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510705, 510700, '安州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510722, 510700, '三台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510723, 510700, '盐亭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510725, 510700, '梓潼县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510726, 510700, '北川羌族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510727, 510700, '平武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510781, 510700, '江油市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510800, 510000, '广元市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510801, 510800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510802, 510800, '利州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510811, 510800, '昭化区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510812, 510800, '朝天区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510821, 510800, '旺苍县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510822, 510800, '青川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510823, 510800, '剑阁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510824, 510800, '苍溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510900, 510000, '遂宁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (510901, 510900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510903, 510900, '船山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510904, 510900, '安居区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510921, 510900, '蓬溪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510923, 510900, '大英县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (510981, 510900, '射洪市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511000, 510000, '内江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511001, 511000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511002, 511000, '市中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511011, 511000, '东兴区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511024, 511000, '威远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511025, 511000, '资中县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511071, 511000, '内江经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511083, 511000, '隆昌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511100, 510000, '乐山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511101, 511100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511102, 511100, '市中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511111, 511100, '沙湾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511112, 511100, '五通桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511113, 511100, '金口河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511123, 511100, '犍为县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511124, 511100, '井研县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511126, 511100, '夹江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511129, 511100, '沐川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511132, 511100, '峨边彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511133, 511100, '马边彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511181, 511100, '峨眉山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511300, 510000, '南充市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511301, 511300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511302, 511300, '顺庆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511303, 511300, '高坪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511304, 511300, '嘉陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511321, 511300, '南部县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511322, 511300, '营山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511323, 511300, '蓬安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511324, 511300, '仪陇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511325, 511300, '西充县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511381, 511300, '阆中市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511400, 510000, '眉山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511401, 511400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511402, 511400, '东坡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511403, 511400, '彭山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511421, 511400, '仁寿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511423, 511400, '洪雅县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511424, 511400, '丹棱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511425, 511400, '青神县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511500, 510000, '宜宾市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511501, 511500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511502, 511500, '翠屏区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511503, 511500, '南溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511504, 511500, '叙州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511523, 511500, '江安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511524, 511500, '长宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511525, 511500, '高县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511526, 511500, '珙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511527, 511500, '筠连县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511528, 511500, '兴文县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511529, 511500, '屏山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511600, 510000, '广安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511601, 511600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511602, 511600, '广安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511603, 511600, '前锋区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511621, 511600, '岳池县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511622, 511600, '武胜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511623, 511600, '邻水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511681, 511600, '华蓥市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511700, 510000, '达州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511701, 511700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511702, 511700, '通川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511703, 511700, '达川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511722, 511700, '宣汉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511723, 511700, '开江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511724, 511700, '大竹县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511725, 511700, '渠县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511771, 511700, '达州经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511781, 511700, '万源市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511800, 510000, '雅安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511801, 511800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511802, 511800, '雨城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511803, 511800, '名山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511822, 511800, '荥经县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511823, 511800, '汉源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511824, 511800, '石棉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511825, 511800, '天全县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511826, 511800, '芦山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511827, 511800, '宝兴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511900, 510000, '巴中市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (511901, 511900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511902, 511900, '巴州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511903, 511900, '恩阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511921, 511900, '通江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511922, 511900, '南江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511923, 511900, '平昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (511971, 511900, '巴中经济开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (512000, 510000, '资阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (512001, 512000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (512002, 512000, '雁江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (512021, 512000, '安岳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (512022, 512000, '乐至县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513200, 510000, '阿坝藏族羌族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (513201, 513200, '马尔康市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513221, 513200, '汶川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513222, 513200, '理县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513223, 513200, '茂县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513224, 513200, '松潘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513225, 513200, '九寨沟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513226, 513200, '金川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513227, 513200, '小金县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513228, 513200, '黑水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513230, 513200, '壤塘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513231, 513200, '阿坝县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513232, 513200, '若尔盖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513233, 513200, '红原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513300, 510000, '甘孜藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (513301, 513300, '康定市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513322, 513300, '泸定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513323, 513300, '丹巴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513324, 513300, '九龙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513325, 513300, '雅江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513326, 513300, '道孚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513327, 513300, '炉霍县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513328, 513300, '甘孜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513329, 513300, '新龙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513330, 513300, '德格县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513331, 513300, '白玉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513332, 513300, '石渠县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513333, 513300, '色达县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513334, 513300, '理塘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513335, 513300, '巴塘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513336, 513300, '乡城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513337, 513300, '稻城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513338, 513300, '得荣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513400, 510000, '凉山彝族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (513401, 513400, '西昌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513402, 513400, '会理市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513422, 513400, '木里藏族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513423, 513400, '盐源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513424, 513400, '德昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513426, 513400, '会东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513427, 513400, '宁南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513428, 513400, '普格县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513429, 513400, '布拖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513430, 513400, '金阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513431, 513400, '昭觉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513432, 513400, '喜德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513433, 513400, '冕宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513434, 513400, '越西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513435, 513400, '甘洛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513436, 513400, '美姑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (513437, 513400, '雷波县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520000, 1, '贵州省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (520100, 520000, '贵阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (520101, 520100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520102, 520100, '南明区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520103, 520100, '云岩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520111, 520100, '花溪区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520112, 520100, '乌当区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520113, 520100, '白云区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520115, 520100, '观山湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520121, 520100, '开阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520122, 520100, '息烽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520123, 520100, '修文县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520181, 520100, '清镇市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520200, 520000, '六盘水市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (520201, 520200, '钟山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520203, 520200, '六枝特区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520204, 520200, '水城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520281, 520200, '盘州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520300, 520000, '遵义市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (520301, 520300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520302, 520300, '红花岗区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520303, 520300, '汇川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520304, 520300, '播州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520322, 520300, '桐梓县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520323, 520300, '绥阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520324, 520300, '正安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520325, 520300, '道真仡佬族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520326, 520300, '务川仡佬族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520327, 520300, '凤冈县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520328, 520300, '湄潭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520329, 520300, '余庆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520330, 520300, '习水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520381, 520300, '赤水市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520382, 520300, '仁怀市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520400, 520000, '安顺市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (520401, 520400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520402, 520400, '西秀区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520403, 520400, '平坝区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520422, 520400, '普定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520423, 520400, '镇宁布依族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520424, 520400, '关岭布依族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520425, 520400, '紫云苗族布依族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520500, 520000, '毕节市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (520501, 520500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520502, 520500, '七星关区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520521, 520500, '大方县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520523, 520500, '金沙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520524, 520500, '织金县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520525, 520500, '纳雍县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520526, 520500, '威宁彝族回族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520527, 520500, '赫章县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520581, 520500, '黔西市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520600, 520000, '铜仁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (520601, 520600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520602, 520600, '碧江区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520603, 520600, '万山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520621, 520600, '江口县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520622, 520600, '玉屏侗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520623, 520600, '石阡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520624, 520600, '思南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520625, 520600, '印江土家族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520626, 520600, '德江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520627, 520600, '沿河土家族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (520628, 520600, '松桃苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522300, 520000, '黔西南布依族苗族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (522301, 522300, '兴义市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522302, 522300, '兴仁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522323, 522300, '普安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522324, 522300, '晴隆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522325, 522300, '贞丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522326, 522300, '望谟县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522327, 522300, '册亨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522328, 522300, '安龙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522600, 520000, '黔东南苗族侗族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (522601, 522600, '凯里市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522622, 522600, '黄平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522623, 522600, '施秉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522624, 522600, '三穗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522625, 522600, '镇远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522626, 522600, '岑巩县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522627, 522600, '天柱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522628, 522600, '锦屏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522629, 522600, '剑河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522630, 522600, '台江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522631, 522600, '黎平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522632, 522600, '榕江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522633, 522600, '从江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522634, 522600, '雷山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522635, 522600, '麻江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522636, 522600, '丹寨县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522700, 520000, '黔南布依族苗族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (522701, 522700, '都匀市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522702, 522700, '福泉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522722, 522700, '荔波县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522723, 522700, '贵定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522725, 522700, '瓮安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522726, 522700, '独山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522727, 522700, '平塘县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522728, 522700, '罗甸县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522729, 522700, '长顺县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522730, 522700, '龙里县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522731, 522700, '惠水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (522732, 522700, '三都水族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530000, 1, '云南省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (530100, 530000, '昆明市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530101, 530100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530102, 530100, '五华区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530103, 530100, '盘龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530111, 530100, '官渡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530112, 530100, '西山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530113, 530100, '东川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530114, 530100, '呈贡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530115, 530100, '晋宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530124, 530100, '富民县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530125, 530100, '宜良县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530126, 530100, '石林彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530127, 530100, '嵩明县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530128, 530100, '禄劝彝族苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530129, 530100, '寻甸回族彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530181, 530100, '安宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530300, 530000, '曲靖市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530301, 530300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530302, 530300, '麒麟区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530303, 530300, '沾益区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530304, 530300, '马龙区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530322, 530300, '陆良县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530323, 530300, '师宗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530324, 530300, '罗平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530325, 530300, '富源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530326, 530300, '会泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530381, 530300, '宣威市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530400, 530000, '玉溪市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530401, 530400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530402, 530400, '红塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530403, 530400, '江川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530423, 530400, '通海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530424, 530400, '华宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530425, 530400, '易门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530426, 530400, '峨山彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530427, 530400, '新平彝族傣族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530428, 530400, '元江哈尼族彝族傣族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530481, 530400, '澄江市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530500, 530000, '保山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530501, 530500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530502, 530500, '隆阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530521, 530500, '施甸县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530523, 530500, '龙陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530524, 530500, '昌宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530581, 530500, '腾冲市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530600, 530000, '昭通市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530601, 530600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530602, 530600, '昭阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530621, 530600, '鲁甸县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530622, 530600, '巧家县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530623, 530600, '盐津县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530624, 530600, '大关县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530625, 530600, '永善县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530626, 530600, '绥江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530627, 530600, '镇雄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530628, 530600, '彝良县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530629, 530600, '威信县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530681, 530600, '水富市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530700, 530000, '丽江市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530701, 530700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530702, 530700, '古城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530721, 530700, '玉龙纳西族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530722, 530700, '永胜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530723, 530700, '华坪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530724, 530700, '宁蒗彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530800, 530000, '普洱市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530801, 530800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530802, 530800, '思茅区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530821, 530800, '宁洱哈尼族彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530822, 530800, '墨江哈尼族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530823, 530800, '景东彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530824, 530800, '景谷傣族彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530825, 530800, '镇沅彝族哈尼族拉祜族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530826, 530800, '江城哈尼族彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530827, 530800, '孟连傣族拉祜族佤族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530828, 530800, '澜沧拉祜族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530829, 530800, '西盟佤族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530900, 530000, '临沧市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (530901, 530900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530902, 530900, '临翔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530921, 530900, '凤庆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530922, 530900, '云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530923, 530900, '永德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530924, 530900, '镇康县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530925, 530900, '双江拉祜族佤族布朗族傣族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530926, 530900, '耿马傣族佤族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (530927, 530900, '沧源佤族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532300, 530000, '楚雄彝族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (532301, 532300, '楚雄市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532302, 532300, '禄丰市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532322, 532300, '双柏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532323, 532300, '牟定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532324, 532300, '南华县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532325, 532300, '姚安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532326, 532300, '大姚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532327, 532300, '永仁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532328, 532300, '元谋县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532329, 532300, '武定县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532500, 530000, '红河哈尼族彝族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (532501, 532500, '个旧市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532502, 532500, '开远市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532503, 532500, '蒙自市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532504, 532500, '弥勒市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532523, 532500, '屏边苗族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532524, 532500, '建水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532525, 532500, '石屏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532527, 532500, '泸西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532528, 532500, '元阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532529, 532500, '红河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532530, 532500, '金平苗族瑶族傣族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532531, 532500, '绿春县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532532, 532500, '河口瑶族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532600, 530000, '文山壮族苗族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (532601, 532600, '文山市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532622, 532600, '砚山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532623, 532600, '西畴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532624, 532600, '麻栗坡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532625, 532600, '马关县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532626, 532600, '丘北县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532627, 532600, '广南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532628, 532600, '富宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532800, 530000, '西双版纳傣族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (532801, 532800, '景洪市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532822, 532800, '勐海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532823, 532800, '勐腊县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532900, 530000, '大理白族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (532901, 532900, '大理市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532922, 532900, '漾濞彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532923, 532900, '祥云县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532924, 532900, '宾川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532925, 532900, '弥渡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532926, 532900, '南涧彝族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532927, 532900, '巍山彝族回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532928, 532900, '永平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532929, 532900, '云龙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532930, 532900, '洱源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532931, 532900, '剑川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (532932, 532900, '鹤庆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533100, 530000, '德宏傣族景颇族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (533102, 533100, '瑞丽市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533103, 533100, '芒市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533122, 533100, '梁河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533123, 533100, '盈江县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533124, 533100, '陇川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533300, 530000, '怒江傈僳族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (533301, 533300, '泸水市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533323, 533300, '福贡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533324, 533300, '贡山独龙族怒族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533325, 533300, '兰坪白族普米族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533400, 530000, '迪庆藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (533401, 533400, '香格里拉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533422, 533400, '德钦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (533423, 533400, '维西傈僳族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540000, 1, '西藏自治区', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (540100, 540000, '拉萨市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (540101, 540100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540102, 540100, '城关区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540103, 540100, '堆龙德庆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540104, 540100, '达孜区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540121, 540100, '林周县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540122, 540100, '当雄县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540123, 540100, '尼木县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540124, 540100, '曲水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540127, 540100, '墨竹工卡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540171, 540100, '格尔木藏青工业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540172, 540100, '拉萨经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540173, 540100, '西藏文化旅游创意园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540174, 540100, '达孜工业园区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540200, 540000, '日喀则市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (540202, 540200, '桑珠孜区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540221, 540200, '南木林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540222, 540200, '江孜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540223, 540200, '定日县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540224, 540200, '萨迦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540225, 540200, '拉孜县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540226, 540200, '昂仁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540227, 540200, '谢通门县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540228, 540200, '白朗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540229, 540200, '仁布县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540230, 540200, '康马县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540231, 540200, '定结县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540232, 540200, '仲巴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540233, 540200, '亚东县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540234, 540200, '吉隆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540235, 540200, '聂拉木县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540236, 540200, '萨嘎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540237, 540200, '岗巴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540300, 540000, '昌都市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (540302, 540300, '卡若区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540321, 540300, '江达县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540322, 540300, '贡觉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540323, 540300, '类乌齐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540324, 540300, '丁青县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540325, 540300, '察雅县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540326, 540300, '八宿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540327, 540300, '左贡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540328, 540300, '芒康县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540329, 540300, '洛隆县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540330, 540300, '边坝县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540400, 540000, '林芝市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (540402, 540400, '巴宜区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540421, 540400, '工布江达县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540422, 540400, '米林县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540423, 540400, '墨脱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540424, 540400, '波密县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540425, 540400, '察隅县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540426, 540400, '朗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540500, 540000, '山南市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (540501, 540500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540502, 540500, '乃东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540521, 540500, '扎囊县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540522, 540500, '贡嘎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540523, 540500, '桑日县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540524, 540500, '琼结县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540525, 540500, '曲松县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540526, 540500, '措美县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540527, 540500, '洛扎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540528, 540500, '加查县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540529, 540500, '隆子县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540530, 540500, '错那县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540531, 540500, '浪卡子县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540600, 540000, '那曲市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (540602, 540600, '色尼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540621, 540600, '嘉黎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540622, 540600, '比如县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540623, 540600, '聂荣县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540624, 540600, '安多县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540625, 540600, '申扎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540626, 540600, '索县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540627, 540600, '班戈县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540628, 540600, '巴青县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540629, 540600, '尼玛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (540630, 540600, '双湖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542500, 540000, '阿里地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (542521, 542500, '普兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542522, 542500, '札达县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542523, 542500, '噶尔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542524, 542500, '日土县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542525, 542500, '革吉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542526, 542500, '改则县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (542527, 542500, '措勤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610000, 1, '陕西省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (610100, 610000, '西安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610101, 610100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610102, 610100, '新城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610103, 610100, '碑林区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610104, 610100, '莲湖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610111, 610100, '灞桥区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610112, 610100, '未央区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610113, 610100, '雁塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610114, 610100, '阎良区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610115, 610100, '临潼区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610116, 610100, '长安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610117, 610100, '高陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610118, 610100, '鄠邑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610122, 610100, '蓝田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610124, 610100, '周至县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610200, 610000, '铜川市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610201, 610200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610202, 610200, '王益区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610203, 610200, '印台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610204, 610200, '耀州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610222, 610200, '宜君县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610300, 610000, '宝鸡市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610301, 610300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610302, 610300, '渭滨区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610303, 610300, '金台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610304, 610300, '陈仓区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610305, 610300, '凤翔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610323, 610300, '岐山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610324, 610300, '扶风县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610326, 610300, '眉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610327, 610300, '陇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610328, 610300, '千阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610329, 610300, '麟游县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610330, 610300, '凤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610331, 610300, '太白县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610400, 610000, '咸阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610401, 610400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610402, 610400, '秦都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610403, 610400, '杨陵区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610404, 610400, '渭城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610422, 610400, '三原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610423, 610400, '泾阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610424, 610400, '乾县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610425, 610400, '礼泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610426, 610400, '永寿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610428, 610400, '长武县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610429, 610400, '旬邑县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610430, 610400, '淳化县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610431, 610400, '武功县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610481, 610400, '兴平市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610482, 610400, '彬州市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610500, 610000, '渭南市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610501, 610500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610502, 610500, '临渭区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610503, 610500, '华州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610522, 610500, '潼关县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610523, 610500, '大荔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610524, 610500, '合阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610525, 610500, '澄城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610526, 610500, '蒲城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610527, 610500, '白水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610528, 610500, '富平县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610581, 610500, '韩城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610582, 610500, '华阴市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610600, 610000, '延安市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610601, 610600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610602, 610600, '宝塔区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610603, 610600, '安塞区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610621, 610600, '延长县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610622, 610600, '延川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610625, 610600, '志丹县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610626, 610600, '吴起县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610627, 610600, '甘泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610628, 610600, '富县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610629, 610600, '洛川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610630, 610600, '宜川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610631, 610600, '黄龙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610632, 610600, '黄陵县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610681, 610600, '子长市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610700, 610000, '汉中市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610701, 610700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610702, 610700, '汉台区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610703, 610700, '南郑区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610722, 610700, '城固县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610723, 610700, '洋县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610724, 610700, '西乡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610725, 610700, '勉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610726, 610700, '宁强县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610727, 610700, '略阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610728, 610700, '镇巴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610729, 610700, '留坝县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610730, 610700, '佛坪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610800, 610000, '榆林市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610801, 610800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610802, 610800, '榆阳区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610803, 610800, '横山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610822, 610800, '府谷县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610824, 610800, '靖边县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610825, 610800, '定边县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610826, 610800, '绥德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610827, 610800, '米脂县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610828, 610800, '佳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610829, 610800, '吴堡县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610830, 610800, '清涧县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610831, 610800, '子洲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610881, 610800, '神木市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610900, 610000, '安康市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (610901, 610900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610902, 610900, '汉滨区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610921, 610900, '汉阴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610922, 610900, '石泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610923, 610900, '宁陕县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610924, 610900, '紫阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610925, 610900, '岚皋县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610926, 610900, '平利县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610927, 610900, '镇坪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610929, 610900, '白河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (610981, 610900, '旬阳市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611000, 610000, '商洛市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (611001, 611000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611002, 611000, '商州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611021, 611000, '洛南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611022, 611000, '丹凤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611023, 611000, '商南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611024, 611000, '山阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611025, 611000, '镇安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (611026, 611000, '柞水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620000, 1, '甘肃省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (620100, 620000, '兰州市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620101, 620100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620102, 620100, '城关区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620103, 620100, '七里河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620104, 620100, '西固区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620105, 620100, '安宁区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620111, 620100, '红古区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620121, 620100, '永登县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620122, 620100, '皋兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620123, 620100, '榆中县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620171, 620100, '兰州新区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620200, 620000, '嘉峪关市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620201, 620200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620300, 620000, '金昌市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620301, 620300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620302, 620300, '金川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620321, 620300, '永昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620400, 620000, '白银市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620401, 620400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620402, 620400, '白银区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620403, 620400, '平川区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620421, 620400, '靖远县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620422, 620400, '会宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620423, 620400, '景泰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620500, 620000, '天水市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620501, 620500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620502, 620500, '秦州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620503, 620500, '麦积区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620521, 620500, '清水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620522, 620500, '秦安县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620523, 620500, '甘谷县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620524, 620500, '武山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620525, 620500, '张家川回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620600, 620000, '武威市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620601, 620600, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620602, 620600, '凉州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620621, 620600, '民勤县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620622, 620600, '古浪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620623, 620600, '天祝藏族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620700, 620000, '张掖市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620701, 620700, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620702, 620700, '甘州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620721, 620700, '肃南裕固族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620722, 620700, '民乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620723, 620700, '临泽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620724, 620700, '高台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620725, 620700, '山丹县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620800, 620000, '平凉市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620801, 620800, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620802, 620800, '崆峒区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620821, 620800, '泾川县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620822, 620800, '灵台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620823, 620800, '崇信县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620825, 620800, '庄浪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620826, 620800, '静宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620881, 620800, '华亭市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620900, 620000, '酒泉市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (620901, 620900, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620902, 620900, '肃州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620921, 620900, '金塔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620922, 620900, '瓜州县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620923, 620900, '肃北蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620924, 620900, '阿克塞哈萨克族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620981, 620900, '玉门市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (620982, 620900, '敦煌市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621000, 620000, '庆阳市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (621001, 621000, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621002, 621000, '西峰区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621021, 621000, '庆城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621022, 621000, '环县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621023, 621000, '华池县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621024, 621000, '合水县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621025, 621000, '正宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621026, 621000, '宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621027, 621000, '镇原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621100, 620000, '定西市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (621101, 621100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621102, 621100, '安定区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621121, 621100, '通渭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621122, 621100, '陇西县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621123, 621100, '渭源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621124, 621100, '临洮县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621125, 621100, '漳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621126, 621100, '岷县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621200, 620000, '陇南市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (621201, 621200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621202, 621200, '武都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621221, 621200, '成县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621222, 621200, '文县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621223, 621200, '宕昌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621224, 621200, '康县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621225, 621200, '西和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621226, 621200, '礼县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621227, 621200, '徽县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (621228, 621200, '两当县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622900, 620000, '临夏回族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (622901, 622900, '临夏市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622921, 622900, '临夏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622922, 622900, '康乐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622923, 622900, '永靖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622924, 622900, '广河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622925, 622900, '和政县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622926, 622900, '东乡族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (622927, 622900, '积石山保安族东乡族撒拉族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623000, 620000, '甘南藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (623001, 623000, '合作市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623021, 623000, '临潭县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623022, 623000, '卓尼县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623023, 623000, '舟曲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623024, 623000, '迭部县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623025, 623000, '玛曲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623026, 623000, '碌曲县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (623027, 623000, '夏河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630000, 1, '青海省', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (630100, 630000, '西宁市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (630101, 630100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630102, 630100, '城东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630103, 630100, '城中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630104, 630100, '城西区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630105, 630100, '城北区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630106, 630100, '湟中区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630121, 630100, '大通回族土族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630123, 630100, '湟源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630200, 630000, '海东市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (630202, 630200, '乐都区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630203, 630200, '平安区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630222, 630200, '民和回族土族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630223, 630200, '互助土族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630224, 630200, '化隆回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (630225, 630200, '循化撒拉族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632200, 630000, '海北藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (632221, 632200, '门源回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632222, 632200, '祁连县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632223, 632200, '海晏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632224, 632200, '刚察县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632300, 630000, '黄南藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (632301, 632300, '同仁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632322, 632300, '尖扎县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632323, 632300, '泽库县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632324, 632300, '河南蒙古族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632500, 630000, '海南藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (632521, 632500, '共和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632522, 632500, '同德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632523, 632500, '贵德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632524, 632500, '兴海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632525, 632500, '贵南县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632600, 630000, '果洛藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (632621, 632600, '玛沁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632622, 632600, '班玛县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632623, 632600, '甘德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632624, 632600, '达日县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632625, 632600, '久治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632626, 632600, '玛多县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632700, 630000, '玉树藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (632701, 632700, '玉树市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632722, 632700, '杂多县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632723, 632700, '称多县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632724, 632700, '治多县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632725, 632700, '囊谦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632726, 632700, '曲麻莱县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632800, 630000, '海西蒙古族藏族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (632801, 632800, '格尔木市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632802, 632800, '德令哈市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632803, 632800, '茫崖市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632821, 632800, '乌兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632822, 632800, '都兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632823, 632800, '天峻县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (632857, 632800, '大柴旦行政委员会', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640000, 1, '宁夏回族自治区', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (640100, 640000, '银川市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (640101, 640100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640104, 640100, '兴庆区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640105, 640100, '西夏区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640106, 640100, '金凤区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640121, 640100, '永宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640122, 640100, '贺兰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640181, 640100, '灵武市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640200, 640000, '石嘴山市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (640201, 640200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640202, 640200, '大武口区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640205, 640200, '惠农区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640221, 640200, '平罗县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640300, 640000, '吴忠市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (640301, 640300, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640302, 640300, '利通区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640303, 640300, '红寺堡区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640323, 640300, '盐池县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640324, 640300, '同心县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640381, 640300, '青铜峡市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640400, 640000, '固原市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (640401, 640400, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640402, 640400, '原州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640422, 640400, '西吉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640423, 640400, '隆德县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640424, 640400, '泾源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640425, 640400, '彭阳县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640500, 640000, '中卫市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (640501, 640500, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640502, 640500, '沙坡头区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640521, 640500, '中宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (640522, 640500, '海原县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650000, 1, '新疆维吾尔自治区', 1, '2022-11-09 10:07:58', '2022-11-09 10:07:58');
INSERT INTO `eb_city_region` VALUES (650100, 650000, '乌鲁木齐市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (650101, 650100, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650102, 650100, '天山区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650103, 650100, '沙依巴克区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650104, 650100, '新市区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650105, 650100, '水磨沟区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650106, 650100, '头屯河区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650107, 650100, '达坂城区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650109, 650100, '米东区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650121, 650100, '乌鲁木齐县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650200, 650000, '克拉玛依市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (650201, 650200, '市辖区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650202, 650200, '独山子区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650203, 650200, '克拉玛依区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650204, 650200, '白碱滩区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650205, 650200, '乌尔禾区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650400, 650000, '吐鲁番市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (650402, 650400, '高昌区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650421, 650400, '鄯善县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650422, 650400, '托克逊县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650500, 650000, '哈密市', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (650502, 650500, '伊州区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650521, 650500, '巴里坤哈萨克自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (650522, 650500, '伊吾县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652300, 650000, '昌吉回族自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (652301, 652300, '昌吉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652302, 652300, '阜康市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652323, 652300, '呼图壁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652324, 652300, '玛纳斯县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652325, 652300, '奇台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652327, 652300, '吉木萨尔县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652328, 652300, '木垒哈萨克自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652700, 650000, '博尔塔拉蒙古自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (652701, 652700, '博乐市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652702, 652700, '阿拉山口市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652722, 652700, '精河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652723, 652700, '温泉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652800, 650000, '巴音郭楞蒙古自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (652801, 652800, '库尔勒市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652822, 652800, '轮台县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652823, 652800, '尉犁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652824, 652800, '若羌县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652825, 652800, '且末县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652826, 652800, '焉耆回族自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652827, 652800, '和静县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652828, 652800, '和硕县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652829, 652800, '博湖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652871, 652800, '库尔勒经济技术开发区', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652900, 650000, '阿克苏地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (652901, 652900, '阿克苏市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652902, 652900, '库车市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652922, 652900, '温宿县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652924, 652900, '沙雅县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652925, 652900, '新和县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652926, 652900, '拜城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652927, 652900, '乌什县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652928, 652900, '阿瓦提县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (652929, 652900, '柯坪县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653000, 650000, '克孜勒苏柯尔克孜自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (653001, 653000, '阿图什市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653022, 653000, '阿克陶县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653023, 653000, '阿合奇县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653024, 653000, '乌恰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653100, 650000, '喀什地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (653101, 653100, '喀什市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653121, 653100, '疏附县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653122, 653100, '疏勒县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653123, 653100, '英吉沙县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653124, 653100, '泽普县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653125, 653100, '莎车县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653126, 653100, '叶城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653127, 653100, '麦盖提县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653128, 653100, '岳普湖县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653129, 653100, '伽师县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653130, 653100, '巴楚县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653131, 653100, '塔什库尔干塔吉克自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653200, 650000, '和田地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (653201, 653200, '和田市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653221, 653200, '和田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653222, 653200, '墨玉县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653223, 653200, '皮山县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653224, 653200, '洛浦县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653225, 653200, '策勒县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653226, 653200, '于田县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (653227, 653200, '民丰县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654000, 650000, '伊犁哈萨克自治州', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (654002, 654000, '伊宁市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654003, 654000, '奎屯市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654004, 654000, '霍尔果斯市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654021, 654000, '伊宁县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654022, 654000, '察布查尔锡伯自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654023, 654000, '霍城县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654024, 654000, '巩留县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654025, 654000, '新源县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654026, 654000, '昭苏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654027, 654000, '特克斯县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654028, 654000, '尼勒克县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654200, 650000, '塔城地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (654201, 654200, '塔城市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654202, 654200, '乌苏市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654203, 654200, '沙湾市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654221, 654200, '额敏县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654224, 654200, '托里县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654225, 654200, '裕民县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654226, 654200, '和布克赛尔蒙古自治县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654300, 650000, '阿勒泰地区', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (654301, 654300, '阿勒泰市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654321, 654300, '布尔津县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654322, 654300, '富蕴县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654323, 654300, '福海县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654324, 654300, '哈巴河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654325, 654300, '青河县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (654326, 654300, '吉木乃县', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659000, 650000, '自治区直辖县级行政区划', 2, '2022-11-09 10:07:58', '2022-11-09 10:19:44');
INSERT INTO `eb_city_region` VALUES (659001, 659000, '石河子市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659002, 659000, '阿拉尔市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659003, 659000, '图木舒克市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659004, 659000, '五家渠市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659005, 659000, '北屯市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659006, 659000, '铁门关市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659007, 659000, '双河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659008, 659000, '可克达拉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659009, 659000, '昆玉市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659010, 659000, '胡杨河市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (659011, 659000, '新星市', 3, '2022-11-09 10:32:31', '2022-11-09 11:06:18');
INSERT INTO `eb_city_region` VALUES (110101001, 110101, '东华门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101002, 110101, '景山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101003, 110101, '交道口街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101004, 110101, '安定门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101005, 110101, '北新桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101006, 110101, '东四街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101007, 110101, '朝阳门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101008, 110101, '建国门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101009, 110101, '东直门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101010, 110101, '和平里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101011, 110101, '前门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101012, 110101, '崇文门外街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101013, 110101, '东花市街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101014, 110101, '龙潭街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101015, 110101, '体育馆路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101016, 110101, '天坛街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110101017, 110101, '永定门外街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102001, 110102, '西长安街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102003, 110102, '新街口街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102007, 110102, '月坛街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102009, 110102, '展览路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102010, 110102, '德胜街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102011, 110102, '金融街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102012, 110102, '什刹海街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102013, 110102, '大栅栏街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102014, 110102, '天桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102015, 110102, '椿树街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102016, 110102, '陶然亭街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102017, 110102, '广安门内街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102018, 110102, '牛街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102019, 110102, '白纸坊街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110102020, 110102, '广安门外街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105001, 110105, '建外街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105002, 110105, '朝外街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105003, 110105, '呼家楼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105004, 110105, '三里屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105005, 110105, '左家庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105006, 110105, '香河园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105007, 110105, '和平街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105008, 110105, '安贞街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105009, 110105, '亚运村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105010, 110105, '小关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105011, 110105, '酒仙桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105012, 110105, '麦子店街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105013, 110105, '团结湖街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105014, 110105, '六里屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105015, 110105, '八里庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105016, 110105, '双井街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105017, 110105, '劲松街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105018, 110105, '潘家园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105019, 110105, '垡头街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105021, 110105, '南磨房地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105022, 110105, '高碑店地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105023, 110105, '将台地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105024, 110105, '太阳宫地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105025, 110105, '大屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105026, 110105, '望京街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105027, 110105, '小红门地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105028, 110105, '十八里店地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105029, 110105, '平房地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105030, 110105, '东风地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105031, 110105, '奥运村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105032, 110105, '来广营地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105033, 110105, '常营地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105034, 110105, '三间房地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105035, 110105, '管庄地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105036, 110105, '金盏地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105037, 110105, '孙河地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105038, 110105, '崔各庄地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105039, 110105, '东坝地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105040, 110105, '黑庄户地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105041, 110105, '豆各庄地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105042, 110105, '王四营地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105043, 110105, '东湖街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110105400, 110105, '首都机场街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106001, 110106, '右安门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106002, 110106, '太平桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106003, 110106, '西罗园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106004, 110106, '大红门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106005, 110106, '南苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106006, 110106, '东高地街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106007, 110106, '东铁匠营街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106008, 110106, '六里桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106009, 110106, '丰台街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106010, 110106, '新村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106011, 110106, '长辛店街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106012, 110106, '云岗街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106013, 110106, '方庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106014, 110106, '宛平街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106015, 110106, '马家堡街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106016, 110106, '和义街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106017, 110106, '卢沟桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106018, 110106, '花乡街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106020, 110106, '成寿寺街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106021, 110106, '石榴庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106022, 110106, '玉泉营街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106023, 110106, '看丹街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106024, 110106, '五里店街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106025, 110106, '青塔街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106100, 110106, '北宫镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110106101, 110106, '王佐镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107001, 110107, '八宝山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107002, 110107, '老山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107003, 110107, '八角街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107004, 110107, '古城街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107005, 110107, '苹果园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107006, 110107, '金顶街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107009, 110107, '广宁街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107010, 110107, '五里坨街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110107011, 110107, '鲁谷街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108001, 110108, '万寿路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108002, 110108, '永定路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108003, 110108, '羊坊店街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108004, 110108, '甘家口街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108005, 110108, '八里庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108006, 110108, '紫竹院街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108007, 110108, '北下关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108008, 110108, '北太平庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108010, 110108, '学院路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108011, 110108, '中关村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108012, 110108, '海淀街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108013, 110108, '青龙桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108014, 110108, '清华园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108015, 110108, '燕园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108016, 110108, '香山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108017, 110108, '清河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108018, 110108, '花园路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108019, 110108, '西三旗街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108020, 110108, '马连洼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108021, 110108, '田村路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108022, 110108, '上地街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108023, 110108, '万柳地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108024, 110108, '东升地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108025, 110108, '曙光街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108026, 110108, '温泉地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108027, 110108, '四季青地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108028, 110108, '西北旺地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108029, 110108, '苏家坨地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110108030, 110108, '上庄地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109001, 110109, '大峪街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109002, 110109, '城子街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109003, 110109, '东辛房街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109004, 110109, '大台街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109005, 110109, '王平地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109006, 110109, '永定地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109007, 110109, '龙泉地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109101, 110109, '潭柘寺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109104, 110109, '军庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109105, 110109, '雁翅镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109106, 110109, '斋堂镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109107, 110109, '清水镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110109108, 110109, '妙峰山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111001, 110111, '城关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111002, 110111, '新镇街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111004, 110111, '向阳街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111005, 110111, '东风街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111006, 110111, '迎风街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111007, 110111, '星城街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111008, 110111, '良乡地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111009, 110111, '周口店地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111010, 110111, '琉璃河地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111011, 110111, '拱辰街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111012, 110111, '西潞街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111101, 110111, '阎村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111103, 110111, '窦店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111104, 110111, '石楼镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111105, 110111, '长阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111107, 110111, '河北镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111108, 110111, '长沟镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111109, 110111, '大石窝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111110, 110111, '张坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111111, 110111, '十渡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111112, 110111, '青龙湖镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111115, 110111, '韩村河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111208, 110111, '霞云岭乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111209, 110111, '南窖乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111210, 110111, '佛子庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111211, 110111, '大安山乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111212, 110111, '史家营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110111213, 110111, '蒲洼乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112001, 110112, '中仓街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112002, 110112, '新华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112003, 110112, '北苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112004, 110112, '玉桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112007, 110112, '潞源街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112008, 110112, '通运街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112009, 110112, '文景街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112010, 110112, '九棵树街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112011, 110112, '临河里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112012, 110112, '杨庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112013, 110112, '潞邑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112104, 110112, '宋庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112105, 110112, '张家湾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112106, 110112, '漷县镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112109, 110112, '马驹桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112110, 110112, '西集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112114, 110112, '台湖镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112117, 110112, '永乐店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112119, 110112, '潞城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112120, 110112, '永顺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112121, 110112, '梨园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110112209, 110112, '于家务回族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113001, 110113, '胜利街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113002, 110113, '光明街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113003, 110113, '仁和地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113004, 110113, '后沙峪地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113005, 110113, '天竺地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113006, 110113, '杨镇地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113007, 110113, '牛栏山地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113008, 110113, '南法信地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113009, 110113, '马坡地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113010, 110113, '石园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113011, 110113, '空港街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113012, 110113, '双丰街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113013, 110113, '旺泉街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113101, 110113, '高丽营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113104, 110113, '李桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113105, 110113, '李遂镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113106, 110113, '南彩镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113108, 110113, '北务镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113109, 110113, '大孙各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113110, 110113, '张镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113111, 110113, '龙湾屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113112, 110113, '木林镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113113, 110113, '北小营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113115, 110113, '北石槽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110113116, 110113, '赵全营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114001, 110114, '城北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114002, 110114, '南口地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114003, 110114, '马池口地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114004, 110114, '沙河地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114005, 110114, '城南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114007, 110114, '东小口地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114008, 110114, '天通苑北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114009, 110114, '天通苑南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114010, 110114, '霍营街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114011, 110114, '回龙观街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114012, 110114, '龙泽园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114013, 110114, '史各庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114104, 110114, '阳坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114110, 110114, '小汤山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114111, 110114, '南邵镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114112, 110114, '崔村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114113, 110114, '百善镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114115, 110114, '北七家镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114116, 110114, '兴寿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114118, 110114, '流村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114119, 110114, '十三陵镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110114120, 110114, '延寿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115001, 110115, '兴丰街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115002, 110115, '林校路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115003, 110115, '清源街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115004, 110115, '亦庄地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115005, 110115, '黄村地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115006, 110115, '旧宫地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115007, 110115, '西红门地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115008, 110115, '瀛海地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115009, 110115, '观音寺街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115010, 110115, '天宫院街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115011, 110115, '高米店街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115012, 110115, '荣华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115013, 110115, '博兴街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115103, 110115, '青云店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115104, 110115, '采育镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115105, 110115, '安定镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115106, 110115, '礼贤镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115107, 110115, '榆垡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115108, 110115, '庞各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115109, 110115, '北臧村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115110, 110115, '魏善庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115111, 110115, '长子营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115403, 110115, '北京经济技术开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115404, 110115, '中关村国家自主创新示范区大兴生物医药产业基地', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115405, 110115, '国家新媒体产业基地', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110115406, 110115, '大兴国际机场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116001, 110116, '泉河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116002, 110116, '龙山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116003, 110116, '怀柔地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116004, 110116, '雁栖地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116005, 110116, '庙城地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116102, 110116, '北房镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116103, 110116, '杨宋镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116105, 110116, '桥梓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116106, 110116, '怀北镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116107, 110116, '汤河口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116108, 110116, '渤海镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116109, 110116, '九渡河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116110, 110116, '琉璃庙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116111, 110116, '宝山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116211, 110116, '长哨营满族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116213, 110116, '喇叭沟门满族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110116400, 110116, '北京雁栖经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117001, 110117, '滨河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117002, 110117, '兴谷街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117003, 110117, '渔阳地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117004, 110117, '峪口地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117005, 110117, '马坊地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117006, 110117, '金海湖地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117101, 110117, '东高村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117102, 110117, '山东庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117104, 110117, '南独乐河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117105, 110117, '大华山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117106, 110117, '夏各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117108, 110117, '马昌营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117110, 110117, '王辛庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117111, 110117, '大兴庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117112, 110117, '刘家店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117114, 110117, '镇罗营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117213, 110117, '黄松峪乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110117214, 110117, '熊儿寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118001, 110118, '鼓楼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118002, 110118, '果园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118003, 110118, '檀营地区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118100, 110118, '密云镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118101, 110118, '溪翁庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118102, 110118, '西田各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118103, 110118, '十里堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118104, 110118, '河南寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118105, 110118, '巨各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118106, 110118, '穆家峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118107, 110118, '太师屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118108, 110118, '高岭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118109, 110118, '不老屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118110, 110118, '冯家峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118111, 110118, '古北口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118112, 110118, '大城子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118113, 110118, '东邵渠镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118114, 110118, '北庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118115, 110118, '新城子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118116, 110118, '石城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110118400, 110118, '中关村科技园区密云园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119001, 110119, '百泉街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119002, 110119, '香水园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119003, 110119, '儒林街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119100, 110119, '延庆镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119101, 110119, '康庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119102, 110119, '八达岭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119103, 110119, '永宁镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119104, 110119, '旧县镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119105, 110119, '张山营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119106, 110119, '四海镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119107, 110119, '千家店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119108, 110119, '沈家营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119109, 110119, '大榆树镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119110, 110119, '井庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119200, 110119, '大庄科乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119201, 110119, '刘斌堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119202, 110119, '香营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (110119203, 110119, '珍珠泉乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120101001, 120101, '劝业场街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120101002, 120101, '小白楼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120101003, 120101, '五大道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120101004, 120101, '新兴街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120101005, 120101, '南营门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120101006, 120101, '南市街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102001, 120102, '大王庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102002, 120102, '大直沽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102003, 120102, '中山门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102004, 120102, '富民路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102005, 120102, '二号桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102006, 120102, '春华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102007, 120102, '唐家口街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102008, 120102, '向阳楼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102009, 120102, '常州道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102010, 120102, '上杭路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102011, 120102, '东新街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102012, 120102, '鲁山道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120102013, 120102, '天津铁厂街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103001, 120103, '大营门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103002, 120103, '下瓦房街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103003, 120103, '桃园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103004, 120103, '挂甲寺街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103005, 120103, '马场街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103006, 120103, '越秀路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103007, 120103, '友谊路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103008, 120103, '天塔街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103009, 120103, '尖山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103010, 120103, '陈塘庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103011, 120103, '柳林街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103012, 120103, '东海街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103013, 120103, '梅江街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120103014, 120103, '太湖路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104001, 120104, '长虹街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104002, 120104, '鼓楼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104003, 120104, '兴南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104004, 120104, '广开街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104005, 120104, '万兴街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104006, 120104, '学府街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104007, 120104, '向阳路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104008, 120104, '嘉陵道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104009, 120104, '王顶堤街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104010, 120104, '水上公园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104011, 120104, '体育中心街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120104012, 120104, '华苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105001, 120105, '光复道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105002, 120105, '望海楼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105003, 120105, '鸿顺里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105004, 120105, '新开河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105005, 120105, '铁东路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105006, 120105, '建昌道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105007, 120105, '宁园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105008, 120105, '王串场街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105009, 120105, '江都路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120105010, 120105, '月牙河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106001, 120106, '西于庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106003, 120106, '咸阳北路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106004, 120106, '丁字沽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106005, 120106, '西沽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106006, 120106, '三条石街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106008, 120106, '邵公庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106009, 120106, '芥园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106010, 120106, '铃铛阁街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120106012, 120106, '和苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110001, 120110, '张贵庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110002, 120110, '丰年村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110003, 120110, '万新街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110004, 120110, '无瑕街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110005, 120110, '新立街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110006, 120110, '华明街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110007, 120110, '金钟街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110008, 120110, '军粮城街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110009, 120110, '金桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110010, 120110, '华新街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110011, 120110, '东丽湖街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110400, 120110, '天津经济技术开发区西区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110401, 120110, '天津航空物流区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110402, 120110, '天津空港经济区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110403, 120110, '东丽区经济技术开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110405, 120110, '综合保税区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110406, 120110, '航空新城', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120110407, 120110, '服务滨海新区建设管理委员会', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111001, 120111, '西营门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111002, 120111, '李七庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111003, 120111, '赤龙南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111005, 120111, '津门湖街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111100, 120111, '中北镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111101, 120111, '杨柳青镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111102, 120111, '辛口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111103, 120111, '张家窝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111104, 120111, '精武镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111105, 120111, '大寺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111106, 120111, '王稳庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111400, 120111, '天津经济技术开发区微电子小区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111401, 120111, '新技术产业园区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120111450, 120111, '西青区开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112001, 120112, '双新街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112002, 120112, '双林街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112003, 120112, '海棠街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112100, 120112, '咸水沽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112101, 120112, '葛沽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112102, 120112, '小站镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112103, 120112, '双港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112104, 120112, '辛庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112106, 120112, '双桥河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112107, 120112, '八里台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112108, 120112, '北闸口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112403, 120112, '长青办事处', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112404, 120112, '津南开发区东区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112405, 120112, '津南开发区西区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120112501, 120112, '津南国家农业园区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113001, 120113, '果园新村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113002, 120113, '集贤里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113003, 120113, '普东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113004, 120113, '瑞景街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113005, 120113, '佳荣里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113006, 120113, '青源街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113007, 120113, '广源街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113008, 120113, '双环邨街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113100, 120113, '天穆镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113101, 120113, '北仓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113102, 120113, '双街镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113103, 120113, '双口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113104, 120113, '青光镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113106, 120113, '宜兴埠镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113107, 120113, '小淀镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113108, 120113, '大张庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113111, 120113, '西堤头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113400, 120113, '科技园区北区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113401, 120113, '科技园区南区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113402, 120113, '天津医药医疗器械工业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113403, 120113, '天津陆路港物流装备产业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113404, 120113, '天津风电产业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113500, 120113, '红旗农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120113501, 120113, '曙光农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114001, 120114, '杨村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114002, 120114, '下朱庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114003, 120114, '东蒲洼街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114004, 120114, '黄庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114005, 120114, '徐官屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114006, 120114, '运河西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114101, 120114, '梅厂镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114102, 120114, '大碱厂镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114103, 120114, '崔黄口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114104, 120114, '大良镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114105, 120114, '下伍旗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114106, 120114, '南蔡村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114107, 120114, '大孟庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114108, 120114, '泗村店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114109, 120114, '河西务镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114110, 120114, '城关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114111, 120114, '东马圈镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114112, 120114, '黄花店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114113, 120114, '石各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114114, 120114, '王庆坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114115, 120114, '汊沽港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114116, 120114, '河北屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114117, 120114, '上马台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114118, 120114, '大王古庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114119, 120114, '陈咀镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114120, 120114, '豆张庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114121, 120114, '曹子里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114122, 120114, '大黄堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114123, 120114, '高村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114124, 120114, '白古屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114400, 120114, '天津经济技术开发区逸仙科学工业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114401, 120114, '武清经济技术开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114403, 120114, '天津京滨工业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114404, 120114, '天津京津电子商务产业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114405, 120114, '天津武清汽车产业园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114406, 120114, '天津京津科技谷', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120114407, 120114, '京津高村科技创新园', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115001, 120115, '海滨街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115002, 120115, '宝平街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115003, 120115, '钰华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115006, 120115, '周良街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115007, 120115, '潮阳街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115008, 120115, '朝霞街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115101, 120115, '大口屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115103, 120115, '王卜庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115104, 120115, '方家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115105, 120115, '林亭口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115106, 120115, '八门城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115107, 120115, '大钟庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115108, 120115, '新安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115111, 120115, '霍各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115113, 120115, '新开口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115115, 120115, '大唐庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115119, 120115, '牛道口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115120, 120115, '史各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115121, 120115, '郝各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115123, 120115, '牛家牌镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115124, 120115, '尔王庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115125, 120115, '黄庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115126, 120115, '口东镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115127, 120115, '大白庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115456, 120115, '宝坻经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120115457, 120115, '京津中关村科技城', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116001, 120116, '塘沽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116005, 120116, '杭州道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116006, 120116, '新河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116007, 120116, '大沽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116008, 120116, '新北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116009, 120116, '北塘街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116011, 120116, '胡家园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116012, 120116, '新港街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116013, 120116, '新村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116014, 120116, '天津经济技术开发区东区泰达街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116031, 120116, '汉沽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116032, 120116, '寨上街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116033, 120116, '茶淀街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116051, 120116, '大港街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116053, 120116, '古林街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116054, 120116, '海滨街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116100, 120116, '新城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116135, 120116, '杨家泊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116156, 120116, '太平镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116157, 120116, '小王庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116158, 120116, '中塘镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116400, 120116, '天津经济技术开发区（其他片区）', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116401, 120116, '天津港保税区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116402, 120116, '天津滨海新区高新技术产业开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116403, 120116, '东疆保税港区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120116406, 120116, '中新天津生态城', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117001, 120117, '芦台街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117002, 120117, '桥北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117102, 120117, '宁河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117103, 120117, '苗庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117104, 120117, '丰台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117105, 120117, '岳龙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117106, 120117, '板桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117107, 120117, '潘庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117109, 120117, '造甲城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117110, 120117, '七里海镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117111, 120117, '大北涧沽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117112, 120117, '东棘坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117113, 120117, '北淮淀镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117114, 120117, '俵口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117115, 120117, '廉庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117400, 120117, '宁河区贸易开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117401, 120117, '宁河区经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117402, 120117, '天津未来科技城天津经济技术开发区片区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117403, 120117, '天津未来科技城滨海高新区片区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117451, 120117, '天津未来科技城宁河片区现代产业区组团', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117452, 120117, '天津未来科技城宁河片区潘庄工业区组团', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120117453, 120117, '天津未来科技城宁河片区北淮淀组团', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118001, 120118, '华康街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118002, 120118, '朝阳街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118100, 120118, '静海镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118101, 120118, '唐官屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118102, 120118, '独流镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118103, 120118, '王口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118104, 120118, '台头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118105, 120118, '子牙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118106, 120118, '陈官屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118107, 120118, '中旺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118108, 120118, '大邱庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118109, 120118, '蔡公庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118110, 120118, '梁头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118111, 120118, '团泊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118112, 120118, '双塘镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118113, 120118, '大丰堆镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118114, 120118, '沿庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118115, 120118, '西翟庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118200, 120118, '良王庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118201, 120118, '杨成庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118400, 120118, '天津静海经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118402, 120118, '天津子牙循环经济产业区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120118403, 120118, '团泊新城', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119001, 120119, '文昌街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119100, 120119, '渔阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119101, 120119, '洇溜镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119102, 120119, '官庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119103, 120119, '马伸桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119104, 120119, '下营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119105, 120119, '邦均镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119106, 120119, '别山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119108, 120119, '尤古庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119109, 120119, '上仓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119111, 120119, '下仓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119112, 120119, '罗庄子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119113, 120119, '白涧镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119115, 120119, '侯家营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119116, 120119, '桑梓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119117, 120119, '东施古镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119118, 120119, '下窝头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119119, 120119, '杨津庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119120, 120119, '出头岭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119121, 120119, '西龙虎峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119122, 120119, '穿芳峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119123, 120119, '东二营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119124, 120119, '许家台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119125, 120119, '礼明庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119126, 120119, '东赵各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119127, 120119, '州河湾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119203, 120119, '孙各庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (120119401, 120119, '天津市蓟州区京津州河科技产业园管理委员会', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102001, 130102, '建北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102002, 130102, '青园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102003, 130102, '广安街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102004, 130102, '育才街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102005, 130102, '跃进街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102007, 130102, '河东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102010, 130102, '长丰街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102011, 130102, '谈固街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102012, 130102, '中山东路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102013, 130102, '阜康街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102014, 130102, '建安街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102015, 130102, '胜利北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102100, 130102, '西兆通镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102101, 130102, '南村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102102, 130102, '高营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130102103, 130102, '桃园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104001, 130104, '东里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104002, 130104, '中山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104004, 130104, '南长街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104005, 130104, '维明街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104007, 130104, '友谊街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104008, 130104, '红旗街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104009, 130104, '新石街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104010, 130104, '苑东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104011, 130104, '西里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104012, 130104, '振头街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104013, 130104, '留营街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104014, 130104, '长兴街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104015, 130104, '彭后街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104016, 130104, '东风街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104017, 130104, '东华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104018, 130104, '休门街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130104019, 130104, '汇通街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105001, 130105, '革新街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105003, 130105, '新华路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105004, 130105, '宁安街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105005, 130105, '东焦街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105006, 130105, '西苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105007, 130105, '合作路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105008, 130105, '联盟街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105009, 130105, '石岗街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105011, 130105, '天苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105012, 130105, '北苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105013, 130105, '赵陵铺路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105014, 130105, '西三庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105015, 130105, '大郭街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105016, 130105, '杜北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130105017, 130105, '赵佗路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130107001, 130107, '矿市街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130107002, 130107, '四微街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130107100, 130107, '贾庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130107101, 130107, '凤山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130107200, 130107, '横涧乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108001, 130108, '裕兴街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108002, 130108, '裕强街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108003, 130108, '东苑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108004, 130108, '建通街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108005, 130108, '槐底街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108006, 130108, '裕华路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108007, 130108, '裕东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108008, 130108, '裕翔街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108009, 130108, '建华南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130108101, 130108, '方村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109100, 130109, '廉州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109101, 130109, '兴安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109102, 130109, '贾市庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109103, 130109, '南营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109104, 130109, '梅花镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109105, 130109, '岗上镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109107, 130109, '南董镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109108, 130109, '张家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109109, 130109, '南孟镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109110, 130109, '增村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109111, 130109, '常安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109112, 130109, '西关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109200, 130109, '九门回族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130109500, 130109, '石家庄经济技术开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110100, 130110, '获鹿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110101, 130110, '铜冶镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110102, 130110, '寺家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110103, 130110, '上庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110104, 130110, '李村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110105, 130110, '宜安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110106, 130110, '黄壁庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110107, 130110, '大河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110108, 130110, '山尹村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110200, 130110, '石井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110201, 130110, '白鹿泉乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110202, 130110, '上寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130110500, 130110, '河北鹿泉经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111100, 130111, '栾城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111103, 130111, '冶河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111104, 130111, '窦妪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111105, 130111, '楼底镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111200, 130111, '南高乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111201, 130111, '柳林屯乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130111202, 130111, '西营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121100, 130121, '微水镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121101, 130121, '上安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121102, 130121, '天长镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121103, 130121, '秀林镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121104, 130121, '南峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121105, 130121, '威州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121106, 130121, '小作镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121107, 130121, '南障城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121108, 130121, '苍岩山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121109, 130121, '测鱼镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121200, 130121, '吴家窑乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121201, 130121, '北正乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121202, 130121, '于家乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121203, 130121, '孙庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121204, 130121, '南陉乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121205, 130121, '辛庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130121206, 130121, '南王庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123001, 130123, '诸福屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123002, 130123, '三里屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123100, 130123, '正定镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123102, 130123, '新城铺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123103, 130123, '新安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123104, 130123, '南岗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123105, 130123, '曲阳桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123200, 130123, '南牛乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123201, 130123, '南楼乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130123202, 130123, '西平乐乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125100, 130125, '龙州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125101, 130125, '南桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125102, 130125, '上碑镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125103, 130125, '口头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125200, 130125, '独羊岗乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125201, 130125, '安香乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125202, 130125, '只里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125203, 130125, '市同乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125204, 130125, '翟营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125205, 130125, '城寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125206, 130125, '上方乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125207, 130125, '玉亭乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125208, 130125, '北河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125209, 130125, '上闫庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125210, 130125, '九口子乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130125400, 130125, '开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126100, 130126, '灵寿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126101, 130126, '青同镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126102, 130126, '塔上镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126103, 130126, '陈庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126104, 130126, '慈峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126105, 130126, '岔头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126200, 130126, '三圣院乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126201, 130126, '北洼乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126202, 130126, '牛城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126203, 130126, '狗台乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126204, 130126, '南寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126205, 130126, '南燕川乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126206, 130126, '北谭庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126207, 130126, '寨头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130126208, 130126, '南营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130127100, 130127, '高邑镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130127101, 130127, '大营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130127102, 130127, '富村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130127103, 130127, '万城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130127104, 130127, '中韩镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130128100, 130128, '深泽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130128101, 130128, '铁杆镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130128102, 130128, '赵八镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130128103, 130128, '大桥头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130128200, 130128, '白庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130128201, 130128, '留村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129100, 130129, '赞皇镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129101, 130129, '院头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129102, 130129, '南邢郭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129103, 130129, '嶂石岩镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129200, 130129, '西龙门乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129202, 130129, '南清河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129203, 130129, '西阳泽乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129204, 130129, '土门乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129205, 130129, '黄北坪乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129207, 130129, '许亭乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130129208, 130129, '张楞乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130100, 130130, '无极镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130101, 130130, '七汲镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130102, 130130, '张段固镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130103, 130130, '北苏镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130104, 130130, '郭庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130105, 130130, '大陈镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130200, 130130, '高头回族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130201, 130130, '郝庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130202, 130130, '东侯坊乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130203, 130130, '里城道乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130130204, 130130, '南流乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131100, 130131, '平山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131101, 130131, '东回舍镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131102, 130131, '温塘镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131103, 130131, '南甸镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131104, 130131, '岗南镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131105, 130131, '古月镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131106, 130131, '下槐镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131107, 130131, '孟家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131108, 130131, '小觉镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131109, 130131, '蛟潭庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131110, 130131, '西柏坡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131111, 130131, '下口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131200, 130131, '西大吾乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131201, 130131, '上三汲乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131202, 130131, '两河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131203, 130131, '东王坡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131204, 130131, '苏家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131205, 130131, '宅北乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131207, 130131, '北冶乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131209, 130131, '上观音堂乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131210, 130131, '杨家桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131211, 130131, '营里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130131212, 130131, '合河口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132001, 130132, '城区街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132100, 130132, '槐阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132101, 130132, '殷村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132102, 130132, '南佐镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132103, 130132, '宋曹镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132104, 130132, '南因镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132105, 130132, '姬村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132106, 130132, '北褚镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132107, 130132, '马村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132201, 130132, '东张乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132202, 130132, '赵同乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132204, 130132, '苏村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132205, 130132, '苏阳乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132206, 130132, '北正乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132207, 130132, '前仙乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130132208, 130132, '黑水河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133100, 130133, '赵州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133101, 130133, '范庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133102, 130133, '北王里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133103, 130133, '新寨店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133104, 130133, '韩村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133105, 130133, '南柏舍镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133106, 130133, '沙河店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133107, 130133, '王西章镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133200, 130133, '前大章乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133201, 130133, '谢庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130133202, 130133, '高村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130171010, 130171, '长江街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130171011, 130171, '太行街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130171100, 130171, '宋营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130171101, 130171, '郄马镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130172100, 130172, '丘头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181100, 130181, '辛集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181101, 130181, '旧城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181102, 130181, '张古庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181103, 130181, '位伯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181104, 130181, '新垒头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181105, 130181, '新城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181106, 130181, '南智邱镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181107, 130181, '王口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181200, 130181, '天宫营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181201, 130181, '前营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181202, 130181, '马庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181203, 130181, '和睦井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181204, 130181, '田家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181205, 130181, '中里厢乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181206, 130181, '小辛庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130181500, 130181, '辛集经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183100, 130183, '晋州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183101, 130183, '总十庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183102, 130183, '营里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183103, 130183, '桃园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183104, 130183, '东卓宿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183105, 130183, '马于镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183106, 130183, '小樵镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183107, 130183, '槐树镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183108, 130183, '东里庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130183201, 130183, '周家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184001, 130184, '长寿街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184101, 130184, '化皮镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184102, 130184, '承安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184103, 130184, '正莫镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184104, 130184, '南大岳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184105, 130184, '杜固镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184106, 130184, '邯邰镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184107, 130184, '东王镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184108, 130184, '马头铺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184200, 130184, '协神乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184201, 130184, '木村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130184202, 130184, '彭家庄回族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202001, 130202, '学院南路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202002, 130202, '友谊街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202003, 130202, '广场街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202004, 130202, '永红桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202005, 130202, '小山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202006, 130202, '文化北后街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202007, 130202, '钱家营矿区街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202008, 130202, '惠民道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202009, 130202, '梁家屯路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202102, 130202, '稻地镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130202200, 130202, '女织寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203001, 130203, '乔屯街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203002, 130203, '文化路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203003, 130203, '钓鱼台街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203004, 130203, '东新村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203005, 130203, '缸窑街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203006, 130203, '机场路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203007, 130203, '河北路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203008, 130203, '龙东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203009, 130203, '大里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203010, 130203, '光明街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203011, 130203, '翔云道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203100, 130203, '韩城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130203101, 130203, '果园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204001, 130204, '林西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204002, 130204, '唐家庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204003, 130204, '古冶街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204004, 130204, '赵各庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204007, 130204, '京华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204100, 130204, '范各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204101, 130204, '卑家店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204201, 130204, '王辇庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204202, 130204, '习家套乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130204203, 130204, '大庄坨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205001, 130205, '马家沟街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205002, 130205, '开平街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205003, 130205, '税务庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205005, 130205, '陡电街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205006, 130205, '荆各庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205100, 130205, '开平镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205101, 130205, '栗园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205102, 130205, '郑庄子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205103, 130205, '双桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205104, 130205, '洼里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130205105, 130205, '越河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207103, 130207, '小集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207104, 130207, '黄各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207105, 130207, '西葛镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207106, 130207, '大新庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207107, 130207, '钱营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207108, 130207, '唐坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207109, 130207, '王兰庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207110, 130207, '柳树瞿阝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207111, 130207, '黑沿子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207113, 130207, '胥各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207114, 130207, '大齐各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207115, 130207, '岔河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207201, 130207, '南孙庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207202, 130207, '东田庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130207203, 130207, '尖字沽乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208001, 130208, '太平路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208002, 130208, '燕山路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208003, 130208, '浭阳街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208100, 130208, '丰润镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208102, 130208, '任各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208103, 130208, '左家坞镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208104, 130208, '泉河头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208105, 130208, '王官营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208106, 130208, '火石营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208109, 130208, '新军屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208110, 130208, '小张各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208111, 130208, '丰登坞镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208112, 130208, '李钊庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208113, 130208, '白官屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208114, 130208, '石各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208115, 130208, '沙流河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208116, 130208, '七树庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208117, 130208, '杨官林镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208118, 130208, '银城铺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208119, 130208, '常庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208202, 130208, '姜家营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208205, 130208, '欢喜庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130208208, 130208, '刘家营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209100, 130209, '唐海镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209112, 130209, '滨海镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209113, 130209, '柳赞镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209401, 130209, '一农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209403, 130209, '三农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209404, 130209, '四农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209405, 130209, '五农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209406, 130209, '六农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209407, 130209, '七农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209408, 130209, '八农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209409, 130209, '九农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209410, 130209, '十农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209411, 130209, '十一农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209412, 130209, '八里滩养殖场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209413, 130209, '十里海养殖场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209450, 130209, '南堡经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209451, 130209, '曹妃甸工业区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130209452, 130209, '曹妃甸新城', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224001, 130224, '友谊路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224100, 130224, '倴城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224101, 130224, '宋道口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224102, 130224, '长凝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224103, 130224, '胡各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224104, 130224, '坨里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224105, 130224, '姚王庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224106, 130224, '司各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224107, 130224, '安各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224108, 130224, '扒齿港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224109, 130224, '程庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224110, 130224, '青坨营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224111, 130224, '柏各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224114, 130224, '南堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224115, 130224, '方各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224116, 130224, '东黄坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130224117, 130224, '马城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225001, 130225, '乐安街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225100, 130225, '乐亭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225101, 130225, '汤家河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225102, 130225, '胡家坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225104, 130225, '闫各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225105, 130225, '马头营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225106, 130225, '新寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225107, 130225, '汀流河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225108, 130225, '姜各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225109, 130225, '毛庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225110, 130225, '中堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225111, 130225, '大相各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225201, 130225, '庞各庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225203, 130225, '古河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225453, 130225, '河北乐亭经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130225454, 130225, '乐亭县城区工业聚集区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227001, 130227, '栗乡街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227100, 130227, '兴城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227101, 130227, '金厂峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227102, 130227, '洒河桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227103, 130227, '太平寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227104, 130227, '罗家屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227105, 130227, '东荒峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227106, 130227, '新集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227107, 130227, '三屯营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227108, 130227, '滦阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227109, 130227, '汉儿庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227110, 130227, '新庄子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227111, 130227, '东莲花院镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227200, 130227, '白庙子乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227201, 130227, '上营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227203, 130227, '渔户寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227204, 130227, '旧城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227205, 130227, '尹庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130227450, 130227, '栗乡工业产业聚集区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229001, 130229, '无终街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229100, 130229, '玉田镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229101, 130229, '亮甲店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229102, 130229, '鸦鸿桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229103, 130229, '窝洛沽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229104, 130229, '石臼窝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229105, 130229, '虹桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229106, 130229, '散水头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229107, 130229, '林南仓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229108, 130229, '林西镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229109, 130229, '杨家板桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229110, 130229, '彩亭桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229111, 130229, '孤树镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229112, 130229, '大安镇镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229113, 130229, '唐自头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229114, 130229, '郭家屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229115, 130229, '杨家套镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229116, 130229, '陈家铺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229201, 130229, '林头屯乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229203, 130229, '潮洛窝乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229205, 130229, '郭家桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229400, 130229, '河北玉田经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130229401, 130229, '河北唐山国家农业科技园区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130271100, 130271, '海北镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130271450, 130271, '新华路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130272101, 130272, '汉丰镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130272451, 130272, '兴农街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130272452, 130272, '振兴街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130273001, 130273, '街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130273101, 130273, '老庄子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130273401, 130273, '庆北办事处', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130273402, 130273, '三女河办事处', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130274103, 130274, '王滩镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130274451, 130274, '社区管理服务中心', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130274452, 130274, '唐山湾国际旅游岛', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130274455, 130274, '大清河', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281001, 130281, '华明路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281002, 130281, '文化路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281100, 130281, '遵化镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281101, 130281, '堡子店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281102, 130281, '马兰峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281103, 130281, '平安城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281104, 130281, '东新庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281105, 130281, '新店子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281106, 130281, '党峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281107, 130281, '地北头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281108, 130281, '东旧寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281109, 130281, '铁厂镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281110, 130281, '苏家洼镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281111, 130281, '建明镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281112, 130281, '石门镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281113, 130281, '崔家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281200, 130281, '西留村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281202, 130281, '兴旺寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281203, 130281, '西下营满族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281204, 130281, '汤泉满族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281205, 130281, '东陵满族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281206, 130281, '刘备寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281207, 130281, '团瓢庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281208, 130281, '娘娘庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281209, 130281, '西三里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281210, 130281, '侯家寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130281211, 130281, '小厂乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283001, 130283, '永顺街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283002, 130283, '兴安街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283003, 130283, '滨河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283004, 130283, '杨店子街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283101, 130283, '夏官营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283102, 130283, '杨各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283103, 130283, '建昌营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283104, 130283, '赵店子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283105, 130283, '野鸡坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283106, 130283, '大崔庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283108, 130283, '蔡园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283109, 130283, '马兰庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283110, 130283, '沙河驿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283111, 130283, '木厂口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283112, 130283, '上射雁庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283113, 130283, '太平庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283114, 130283, '扣庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283115, 130283, '大五里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283116, 130283, '五重安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283117, 130283, '彭店子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130283118, 130283, '阎家店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284001, 130284, '滦河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284002, 130284, '古城街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284003, 130284, '滦城路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284004, 130284, '响嘡街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284102, 130284, '东安各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284103, 130284, '雷庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284104, 130284, '茨榆坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284105, 130284, '榛子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284106, 130284, '杨柳庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284107, 130284, '油榨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284108, 130284, '古马镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284109, 130284, '小马庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284110, 130284, '九百户镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130284111, 130284, '王店子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302001, 130302, '文化路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302002, 130302, '海滨路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302003, 130302, '北环路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302004, 130302, '建设大街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302005, 130302, '河东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302006, 130302, '西港路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302007, 130302, '燕山大街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302008, 130302, '港城大街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302009, 130302, '东环路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302010, 130302, '白塔岭街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302100, 130302, '东港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302101, 130302, '海港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302102, 130302, '西港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302103, 130302, '海阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302104, 130302, '北港镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302105, 130302, '杜庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302106, 130302, '石门寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302107, 130302, '驻操营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302403, 130302, '临港物流园区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130302404, 130302, '海港经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303001, 130303, '南关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303002, 130303, '古城街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303003, 130303, '西关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303004, 130303, '路南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303100, 130303, '第一关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303101, 130303, '石河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130303102, 130303, '孟姜镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130304001, 130304, '西山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130304002, 130304, '东山街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130304100, 130304, '海滨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130304101, 130304, '戴河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130304103, 130304, '牛头崖镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306001, 130306, '骊城街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306100, 130306, '抚宁镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306101, 130306, '留守营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306102, 130306, '榆关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306105, 130306, '台营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306106, 130306, '大新寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306109, 130306, '坟坨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130306200, 130306, '茶棚乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321001, 130321, '都阳路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321100, 130321, '青龙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321101, 130321, '祖山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321102, 130321, '木头凳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321103, 130321, '双山子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321104, 130321, '马圈子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321105, 130321, '肖营子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321106, 130321, '大巫岚镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321107, 130321, '土门子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321108, 130321, '八道河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321109, 130321, '隔河头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321110, 130321, '娄杖子镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321200, 130321, '凤凰山乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321201, 130321, '龙王庙乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321202, 130321, '三星口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321203, 130321, '干沟乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321206, 130321, '大石岭乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321208, 130321, '官场乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321209, 130321, '茨榆山乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321210, 130321, '平方子乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321211, 130321, '安子岭乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321212, 130321, '朱杖子乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321213, 130321, '草碾乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321217, 130321, '三拨子乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130321218, 130321, '凉水河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322100, 130322, '昌黎镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322101, 130322, '靖安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322102, 130322, '安山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322103, 130322, '龙家店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322104, 130322, '泥井镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322105, 130322, '大蒲河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322106, 130322, '新集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322107, 130322, '刘台庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322108, 130322, '茹荷镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322109, 130322, '朱各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322110, 130322, '荒佃庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322201, 130322, '团林乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322202, 130322, '葛条港乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322203, 130322, '马坨店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322206, 130322, '两山乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130322207, 130322, '十里铺乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324100, 130324, '卢龙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324101, 130324, '潘庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324102, 130324, '燕河营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324103, 130324, '双望镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324104, 130324, '刘田各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324105, 130324, '石门镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324106, 130324, '木井镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324107, 130324, '陈官屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324108, 130324, '蛤泊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324200, 130324, '下寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324201, 130324, '刘家营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130324203, 130324, '印庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130371005, 130371, '船厂路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130371011, 130371, '珠江道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130371012, 130371, '黄河道街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130371013, 130371, '腾飞路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130371200, 130371, '渤海乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130372001, 130372, '南戴河街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130372400, 130372, '大蒲河管理处', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130372401, 130372, '团林管理处', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130372402, 130372, '留守营管理处', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402001, 130402, '火磨街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402002, 130402, '陵园路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402003, 130402, '光明路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402004, 130402, '滏东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402005, 130402, '罗城头街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402006, 130402, '渚河路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402007, 130402, '浴新南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402008, 130402, '农林路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402009, 130402, '贸东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402010, 130402, '贸西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402011, 130402, '盛和路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402101, 130402, '北张庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402102, 130402, '河沙镇镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402200, 130402, '马庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402201, 130402, '南堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130402202, 130402, '代召乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403001, 130403, '丛台西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403002, 130403, '联纺西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403003, 130403, '联纺东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403004, 130403, '光明桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403005, 130403, '丛台东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403006, 130403, '四季青街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403007, 130403, '和平街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403008, 130403, '中华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403009, 130403, '人民路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403010, 130403, '柳林桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403101, 130403, '黄粱梦镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403200, 130403, '苏曹乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403205, 130403, '三陵乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403206, 130403, '南吕固乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130403207, 130403, '兼庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404001, 130404, '胜利桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404002, 130404, '百家村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404003, 130404, '铁路大院街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404004, 130404, '化林路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404005, 130404, '庞村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404006, 130404, '二六七二街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404007, 130404, '石化街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404100, 130404, '户村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404200, 130404, '彭家寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130404201, 130404, '康庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406001, 130406, '滏阳东路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406100, 130406, '临水镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406101, 130406, '峰峰镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406102, 130406, '新坡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406103, 130406, '大社镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406104, 130406, '和村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406105, 130406, '义井镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406106, 130406, '彭城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406107, 130406, '界城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406108, 130406, '大峪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130406200, 130406, '西固义乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407100, 130407, '肥乡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407101, 130407, '天台山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407102, 130407, '辛安镇镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407103, 130407, '大寺上镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407104, 130407, '东漳堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407105, 130407, '毛演堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407106, 130407, '西吕营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407203, 130407, '元固乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130407206, 130407, '旧店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408100, 130408, '临洺关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408101, 130408, '大北汪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408102, 130408, '张西堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408103, 130408, '广府镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408105, 130408, '永合会镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408106, 130408, '刘营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408107, 130408, '西苏镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408108, 130408, '讲武镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408109, 130408, '东杨庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408201, 130408, '界河店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408203, 130408, '刘汉乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408204, 130408, '正西乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408206, 130408, '曲陌乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408207, 130408, '辛庄堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408208, 130408, '小龙马乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408211, 130408, '西河庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130408213, 130408, '西阳城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423100, 130423, '临漳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423101, 130423, '南东坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423102, 130423, '孙陶集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423103, 130423, '柳园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423104, 130423, '称勾集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423105, 130423, '邺城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423106, 130423, '章里集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423200, 130423, '狄邱乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423201, 130423, '张村集乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423202, 130423, '西羊羔乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423204, 130423, '杜村集乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423206, 130423, '习文乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423207, 130423, '砖寨营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130423208, 130423, '柏鹤集乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424100, 130424, '成安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424101, 130424, '商城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424102, 130424, '漳河店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424103, 130424, '李家疃镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424104, 130424, '北乡义镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424105, 130424, '道东堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424200, 130424, '辛义乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424201, 130424, '柏寺营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130424204, 130424, '长巷乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425100, 130425, '大名镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425101, 130425, '杨桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425102, 130425, '万堤镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425103, 130425, '龙王庙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425104, 130425, '束馆镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425105, 130425, '金滩镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425106, 130425, '沙圪塔镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425107, 130425, '大街镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425108, 130425, '铺上镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425109, 130425, '孙甘店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425201, 130425, '王村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425203, 130425, '黄金堤乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425205, 130425, '旧治乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425206, 130425, '西未庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425208, 130425, '西付集乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425209, 130425, '埝头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425210, 130425, '北峰乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425211, 130425, '张铁集乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425212, 130425, '红庙乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130425213, 130425, '营镇回族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426001, 130426, '平安街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426101, 130426, '河南店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426102, 130426, '索堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426103, 130426, '西戌镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426104, 130426, '井店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426105, 130426, '更乐镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426106, 130426, '固新镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426107, 130426, '西达镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426108, 130426, '偏城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426200, 130426, '神头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426201, 130426, '辽城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426202, 130426, '偏店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426203, 130426, '龙虎乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426204, 130426, '木井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426205, 130426, '关防乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426206, 130426, '合漳乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426207, 130426, '鹿头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130426400, 130426, '涉城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427100, 130427, '磁州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427103, 130427, '讲武城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427104, 130427, '岳城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427105, 130427, '观台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427107, 130427, '白土镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427108, 130427, '黄沙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427200, 130427, '路村营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427204, 130427, '时村营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427207, 130427, '陶泉乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427208, 130427, '都党乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130427209, 130427, '北贾壁乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430100, 130430, '新马头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430101, 130430, '邱城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430102, 130430, '梁二庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430103, 130430, '香城固镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430104, 130430, '古城营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430201, 130430, '南辛店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130430204, 130430, '陈村回族乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431100, 130431, '鸡泽镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431101, 130431, '小寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431102, 130431, '双塔镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431103, 130431, '曹庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431104, 130431, '浮图店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431105, 130431, '吴官营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130431202, 130431, '风正乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432100, 130432, '广平镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432101, 130432, '平固店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432102, 130432, '胜营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432103, 130432, '南阳堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432104, 130432, '十里铺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432105, 130432, '南韩镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130432106, 130432, '东张孟镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433100, 130433, '馆陶镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433101, 130433, '房寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433102, 130433, '柴堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433103, 130433, '魏僧寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433200, 130433, '寿山寺乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433201, 130433, '王桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433202, 130433, '南徐村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130433203, 130433, '路桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434100, 130434, '魏城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434101, 130434, '德政镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434102, 130434, '北皋镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434103, 130434, '双井镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434104, 130434, '牙里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434105, 130434, '车往镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434106, 130434, '回隆镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434107, 130434, '张二庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434108, 130434, '东代固镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434109, 130434, '院堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434110, 130434, '棘针寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434111, 130434, '南双庙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434112, 130434, '边马镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434113, 130434, '泊口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434114, 130434, '仕望集镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434202, 130434, '沙口集乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434203, 130434, '野胡拐乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434205, 130434, '前大磨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434208, 130434, '大辛庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434209, 130434, '大马村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130434212, 130434, '北台头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435100, 130435, '曲周镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435101, 130435, '安寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435102, 130435, '侯村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435103, 130435, '河南疃镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435104, 130435, '第四疃镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435105, 130435, '白寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435200, 130435, '槐桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435201, 130435, '南里岳乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435203, 130435, '大河道乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130435204, 130435, '依庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130471001, 130471, '开发区街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130471100, 130471, '尚璧镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130471101, 130471, '南沿村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130471200, 130471, '小西堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130471201, 130471, '姚寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473001, 130473, '城南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473100, 130473, '高臾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473101, 130473, '西光禄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473102, 130473, '林坛镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473103, 130473, '马头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473200, 130473, '辛庄营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473201, 130473, '花官营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473202, 130473, '台城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130473203, 130473, '南城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481100, 130481, '武安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481101, 130481, '康二城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481102, 130481, '午汲镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481103, 130481, '磁山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481104, 130481, '伯延镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481105, 130481, '淑村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481106, 130481, '大同镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481107, 130481, '邑城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481108, 130481, '矿山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481109, 130481, '贺进镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481110, 130481, '阳邑镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481111, 130481, '徘徊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481112, 130481, '冶陶镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481200, 130481, '上团城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481201, 130481, '北安庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481202, 130481, '北安乐乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481203, 130481, '西土山乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481204, 130481, '西寺庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481205, 130481, '活水乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481206, 130481, '石洞乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481207, 130481, '管陶乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481208, 130481, '马家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130481400, 130481, '河北武安工业园区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502001, 130502, '南长街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502002, 130502, '北大街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502003, 130502, '西大街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502004, 130502, '西门里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502005, 130502, '泉东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502006, 130502, '豫让桥街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502100, 130502, '东郭村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502101, 130502, '祝村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502103, 130502, '晏家屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130502200, 130502, '大梁庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503001, 130503, '钢铁路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503002, 130503, '中兴路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503003, 130503, '达活泉街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503004, 130503, '张宽街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503005, 130503, '章村街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503006, 130503, '中华大街街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503007, 130503, '团结路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503008, 130503, '泉西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503100, 130503, '南大郭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503101, 130503, '李村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503102, 130503, '南石门镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503103, 130503, '羊范镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503104, 130503, '皇寺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503105, 130503, '会宁镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503106, 130503, '西黄村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503107, 130503, '路罗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503108, 130503, '将军墓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503109, 130503, '浆水镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503110, 130503, '宋家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503202, 130503, '太子井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503203, 130503, '龙泉寺乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503204, 130503, '北小庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503205, 130503, '城计头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503206, 130503, '白岸乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130503207, 130503, '冀家村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505100, 130505, '任城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505101, 130505, '邢家湾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505102, 130505, '辛店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505103, 130505, '天口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505200, 130505, '西固城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505201, 130505, '永福庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505202, 130505, '大屯乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130505203, 130505, '骆庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506100, 130506, '和阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506101, 130506, '贾宋镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506102, 130506, '郝桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506103, 130506, '三思镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506104, 130506, '河郭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506200, 130506, '东三召乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506201, 130506, '阎里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130506203, 130506, '史召乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522100, 130522, '临城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522101, 130522, '东镇镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522102, 130522, '西竖镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522103, 130522, '郝庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522104, 130522, '黑城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522201, 130522, '鸭鸽营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522203, 130522, '石城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130522205, 130522, '赵庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523100, 130523, '内丘镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523101, 130523, '大孟村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523102, 130523, '金店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523103, 130523, '官庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523104, 130523, '柳林镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523200, 130523, '五郭店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523203, 130523, '南赛乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523204, 130523, '獐獏乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130523205, 130523, '侯家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130524100, 130524, '柏乡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130524101, 130524, '固城店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130524102, 130524, '西汪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130524103, 130524, '龙华镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130524200, 130524, '王家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130524203, 130524, '内步乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525100, 130525, '隆尧镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525101, 130525, '魏家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525102, 130525, '尹村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525103, 130525, '山口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525104, 130525, '莲子镇镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525105, 130525, '固城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525106, 130525, '东良镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525200, 130525, '北楼乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525202, 130525, '双碑乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525203, 130525, '牛家桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525204, 130525, '千户营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525205, 130525, '大张家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130525400, 130525, '柳行农场', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528001, 130528, '宁北街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528100, 130528, '凤凰镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528101, 130528, '河渠镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528102, 130528, '北河庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528103, 130528, '耿庄桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528104, 130528, '东汪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528105, 130528, '贾家口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528106, 130528, '四芝兰镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528107, 130528, '大陆村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528108, 130528, '苏家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528109, 130528, '换马店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528110, 130528, '唐邱镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528111, 130528, '大曹庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528112, 130528, '侯口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528202, 130528, '纪昌庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528205, 130528, '北鱼乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528208, 130528, '徐家河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130528401, 130528, '大曹庄管理区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529100, 130529, '巨鹿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529101, 130529, '王虎寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529102, 130529, '西郭城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529103, 130529, '官亭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529104, 130529, '阎疃镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529105, 130529, '小吕寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529106, 130529, '苏家营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529107, 130529, '观寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529200, 130529, '堤村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130529201, 130529, '张王疃乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130530100, 130530, '新河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130530101, 130530, '寻寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130530200, 130530, '白神首乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130530201, 130530, '荆家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130530202, 130530, '西流乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130530203, 130530, '仁让里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531100, 130531, '广宗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531101, 130531, '冯家寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531102, 130531, '北塘疃镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531103, 130531, '核桃园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531200, 130531, '葫芦乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531201, 130531, '大平台乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531202, 130531, '件只乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130531204, 130531, '东召乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532001, 130532, '中华路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532101, 130532, '平乡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532102, 130532, '河古庙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532200, 130532, '节固乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532201, 130532, '油召乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532202, 130532, '田付村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130532203, 130532, '寻召乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533100, 130533, '洺州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533101, 130533, '梨园屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533102, 130533, '章台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533103, 130533, '侯贯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533104, 130533, '七级镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533105, 130533, '贺营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533106, 130533, '方家营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533107, 130533, '常庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533108, 130533, '第什营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533109, 130533, '贺钊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533110, 130533, '赵村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533111, 130533, '固献镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533202, 130533, '枣园乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533206, 130533, '张家营乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533207, 130533, '常屯乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130533209, 130533, '高公庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130534100, 130534, '葛仙庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130534101, 130534, '连庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130534102, 130534, '油坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130534103, 130534, '谢炉镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130534104, 130534, '王官庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130534105, 130534, '坝营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535100, 130535, '临西镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535101, 130535, '河西镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535102, 130535, '下堡寺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535103, 130535, '尖塚镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535104, 130535, '老官寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535105, 130535, '吕寨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535106, 130535, '大刘庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535200, 130535, '东枣园乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535203, 130535, '摇鞍镇乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130535400, 130535, '轴承工业园区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130571100, 130571, '东汪镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130571101, 130571, '王快镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130571103, 130571, '沙河城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130571104, 130571, '留村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130571400, 130571, '市高新技术开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581001, 130581, '凤岗街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581002, 130581, '南杜街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581003, 130581, '北胡街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581004, 130581, '西丁街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581100, 130581, '苏村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581101, 130581, '大高村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581102, 130581, '垂杨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581103, 130581, '明化镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581104, 130581, '段芦头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581105, 130581, '紫冢镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581200, 130581, '大村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581201, 130581, '南便村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581202, 130581, '大屯乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581203, 130581, '王道寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130581204, 130581, '薛吴村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582001, 130582, '褡裢街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582002, 130582, '桥东街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582003, 130582, '桥西街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582004, 130582, '赞善街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582005, 130582, '周庄街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582101, 130582, '新城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582102, 130582, '白塔镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582103, 130582, '十里亭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582104, 130582, '綦村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582201, 130582, '册井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582202, 130582, '刘石岗乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582203, 130582, '柴关乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130582204, 130582, '蝉房乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602001, 130602, '先锋街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602002, 130602, '新市场街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602003, 130602, '东风路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602004, 130602, '建南街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602005, 130602, '韩村北路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602100, 130602, '大激店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602200, 130602, '颉庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602201, 130602, '富昌乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602202, 130602, '韩村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130602203, 130602, '南奇乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606001, 130606, '和平里街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606002, 130606, '五四路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606003, 130606, '西关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606004, 130606, '中华路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606005, 130606, '东关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606006, 130606, '联盟街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606007, 130606, '红星街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606008, 130606, '裕华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606009, 130606, '永华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606010, 130606, '南关街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606100, 130606, '百楼镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606200, 130606, '韩庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606201, 130606, '东金庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606203, 130606, '杨庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606204, 130606, '南大园乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606205, 130606, '焦庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130606206, 130606, '五尧乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607001, 130607, '惠阳街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607100, 130607, '满城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607101, 130607, '大册营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607102, 130607, '神星镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607103, 130607, '南韩村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607104, 130607, '方顺桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607105, 130607, '于家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607203, 130607, '要庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607204, 130607, '白龙乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607205, 130607, '石井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607206, 130607, '坨南乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607207, 130607, '刘家台乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130607400, 130607, '河北满城经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608100, 130608, '清苑镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608101, 130608, '冉庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608102, 130608, '阳城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608103, 130608, '魏村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608104, 130608, '温仁镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608105, 130608, '张登镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608106, 130608, '大庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608107, 130608, '臧村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608108, 130608, '望亭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608109, 130608, '东闾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608200, 130608, '白团乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608201, 130608, '北店乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608202, 130608, '石桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608203, 130608, '李庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608204, 130608, '北王力乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608206, 130608, '何桥乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608207, 130608, '孙村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608208, 130608, '阎庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130608400, 130608, '河北清苑经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609100, 130609, '安肃镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609101, 130609, '崔庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609102, 130609, '大因镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609103, 130609, '遂城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609104, 130609, '高林村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609105, 130609, '大王店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609106, 130609, '漕河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609107, 130609, '东史端镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609108, 130609, '留村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609109, 130609, '正村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609203, 130609, '户木乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609204, 130609, '瀑河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609205, 130609, '东釜山乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130609206, 130609, '义联庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623100, 130623, '涞水镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623101, 130623, '永阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623102, 130623, '义安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623103, 130623, '石亭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623104, 130623, '赵各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623105, 130623, '九龙镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623106, 130623, '三坡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623107, 130623, '一渡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623108, 130623, '明义镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623109, 130623, '王村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623110, 130623, '娄村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623111, 130623, '东文山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623205, 130623, '其中口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623206, 130623, '龙门乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623207, 130623, '胡家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130623401, 130623, '涞水县城区社区管理办公室', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624100, 130624, '阜平镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624101, 130624, '龙泉关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624102, 130624, '平阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624103, 130624, '城南庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624104, 130624, '天生桥镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624105, 130624, '王林口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624106, 130624, '砂窝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624107, 130624, '北果园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624202, 130624, '台峪乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624203, 130624, '大台乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624204, 130624, '史家寨乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624206, 130624, '吴王口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624207, 130624, '夏庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130624400, 130624, '河北阜平经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626100, 130626, '定兴镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626101, 130626, '固城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626102, 130626, '贤寓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626103, 130626, '北河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626104, 130626, '天宫寺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626105, 130626, '小朱庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626106, 130626, '姚村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626107, 130626, '杨村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626200, 130626, '东落堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626201, 130626, '高里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626202, 130626, '张家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626204, 130626, '肖村乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626205, 130626, '柳卓乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626207, 130626, '北田乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626208, 130626, '北南蔡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130626209, 130626, '李郁庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627100, 130627, '仁厚镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627101, 130627, '王京镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627102, 130627, '高昌镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627103, 130627, '北罗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627104, 130627, '白合镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627105, 130627, '军城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627106, 130627, '川里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627107, 130627, '长古城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627108, 130627, '罗庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627109, 130627, '北店头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627201, 130627, '都亭乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627202, 130627, '南店头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627205, 130627, '雹水乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627206, 130627, '大洋乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627207, 130627, '迷城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627208, 130627, '齐家佐乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627209, 130627, '羊角乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627210, 130627, '石门乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627211, 130627, '黄石口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130627212, 130627, '倒马关乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628001, 130628, '高阳县锦华街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628101, 130628, '庞口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628102, 130628, '西演镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628103, 130628, '邢家南镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628104, 130628, '晋庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628105, 130628, '小王果庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628106, 130628, '蒲口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628107, 130628, '庞家佐镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130628400, 130628, '高阳县经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629100, 130629, '容城镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629101, 130629, '小里镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629102, 130629, '南张镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629103, 130629, '大河镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629104, 130629, '晾马台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629200, 130629, '八于乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629201, 130629, '贾光乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130629203, 130629, '平王乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630100, 130630, '涞源镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630101, 130630, '银坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630102, 130630, '走马驿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630103, 130630, '水堡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630104, 130630, '王安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630105, 130630, '杨家庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630106, 130630, '白石山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630107, 130630, '南屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630108, 130630, '泉坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630109, 130630, '北石佛镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630201, 130630, '南马庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630203, 130630, '金家井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630204, 130630, '留家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630205, 130630, '上庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630206, 130630, '东团堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630207, 130630, '塔崖驿乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130630208, 130630, '乌龙沟乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631100, 130631, '望都镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631101, 130631, '固店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631102, 130631, '贾村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631103, 130631, '中韩庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631104, 130631, '寺庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631105, 130631, '赵庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631106, 130631, '高岭镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631202, 130631, '黑堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130631400, 130631, '望都经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632100, 130632, '安新镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632101, 130632, '大王镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632102, 130632, '三台镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632103, 130632, '端村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632104, 130632, '赵北口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632105, 130632, '同口镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632106, 130632, '刘李庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632107, 130632, '安州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632108, 130632, '老河头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632200, 130632, '圈头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632201, 130632, '寨里乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632202, 130632, '芦庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130632203, 130632, '龙化乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633100, 130633, '易州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633101, 130633, '梁格庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633102, 130633, '西陵镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633103, 130633, '裴山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633104, 130633, '塘湖镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633105, 130633, '狼牙山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633106, 130633, '良岗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633107, 130633, '紫荆关镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633108, 130633, '高村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633200, 130633, '桥头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633201, 130633, '白马乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633202, 130633, '流井乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633204, 130633, '高陌乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633205, 130633, '大龙华乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633206, 130633, '安格庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633207, 130633, '凌云册乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633208, 130633, '西山北乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633209, 130633, '尉都乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633210, 130633, '独乐乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633211, 130633, '七峪乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633212, 130633, '富岗乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633213, 130633, '坡仓乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633214, 130633, '牛岗乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633215, 130633, '桥家河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633216, 130633, '甘河净乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633217, 130633, '蔡家峪乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633218, 130633, '南城司乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130633400, 130633, '恋乡太行水镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634100, 130634, '恒州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634101, 130634, '灵山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634102, 130634, '燕赵镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634103, 130634, '羊平镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634104, 130634, '文德镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634105, 130634, '晓林镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634106, 130634, '邸村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634107, 130634, '齐村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634108, 130634, '孝墓镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634109, 130634, '产德镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634200, 130634, '路庄子乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634201, 130634, '下河乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634202, 130634, '庄窠乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634205, 130634, '东旺乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634210, 130634, '党城乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634211, 130634, '郎家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634212, 130634, '范家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130634213, 130634, '北台乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635100, 130635, '蠡吾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635101, 130635, '留史镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635102, 130635, '大百尺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635103, 130635, '辛兴镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635104, 130635, '北郭丹镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635105, 130635, '万安镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635106, 130635, '桑园镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635107, 130635, '南庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635108, 130635, '大曲堤镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635109, 130635, '鲍墟镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635110, 130635, '小陈镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635201, 130635, '林堡乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130635202, 130635, '北埝头乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636100, 130636, '蒲阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636101, 130636, '高于铺镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636102, 130636, '腰山镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636103, 130636, '蒲上镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636104, 130636, '神南镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636105, 130636, '安阳镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636201, 130636, '白云乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636202, 130636, '河口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636204, 130636, '台鱼乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130636205, 130636, '大悲乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637100, 130637, '博野镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637101, 130637, '小店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637102, 130637, '程委镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637103, 130637, '东墟镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637104, 130637, '北杨镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637105, 130637, '城东镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130637106, 130637, '南小王镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638100, 130638, '雄州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638101, 130638, '昝岗镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638102, 130638, '大营镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638103, 130638, '龙湾镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638104, 130638, '朱各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638105, 130638, '米家务镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638106, 130638, '鄚州镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638107, 130638, '苟各庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638200, 130638, '北沙口乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638203, 130638, '双堂乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638204, 130638, '张岗乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130638205, 130638, '七间房乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130671202, 130671, '贤台乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130671205, 130671, '大马坊乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130671400, 130671, '保定国家高新区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130672103, 130672, '白沟镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681001, 130681, '双塔街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681002, 130681, '桃园街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681003, 130681, '清凉寺街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681100, 130681, '松林店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681101, 130681, '码头镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681102, 130681, '东城坊镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681103, 130681, '高官庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681104, 130681, '东仙坡镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681105, 130681, '百尺竿镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681106, 130681, '义和庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681107, 130681, '刁窝镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681108, 130681, '林家屯镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681109, 130681, '豆庄镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681204, 130681, '孙家庄乡', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681400, 130681, '高新技术产业开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681401, 130681, '京南经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130681402, 130681, '松林店经济开发区', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682001, 130682, '南城区街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682002, 130682, '北城区街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682003, 130682, '西城区街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682004, 130682, '长安路街道', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682100, 130682, '留早镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682101, 130682, '清风店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682102, 130682, '庞村镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682103, 130682, '砖路镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682104, 130682, '明月店镇', 4, '2022-11-09 10:39:24', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682105, 130682, '叮咛店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682106, 130682, '东亭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682107, 130682, '大辛庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682108, 130682, '东旺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682109, 130682, '高蓬镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682110, 130682, '邢邑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682111, 130682, '李亲顾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682112, 130682, '子位镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682113, 130682, '开元镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682115, 130682, '周村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682116, 130682, '息冢镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682203, 130682, '东留春乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682204, 130682, '号头庄回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682205, 130682, '杨家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682206, 130682, '大鹿庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130682208, 130682, '西城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683001, 130683, '药都街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683002, 130683, '祁州路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683101, 130683, '伍仁桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683102, 130683, '石佛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683103, 130683, '郑章镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683104, 130683, '大五女镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683105, 130683, '西佛落镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683106, 130683, '西城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683200, 130683, '明官店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683201, 130683, '南娄底乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683204, 130683, '北段村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130683400, 130683, '现代中药工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684001, 130684, '和平街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684002, 130684, '军城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684003, 130684, '东盛街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684004, 130684, '北城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684005, 130684, '兴华路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684100, 130684, '方官镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684101, 130684, '新城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684102, 130684, '泗庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684104, 130684, '辛立庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684105, 130684, '东马营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684106, 130684, '辛桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684107, 130684, '肖官营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684108, 130684, '张六庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130684109, 130684, '梁家营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702001, 130702, '红旗楼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702002, 130702, '胜利北路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702003, 130702, '五一路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702004, 130702, '花园街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702005, 130702, '工业路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702101, 130702, '姚家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702102, 130702, '大仓盖镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130702202, 130702, '东望山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703001, 130703, '新华街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703002, 130703, '大境门街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703003, 130703, '明德北街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703004, 130703, '明德南街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703005, 130703, '堡子里街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703006, 130703, '南营坊街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703007, 130703, '工人新村街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130703100, 130703, '东窑子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705001, 130705, '天泰寺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705002, 130705, '皇城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705003, 130705, '南关街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705004, 130705, '南大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705005, 130705, '大北街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705006, 130705, '工业街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705007, 130705, '建国街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705100, 130705, '庞家堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705101, 130705, '深井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705102, 130705, '崞村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705104, 130705, '洋河南镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705106, 130705, '贾家营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705107, 130705, '顾家营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705108, 130705, '赵川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705109, 130705, '江家屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705200, 130705, '河子西乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705201, 130705, '春光乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705202, 130705, '侯家庙乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705204, 130705, '李家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705205, 130705, '王家湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130705206, 130705, '塔儿村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130706001, 130706, '城镇街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130706002, 130706, '煤矿街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130706200, 130706, '花园乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130706201, 130706, '辛庄子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130706202, 130706, '定方水乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130706203, 130706, '段家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708100, 130708, '孔家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708101, 130708, '万全镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708102, 130708, '洗马林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708103, 130708, '郭磊庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708200, 130708, '膳房堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708201, 130708, '北新屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708202, 130708, '宣平堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708203, 130708, '高庙堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708204, 130708, '旧堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708205, 130708, '安家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708206, 130708, '北沙城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708400, 130708, '孔家庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130708401, 130708, '宣平街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709001, 130709, '西湾子街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709100, 130709, '西湾子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709101, 130709, '高家营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709200, 130709, '四台嘴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709201, 130709, '红旗营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709202, 130709, '石窑子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709203, 130709, '驿马图乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709204, 130709, '石嘴子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709205, 130709, '狮子沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709206, 130709, '清三营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130709207, 130709, '白旗乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722100, 130722, '张北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722101, 130722, '公会镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722102, 130722, '二台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722103, 130722, '大囫囵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722104, 130722, '小二台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722106, 130722, '油篓沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722107, 130722, '大河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722200, 130722, '台路沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722202, 130722, '馒头营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722203, 130722, '二泉井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722204, 130722, '单晶河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722206, 130722, '海流图乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722207, 130722, '两面井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722208, 130722, '大西湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722209, 130722, '郝家营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722210, 130722, '白庙滩乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722212, 130722, '战海乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130722213, 130722, '三号乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723100, 130723, '康保镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723101, 130723, '张纪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723102, 130723, '土城子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723103, 130723, '邓油坊镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723104, 130723, '李家地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723105, 130723, '照阳河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723106, 130723, '屯垦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723200, 130723, '闫油坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723201, 130723, '丹清河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723202, 130723, '哈咇嘎乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723203, 130723, '二号卜乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723204, 130723, '芦家营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723205, 130723, '忠义乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723206, 130723, '处长地乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723207, 130723, '满德堂乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723500, 130723, '康保牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130723501, 130723, '屯垦林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724100, 130724, '平定堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724101, 130724, '小厂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724102, 130724, '黄盖淖镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724103, 130724, '九连城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724200, 130724, '高山堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724201, 130724, '小河子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724202, 130724, '二道渠乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724203, 130724, '大二号回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724204, 130724, '闪电河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724205, 130724, '长梁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724206, 130724, '丰源店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724207, 130724, '西辛营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724208, 130724, '莲花滩乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130724209, 130724, '白土窑乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725100, 130725, '南壕堑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725101, 130725, '大青沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725102, 130725, '八道沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725103, 130725, '红土梁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725104, 130725, '小蒜沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725105, 130725, '三工地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725106, 130725, '满井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725200, 130725, '大营盘乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725201, 130725, '大苏计乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725202, 130725, '石井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725205, 130725, '七甲乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725206, 130725, '套里庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725207, 130725, '甲石河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130725208, 130725, '下马圈乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726100, 130726, '蔚州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726101, 130726, '代王城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726102, 130726, '西合营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726103, 130726, '吉家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726104, 130726, '白乐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726105, 130726, '暖泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726106, 130726, '南留庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726107, 130726, '北水泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726108, 130726, '桃花镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726109, 130726, '阳眷镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726110, 130726, '宋家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726200, 130726, '下宫村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726202, 130726, '南杨庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726203, 130726, '柏树乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726204, 130726, '常宁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726205, 130726, '涌泉庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726206, 130726, '杨庄窠乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726207, 130726, '南岭庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726208, 130726, '陈家洼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726209, 130726, '黄梅乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726210, 130726, '白草村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130726211, 130726, '草沟堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727100, 130727, '西城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727101, 130727, '东城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727102, 130727, '化稍营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727103, 130727, '揣骨疃镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727104, 130727, '东井集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727200, 130727, '要家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727201, 130727, '东坊城堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727202, 130727, '井儿沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727203, 130727, '三马坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727204, 130727, '高墙乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727205, 130727, '大田洼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727206, 130727, '辛堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727207, 130727, '马圈堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130727208, 130727, '浮图讲乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728100, 130728, '柴沟堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728101, 130728, '左卫镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728102, 130728, '头百户镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728103, 130728, '怀安城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728200, 130728, '渡口堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728201, 130728, '第六屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728202, 130728, '西湾堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728203, 130728, '西沙城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728204, 130728, '太平庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728205, 130728, '王虎屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130728206, 130728, '第三堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730100, 130730, '沙城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730101, 130730, '北辛堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730102, 130730, '新保安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730103, 130730, '东花园镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730104, 130730, '官厅镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730105, 130730, '桑园镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730106, 130730, '存瑞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730107, 130730, '土木镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730108, 130730, '大黄庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730109, 130730, '西八里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730110, 130730, '小南辛堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730200, 130730, '狼山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730203, 130730, '鸡鸣驿乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730205, 130730, '东八里乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730207, 130730, '瑞云观乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730208, 130730, '孙庄子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130730210, 130730, '王家楼回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731100, 130731, '涿鹿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731101, 130731, '张家堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731102, 130731, '武家沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731103, 130731, '五堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731104, 130731, '保岱镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731105, 130731, '矾山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731106, 130731, '大堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731107, 130731, '河东镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731108, 130731, '东小庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731109, 130731, '辉耀镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731110, 130731, '大河南镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731111, 130731, '温泉屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731112, 130731, '蟒石口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731201, 130731, '栾庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731204, 130731, '黑山寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731205, 130731, '卧佛寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130731206, 130731, '谢家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732100, 130732, '赤城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732101, 130732, '田家窑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732102, 130732, '龙关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732103, 130732, '雕鹗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732104, 130732, '独石口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732105, 130732, '白草镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732106, 130732, '龙门所镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732107, 130732, '后城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732108, 130732, '东卯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732200, 130732, '炮梁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732201, 130732, '大海陀乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732202, 130732, '镇宁堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732203, 130732, '马营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732204, 130732, '云州乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732205, 130732, '三道川乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732206, 130732, '东万口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732207, 130732, '茨营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130732208, 130732, '样田乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130771001, 130771, '南站街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130771002, 130771, '马路东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130771100, 130771, '老鸦庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130771101, 130771, '沈家屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130771102, 130771, '姚家房镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130771103, 130771, '沙岭子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772105, 130772, '沙沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772215, 130772, '宇宙营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772401, 130772, '黄山管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772402, 130772, '石门管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772403, 130772, '乌兰管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772404, 130772, '金沙管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130772405, 130772, '白塔管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130773501, 130773, '榆树沟管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130773502, 130773, '沙梁子管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130773503, 130773, '小城子管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130773504, 130773, '东大门管理处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802001, 130802, '西大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802002, 130802, '头道牌楼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802003, 130802, '潘家沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802004, 130802, '中华路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802005, 130802, '新华路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802006, 130802, '石洞子沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802007, 130802, '桥东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802100, 130802, '水泉沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802101, 130802, '狮子沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802102, 130802, '牛圈子沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802103, 130802, '大石庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130802105, 130802, '双峰寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803001, 130803, '元宝山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803002, 130803, '钢城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803003, 130803, '秀水街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803100, 130803, '双塔山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803101, 130803, '滦河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803102, 130803, '大庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803103, 130803, '偏桥子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803104, 130803, '西地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130803105, 130803, '陈栅子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130804001, 130804, '铁北路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130804100, 130804, '鹰手营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130804101, 130804, '北马圈子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130804102, 130804, '寿王坟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130804103, 130804, '汪家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821100, 130821, '下板城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821102, 130821, '甲山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821103, 130821, '六沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821104, 130821, '三沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821105, 130821, '头沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821106, 130821, '高寺台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821107, 130821, '鞍匠镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821108, 130821, '三家镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821109, 130821, '磴上镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821110, 130821, '上谷镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821111, 130821, '新杖子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821112, 130821, '石灰窑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821200, 130821, '东小白旗乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821202, 130821, '刘杖子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821204, 130821, '孟家院乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821205, 130821, '大营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821206, 130821, '八家乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821208, 130821, '满杖子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821210, 130821, '五道河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821211, 130821, '岔沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821212, 130821, '岗子满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821214, 130821, '两家满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130821216, 130821, '仓子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822100, 130822, '兴隆镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822101, 130822, '半壁山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822102, 130822, '挂兰峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822103, 130822, '青松岭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822104, 130822, '六道河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822105, 130822, '平安堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822106, 130822, '北营房镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822107, 130822, '孤山子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822108, 130822, '蓝旗营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822109, 130822, '雾灵山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822110, 130822, '李家营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822111, 130822, '大杖子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822112, 130822, '三道河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822113, 130822, '蘑菇峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822114, 130822, '大水泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822200, 130822, '南天门满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822202, 130822, '八卦岭满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822203, 130822, '陡子峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822204, 130822, '上石洞乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130822211, 130822, '安子岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824001, 130824, '中兴路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824100, 130824, '滦平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824101, 130824, '长山峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824102, 130824, '红旗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824103, 130824, '金沟屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824104, 130824, '虎什哈镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824105, 130824, '巴克什营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824106, 130824, '张百湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824107, 130824, '付营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824108, 130824, '大屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824109, 130824, '火斗山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824110, 130824, '两间房镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824111, 130824, '小营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824200, 130824, '平坊满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824201, 130824, '安纯沟门满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824206, 130824, '西沟满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824207, 130824, '邓厂满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824208, 130824, '五道营子满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824209, 130824, '马营子满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130824210, 130824, '付家店满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825001, 130825, '安州街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825100, 130825, '苔山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825101, 130825, '韩麻营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825102, 130825, '中关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825103, 130825, '七家镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825104, 130825, '汤头沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825105, 130825, '张三营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825106, 130825, '唐三营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825107, 130825, '蓝旗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825108, 130825, '步古沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825109, 130825, '郭家屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825110, 130825, '茅荆坝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825200, 130825, '荒地乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825201, 130825, '章吉营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825203, 130825, '尹家营满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825204, 130825, '庙子沟蒙古族满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825205, 130825, '偏坡营满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825206, 130825, '山湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825207, 130825, '八达营蒙古族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825208, 130825, '太平庄满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825209, 130825, '旧屯满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825210, 130825, '西阿超满族蒙古族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825212, 130825, '碱房乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825213, 130825, '韩家店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130825214, 130825, '湾沟门乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826001, 130826, '新丰路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826100, 130826, '大阁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826101, 130826, '大滩镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826102, 130826, '鱼儿山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826103, 130826, '土城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826104, 130826, '黄旗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826105, 130826, '凤山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826106, 130826, '波罗诺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826107, 130826, '黑山咀镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826108, 130826, '天桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826109, 130826, '胡麻营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826110, 130826, '将军营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826200, 130826, '万胜永乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826201, 130826, '四岔口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826202, 130826, '苏家店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826203, 130826, '外沟门乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826204, 130826, '草原乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826205, 130826, '窟窿山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826206, 130826, '小坝子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826207, 130826, '五道营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826209, 130826, '选将营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826210, 130826, '西官营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826211, 130826, '王营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826212, 130826, '北头营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826214, 130826, '石人沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826215, 130826, '汤河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130826216, 130826, '杨木栅子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827100, 130827, '宽城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827101, 130827, '龙须门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827102, 130827, '峪耳崖镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827103, 130827, '板城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827104, 130827, '汤道河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827105, 130827, '桲罗台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827106, 130827, '碾子峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827107, 130827, '亮甲台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827108, 130827, '化皮溜子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827109, 130827, '松岭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827201, 130827, '塌山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827203, 130827, '孟子岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827204, 130827, '独石沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827207, 130827, '铧尖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827208, 130827, '东黄花川乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827210, 130827, '苇子沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827211, 130827, '大字沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130827212, 130827, '大石柱子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828100, 130828, '围场镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828101, 130828, '四合永镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828102, 130828, '克勒沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828103, 130828, '棋盘山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828104, 130828, '半截塔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828105, 130828, '朝阳地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828106, 130828, '朝阳湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828107, 130828, '腰站镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828108, 130828, '龙头山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828109, 130828, '新拨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828110, 130828, '御道口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828111, 130828, '城子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828200, 130828, '道坝子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828203, 130828, '黄土坎乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828204, 130828, '四道沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828205, 130828, '兰旗卡伦乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828206, 130828, '银窝沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828207, 130828, '新地乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828208, 130828, '广发永乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828209, 130828, '育太和乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828210, 130828, '郭家湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828211, 130828, '杨家湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828212, 130828, '大唤起乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828213, 130828, '哈里哈乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828215, 130828, '张家湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828216, 130828, '宝元栈乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828217, 130828, '山湾子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828218, 130828, '三义永乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828219, 130828, '姜家店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828220, 130828, '下伙房乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828221, 130828, '燕格柏乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828222, 130828, '牌楼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828224, 130828, '老窝铺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828226, 130828, '石桌子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828227, 130828, '大头山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828228, 130828, '南山嘴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828229, 130828, '西龙头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828450, 130828, '塞罕坝机械林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130828500, 130828, '国营御道口牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130871104, 130871, '冯营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130871106, 130871, '上板城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881100, 130881, '平泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881101, 130881, '黄土梁子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881102, 130881, '榆树林子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881103, 130881, '杨树岭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881104, 130881, '七沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881105, 130881, '小寺沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881106, 130881, '党坝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881107, 130881, '卧龙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881108, 130881, '南五十家子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881109, 130881, '北五十家子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881110, 130881, '桲椤树镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881111, 130881, '柳溪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881112, 130881, '平北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881113, 130881, '青河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881114, 130881, '台头山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881200, 130881, '王土房乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881203, 130881, '七家岱满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881206, 130881, '茅兰沟满族蒙古族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130881210, 130881, '道虎沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130902001, 130902, '建设北街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130902002, 130902, '车站街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130902003, 130902, '南大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130902004, 130902, '东环街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130902005, 130902, '道东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130902200, 130902, '小赵庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903001, 130903, '水月寺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903002, 130903, '南环中路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903003, 130903, '南湖街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903004, 130903, '市场街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903005, 130903, '西环中街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903006, 130903, '公园街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903100, 130903, '小王庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130903101, 130903, '南陈屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921100, 130921, '旧州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921101, 130921, '兴济镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921102, 130921, '杜生镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921103, 130921, '崔尔庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921104, 130921, '李天木镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921105, 130921, '纸房头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921106, 130921, '姚官屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921200, 130921, '薛官屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921201, 130921, '捷地回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921202, 130921, '张官屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921204, 130921, '风化店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921206, 130921, '杜林回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921207, 130921, '汪家铺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921208, 130921, '刘家庙乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921209, 130921, '仵龙堂乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921210, 130921, '大官厅乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921211, 130921, '高川乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921212, 130921, '黄递铺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130921213, 130921, '大褚村回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922100, 130922, '清州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922101, 130922, '金牛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922102, 130922, '新兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922103, 130922, '流河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922104, 130922, '木门店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922105, 130922, '马厂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922106, 130922, '盘古镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922107, 130922, '曹寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922200, 130922, '上伍乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922203, 130922, '陈嘴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130922400, 130922, '青县农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923100, 130923, '东光镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923101, 130923, '连镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923102, 130923, '找王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923103, 130923, '秦村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923104, 130923, '灯明寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923105, 130923, '南霞口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923106, 130923, '大单镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923107, 130923, '龙王李镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130923201, 130923, '于桥乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924100, 130924, '苏基镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924101, 130924, '辛集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924102, 130924, '高湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924103, 130924, '赵毛陶镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924201, 130924, '香坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924202, 130924, '小山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924203, 130924, '张会亭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924400, 130924, '海兴县农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924401, 130924, '青先农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130924402, 130924, '青锋农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925100, 130925, '盐山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925101, 130925, '望树镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925102, 130925, '庆云镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925103, 130925, '韩集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925104, 130925, '千童镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925105, 130925, '圣佛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925106, 130925, '边务镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925107, 130925, '小庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925108, 130925, '杨集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925201, 130925, '小营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925203, 130925, '孟店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130925204, 130925, '常庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926100, 130926, '肃宁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926101, 130926, '梁家村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926102, 130926, '窝北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926103, 130926, '尚村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926104, 130926, '万里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926105, 130926, '师素镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926106, 130926, '河北留善寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926107, 130926, '付家佐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130926205, 130926, '邵庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927100, 130927, '南皮镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927101, 130927, '冯家口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927102, 130927, '寨子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927103, 130927, '鲍官屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927104, 130927, '王寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927105, 130927, '乌马营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927106, 130927, '潞灌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927200, 130927, '大浪淀乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130927201, 130927, '刘八里乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928100, 130928, '桑园镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928101, 130928, '铁城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928102, 130928, '于集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928103, 130928, '梁集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928104, 130928, '安陵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928200, 130928, '曹家洼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928201, 130928, '东宋门乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928202, 130928, '杨家寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928203, 130928, '沟店铺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928204, 130928, '何庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130928400, 130928, '吴桥经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929100, 130929, '乐寿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929101, 130929, '淮镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929102, 130929, '郭庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929103, 130929, '河城街镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929104, 130929, '韩村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929105, 130929, '陌南镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929106, 130929, '陈庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929107, 130929, '段村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929108, 130929, '高官镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929109, 130929, '十五级镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929206, 130929, '商林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929209, 130929, '张村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929210, 130929, '临河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929211, 130929, '小平王乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929213, 130929, '垒头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929214, 130929, '南河头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929215, 130929, '西城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929216, 130929, '本斋回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929400, 130929, '梅庄洼农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130929401, 130929, '献县经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130930100, 130930, '孟村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130930101, 130930, '新县镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130930102, 130930, '辛店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130930103, 130930, '高寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130930200, 130930, '宋庄子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130930201, 130930, '牛进庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130971400, 130971, '开发区乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130972400, 130972, '高新乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130973206, 130973, '新村回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130973400, 130973, '南大港管理区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130973401, 130973, '国营中捷农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130973402, 130973, '港城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130973403, 130973, '临港化工园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981001, 130981, '解放街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981002, 130981, '河东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981003, 130981, '鼓楼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981100, 130981, '泊镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981101, 130981, '交河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981102, 130981, '齐桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981103, 130981, '寺门村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981104, 130981, '郝村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981105, 130981, '富镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981106, 130981, '文庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981107, 130981, '洼里王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981108, 130981, '四营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981201, 130981, '王武庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981202, 130981, '营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981204, 130981, '西辛店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130981400, 130981, '河北泊头经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982001, 130982, '新华路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982002, 130982, '西环路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982003, 130982, '永丰路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982004, 130982, '中华路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982005, 130982, '渤海路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982006, 130982, '油建路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982007, 130982, '会战道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982100, 130982, '出岸镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982101, 130982, '石门桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982102, 130982, '吕公堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982103, 130982, '长丰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982106, 130982, '梁召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982107, 130982, '辛中驿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982108, 130982, '麻家坞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982109, 130982, '北辛庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982110, 130982, '议论堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982204, 130982, '青塔乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982207, 130982, '北汉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982208, 130982, '于村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982400, 130982, '华北石油管理局', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130982500, 130982, '河北任丘经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983001, 130983, '骅东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983002, 130983, '骅中街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983003, 130983, '骅西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983100, 130983, '黄骅镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983101, 130983, '南排河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983102, 130983, '吕桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983103, 130983, '旧城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983104, 130983, '齐家务镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983105, 130983, '滕庄子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983106, 130983, '常郭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983107, 130983, '羊二庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983204, 130983, '官庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130983207, 130983, '羊三木回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984001, 130984, '瀛州路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984002, 130984, '城垣西路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984101, 130984, '米各庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984102, 130984, '景和镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984103, 130984, '卧佛堂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984104, 130984, '束城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984105, 130984, '留古寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984106, 130984, '沙河桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984107, 130984, '诗经村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984108, 130984, '尊祖庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984109, 130984, '兴村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984110, 130984, '行别营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984111, 130984, '故仙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984201, 130984, '黎民居乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984203, 130984, '沙洼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984204, 130984, '西九吉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984205, 130984, '北石槽乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984209, 130984, '时村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984212, 130984, '龙华店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984213, 130984, '果子洼回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (130984403, 130984, '河北河间经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002001, 131002, '银河南路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002002, 131002, '光明西道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002003, 131002, '永华道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002100, 131002, '落垡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002101, 131002, '码头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002102, 131002, '葛渔城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002103, 131002, '东沽港镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002104, 131002, '调河头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002105, 131002, '北史家务镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002106, 131002, '杨税务镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002201, 131002, '仇庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002400, 131002, '廊坊龙河高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002401, 131002, '河北廊坊高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002402, 131002, '河北廊坊龙港经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131002403, 131002, '河北安次经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003001, 131003, '银河北路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003002, 131003, '爱民东道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003003, 131003, '解放道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003004, 131003, '新开路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003005, 131003, '新源道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003100, 131003, '南尖塔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003101, 131003, '万庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003102, 131003, '九州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003103, 131003, '北旺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131003500, 131003, '新世纪步行街服务中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022100, 131022, '固安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022101, 131022, '宫村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022102, 131022, '柳泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022103, 131022, '牛驼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022104, 131022, '马庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022200, 131022, '东湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022201, 131022, '彭村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022202, 131022, '渠沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022203, 131022, '礼让店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131022400, 131022, '固安温泉休闲商务产业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023001, 131023, '城区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023100, 131023, '永清镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023101, 131023, '韩村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023102, 131023, '后奕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023103, 131023, '别古庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023104, 131023, '里澜城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023200, 131023, '管家务回族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023201, 131023, '曹家务乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023202, 131023, '龙虎庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023203, 131023, '刘街乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023204, 131023, '三圣口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023400, 131023, '河北永清经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131023401, 131023, '北京亦庄永清高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024100, 131024, '淑阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024101, 131024, '蒋辛屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024102, 131024, '渠口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024103, 131024, '安头屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024104, 131024, '安平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024105, 131024, '刘宋镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024106, 131024, '五百户镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024107, 131024, '钱旺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024108, 131024, '钳屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024500, 131024, '河北香河经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131024501, 131024, '香河新兴产业示范区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025100, 131025, '平舒镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025101, 131025, '旺村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025102, 131025, '大尚屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025103, 131025, '南赵扶镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025104, 131025, '留各庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025105, 131025, '权村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025106, 131025, '里坦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025107, 131025, '广安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025108, 131025, '北魏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025109, 131025, '臧屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131025400, 131025, '河北大城经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026100, 131026, '文安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026101, 131026, '新镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026102, 131026, '苏桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026103, 131026, '大柳河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026104, 131026, '左各庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026105, 131026, '滩里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026106, 131026, '史各庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026107, 131026, '赵各庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026108, 131026, '兴隆宫镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026109, 131026, '大留镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026110, 131026, '孙氏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026111, 131026, '德归镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131026200, 131026, '大围河回族满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028001, 131028, '北辰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028100, 131028, '大厂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028101, 131028, '夏垫镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028102, 131028, '祁各庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028103, 131028, '邵府镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028104, 131028, '陈府镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131028400, 131028, '河北大厂高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131071450, 131071, '耀华道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131071451, 131071, '云鹏道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081001, 131081, '裕华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081100, 131081, '霸州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081101, 131081, '南孟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081102, 131081, '信安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081103, 131081, '堂二里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081104, 131081, '煎茶铺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081105, 131081, '胜芳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081106, 131081, '杨芬港镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081107, 131081, '康仙庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081108, 131081, '王庄子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081200, 131081, '岔河集乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081202, 131081, '东杨庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131081204, 131081, '东段乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082001, 131082, '鼎盛东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082002, 131082, '泃阳西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082003, 131082, '行宫东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082004, 131082, '迎宾北路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082005, 131082, '燕顺路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082006, 131082, '康城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082100, 131082, '泃阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082101, 131082, '李旗庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082102, 131082, '杨庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082103, 131082, '皇庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082104, 131082, '新集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082105, 131082, '段甲岭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082106, 131082, '黄土庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082107, 131082, '高楼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082108, 131082, '齐心庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082109, 131082, '燕郊镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082450, 131082, '燕郊高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131082451, 131082, '河北三河国家农业科技园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102001, 131102, '河西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102002, 131102, '河东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102003, 131102, '路北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102004, 131102, '中华大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102100, 131102, '郑家河沿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102101, 131102, '赵家圈镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102102, 131102, '邓庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131102200, 131102, '何家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103100, 131103, '冀州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103102, 131103, '官道李镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103103, 131103, '南午村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103104, 131103, '周村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103105, 131103, '码头李镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103106, 131103, '西王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103200, 131103, '门家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103201, 131103, '徐家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103202, 131103, '北漳淮乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103203, 131103, '小寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131103400, 131103, '社区建设办公室', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121100, 131121, '枣强镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121101, 131121, '恩察镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121102, 131121, '大营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121103, 131121, '嘉会镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121104, 131121, '马屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121105, 131121, '肖张镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121106, 131121, '张秀屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121107, 131121, '新屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121108, 131121, '唐林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121202, 131121, '王均乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131121204, 131121, '王常乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122100, 131122, '武邑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122101, 131122, '清凉店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122102, 131122, '审坡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122103, 131122, '赵桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122104, 131122, '韩庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122105, 131122, '肖桥头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122106, 131122, '龙店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122201, 131122, '圈头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131122203, 131122, '大紫塔乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131123100, 131123, '武强镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131123101, 131123, '街关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131123102, 131123, '周窝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131123103, 131123, '东孙庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131123104, 131123, '豆村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131123201, 131123, '北代乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124100, 131124, '饶阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124101, 131124, '大尹村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124102, 131124, '五公镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124103, 131124, '大官亭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124104, 131124, '王同岳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124105, 131124, '东里满镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131124106, 131124, '留楚镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125100, 131125, '安平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125101, 131125, '马店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125102, 131125, '南王庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125103, 131125, '大子文镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125104, 131125, '东黄城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125200, 131125, '大何庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125201, 131125, '程油子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125202, 131125, '西两洼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125400, 131125, '高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131125401, 131125, '社区建设办公室', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126100, 131126, '郑口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126101, 131126, '夏庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126102, 131126, '青罕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126103, 131126, '故城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126104, 131126, '武官寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126105, 131126, '饶阳店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126106, 131126, '军屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126107, 131126, '建国镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126108, 131126, '西半屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126109, 131126, '房庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126110, 131126, '三朗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126200, 131126, '辛庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131126201, 131126, '里老乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127100, 131127, '景州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127101, 131127, '龙华镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127102, 131127, '广川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127103, 131127, '王瞳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127104, 131127, '洚河流镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127105, 131127, '安陵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127106, 131127, '杜桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127107, 131127, '王谦寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127108, 131127, '北留智镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127109, 131127, '留智庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127110, 131127, '梁集镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127200, 131127, '刘集乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127201, 131127, '连镇乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127203, 131127, '温城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127204, 131127, '后留名府乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131127205, 131127, '青兰乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128100, 131128, '阜城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128101, 131128, '古城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128102, 131128, '码头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128103, 131128, '霞口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128104, 131128, '崔家庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128105, 131128, '漫河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128201, 131128, '建桥乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128202, 131128, '蒋坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128203, 131128, '大白乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131128204, 131128, '王集乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131171201, 131171, '大麻森乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131171400, 131171, '高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131171401, 131171, '新型功能材料产业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131171402, 131171, '苏正办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131172101, 131172, '魏家屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131172203, 131172, '彭杜村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131172401, 131172, '滨湖新区教育园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182100, 131182, '唐奉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182101, 131182, '深州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182102, 131182, '辰时镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182103, 131182, '榆科镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182104, 131182, '魏家桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182105, 131182, '大堤镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182106, 131182, '前磨头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182107, 131182, '王家井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182108, 131182, '护驾迟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182109, 131182, '大屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182110, 131182, '高古庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182111, 131182, '北溪村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182112, 131182, '大冯营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182200, 131182, '兵曹乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182201, 131182, '穆村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182202, 131182, '东安庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182206, 131182, '乔屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182400, 131182, '深州监狱', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182401, 131182, '城市新区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (131182403, 131182, '经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105001, 140105, '坞城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105002, 140105, '营盘街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105003, 140105, '北营街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105004, 140105, '平阳路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105005, 140105, '黄陵街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105006, 140105, '小店街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105007, 140105, '龙城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105100, 140105, '北格镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105200, 140105, '西温庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140105201, 140105, '刘家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106001, 140106, '柳巷街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106002, 140106, '文庙街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106003, 140106, '庙前街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106004, 140106, '迎泽街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106005, 140106, '桥东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106006, 140106, '老军营街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140106100, 140106, '郝庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107001, 140107, '巨轮街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107002, 140107, '三桥街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107003, 140107, '鼓楼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107004, 140107, '杏花岭街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107005, 140107, '坝陵桥街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107006, 140107, '大东关街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107007, 140107, '职工新街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107008, 140107, '敦化坊街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107009, 140107, '涧河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107010, 140107, '杨家峪街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107011, 140107, '享堂街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140107100, 140107, '中涧河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108001, 140108, '尖草坪街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108002, 140108, '光社街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108003, 140108, '上兰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108004, 140108, '南寨街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108005, 140108, '迎新街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108006, 140108, '古城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108007, 140108, '汇丰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108008, 140108, '柴村街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108009, 140108, '新城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108100, 140108, '向阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108101, 140108, '阳曲镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108201, 140108, '柏板乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108202, 140108, '西墕乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140108400, 140108, '太原中北高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109001, 140109, '千峰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109002, 140109, '下元街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109003, 140109, '和平街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109004, 140109, '兴华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109005, 140109, '万柏林街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109006, 140109, '杜儿坪街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109007, 140109, '白家庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109008, 140109, '南寒街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109009, 140109, '东社街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109011, 140109, '小井峪街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109012, 140109, '西铭街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109013, 140109, '长风西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109014, 140109, '神堂沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140109015, 140109, '王化街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140110001, 140110, '义井街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140110002, 140110, '罗城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140110003, 140110, '晋源街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140110100, 140110, '金胜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140110101, 140110, '晋祠镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140110102, 140110, '姚村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121100, 140121, '清源镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121101, 140121, '徐沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121102, 140121, '东于镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121103, 140121, '孟封镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121200, 140121, '马峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121201, 140121, '柳杜乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121202, 140121, '西谷乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121203, 140121, '王答乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140121204, 140121, '集义乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122100, 140122, '黄寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122101, 140122, '大盂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122102, 140122, '东黄水镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122103, 140122, '泥屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122200, 140122, '高村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122201, 140122, '侯村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122202, 140122, '凌井店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122203, 140122, '西凌井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122205, 140122, '杨兴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140122400, 140122, '中心镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123100, 140123, '娄烦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123101, 140123, '静游镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123102, 140123, '杜交曲镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123201, 140123, '马家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123202, 140123, '盖家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123203, 140123, '米峪镇乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140123204, 140123, '天池店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140171401, 140171, '唐槐园区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140171402, 140171, '学府园区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140171403, 140171, '阳曲产业园区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140171404, 140171, '潇河园区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140171405, 140171, '科创城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181001, 140181, '东曲街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181002, 140181, '西曲街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181003, 140181, '桃园街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181004, 140181, '屯兰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181100, 140181, '河口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181101, 140181, '镇城底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181102, 140181, '马兰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181201, 140181, '嘉乐泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181202, 140181, '梭峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181203, 140181, '岔口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181204, 140181, '常安乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181205, 140181, '原相乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140181206, 140181, '邢家社乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212100, 140212, '新荣镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212101, 140212, '古店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212102, 140212, '花园屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212200, 140212, '破鲁堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212202, 140212, '郭家窑乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212206, 140212, '西村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140212209, 140212, '堡子湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213050, 140213, '永泰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213051, 140213, '古城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213052, 140213, '新旺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213053, 140213, '迎宾街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213054, 140213, '振华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213055, 140213, '清远街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213056, 140213, '武定街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213057, 140213, '御河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213058, 140213, '开源街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213059, 140213, '大庆路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213060, 140213, '马军营街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213061, 140213, '卧虎湾街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213062, 140213, '新华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213063, 140213, '鹿苑街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213064, 140213, '白登山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213065, 140213, '文瀛湖街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213066, 140213, '水泊寺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140213067, 140213, '小南头街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214001, 140214, '新胜街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214002, 140214, '新平旺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214016, 140214, '新泉路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214017, 140214, '民胜街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214018, 140214, '口泉街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214023, 140214, '平泉路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214025, 140214, '和顺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214026, 140214, '和瑞街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214027, 140214, '平盛路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214028, 140214, '清泉街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214029, 140214, '西花园街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214030, 140214, '老平旺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214031, 140214, '新文街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214032, 140214, '和旺街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214033, 140214, '玉龙街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214034, 140214, '云武街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214035, 140214, '云燕街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214036, 140214, '玉泉街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214037, 140214, '平德街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214038, 140214, '平喜街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214039, 140214, '平源街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214101, 140214, '高山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214102, 140214, '云冈镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214200, 140214, '口泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214206, 140214, '西韩岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214207, 140214, '平旺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140214210, 140214, '鸦儿崖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215100, 140215, '西坪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215101, 140215, '倍加造镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215102, 140215, '周士庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215201, 140215, '吉家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215202, 140215, '峰峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215204, 140215, '杜庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215205, 140215, '党留庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215209, 140215, '聚乐乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140215211, 140215, '许堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221100, 140221, '龙泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221101, 140221, '罗文皂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221102, 140221, '大白登镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221103, 140221, '王官屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221104, 140221, '古城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221105, 140221, '东小村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221106, 140221, '友宰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221201, 140221, '长城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221204, 140221, '狮子屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221209, 140221, '下深井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140221212, 140221, '鳌石乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222100, 140222, '玉泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222101, 140222, '谷前堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222102, 140222, '米薪关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222103, 140222, '逯家湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222104, 140222, '新平堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222200, 140222, '卅里铺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222204, 140222, '贾家屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222206, 140222, '赵家沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222208, 140222, '南高崖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222209, 140222, '张西河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140222210, 140222, '马家皂乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223100, 140223, '壶泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223101, 140223, '南村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223102, 140223, '加斗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223103, 140223, '作疃镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223104, 140223, '梁庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223200, 140223, '一斗泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223202, 140223, '蕉山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140223206, 140223, '宜兴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224100, 140224, '武灵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224101, 140224, '东河南镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224102, 140224, '上寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224200, 140224, '落水河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224205, 140224, '赵北乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224206, 140224, '石家田乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224207, 140224, '柳科乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224208, 140224, '白崖台乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224210, 140224, '红石塄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224212, 140224, '下关乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140224213, 140224, '独峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225100, 140225, '永安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225101, 140225, '西坊城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225102, 140225, '蔡村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225103, 140225, '沙圪坨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225104, 140225, '王庄堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225106, 140225, '青磁窑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225201, 140225, '东坊城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225203, 140225, '裴村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225204, 140225, '驼峰乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225205, 140225, '西留村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225206, 140225, '下韩村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225208, 140225, '南榆林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225210, 140225, '吴城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225213, 140225, '大仁庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225215, 140225, '千佛岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140225218, 140225, '官儿乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226100, 140226, '云兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226101, 140226, '鹊儿山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226102, 140226, '店湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226200, 140226, '管家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226201, 140226, '张家场乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226205, 140226, '三屯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226206, 140226, '马道头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140226207, 140226, '小京庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140271400, 140271, '经济技术开发区乡级单位', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140302001, 140302, '上站街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140302002, 140302, '下站街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140302003, 140302, '北大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140302004, 140302, '南山路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140302005, 140302, '义井街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140302100, 140302, '义井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140303001, 140303, '平潭街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140303003, 140303, '蔡洼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140303004, 140303, '赛鱼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140303005, 140303, '沙坪街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140303006, 140303, '贵石沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140303007, 140303, '桥头街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311100, 140311, '荫营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311101, 140311, '河底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311103, 140311, '平坦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311200, 140311, '西南舁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311201, 140311, '杨家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311202, 140311, '李家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311203, 140311, '旧街乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140311400, 140311, '开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321100, 140321, '冠山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321101, 140321, '冶西镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321102, 140321, '锁簧镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321103, 140321, '张庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321104, 140321, '东回镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321105, 140321, '柏井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321106, 140321, '娘子关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321107, 140321, '巨城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321200, 140321, '石门口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140321201, 140321, '岔口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322100, 140322, '秀水镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322101, 140322, '孙家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322102, 140322, '路家村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322103, 140322, '南娄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322104, 140322, '牛村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322105, 140322, '苌池镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322106, 140322, '上社镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322107, 140322, '西烟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322200, 140322, '仙人乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322201, 140322, '北下庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322203, 140322, '梁家寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322204, 140322, '西潘乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140322205, 140322, '东梁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403001, 140403, '东街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403002, 140403, '西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403003, 140403, '英雄南路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403004, 140403, '英雄中路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403005, 140403, '紫金街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403006, 140403, '太行东街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403007, 140403, '太行西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403008, 140403, '延安南路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403009, 140403, '常青街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403010, 140403, '五马街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403013, 140403, '堠北庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403014, 140403, '老顶山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403015, 140403, '大辛庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403103, 140403, '马厂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403104, 140403, '黄碾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403105, 140403, '西白兔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403400, 140403, '长治市漳泽工业转型试验区管理委员会社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403401, 140403, '长治市老顶山旅游开发管理中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140403403, 140403, '长治经济技术开发区潞州区部分', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404001, 140404, '韩店街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404101, 140404, '苏店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404102, 140404, '荫城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404103, 140404, '西火镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404104, 140404, '八义镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404106, 140404, '郝家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404107, 140404, '南宋镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404201, 140404, '西池乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404202, 140404, '北呈乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404203, 140404, '东和乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404400, 140404, '振兴乡村生态文化旅游区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404401, 140404, '上党经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140404406, 140404, '长治市经济技术开发区上党区部分', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405001, 140405, '麟绛街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405101, 140405, '上村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405102, 140405, '渔泽镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405103, 140405, '余吾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405104, 140405, '吾元镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405105, 140405, '张店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405106, 140405, '丰宜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405200, 140405, '李高乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405201, 140405, '路村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405202, 140405, '河神庙乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405400, 140405, '西流寨开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405401, 140405, '康庄工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405402, 140405, '上莲开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140405403, 140405, '屯留经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406001, 140406, '潞华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406002, 140406, '成家川街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406003, 140406, '翟店街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406100, 140406, '店上镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406101, 140406, '微子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406102, 140406, '辛安泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406104, 140406, '史回镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406201, 140406, '黄牛蹄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140406400, 140406, '潞城经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423100, 140423, '古韩镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423101, 140423, '王桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423102, 140423, '侯堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423103, 140423, '夏店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423104, 140423, '虒亭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423105, 140423, '西营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423106, 140423, '王村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423107, 140423, '下良镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423108, 140423, '善福镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140423402, 140423, '襄垣经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425100, 140425, '青羊镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425101, 140425, '龙溪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425102, 140425, '石城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425103, 140425, '苗庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425104, 140425, '玉峡关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425200, 140425, '西沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425201, 140425, '东寺头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425202, 140425, '虹梯关乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425203, 140425, '阳高乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425204, 140425, '北耽车乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425206, 140425, '北社乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140425400, 140425, '平顺经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426101, 140426, '东阳关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426102, 140426, '上遥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426103, 140426, '西井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426104, 140426, '黄崖洞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426105, 140426, '黎侯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426106, 140426, '洪井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426107, 140426, '西仵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426108, 140426, '程家山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140426400, 140426, '黎城县经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427100, 140427, '龙泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427101, 140427, '百尺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427102, 140427, '店上镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427103, 140427, '晋庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427104, 140427, '树掌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427105, 140427, '大峡谷镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427106, 140427, '集店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427201, 140427, '黄山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427202, 140427, '东井岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427203, 140427, '石坡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140427401, 140427, '壶关县经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428100, 140428, '丹朱镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428101, 140428, '鲍店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428102, 140428, '石哲镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428103, 140428, '大堡头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428104, 140428, '慈林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428105, 140428, '色头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428106, 140428, '南漳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428107, 140428, '宋村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428108, 140428, '南陈镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428201, 140428, '碾张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428202, 140428, '常张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140428400, 140428, '长子经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429100, 140429, '丰州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429101, 140429, '洪水镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429102, 140429, '蟠龙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429103, 140429, '监漳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429104, 140429, '故城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429105, 140429, '韩北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429202, 140429, '大有乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429203, 140429, '贾豁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429205, 140429, '上司乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429206, 140429, '石北乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429207, 140429, '涌泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429208, 140429, '分水岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429400, 140429, '武乡经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140429401, 140429, '武乡县现代农业产业示范区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430100, 140430, '定昌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430101, 140430, '郭村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430102, 140430, '故县镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430103, 140430, '新店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430104, 140430, '漳源镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430105, 140430, '册村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430106, 140430, '沁州黄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430107, 140430, '南里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430108, 140430, '松村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430203, 140430, '牛寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430206, 140430, '杨安乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140430400, 140430, '沁县现代农业产业示范区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431100, 140431, '沁河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431101, 140431, '郭道镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431102, 140431, '灵空山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431103, 140431, '王和镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431105, 140431, '王陶镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431107, 140431, '景凤镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431200, 140431, '中峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431201, 140431, '法中乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431202, 140431, '交口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431203, 140431, '聪子峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431204, 140431, '韩洪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431207, 140431, '赤石桥乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140431400, 140431, '沁源经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140471400, 140471, '长治高新技术开发区城北街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502001, 140502, '东街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502002, 140502, '西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502003, 140502, '南街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502004, 140502, '北街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502006, 140502, '钟家庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502007, 140502, '西上庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502009, 140502, '开发区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140502100, 140502, '北石店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521100, 140521, '龙港镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521101, 140521, '中村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521102, 140521, '郑庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521103, 140521, '端氏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521104, 140521, '嘉峰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521105, 140521, '郑村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521106, 140521, '柿庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521201, 140521, '土沃乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521202, 140521, '张村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521204, 140521, '胡底乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521205, 140521, '固县乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140521206, 140521, '十里乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522100, 140522, '凤城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522101, 140522, '北留镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522102, 140522, '润城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522103, 140522, '町店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522104, 140522, '芹池镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522105, 140522, '次营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522106, 140522, '横河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522107, 140522, '河北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522108, 140522, '蟒河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522109, 140522, '东冶镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522110, 140522, '演礼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522111, 140522, '白桑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522201, 140522, '寺头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522202, 140522, '西河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140522205, 140522, '董封乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524100, 140524, '崇文镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524101, 140524, '礼义镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524102, 140524, '附城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524103, 140524, '西河底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524104, 140524, '平城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524105, 140524, '杨村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524106, 140524, '潞城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524204, 140524, '夺火乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524206, 140524, '马圪当乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524207, 140524, '古郊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140524209, 140524, '六泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525100, 140525, '南村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525101, 140525, '下村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525102, 140525, '大东沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525103, 140525, '周村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525104, 140525, '犁川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525105, 140525, '晋庙铺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525106, 140525, '金村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525107, 140525, '高都镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525108, 140525, '巴公镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525109, 140525, '大阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525110, 140525, '山河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525111, 140525, '大箕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525112, 140525, '柳树口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525113, 140525, '北义城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525114, 140525, '川底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140525115, 140525, '南岭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581001, 140581, '北城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581002, 140581, '东城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581003, 140581, '南城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581101, 140581, '米山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581102, 140581, '三甲镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581103, 140581, '神农镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581104, 140581, '陈区镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581105, 140581, '北诗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581106, 140581, '河西镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581107, 140581, '马村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581108, 140581, '野川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581109, 140581, '寺庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581201, 140581, '建宁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581202, 140581, '石末乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140581203, 140581, '原村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602001, 140602, '北城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602002, 140602, '南城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602003, 140602, '神头街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602004, 140602, '北旺庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602100, 140602, '神头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602101, 140602, '利民镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602200, 140602, '下团堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602201, 140602, '小平易乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602202, 140602, '滋润乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602204, 140602, '南榆林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602205, 140602, '贾庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602206, 140602, '沙塄河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602207, 140602, '窑子头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140602208, 140602, '张蔡庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603100, 140603, '井坪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603101, 140603, '凤凰城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603200, 140603, '白堂乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603201, 140603, '陶村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603202, 140603, '下水头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603203, 140603, '双碾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603204, 140603, '阻虎乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603205, 140603, '高石庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603206, 140603, '西水界乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603207, 140603, '下面高乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603209, 140603, '向阳堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140603210, 140603, '榆岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621100, 140621, '玉井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621101, 140621, '北周庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621102, 140621, '古城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621103, 140621, '岱岳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621104, 140621, '广武镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621200, 140621, '吴马营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621201, 140621, '马营乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621202, 140621, '下喇叭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621203, 140621, '合盛堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621205, 140621, '安荣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621206, 140621, '薛圐圙乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140621209, 140621, '马营庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622100, 140622, '金城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622101, 140622, '南河种镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622102, 140622, '下社镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622200, 140622, '镇子梁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622201, 140622, '义井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622202, 140622, '臧寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622203, 140622, '大黄巍乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622204, 140622, '杏寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622205, 140622, '下马峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622206, 140622, '南泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622207, 140622, '大临河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140622208, 140622, '白马石乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623100, 140623, '新城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623101, 140623, '右卫镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623102, 140623, '威远镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623103, 140623, '元堡子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623200, 140623, '牛心堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623202, 140623, '高家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623204, 140623, '杨千河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140623205, 140623, '李达窑乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140671400, 140671, '山西朔州经济开发区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681001, 140681, '云东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681002, 140681, '云中街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681003, 140681, '云西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681101, 140681, '吴家窑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681102, 140681, '金沙滩镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681103, 140681, '毛家皂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681200, 140681, '何家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681201, 140681, '新家园乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681202, 140681, '亲和乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681203, 140681, '海北头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681205, 140681, '河头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681500, 140681, '金沙滩农牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140681501, 140681, '金沙滩林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702001, 140702, '北关街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702002, 140702, '锦纶街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702003, 140702, '新华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702004, 140702, '西南街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702005, 140702, '路西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702006, 140702, '经纬街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702007, 140702, '安宁街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702008, 140702, '新建街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702009, 140702, '晋华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702100, 140702, '乌金山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702101, 140702, '东阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702103, 140702, '长凝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702104, 140702, '北田镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702105, 140702, '修文镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702200, 140702, '郭家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702201, 140702, '张庆乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702202, 140702, '庄子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702203, 140702, '东赵乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702401, 140702, '山西转型综合改革示范区晋中开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140702402, 140702, '榆次区使赵乡社会事务管理中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703101, 140703, '胡村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703102, 140703, '范村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703103, 140703, '水秀镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703200, 140703, '侯城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703201, 140703, '北汪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703203, 140703, '阳邑乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703204, 140703, '小白乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703205, 140703, '任村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703401, 140703, '白塔区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703402, 140703, '北城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140703403, 140703, '南城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721100, 140721, '箕城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721101, 140721, '云簇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721102, 140721, '郝北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721103, 140721, '社城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721200, 140721, '河峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721201, 140721, '北寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721202, 140721, '西马乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140721400, 140721, '城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722100, 140722, '辽阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722101, 140722, '桐峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722102, 140722, '麻田镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722103, 140722, '芹泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722104, 140722, '拐儿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722200, 140722, '寒王乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722201, 140722, '石匣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722204, 140722, '羊角乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140722400, 140722, '城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723100, 140723, '义兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723101, 140723, '李阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723102, 140723, '松烟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723103, 140723, '青城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723104, 140723, '横岭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723200, 140723, '喂马乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723201, 140723, '平松乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723203, 140723, '马坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140723400, 140723, '城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724100, 140724, '乐平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724101, 140724, '皋落镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724102, 140724, '冶头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724103, 140724, '沾尚镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724104, 140724, '大寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724200, 140724, '李家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724201, 140724, '界都乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724202, 140724, '三都乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724203, 140724, '赵壁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724204, 140724, '孔氏乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140724400, 140724, '城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725100, 140725, '朝阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725101, 140725, '南燕竹镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725102, 140725, '宗艾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725103, 140725, '平头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725104, 140725, '松塔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725105, 140725, '西洛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725106, 140725, '尹灵芝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725200, 140725, '平舒乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725201, 140725, '解愁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725202, 140725, '温家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725203, 140725, '景尚乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140725205, 140725, '羊头崖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727100, 140727, '昭馀镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727101, 140727, '东观镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727102, 140727, '古县镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727103, 140727, '贾令镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727104, 140727, '城赵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727105, 140727, '来远镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727201, 140727, '峪口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727400, 140727, '祁县经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140727404, 140727, '城区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728001, 140728, '古城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728002, 140728, '城东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728003, 140728, '城西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728100, 140728, '古陶镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728101, 140728, '段村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728102, 140728, '东泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728103, 140728, '洪善镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728104, 140728, '宁固镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728200, 140728, '南政乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728201, 140728, '中都乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728202, 140728, '岳壁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728203, 140728, '卜宜乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728205, 140728, '朱坑乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728206, 140728, '襄垣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728207, 140728, '杜家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140728208, 140728, '香乐乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729100, 140729, '翠峰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729101, 140729, '静升镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729102, 140729, '两渡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729103, 140729, '夏门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729104, 140729, '南关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729105, 140729, '段纯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729202, 140729, '王禹乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729203, 140729, '坛镇乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729204, 140729, '梁家焉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729205, 140729, '交口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140729403, 140729, '灵石县城区社会事务服务中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781001, 140781, '北关街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781002, 140781, '西关街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781003, 140781, '东南街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781004, 140781, '西南街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781005, 140781, '北坛街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781100, 140781, '义安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781101, 140781, '张兰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781102, 140781, '连福镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781103, 140781, '洪山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781104, 140781, '龙凤镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781105, 140781, '绵山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781106, 140781, '义棠镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781200, 140781, '城关乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140781201, 140781, '宋古乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802001, 140802, '中城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802002, 140802, '东城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802003, 140802, '西城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802004, 140802, '南城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802005, 140802, '北城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802006, 140802, '安邑街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802007, 140802, '大渠街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802008, 140802, '姚孟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802100, 140802, '解州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802101, 140802, '龙居镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802102, 140802, '北相镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802103, 140802, '泓芝驿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802104, 140802, '三路里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802105, 140802, '陶村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802106, 140802, '东郭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802200, 140802, '席张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802201, 140802, '金井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802202, 140802, '王范乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802203, 140802, '冯村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802204, 140802, '上郭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802205, 140802, '上王乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140802404, 140802, '运城经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821100, 140821, '猗氏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821101, 140821, '嵋阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821102, 140821, '临晋镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821103, 140821, '七级镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821104, 140821, '东张镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821105, 140821, '孙吉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821106, 140821, '三管镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821107, 140821, '牛杜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821108, 140821, '耽子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821109, 140821, '角杯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821200, 140821, '楚侯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821201, 140821, '庙上乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821203, 140821, '北辛乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821204, 140821, '北景乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140821402, 140821, '临猗县城市社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822100, 140822, '解店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822101, 140822, '通化镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822102, 140822, '汉薛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822103, 140822, '荣河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822104, 140822, '裴庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822105, 140822, '高村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822200, 140822, '万泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822201, 140822, '里望乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822202, 140822, '西村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822203, 140822, '南张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822205, 140822, '皇甫乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822206, 140822, '贾村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822207, 140822, '王显乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140822208, 140822, '光华乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823100, 140823, '桐城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823101, 140823, '郭家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823102, 140823, '畖底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823103, 140823, '薛店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823104, 140823, '东镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823105, 140823, '礼元镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823106, 140823, '河底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823107, 140823, '阳隅镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823108, 140823, '侯村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823109, 140823, '裴社镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823204, 140823, '后宫乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823205, 140823, '石门乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140823400, 140823, '闻喜县社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824100, 140824, '稷峰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824101, 140824, '西社镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824102, 140824, '化峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824103, 140824, '翟店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824104, 140824, '清河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824200, 140824, '蔡村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824201, 140824, '太阳乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824400, 140824, '稷山县社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140824401, 140824, '稷山县经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825100, 140825, '龙兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825101, 140825, '三泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825102, 140825, '泽掌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825103, 140825, '北张镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825104, 140825, '古交镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825105, 140825, '万安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825106, 140825, '阳王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825107, 140825, '泉掌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825108, 140825, '横桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825400, 140825, '新绛县社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140825498, 140825, '新绛县经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826100, 140826, '古绛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826101, 140826, '横水镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826102, 140826, '陈村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826103, 140826, '卫庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826104, 140826, '磨里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826105, 140826, '南樊镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826106, 140826, '安峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826107, 140826, '大交镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826200, 140826, '郝庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826201, 140826, '冷口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826400, 140826, '绛县社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140826402, 140826, '山西绛县经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827100, 140827, '新城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827101, 140827, '历山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827102, 140827, '古城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827103, 140827, '王茅镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827104, 140827, '毛家湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827105, 140827, '英言镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827200, 140827, '蒲掌乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827202, 140827, '解峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827203, 140827, '华峰乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827204, 140827, '长直乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827205, 140827, '皋落乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140827400, 140827, '垣曲县城市社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828100, 140828, '瑶峰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828101, 140828, '庙前镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828102, 140828, '裴介镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828103, 140828, '水头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828104, 140828, '埝掌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828105, 140828, '泗交镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828106, 140828, '禹王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828200, 140828, '尉郭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828202, 140828, '胡张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828203, 140828, '南大里乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140828204, 140828, '祁家河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829100, 140829, '圣人涧镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829101, 140829, '常乐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829102, 140829, '张店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829103, 140829, '张村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829104, 140829, '曹川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829105, 140829, '三门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829106, 140829, '部官镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829107, 140829, '洪池镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829201, 140829, '杜马乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140829400, 140829, '平陆县社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830100, 140830, '古魏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830101, 140830, '风陵渡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830102, 140830, '陌南镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830103, 140830, '西陌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830104, 140830, '永乐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830105, 140830, '大王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830106, 140830, '阳城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830107, 140830, '南磑镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830200, 140830, '东垆乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830202, 140830, '学张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830401, 140830, '芮城县社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140830402, 140830, '山西风陵渡经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881001, 140881, '城西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881002, 140881, '城北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881003, 140881, '城东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881100, 140881, '虞乡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881101, 140881, '卿头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881102, 140881, '开张镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881103, 140881, '栲栳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881104, 140881, '蒲州镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881105, 140881, '韩阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881106, 140881, '张营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881400, 140881, '永济监狱', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881401, 140881, '山西省永济虞乡强制隔离戒毒所', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140881402, 140881, '山西省永济董村强制隔离戒毒所', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882001, 140882, '城区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882002, 140882, '清涧街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882003, 140882, '赵家庄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882004, 140882, '阳村街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882100, 140882, '樊村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882101, 140882, '僧楼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882102, 140882, '柴家镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882200, 140882, '小梁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882203, 140882, '下化乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140882450, 140882, '山西铝厂', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902001, 140902, '秀容街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902002, 140902, '长征街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902003, 140902, '新建路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902004, 140902, '云中路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902005, 140902, '九原街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902006, 140902, '旭来街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902007, 140902, '桥西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902101, 140902, '奇村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902102, 140902, '三交镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902103, 140902, '庄磨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902104, 140902, '豆罗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902105, 140902, '董村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902106, 140902, '西张镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902107, 140902, '忻口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902108, 140902, '合索镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902206, 140902, '兰村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902209, 140902, '东楼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140902210, 140902, '北义井乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921100, 140921, '晋昌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921101, 140921, '河边镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921102, 140921, '宏道镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921103, 140921, '季庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921104, 140921, '蒋村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921201, 140921, '南王乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921203, 140921, '神山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921205, 140921, '受禄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140921400, 140921, '定襄县居民办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922100, 140922, '台城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922102, 140922, '耿镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922103, 140922, '豆村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922104, 140922, '白家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922105, 140922, '东冶镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922107, 140922, '建安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922200, 140922, '沟南乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922201, 140922, '东雷乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922202, 140922, '高洪口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922203, 140922, '门限石乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922204, 140922, '陈家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922207, 140922, '蒋坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922209, 140922, '阳白乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140922210, 140922, '茹村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923100, 140923, '上馆镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923101, 140923, '阳明堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923102, 140923, '峨口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923103, 140923, '聂营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923104, 140923, '枣林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923106, 140923, '雁门关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923107, 140923, '峪口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923200, 140923, '新高乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923202, 140923, '上磨坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140923400, 140923, '代县居民事务中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924100, 140924, '繁城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924101, 140924, '砂河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924102, 140924, '大营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924103, 140924, '平型关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924200, 140924, '下茹越乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924202, 140924, '光裕堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924203, 140924, '集义庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924204, 140924, '东山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924205, 140924, '金山铺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924208, 140924, '神堂堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140924209, 140924, '岩头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925100, 140925, '凤凰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925101, 140925, '阳方口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925102, 140925, '东寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925103, 140925, '石家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925104, 140925, '宁化镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925200, 140925, '薛家洼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925201, 140925, '余庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925202, 140925, '涔山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925204, 140925, '西马坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925206, 140925, '迭台寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925208, 140925, '怀道乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925209, 140925, '东马坊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925400, 140925, '阳方口煤矿', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140925401, 140925, '宁武县居民办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926100, 140926, '鹅城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926101, 140926, '杜家村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926102, 140926, '康家会镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926103, 140926, '丰润镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926104, 140926, '双路镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926105, 140926, '王村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926204, 140926, '段家寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926205, 140926, '辛村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926207, 140926, '神峪沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926208, 140926, '娘子神乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926209, 140926, '娑婆乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926210, 140926, '赤泥窊乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140926400, 140926, '静乐县居民办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927100, 140927, '龙泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927101, 140927, '义井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927102, 140927, '八角镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927200, 140927, '东湖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927203, 140927, '贺职乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927204, 140927, '长畛乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927205, 140927, '烈堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927206, 140927, '大严备乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140927400, 140927, '神池县城镇街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928100, 140928, '砚城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928101, 140928, '小河头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928102, 140928, '三岔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928200, 140928, '前所乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928201, 140928, '李家坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928202, 140928, '孙家坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928204, 140928, '胡会乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928206, 140928, '韩家楼乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928207, 140928, '东秀庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928208, 140928, '杏岭子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140928400, 140928, '五寨县居民办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929100, 140929, '岚漪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929101, 140929, '三井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929102, 140929, '宋家沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929201, 140929, '高家会乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929202, 140929, '李家沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929203, 140929, '水峪贯乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929204, 140929, '西豹峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929205, 140929, '温泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929206, 140929, '阳坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929207, 140929, '大涧乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140929400, 140929, '岢岚县居民办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930100, 140930, '西口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930101, 140930, '楼子营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930102, 140930, '刘家塔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930103, 140930, '巡镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930104, 140930, '旧县镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930105, 140930, '沙泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930200, 140930, '鹿固乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930202, 140930, '单寨乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930203, 140930, '土沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930205, 140930, '沙坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140930206, 140930, '社梁乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931100, 140931, '东关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931101, 140931, '义门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931102, 140931, '桥头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931103, 140931, '杨家湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931104, 140931, '孙家沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931200, 140931, '腰庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931201, 140931, '韩家川乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931202, 140931, '林遮峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931203, 140931, '冯家川乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931204, 140931, '土崖塔乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931208, 140931, '南河沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140931400, 140931, '保德县居民事务中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932100, 140932, '新关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932102, 140932, '老营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932103, 140932, '万家寨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932104, 140932, '水泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932105, 140932, '老牛湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932106, 140932, '尚峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932200, 140932, '窑头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140932201, 140932, '楼沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140971100, 140971, '台怀镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140971101, 140971, '石咀镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140971200, 140971, '金岗库乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981001, 140981, '北城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981002, 140981, '南城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981004, 140981, '新原街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981005, 140981, '吉祥街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981101, 140981, '苏龙口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981102, 140981, '崞阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981103, 140981, '大牛店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981104, 140981, '闫庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981106, 140981, '轩岗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981107, 140981, '云水镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981108, 140981, '同川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981202, 140981, '子干乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981203, 140981, '中阳乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981204, 140981, '沿沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981205, 140981, '大林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981206, 140981, '西镇乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981208, 140981, '王家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981210, 140981, '段家堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981400, 140981, '山西鲁能晋北铝业工矿区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981401, 140981, '原平市石豹沟煤矿工矿区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981403, 140981, '原平农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (140981404, 140981, '原平经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002001, 141002, '解放路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002002, 141002, '鼓楼西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002003, 141002, '水塔街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002004, 141002, '南街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002005, 141002, '乡贤街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002006, 141002, '辛寺街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002007, 141002, '铁路东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002008, 141002, '车站街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002009, 141002, '汾河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002010, 141002, '滨河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002100, 141002, '屯里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002101, 141002, '乔李镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002102, 141002, '大阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002103, 141002, '县底镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002104, 141002, '刘村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002105, 141002, '金殿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002106, 141002, '吴村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002107, 141002, '土门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002108, 141002, '魏村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002109, 141002, '尧庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002200, 141002, '段店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002201, 141002, '贾得乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002203, 141002, '一平垣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002204, 141002, '枕头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141002401, 141002, '临汾经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021100, 141021, '乐昌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021101, 141021, '史村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021102, 141021, '曲村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021103, 141021, '高显镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021104, 141021, '里村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021200, 141021, '北董乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141021201, 141021, '杨谈乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022100, 141022, '唐兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022101, 141022, '南梁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022102, 141022, '里砦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022103, 141022, '隆化镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022104, 141022, '桥上镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022105, 141022, '西阎镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022106, 141022, '王庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022200, 141022, '中卫乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141022201, 141022, '南唐乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023100, 141023, '新城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023101, 141023, '赵康镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023102, 141023, '汾城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023103, 141023, '南贾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023104, 141023, '古城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023105, 141023, '襄陵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023106, 141023, '邓庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023200, 141023, '陶寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023201, 141023, '永固乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023202, 141023, '景毛乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023203, 141023, '西贾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023204, 141023, '南辛店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141023205, 141023, '大邓乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024100, 141024, '大槐树镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024101, 141024, '甘亭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024102, 141024, '曲亭镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024103, 141024, '苏堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024104, 141024, '广胜寺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024105, 141024, '明姜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024106, 141024, '赵城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024107, 141024, '万安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024108, 141024, '刘家垣镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024109, 141024, '辛村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024200, 141024, '淹底乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024201, 141024, '兴唐寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024202, 141024, '堤村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024204, 141024, '龙马乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141024207, 141024, '山目乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141025100, 141025, '岳阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141025101, 141025, '北平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141025102, 141025, '古阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141025103, 141025, '旧县镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141025104, 141025, '三合镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141025202, 141025, '南垣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141026100, 141026, '府城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141026101, 141026, '和川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141026102, 141026, '唐城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141026103, 141026, '冀氏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141026104, 141026, '良马镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141026105, 141026, '马壁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027100, 141027, '天坛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027101, 141027, '响水河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027102, 141027, '张庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027103, 141027, '北王镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027201, 141027, '东张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027202, 141027, '槐埝乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141027206, 141027, '寨圪塔乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028100, 141028, '吉昌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028101, 141028, '屯里镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028102, 141028, '壶口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028200, 141028, '车城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028201, 141028, '文城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028203, 141028, '柏山寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141028204, 141028, '中垛乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029100, 141029, '昌宁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029101, 141029, '光华镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029102, 141029, '台头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029103, 141029, '管头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029104, 141029, '西坡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029200, 141029, '双鹤乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029201, 141029, '关王庙乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029202, 141029, '尉庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029203, 141029, '西交口乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141029204, 141029, '枣岭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141030100, 141030, '昕水镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141030101, 141030, '曲峨镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141030102, 141030, '太古镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141030200, 141030, '三多乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141030201, 141030, '太德乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031100, 141031, '龙泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031101, 141031, '午城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031102, 141031, '黄土镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031200, 141031, '阳头升乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031201, 141031, '寨子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031203, 141031, '下李乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141031204, 141031, '城南乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141032100, 141032, '芝河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141032101, 141032, '桑壁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141032203, 141032, '坡头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141032205, 141032, '乾坤湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141032206, 141032, '望海寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141032207, 141032, '楼山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033100, 141033, '蒲城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033101, 141033, '薛关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033102, 141033, '黑龙关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033103, 141033, '克城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033104, 141033, '乔家湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033200, 141033, '山中乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033201, 141033, '古县乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141033204, 141033, '太林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034100, 141034, '永安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034101, 141034, '对竹镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034102, 141034, '勍香镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034103, 141034, '和平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034104, 141034, '僧念镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034200, 141034, '佃坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034201, 141034, '团柏乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141034400, 141034, '社区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081001, 141081, '路东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081002, 141081, '路西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081003, 141081, '浍滨街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081004, 141081, '上马街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081005, 141081, '张村街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081200, 141081, '新田乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081201, 141081, '高村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141081202, 141081, '凤城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082001, 141082, '鼓楼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082002, 141082, '北环路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082003, 141082, '南环路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082004, 141082, '开元街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082005, 141082, '退沙街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082100, 141082, '白龙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082101, 141082, '辛置镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082102, 141082, '大张镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082103, 141082, '李曹镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082200, 141082, '陶唐峪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082201, 141082, '三教乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141082202, 141082, '师庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102001, 141102, '滨河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102002, 141102, '凤山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102003, 141102, '莲花池街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102004, 141102, '城北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102005, 141102, '田家会街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102006, 141102, '交口街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102007, 141102, '西属巴街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102100, 141102, '吴城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102101, 141102, '信义镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102201, 141102, '枣林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141102202, 141102, '坪头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121100, 141121, '凤城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121101, 141121, '开栅镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121102, 141121, '南庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121103, 141121, '南安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121104, 141121, '刘胡兰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121105, 141121, '下曲镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121106, 141121, '孝义镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121200, 141121, '南武乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121201, 141121, '西城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121202, 141121, '北张乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121203, 141121, '马西乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141121204, 141121, '西槽头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122100, 141122, '天宁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122101, 141122, '夏家营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122102, 141122, '西营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122103, 141122, '水峪贯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122104, 141122, '西社镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122105, 141122, '庞泉沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122106, 141122, '洪相镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122202, 141122, '东坡底乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141122400, 141122, '夏家营生态工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123100, 141123, '蔚汾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123101, 141123, '魏家滩镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123102, 141123, '瓦塘镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123103, 141123, '康宁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123104, 141123, '高家村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123105, 141123, '罗峪口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123106, 141123, '蔡家会镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123200, 141123, '交楼申乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123202, 141123, '东会乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123203, 141123, '固贤乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123204, 141123, '奥家湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123205, 141123, '蔡家崖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123207, 141123, '孟家坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123208, 141123, '赵家坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123209, 141123, '圪垯上乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141123400, 141123, '兴县经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124100, 141124, '临泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124101, 141124, '白文镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124102, 141124, '城庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124103, 141124, '兔坂镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124104, 141124, '克虎镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124105, 141124, '三交镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124106, 141124, '湍水头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124107, 141124, '林家坪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124108, 141124, '招贤镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124109, 141124, '碛口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124110, 141124, '刘家会镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124111, 141124, '丛罗峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124112, 141124, '曲峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124200, 141124, '木瓜坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124201, 141124, '安业乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124202, 141124, '玉坪乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124203, 141124, '青凉寺乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124204, 141124, '石白头乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124205, 141124, '雷家碛乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124206, 141124, '八堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124207, 141124, '大禹乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124208, 141124, '车赶乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141124209, 141124, '安家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125100, 141125, '柳林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125101, 141125, '穆村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125102, 141125, '薛村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125103, 141125, '庄上镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125104, 141125, '留誉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125105, 141125, '三交镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125106, 141125, '成家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125107, 141125, '孟门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125108, 141125, '陈家湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125109, 141125, '金家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125200, 141125, '李家湾乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125201, 141125, '贾家垣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125204, 141125, '高家沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125205, 141125, '石西乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141125206, 141125, '王家沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126100, 141126, '灵泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126101, 141126, '罗村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126102, 141126, '义牒镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126103, 141126, '小蒜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126104, 141126, '辛关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126200, 141126, '龙交乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126201, 141126, '和合乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126203, 141126, '曹家垣乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141126204, 141126, '裴沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127100, 141127, '东村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127101, 141127, '岚城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127102, 141127, '普明镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127103, 141127, '界河口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127201, 141127, '上明乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127202, 141127, '王狮乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127203, 141127, '梁家庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127204, 141127, '顺会乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127206, 141127, '社科乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141127400, 141127, '岚县普明工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141128100, 141128, '圪洞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141128101, 141128, '马坊镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141128102, 141128, '峪口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141128103, 141128, '大武镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141128104, 141128, '北武当镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141128105, 141128, '积翠镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141129100, 141129, '宁乡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141129101, 141129, '金罗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141129102, 141129, '枝柯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141129103, 141129, '武家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141129104, 141129, '暖泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141129201, 141129, '下枣林乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130100, 141130, '水头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130101, 141130, '康城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130102, 141130, '双池镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130103, 141130, '桃红坡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130104, 141130, '石口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130105, 141130, '回龙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141130202, 141130, '温泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181001, 141181, '新义街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181002, 141181, '中阳楼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181003, 141181, '振兴街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181004, 141181, '胜溪湖街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181005, 141181, '崇文街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181100, 141181, '兑镇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181101, 141181, '阳泉曲镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181102, 141181, '下堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181103, 141181, '西辛庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181104, 141181, '高阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181105, 141181, '梧桐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181106, 141181, '柱濮镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181107, 141181, '大孝堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181201, 141181, '下栅乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181202, 141181, '驿马乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141181204, 141181, '杜村乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182001, 141182, '文峰街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182002, 141182, '太和桥街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182003, 141182, '西河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182100, 141182, '贾家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182101, 141182, '杏花村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182102, 141182, '冀村镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182103, 141182, '肖家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182104, 141182, '演武镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182105, 141182, '三泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182106, 141182, '石庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182107, 141182, '杨家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182108, 141182, '峪道河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182109, 141182, '阳城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (141182110, 141182, '栗家庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102001, 150102, '海拉尔东路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102002, 150102, '锡林北路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102003, 150102, '中山东路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102004, 150102, '东街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102005, 150102, '西街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102006, 150102, '东风路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102007, 150102, '迎新路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102008, 150102, '成吉思汗大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102101, 150102, '保合少镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150102400, 150102, '新城区鸿盛高科技园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103001, 150103, '新华西路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103002, 150103, '中山西路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103003, 150103, '光明路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103004, 150103, '海拉尔西路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103005, 150103, '环河街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103006, 150103, '通道街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103007, 150103, '钢铁路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150103100, 150103, '攸攸板镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104001, 150104, '小召前街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104002, 150104, '兴隆巷街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104003, 150104, '长和廊街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104004, 150104, '石东路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104005, 150104, '大南街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104006, 150104, '鄂尔多斯路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104007, 150104, '西菜园街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104008, 150104, '昭君路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104100, 150104, '小黑河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150104400, 150104, '裕隆工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105001, 150105, '人民路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105002, 150105, '大学西路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105003, 150105, '乌兰察布东路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105004, 150105, '大学东路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105005, 150105, '中专路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105006, 150105, '昭乌达路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105007, 150105, '巴彦街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105008, 150105, '敕勒川路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105101, 150105, '榆林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105103, 150105, '黄合少镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105104, 150105, '金河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150105400, 150105, '金桥经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121100, 150121, '察素齐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121101, 150121, '毕克齐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121102, 150121, '善岱镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121103, 150121, '台阁牧镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121104, 150121, '白庙子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121105, 150121, '沙尔沁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121106, 150121, '敕勒川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121207, 150121, '北什轴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121208, 150121, '塔布赛乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150121401, 150121, '呼和浩特金山经济技术开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150122100, 150122, '双河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150122101, 150122, '新营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150122102, 150122, '五申镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150122103, 150122, '伍什家镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150122104, 150122, '古城镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150122400, 150122, '托县工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123100, 150123, '城关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123101, 150123, '盛乐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123102, 150123, '新店子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123103, 150123, '巧什营镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123203, 150123, '舍必崖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123205, 150123, '大红城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123206, 150123, '羊群沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123207, 150123, '黑老夭乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123400, 150123, '盛乐经济工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150123401, 150123, '内蒙古和林格尔新区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124100, 150124, '城关镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124101, 150124, '宏河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124102, 150124, '喇嘛湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124103, 150124, '老牛湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124200, 150124, '窑沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124201, 150124, '北堡乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124202, 150124, '韭菜庄乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124203, 150124, '五良太乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150124401, 150124, '内蒙古清水河工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125100, 150125, '可可以力更镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125101, 150125, '哈乐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125102, 150125, '西乌兰不浪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125200, 150125, '大青山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125205, 150125, '上秃亥乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125207, 150125, '得胜沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125211, 150125, '二份子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125213, 150125, '哈拉合少乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125214, 150125, '耗赖山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125402, 150125, '内蒙古武川经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150125403, 150125, '武川金三角经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150172401, 150172, '如意工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150172402, 150172, '金川工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150172403, 150172, '呼和浩特综合保税区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150172404, 150172, '呼和浩特留学人员创业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150172405, 150172, '沙尔沁工业区（如意南区）', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150172406, 150172, '呼和浩特白塔空港物流园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202001, 150202, '和平路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202002, 150202, '财神庙街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202003, 150202, '西脑包街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202004, 150202, '南门外街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202005, 150202, '南圪洞街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202006, 150202, '东站街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202007, 150202, '回民街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202008, 150202, '天骄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202009, 150202, '河东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202010, 150202, '铁西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202011, 150202, '东兴街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202012, 150202, '杨圪塄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202100, 150202, '河东镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202101, 150202, '沙尔沁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150202400, 150202, '铝业工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203001, 150203, '少先路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203003, 150203, '沼潭街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203004, 150203, '林荫路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203005, 150203, '友谊大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203006, 150203, '阿尔丁大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203007, 150203, '团结大街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203008, 150203, '鞍山道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203009, 150203, '前进道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203010, 150203, '市府东路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203011, 150203, '白云路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203012, 150203, '黄河西路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203013, 150203, '昆工路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203014, 150203, '昆北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203100, 150203, '昆河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203102, 150203, '卜尔汉图镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150203400, 150203, '包钢厂区办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204001, 150204, '先锋道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204002, 150204, '幸福路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204003, 150204, '万青路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204004, 150204, '富强路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204005, 150204, '科学路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204006, 150204, '青山路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204007, 150204, '自由路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204008, 150204, '乌素图街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204100, 150204, '青福镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204101, 150204, '兴胜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150204401, 150204, '包头市装备制造产业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205001, 150205, '石拐街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205002, 150205, '大发街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205003, 150205, '大磁街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205004, 150205, '五当沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205005, 150205, '白狐沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205006, 150205, '大德恒街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205101, 150205, '五当召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205202, 150205, '吉忽伦图苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150205400, 150205, '工业园区管理委员会', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150206001, 150206, '矿山路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150206002, 150206, '通阳道街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207001, 150207, '沙河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207002, 150207, '赛汗街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207003, 150207, '萨如拉街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207004, 150207, '白音席勒街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207103, 150207, '麻池镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207105, 150207, '哈林格尔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207110, 150207, '哈业胡同镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150207202, 150207, '阿嘎如泰苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221104, 150221, '萨拉齐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221105, 150221, '双龙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221106, 150221, '美岱召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221107, 150221, '沟门镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221108, 150221, '将军尧镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221213, 150221, '海子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221214, 150221, '明沙淖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221215, 150221, '苏波盖乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150221500, 150221, '九峰山生态管理委员会', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150222102, 150222, '金山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150222103, 150222, '西斗铺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150222104, 150222, '下湿壕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150222105, 150222, '银号镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150222106, 150222, '怀朔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150222107, 150222, '兴顺西镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223102, 150223, '满都拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223103, 150223, '希拉穆仁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223104, 150223, '百灵庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223105, 150223, '石宝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223106, 150223, '乌克忽洞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223107, 150223, '明安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223108, 150223, '巴音花镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223213, 150223, '达尔汗苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223214, 150223, '查干哈达苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223215, 150223, '巴音敖包苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223216, 150223, '西河乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150223217, 150223, '小文公乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150271010, 150271, '稀土路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150271020, 150271, '民馨路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150271102, 150271, '万水泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302001, 150302, '凤凰岭街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302002, 150302, '海北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302003, 150302, '新华街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302004, 150302, '新华西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302007, 150302, '滨河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302008, 150302, '林荫街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302101, 150302, '千里山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150302400, 150302, '乌海市海勃湾千里山工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150303001, 150303, '拉僧仲街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150303002, 150303, '西卓子山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150303102, 150303, '公乌素镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150303103, 150303, '拉僧庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150303104, 150303, '巴音陶亥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304002, 150304, '三道坎街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304003, 150304, '五虎山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304008, 150304, '新达街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304009, 150304, '巴音赛街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304010, 150304, '梁家沟街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304011, 150304, '苏海图街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304012, 150304, '滨海街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304101, 150304, '乌兰淖尔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150304400, 150304, '乌达经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402001, 150402, '西屯街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402002, 150402, '三中街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402003, 150402, '永巨街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402004, 150402, '东城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402005, 150402, '南新街街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402006, 150402, '站前街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402007, 150402, '铁南街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402008, 150402, '长青街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402009, 150402, '哈达街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402010, 150402, '西城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402011, 150402, '桥北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402100, 150402, '红庙子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402102, 150402, '文钟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402400, 150402, '赤峰红山高新技术产业开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402401, 150402, '内蒙古红山物流园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150402402, 150402, '红山绿色食品产业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403001, 150403, '西露天街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403002, 150403, '平庄城区街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403003, 150403, '平庄东城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403004, 150403, '平庄西城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403005, 150403, '马林街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403006, 150403, '云杉路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403100, 150403, '风水沟镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403101, 150403, '元宝山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403102, 150403, '美丽河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403103, 150403, '平庄镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403104, 150403, '五家镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150403200, 150403, '小五家乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404001, 150404, '振兴街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404002, 150404, '向阳街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404003, 150404, '松州街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404004, 150404, '铁东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404100, 150404, '穆家营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404101, 150404, '初头朗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404102, 150404, '大庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404103, 150404, '王府镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404104, 150404, '老府镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404105, 150404, '哈拉道口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404106, 150404, '上官地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404107, 150404, '安庆镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404108, 150404, '太平地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404200, 150404, '当铺地满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404201, 150404, '夏家店乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404202, 150404, '城子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404203, 150404, '大夫营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404204, 150404, '岗子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404400, 150404, '玉龙街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404401, 150404, '全宁街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404407, 150404, '兴安街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150404408, 150404, '松城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421100, 150421, '天山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421101, 150421, '天山口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421102, 150421, '双胜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421103, 150421, '坤都镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421104, 150421, '巴彦花镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421105, 150421, '绍根镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421106, 150421, '扎嘎斯台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421200, 150421, '新民乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421201, 150421, '先锋乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421202, 150421, '罕苏木苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421203, 150421, '赛罕塔拉苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421204, 150421, '巴拉奇如德苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421205, 150421, '乌兰哈达乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421206, 150421, '巴彦温都尔苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421400, 150421, '轻工食品产业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421401, 150421, '新能源产业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421402, 150421, '绍根煤碳及煤化工产业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421403, 150421, '罕乌拉街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150421404, 150421, '欧沐沦街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422100, 150422, '林东镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422101, 150422, '隆昌镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422102, 150422, '十三敖包镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422103, 150422, '碧流台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422104, 150422, '富河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422105, 150422, '白音勿拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422106, 150422, '哈拉哈达镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422200, 150422, '查干哈达苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422201, 150422, '乌兰达坝苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422202, 150422, '三山乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422203, 150422, '花加拉嘎乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422403, 150422, '林东西城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422404, 150422, '林东东城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150422405, 150422, '林东产业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423100, 150423, '大板镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423101, 150423, '索博日嘎镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423102, 150423, '宝日勿苏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423103, 150423, '查干诺尔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423105, 150423, '巴彦琥硕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423200, 150423, '西拉沐沦苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423201, 150423, '巴彦塔拉苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423202, 150423, '幸福之路苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423203, 150423, '查干沐沦苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423400, 150423, '大板煤电化基地', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423401, 150423, '赛罕街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150423402, 150423, '达尔罕街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424100, 150424, '林西镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424101, 150424, '新城子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424102, 150424, '新林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424103, 150424, '五十家子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424104, 150424, '官地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424105, 150424, '大井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424106, 150424, '统部镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424200, 150424, '大营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424201, 150424, '十二吐乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424400, 150424, '城北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424401, 150424, '城南街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150424402, 150424, '内蒙古林西工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425100, 150425, '经棚镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425101, 150425, '宇宙地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425102, 150425, '土城子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425103, 150425, '同兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425104, 150425, '万合永镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425105, 150425, '芝瑞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425106, 150425, '达来诺日镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425200, 150425, '新开地乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425201, 150425, '红山子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425202, 150425, '达日罕乌拉苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425203, 150425, '巴彦查干苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425204, 150425, '浩来呼热苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425205, 150425, '乌兰布统苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425400, 150425, '应昌街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425401, 150425, '热水塘街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150425403, 150425, '西拉沐沦街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426100, 150426, '乌丹镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426101, 150426, '乌敦套海镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426102, 150426, '五分地镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426103, 150426, '桥头镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426104, 150426, '广德公镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426105, 150426, '梧桐花镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426106, 150426, '海拉苏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426107, 150426, '亿合公镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426200, 150426, '解放营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426201, 150426, '阿什罕苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426202, 150426, '新苏莫苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426203, 150426, '白音套海苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426204, 150426, '毛山东乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426205, 150426, '格日僧苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426400, 150426, '玉龙工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426402, 150426, '紫城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150426403, 150426, '全宁街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428100, 150428, '锦山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428101, 150428, '美林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428102, 150428, '王爷府镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428103, 150428, '小牛群镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428104, 150428, '牛家营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428105, 150428, '乃林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428106, 150428, '西桥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428200, 150428, '十家满族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428201, 150428, '南台子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428400, 150428, '乃林果树农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428401, 150428, '马鞍山羊场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428402, 150428, '喀喇沁经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428403, 150428, '锦山工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428404, 150428, '河北街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150428405, 150428, '河南街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429100, 150429, '天义镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429101, 150429, '小城子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429102, 150429, '大城子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429103, 150429, '八里罕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429104, 150429, '黑里河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429105, 150429, '右北平镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429106, 150429, '大双庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429107, 150429, '汐子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429108, 150429, '大明镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429109, 150429, '忙农镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429110, 150429, '五化镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429111, 150429, '三座店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429112, 150429, '必斯营子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429202, 150429, '一肯中乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429203, 150429, '存金沟乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429400, 150429, '中京工业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429401, 150429, '塞飞亚食品工业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429402, 150429, '八里罕酒业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429403, 150429, '再生资源产业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429404, 150429, '生物科技产业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429405, 150429, '汐子工业园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429406, 150429, '农机产业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429407, 150429, '宁城县铁西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429408, 150429, '宁城县铁东街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150429409, 150429, '宁城县温泉街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430100, 150430, '新惠镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430101, 150430, '四家子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430102, 150430, '长胜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430103, 150430, '贝子府镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430104, 150430, '四道湾子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430105, 150430, '下洼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430106, 150430, '金厂沟梁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430107, 150430, '兴隆洼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430108, 150430, '黄羊洼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430109, 150430, '古鲁板蒿镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430110, 150430, '牛古吐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430202, 150430, '木头营子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430204, 150430, '丰收乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430205, 150430, '玛尼罕乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430206, 150430, '萨力巴乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430207, 150430, '敖润苏莫苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430401, 150430, '敖汉旗工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430404, 150430, '敖汉旗人民政府新州街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150430405, 150430, '敖汉旗惠州街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502001, 150502, '科尔沁街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502002, 150502, '西门街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502003, 150502, '永清街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502004, 150502, '明仁街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502005, 150502, '施介街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502006, 150502, '团结街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502007, 150502, '东郊街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502008, 150502, '铁路街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502009, 150502, '红星街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502010, 150502, '霍林河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502011, 150502, '建国街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502100, 150502, '大林镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502101, 150502, '钱家店镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502102, 150502, '余粮堡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502103, 150502, '木里图镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502104, 150502, '丰田镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502105, 150502, '清河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502106, 150502, '育新镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502107, 150502, '庆和镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502108, 150502, '敖力布皋镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502200, 150502, '莫力庙苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502400, 150502, '国有哲南农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502401, 150502, '三义堂农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502402, 150502, '通辽市高林屯种畜场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502403, 150502, '胡力海原种繁殖场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502404, 150502, '莫力庙种羊场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150502405, 150502, '半截店牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521100, 150521, '保康镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521101, 150521, '宝龙山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521102, 150521, '舍伯吐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521103, 150521, '巴彦塔拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521104, 150521, '门达镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521105, 150521, '架玛吐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521106, 150521, '腰林毛都镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521107, 150521, '希伯花镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521108, 150521, '花吐古拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521109, 150521, '代力吉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521110, 150521, '努日木镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521200, 150521, '花胡硕苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521201, 150521, '协代苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521202, 150521, '白兴吐苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521203, 150521, '图布信苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521204, 150521, '敖包苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521205, 150521, '胜利乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521400, 150521, '白音塔拉农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521401, 150521, '珠日河牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521402, 150521, '丰库牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150521403, 150521, '保康街道办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522100, 150522, '甘旗卡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522101, 150522, '吉尔嘎朗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522102, 150522, '金宝屯镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522103, 150522, '常胜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522104, 150522, '查日苏镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522105, 150522, '双胜镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522106, 150522, '阿古拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522107, 150522, '朝鲁吐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522108, 150522, '努古斯台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522109, 150522, '海鲁吐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522200, 150522, '阿都沁苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522201, 150522, '茂道吐苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522202, 150522, '巴胡塔苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522203, 150522, '散都苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522204, 150522, '巴彦毛都苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522400, 150522, '胜利农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522401, 150522, '孟根达坝牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522402, 150522, '查金台牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522403, 150522, '原种繁育中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522404, 150522, '大青沟管理局', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522405, 150522, '哈日乌苏种畜场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522406, 150522, '乌兰敖道渔场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522407, 150522, '金宝屯林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522408, 150522, '朝鲁吐林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522409, 150522, '茂道吐林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522410, 150522, '伊胡塔林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150522411, 150522, '乌旦塔拉林场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523100, 150523, '开鲁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523101, 150523, '大榆树镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523102, 150523, '黑龙坝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523103, 150523, '麦新镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523104, 150523, '义和塔拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523105, 150523, '建华镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523106, 150523, '小街基镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523107, 150523, '东风镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523108, 150523, '吉日嘎郎吐镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523109, 150523, '东来镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523400, 150523, '清河牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523401, 150523, '辽河农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150523402, 150523, '保安农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524100, 150524, '库伦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524101, 150524, '扣河子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524102, 150524, '白音花镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524103, 150524, '六家子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524104, 150524, '额勒顺镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524200, 150524, '茫汗苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524201, 150524, '先进苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524202, 150524, '水泉乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150524400, 150524, '库伦街道办事处', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525100, 150525, '大沁他拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525101, 150525, '八仙筒镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525102, 150525, '青龙山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525103, 150525, '新镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525104, 150525, '治安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525105, 150525, '东明镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525106, 150525, '沙日浩来镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525107, 150525, '义隆永镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525200, 150525, '固日班花苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525201, 150525, '白音他拉苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525202, 150525, '明仁苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525203, 150525, '黄花塔拉苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525204, 150525, '土城子乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525205, 150525, '苇莲苏乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525400, 150525, '国有六号农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150525401, 150525, '大沁他拉街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526100, 150526, '鲁北镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526101, 150526, '黄花山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526102, 150526, '嘎亥图镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526103, 150526, '巨日合镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526104, 150526, '巴雅尔吐胡硕镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526105, 150526, '香山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526106, 150526, '阿日昆都楞镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526200, 150526, '巴彦塔拉苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526201, 150526, '乌力吉木仁苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526202, 150526, '道老杜苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526203, 150526, '格日朝鲁苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526204, 150526, '前德门苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526205, 150526, '乌兰哈达苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526206, 150526, '查布嘎图苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526207, 150526, '乌额格其苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526400, 150526, '乌额格其牧场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526401, 150526, '香山农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526402, 150526, '乌日根塔拉农场', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150526403, 150526, '通辽市嘎达苏种畜繁育中心', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150571001, 150571, '河西街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150571002, 150571, '电厂街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150571003, 150571, '新城街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150571004, 150571, '滨河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150571100, 150571, '辽河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150581001, 150581, '珠斯花街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150581002, 150581, '莫斯台街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150581003, 150581, '宝日呼吉尔街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150581004, 150581, '沙尔呼热街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150581200, 150581, '达来胡硕苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150581400, 150581, '霍林郭勒市军马场生态保护区管理委员会', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602001, 150602, '交通街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602002, 150602, '公园街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602003, 150602, '林荫街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602004, 150602, '建设街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602005, 150602, '富兴街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602006, 150602, '天骄街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602007, 150602, '诃额伦街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602008, 150602, '巴音门克街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602010, 150602, '幸福街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602011, 150602, '纺织街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602012, 150602, '兴胜街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602013, 150602, '民族街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602100, 150602, '泊尔江海子镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602101, 150602, '罕台镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602102, 150602, '铜川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602400, 150602, '鄂尔多斯市装备制造基地', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602401, 150602, '东胜区轻纺工业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150602404, 150602, '铜川汽车博览园', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150603001, 150603, '哈巴格希街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150603002, 150603, '青春山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150603003, 150603, '滨河街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150603008, 150603, '康新街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150603400, 150603, '鄂尔多斯市高新技术产业园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621001, 150621, '工业街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621002, 150621, '昭君街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621003, 150621, '锡尼街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621004, 150621, '白塔街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621005, 150621, '西园街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621006, 150621, '平原街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621100, 150621, '树林召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621101, 150621, '吉格斯太镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621102, 150621, '白泥井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621103, 150621, '王爱召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621104, 150621, '昭君镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621105, 150621, '恩格贝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621106, 150621, '中和西镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621107, 150621, '风水梁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621200, 150621, '展旦召苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621400, 150621, '达拉特经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150621401, 150621, '鄂尔多斯市生态示范区管理委员会', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622001, 150622, '兴隆街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622002, 150622, '迎泽街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622003, 150622, '蓝天街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622004, 150622, '友谊街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622100, 150622, '薛家湾镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622101, 150622, '沙圪堵镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622102, 150622, '大路镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622103, 150622, '纳日松镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622104, 150622, '龙口镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622105, 150622, '准格尔召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622106, 150622, '魏家峁镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622200, 150622, '暖水乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622201, 150622, '十二连城乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622202, 150622, '布尔陶亥苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622400, 150622, '准格尔经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150622401, 150622, '大路煤化工基地', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150623100, 150623, '敖勒召其镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150623101, 150623, '上海庙镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150623102, 150623, '城川镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150623103, 150623, '昂素镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150623400, 150623, '上海庙经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624100, 150624, '乌兰镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624101, 150624, '棋盘井镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624102, 150624, '蒙西镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624103, 150624, '木凯淖尔镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624200, 150624, '苏米图苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624201, 150624, '阿尔巴斯苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150624404, 150624, '内蒙古鄂托克经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625100, 150625, '锡尼镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625101, 150625, '巴拉贡镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625102, 150625, '吉日嘎朗图镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625103, 150625, '独贵塔拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625104, 150625, '呼和木独镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625200, 150625, '伊和乌素苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150625400, 150625, '内蒙古鄂尔多斯杭锦经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626100, 150626, '嘎鲁图镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626101, 150626, '乌审召镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626102, 150626, '图克镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626103, 150626, '乌兰陶勒盖镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626104, 150626, '无定河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626200, 150626, '苏力德苏木', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150626410, 150626, '苏里格经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627100, 150627, '阿勒腾席热镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627101, 150627, '札萨克镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627102, 150627, '乌兰木伦镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627103, 150627, '纳林陶亥镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627104, 150627, '苏布尔嘎镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627105, 150627, '红庆河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627106, 150627, '伊金霍洛镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627400, 150627, '鄂尔多斯蒙苏经济开发区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150627407, 150627, '鄂尔多斯空港物流园区', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702001, 150702, '正阳街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702002, 150702, '健康街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702003, 150702, '靠山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702004, 150702, '胜利街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702005, 150702, '呼伦街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702007, 150702, '建设街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702008, 150702, '东山街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702100, 150702, '哈克镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150702101, 150702, '奋斗镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150703001, 150703, '第三街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150703002, 150703, '第一街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150703003, 150703, '第二街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150703004, 150703, '第四街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150703005, 150703, '第五街道', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150703100, 150703, '灵泉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721100, 150721, '那吉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721101, 150721, '六合镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721102, 150721, '亚东镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721103, 150721, '霍尔奇镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721104, 150721, '向阳峪镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721105, 150721, '三岔河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721106, 150721, '复兴镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721108, 150721, '兴安镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721200, 150721, '得力其尔鄂温克民族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721201, 150721, '查巴奇鄂温克民族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721202, 150721, '音河达斡尔鄂温克民族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721203, 150721, '新发朝鲜民族乡', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150721402, 150721, '阿荣旗林业和草原局', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722100, 150722, '尼尔基镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722102, 150722, '宝山镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722103, 150722, '哈达阳镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722104, 150722, '阿尔拉镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722105, 150722, '汉古尔河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722106, 150722, '西瓦尔图镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722108, 150722, '腾克镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722109, 150722, '奎勒河镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
INSERT INTO `eb_city_region` VALUES (150722110, 150722, '塔温敖宝镇', 4, '2022-11-09 10:39:25', '2022-11-09 11:10:46');
I