ALTER TABLE `crmeb`.`bcx_brokerage_config`
    MODIFY COLUMN `belong_id` bigint(20) NOT NULL COMMENT '关联id：渠道表id，部门表id，部门成员表id' AFTER `product_id`,
    MODIFY COLUMN `belong_type` tinyint(4) NOT NULL COMMENT '关联类型：1渠道表，2部门表，3部门成员表' AFTER `belong_id`,
    ADD COLUMN `channel_type` tinyint(4) NULL DEFAULT NULL COMMENT '渠道类型：1业务渠道，2区域渠道' AFTER `belong_type`,
    ADD COLUMN `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '佣金类型：1比例，2固定，3自留' AFTER `channel_type`,
    MODIFY COLUMN `ratio` decimal(15, 2) NOT NULL COMMENT '佣金比例' AFTER `belong_type`,
    ADD COLUMN `calculate_ratio` decimal(5, 2) NOT NULL DEFAULT 100 COMMENT '计算系数，默认100%' AFTER `ratio`;

ALTER TABLE `crmeb`.`eb_product`
    ADD COLUMN `max_brokerage` decimal(10, 2) NULL COMMENT '商品最大分佣比例' AFTER `master_id`;


ALTER TABLE `crmeb`.`bcx_performance_report`
    ADD COLUMN `pay_price_calculate` decimal(15, 2) NULL DEFAULT NULL COMMENT '实际业务量，计算公式：实际支付金额 * 计算系数' AFTER `pay_price`,
    CHANGE COLUMN `brokerage_ratio` `brokerage_type` tinyint(4) NULL DEFAULT NULL COMMENT '佣金类型：1比例，2固定，3自留' AFTER `brokerage_config_snapshot`,
    ADD COLUMN `brokerage_ratio` decimal(15, 2) NULL DEFAULT NULL COMMENT '佣金比例' AFTER `brokerage_type`,
    ADD COLUMN `brokerage_calculate_ratio` decimal(5, 2) NULL DEFAULT NULL COMMENT '计算系数' AFTER `brokerage_ratio`;

INSERT INTO `crmeb`.`eb_system_config`
    (`id`, `name`, `title`, `form_id`, `value`, `status`, `create_time`, `update_time`, `form_name`)
     VALUES (135, 'retail_store_product_max_brokerage', 'retail_store_product_max_brokerage', 0, '50', 0, '2023-10-24 14:00:00', '2023-10-24 14:00:00', '');

ALTER TABLE `crmeb`.`bcx_product_benefits`
    CHANGE COLUMN `sku_id` `product_id` int(11) NOT NULL COMMENT '商品sku ID' AFTER `id`,
    ADD COLUMN `product_type` varchar(10) NULL COMMENT '类型，B：B端商品，C：C端商品' AFTER `product_name`;

ALTER TABLE `crmeb`.`eb_user`
    MODIFY COLUMN `user_type` int(10) NULL DEFAULT NULL COMMENT '用户类型：0-默认 1-企业 2-职员 3-组织管理员';

INSERT INTO `crmeb`.`eb_schedule_job` (`bean_name`, `method_name`, `params`, `cron_expression`, `status`, `remark`, `is_delete`, `create_time`)
 VALUES ('GenerateSettleBillTask', 'generateSettleBill', NULL, '0 0 1 * * ?', 0, '生成业绩账单任务', 0, '2023-10-30 15:00:00');


ALTER TABLE `crmeb`.`bcx_brokerage_config`
    ADD INDEX `index_bbbc_product_id`(`product_id`) USING BTREE,
ADD INDEX `index_bbbc_belong_id`(`belong_id`) USING BTREE;

ALTER TABLE `crmeb`.`bcx_performance_report`
    ADD INDEX `index_bpr_belong_id`(`belong_id`) USING BTREE,
ADD INDEX `index_bpr_order_no`(`order_no`) USING BTREE,
ADD INDEX `index_bpr_order_detail_id`(`order_detail_id`) USING BTREE,
ADD INDEX `index_bpr_settle_bill_id`(`settle_bill_id`) USING BTREE,
ADD INDEX `index_bpr_settle_id`(`settle_id`) USING BTREE;

ALTER TABLE `crmeb`.`bcx_product_benefits`
    ADD INDEX `index_bpb_company_id`(`company_id`) USING BTREE;

ALTER TABLE `crmeb`.`bcx_settle`
    ADD INDEX `index_bs_settle_bill_id`(`settle_bill_id`) USING BTREE,
ADD INDEX `index_bs_belong_id`(`belong_id`) USING BTREE,
ADD INDEX `index_bs_settle_no`(`settle_no`) USING BTREE;

ALTER TABLE `crmeb`.`bcx_settle_attachments`
    ADD INDEX `index_bsa_settle_id`(`settle_id`) USING BTREE;

ALTER TABLE `crmeb`.`bcx_settle_bill`
    ADD INDEX `index_bsb_belong_id`(`belong_id`) USING BTREE;


CREATE TABLE `crmeb`.`bcx_user_bank` (
     `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
     `uid` int(11) NOT NULL COMMENT '用户id',
     `user_name` varchar(50) NOT NULL COMMENT '姓名',
     `bank_code` int(12) NOT NULL COMMENT '银行编号',
     `bank_name` varchar(100) NOT NULL COMMENT '银行名称',
     `branch_code` bigint(20) unsigned NOT NULL COMMENT '支行联行编号',
     `branch_name` varchar(100) NOT NULL COMMENT '支行名称',
     `bank_card_no` varchar(50) NOT NULL COMMENT '银行卡号',
     `is_default` tinyint(4) NOT NULL COMMENT '是否默认银行卡：0否，1是',
     `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态：0无效，1有效',
     `create_time` datetime DEFAULT NULL COMMENT '创建时间',
     `update_time` datetime DEFAULT NULL COMMENT '更新时间',
     PRIMARY KEY (`id`) USING BTREE,
     KEY `index_bub_uid` (`uid`) USING BTREE,
     KEY `index_bub_bank_card_no` (`bank_card_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户绑定银行卡表';


ALTER TABLE `crmeb`.`bcx_department_member`
DROP INDEX `fk_dept_bcx_id`,
ADD INDEX `fk_dept_member_bcx_id`(`bcx_id`) USING BTREE;

CREATE TABLE `crmeb`.`bcx_department_member_serve` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
    `original_id` varchar(255) NOT NULL COMMENT '原表id',
    `bcx_id` varchar(50) NOT NULL DEFAULT '' COMMENT '平台id',
    `org_id` varchar(50) NOT NULL DEFAULT '' COMMENT '服务公司id',
    `org_name` varchar(100) DEFAULT NULL COMMENT '服务公司名称',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态：0无效，1有效',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `update_time` datetime DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`,`original_id`) USING BTREE,
    KEY `index_bdms_bcx_id` (`bcx_id`) USING BTREE,
    KEY `index_bdms_org_id` (`org_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='部门成员服务表';

ALTER TABLE `crmeb`.`bcx_brokerage_config`
    ADD COLUMN `service_ratio` decimal(15, 2) NULL COMMENT '服务佣金' AFTER `ratio`;

ALTER TABLE `crmeb`.`bcx_performance_report`
    ADD COLUMN `is_serve` tinyint(4) NULL DEFAULT NULL COMMENT '是否服务绩效：1是，0否' AFTER `brokerage_config_snapshot`;