# ************************************************************
# CRMEB Java 多商户 v1.2 升 v1.3 版本sql
# 平台管理 admin / 123456
# 商户 18292417675 / 000000
# 用户 自己注册 建议使用小程序
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
SET NAMES utf8mb4;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE='NO_AUTO_VALUE_ON_ZERO', SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;



SET FOREIGN_KEY_CHECKS=0;

ALTER TABLE `eb_activity_style` MODIFY COLUMN `createtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间' AFTER `products`;

ALTER TABLE `eb_activity_style` MODIFY COLUMN `updatetime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间' AFTER `createtime`;

ALTER TABLE `eb_cart` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_community_notes` MODIFY COLUMN `refusal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拒绝理由' AFTER `audit_status`;

ALTER TABLE `eb_community_notes` MODIFY COLUMN `like_num` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞数' AFTER `refusal`;

ALTER TABLE `eb_community_notes` MODIFY COLUMN `reply_num` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论数' AFTER `like_num`;

ALTER TABLE `eb_community_notes` MODIFY COLUMN `share_num` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分享数' AFTER `reply_num`;

ALTER TABLE `eb_community_notes` MODIFY COLUMN `views` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '浏览量' AFTER `share_num`;

ALTER TABLE `eb_community_topic` MODIFY COLUMN `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '话题名称' AFTER `id`;

ALTER TABLE `eb_coupon` ADD COLUMN `linked_data` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '关联数据' AFTER `is_del`;

ALTER TABLE `eb_coupon` ADD COLUMN `is_repeated` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否可重复领取' AFTER `linked_data`;

ALTER TABLE `eb_coupon` MODIFY COLUMN `category` tinyint(2) NOT NULL DEFAULT 1 COMMENT '类别 1-商家券, 2-商品券, 3-通用券，4-品类券，5-品牌券，6-跨店券' AFTER `publisher`;

ALTER TABLE `eb_coupon` MODIFY COLUMN `receive_type` tinyint(2) NOT NULL DEFAULT 1 COMMENT '领取类型 1-手动领取,2-商品赠送券,3-平台活动发放' AFTER `category`;

ALTER TABLE `eb_coupon_user` MODIFY COLUMN `category` tinyint(2) NOT NULL DEFAULT 1 COMMENT '类别 1-商家券, 2-商品券, 3-通用拳，4-品类券，5-品牌券，6-跨店券' AFTER `publisher`;

ALTER TABLE `eb_coupon_user` MODIFY COLUMN `receive_type` tinyint(2) NOT NULL DEFAULT 1 COMMENT '领取类型 1-手动领取,2-商品赠送券,3-平台活动发放' AFTER `category`;

ALTER TABLE `eb_marketing_activity` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券补贴金额' AFTER `data_date`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `integral_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '订单积分抵扣金额' AFTER `plat_coupon_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `order_refund_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '订单实际退款金额' AFTER `integral_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `order_refund_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `refund_integral_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还积分抵扣金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `refund_handling_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还手续费金额' AFTER `refund_integral_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '分佣' AFTER `refund_handling_fee`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `refund_brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还佣金' AFTER `brokerage_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `refund_merchant_transfer_amount` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还商户分账金额' AFTER `refund_brokerage_price`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `merchant_transfer_amount` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商户分账金额' AFTER `refund_merchant_transfer_amount`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '运费金额' AFTER `merchant_transfer_amount`;

ALTER TABLE `eb_merchant_daily_statement` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `freight_fee`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券补贴金额' AFTER `data_date`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `integral_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '订单积分抵扣金额' AFTER `plat_coupon_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `order_refund_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '订单实际退款金额' AFTER `integral_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `order_refund_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `refund_integral_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还积分抵扣金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `refund_handling_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还手续费金额' AFTER `refund_integral_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '分佣' AFTER `refund_handling_fee`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `refund_brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还佣金' AFTER `brokerage_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `merchant_transfer_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '商户分账金额' AFTER `refund_brokerage_price`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `refund_merchant_transfer_amount` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还商户分账金额' AFTER `merchant_transfer_amount`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '运费金额' AFTER `refund_merchant_transfer_amount`;

ALTER TABLE `eb_merchant_month_statement` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `freight_fee`;

ALTER TABLE `eb_merchant_order` ADD COLUMN `mer_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商户优惠券金额' AFTER `update_time`;

ALTER TABLE `eb_merchant_order` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券金额' AFTER `mer_coupon_price`;

ALTER TABLE `eb_order` ADD COLUMN `mer_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商户优惠券金额' AFTER `update_time`;

ALTER TABLE `eb_order` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券金额' AFTER `mer_coupon_price`;

ALTER TABLE `eb_order` ADD COLUMN `plat_coupon_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '平台优惠券id' AFTER `plat_coupon_price`;

ALTER TABLE `eb_order_detail` ADD COLUMN `mer_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商户优惠券金额' AFTER `update_time`;

ALTER TABLE `eb_order_detail` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券金额' AFTER `mer_coupon_price`;

ALTER TABLE `eb_order_detail` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券金额' AFTER `plat_coupon_price`;

ALTER TABLE `eb_order_detail` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券补贴金额' AFTER `update_time`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `plat_coupon_price`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `refund_profit_sharing_plat_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台分账金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `refund_profit_sharing_mer_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还商户分账金额' AFTER `refund_profit_sharing_plat_price`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `refund_first_brokerage_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还一级返佣金额' AFTER `refund_profit_sharing_mer_price`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `refund_second_brokerage_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还二级返佣金额' AFTER `refund_first_brokerage_fee`;

ALTER TABLE `eb_order_profit_sharing` ADD COLUMN `freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '运费金额' AFTER `refund_second_brokerage_fee`;

CREATE TABLE `eb_page_category`  (
                                             `id` int(10) NOT NULL AUTO_INCREMENT,
                                             `pid` int(10) NOT NULL DEFAULT 0 COMMENT '父类id',
                                             `type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'link' COMMENT '类型:link、special、product、product_category、custom',
                                             `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '分类名称',
                                             `sort` smallint(5) NOT NULL DEFAULT 0 COMMENT '排序',
                                             `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态',
                                             `add_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
                                             `level` tinyint(1) NOT NULL DEFAULT 0 COMMENT '层级',
                                             `is_mer` int(10) NOT NULL DEFAULT 0 COMMENT '是否商户  0平台，商户id',
                                             PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '页面链接分类' ROW_FORMAT = Dynamic;

CREATE TABLE `eb_page_diy`  (
                                        `id` int(11) NOT NULL AUTO_INCREMENT,
                                        `version` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '版本号',
                                        `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '页面名称',
                                        `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '网站标题',
                                        `cover_image` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '封面图',
                                        `template_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模板名称',
                                        `value` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '页面数据',
                                        `add_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
                                        `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                        `status` int(11) NOT NULL DEFAULT 0 COMMENT '是否使用',
                                        `type` int(1) NOT NULL DEFAULT 0 COMMENT '页面类型',
                                        `is_show` int(1) NOT NULL DEFAULT 0 COMMENT '显示首页',
                                        `is_bg_color` int(1) NOT NULL DEFAULT 0 COMMENT '颜色是否选中',
                                        `is_bg_pic` int(1) NOT NULL DEFAULT 0 COMMENT '背景图是否选中',
                                        `is_diy` int(1) NOT NULL DEFAULT 0 COMMENT '是否是diy数据',
                                        `color_picker` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '背景颜色',
                                        `bg_pic` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '背景图',
                                        `bg_tab_val` int(1) NOT NULL DEFAULT 0 COMMENT '背景图图片样式',
                                        `is_del` int(1) NOT NULL DEFAULT 0 COMMENT '是否删除',
                                        `return_address` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '返回地址',
                                        `title_bg_color` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '标题背景色',
                                        `title_color` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '标题颜色',
                                        `service_status` int(1) NOT NULL DEFAULT 1 COMMENT '商家样式',
                                        `mer_id` int(11) NOT NULL DEFAULT 0 COMMENT '商户ID',
                                        `is_default` int(1) NOT NULL DEFAULT 0 COMMENT '默认模板(1.平台默认 2.商户默认）',
                                        `text_position` int(1) NOT NULL DEFAULT 0 COMMENT '标题文本位置',
                                        PRIMARY KEY (`id`) USING BTREE,
                                        INDEX `template_name`(`template_name`, `type`) USING BTREE,
                                        INDEX `status_type`(`status`, `type`) USING BTREE,
                                        INDEX `mer_id`(`mer_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'DIY数据表' ROW_FORMAT = Dynamic;

CREATE TABLE `eb_page_link`  (
                                         `id` int(10) NOT NULL AUTO_INCREMENT,
                                         `cate_id` int(10) NOT NULL DEFAULT 0 COMMENT '分类id',
                                         `type` tinyint(1) NOT NULL DEFAULT 1 COMMENT '分组1:基础2:分销3:个人中心',
                                         `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '页面名称',
                                         `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '页面链接',
                                         `param` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '参数',
                                         `example` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '事例',
                                         `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态',
                                         `sort` smallint(5) NOT NULL DEFAULT 0 COMMENT '排序',
                                         `add_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
                                         `is_mer` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1是商户的链接',
                                         PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '页面链接' ROW_FORMAT = Dynamic;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券补贴金额' AFTER `integral_price`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `order_refund_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '订单实际退款金额' AFTER `plat_coupon_price`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `order_refund_price`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `refund_handling_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还手续费金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '分佣' AFTER `refund_handling_fee`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `refund_brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还佣金' AFTER `brokerage_price`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `refund_merchant_transfer_amount` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还商户分账金额' AFTER `refund_brokerage_price`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '运费金额' AFTER `refund_merchant_transfer_amount`;

ALTER TABLE `eb_platform_daily_statement` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `freight_fee`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '平台优惠券补贴金额' AFTER `integral_price`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `order_refund_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '订单实际退款金额' AFTER `plat_coupon_price`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `order_refund_price`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `refund_handling_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还手续费金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '分佣' AFTER `refund_handling_fee`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `refund_brokerage_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还佣金' AFTER `brokerage_price`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `refund_merchant_transfer_amount` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还商户分账金额' AFTER `refund_brokerage_price`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '运费金额' AFTER `refund_merchant_transfer_amount`;

ALTER TABLE `eb_platform_month_statement` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `freight_fee`;

ALTER TABLE `eb_product_attr` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_product_coupon` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_product_description` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_product_reply` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_product_rule` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_refund_order` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `update_time`;

ALTER TABLE `eb_refund_order` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_refund_order_info` ADD COLUMN `refund_plat_coupon_price` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退还平台优惠券补贴金额' AFTER `update_time`;

ALTER TABLE `eb_refund_order_info` ADD COLUMN `refund_freight_fee` decimal(8, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '退运费金额' AFTER `refund_plat_coupon_price`;

ALTER TABLE `eb_sms_template` ROW_FORMAT = COMPACT;

CREATE TABLE `eb_summary_financial_statements`  (
                                                            `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '帐单id',
                                                            `recharge_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '会员充值金额',
                                                            `recharge_num` int(10) NOT NULL DEFAULT 0 COMMENT '充值笔数',
                                                            `wechat_pay_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '微信支付金额',
                                                            `wechat_pay_num` int(10) NOT NULL DEFAULT 0 COMMENT '微信支付笔数',
                                                            `ali_pay_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '支付宝支付金额',
                                                            `ali_pay_num` int(10) NOT NULL DEFAULT 0 COMMENT '支付宝支付笔数',
                                                            `merchant_split_settlement` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '商户分账结算金额',
                                                            `merchant_split_settlement_num` int(10) NOT NULL DEFAULT 0 COMMENT '商户分账结算笔数',
                                                            `brokerage_settlement` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '佣金结算金额',
                                                            `brokerage_settlement_num` int(10) NOT NULL DEFAULT 0 COMMENT '佣金结算笔数',
                                                            `order_refund_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '订单退款金额',
                                                            `order_refund_num` int(10) NOT NULL DEFAULT 0 COMMENT '订单退款笔数',
                                                            `income_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '收入金额',
                                                            `payout_amount` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '支出金额',
                                                            `income_expenditure` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '日收支',
                                                            `data_date` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '日期：年-月-日',
                                                            PRIMARY KEY (`id`) USING BTREE,
                                                            INDEX `data_date`(`data_date`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '财务流水汇总表' ROW_FORMAT = DYNAMIC;

ALTER TABLE `eb_template_message` ROW_FORMAT = COMPACT;

ALTER TABLE `eb_user_balance_record` MODIFY COLUMN `balance` decimal(16, 2) NOT NULL DEFAULT 0.00 COMMENT '剩余' AFTER `amount`;

ALTER TABLE `eb_user_closing` MODIFY COLUMN `closing_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '结算类型：bank = 银行卡 alipay = 支付宝 wechat=微信' AFTER `uid`;

ALTER TABLE `eb_wechat_live_room` MODIFY COLUMN `end_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '直播预计结束时间' AFTER `start_time`;

ALTER TABLE `qrtz_triggers` ADD CONSTRAINT `QRTZ_TRIGGERS_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `QRTZ_JOB_DETAILS` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT;

SET FOREIGN_KEY_CHECKS=1;

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
