package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.bcx.BcxDepartmentMemberServe;
import com.zbkj.service.dao.BcxDepartmentMemberServeDao;
import com.zbkj.service.service.BcxDepartmentMemberServeService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * description: 部门成员服务表 服务实现类
 * author : linchunpeng
 * date : 2023/8/3
 */
@Service
public class BcxDepartmentMemberServeServiceImpl extends ServiceImpl<BcxDepartmentMemberServeDao, BcxDepartmentMemberServe> implements BcxDepartmentMemberServeService {
    
    @Resource
    private BcxDepartmentMemberServeDao dao;

    /**
     * description：通过部门成员-v5的id、公司id，判断是否在成员服务的公司范围里面
     * author：linchunpeng
     * date：2023/11/13
     */
    @Override
    public boolean isDepartmentMemberServe(String bcxId, List<String> orgIdList) {
        if (CollectionUtil.isEmpty(orgIdList)) {
            return false;
        }
        LambdaQueryWrapper<BcxDepartmentMemberServe> lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxDepartmentMemberServe::getBcxId, bcxId);
        lqw.in(BcxDepartmentMemberServe::getOrgId, orgIdList);
        List<BcxDepartmentMemberServe> list = dao.selectList(lqw);
        if (CollectionUtil.isNotEmpty(list)) {
            return true;
        }
        return false;
    }

}