/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.model.system.SystemGroupData;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemFormItemCheckRequest;
import com.zbkj.common.request.SystemGroupDataRequest;
import com.zbkj.common.request.SystemGroupDataSearchRequest;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.SystemGroupDataDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemFormTempService;
import com.zbkj.service.service.SystemGroupDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemGroupDataServiceImpl
extends ServiceImpl<SystemGroupDataDao, SystemGroupData>
implements SystemGroupDataService {
    @Resource
    private SystemGroupDataDao dao;
    @Autowired
    private SystemFormTempService systemFormTempService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public List<SystemGroupData> getList(SystemGroupDataSearchRequest request, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        request.setKeywords(URLUtil.decode((String)request.getKeywords()));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        SystemGroupData model = new SystemGroupData();
        BeanUtils.copyProperties((Object)request, (Object)model);
        lambdaQueryWrapper.setEntity((Object)model);
        ((LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(SystemGroupData::getSort)).orderByAsc(SystemGroupData::getId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean create(SystemGroupDataRequest systemGroupDataRequest) {
        this.systemFormTempService.checkForm(systemGroupDataRequest.getForm());
        SystemGroupData systemGroupData = new SystemGroupData();
        systemGroupData.setGid(systemGroupDataRequest.getGid());
        String value = JSONObject.toJSONString((Object)systemGroupDataRequest.getForm());
        value = this.systemAttachmentService.clearPrefix(value);
        systemGroupData.setValue(value);
        systemGroupData.setSort(systemGroupDataRequest.getForm().getSort());
        systemGroupData.setStatus(systemGroupDataRequest.getForm().getStatus());
        return this.save(systemGroupData);
    }

    @Override
    public Boolean update(Integer id, SystemGroupDataRequest request) {
        this.systemFormTempService.checkForm(request.getForm());
        SystemGroupData systemGroupData = new SystemGroupData();
        systemGroupData.setId(id);
        systemGroupData.setGid(request.getGid());
        String value = JSONObject.toJSONString((Object)request.getForm());
        value = this.systemAttachmentService.clearPrefix(value);
        systemGroupData.setValue(value);
        systemGroupData.setSort(request.getForm().getSort());
        systemGroupData.setStatus(request.getForm().getStatus());
        return this.updateById(systemGroupData);
    }

    @Override
    public <T> List<T> getListByGid(Integer gid, Class<T> cls) {
        SystemGroupDataSearchRequest systemGroupDataSearchRequest = new SystemGroupDataSearchRequest();
        systemGroupDataSearchRequest.setGid(gid);
        systemGroupDataSearchRequest.setStatus(Boolean.valueOf(true));
        List<SystemGroupData> list = this.getList(systemGroupDataSearchRequest, new PageParamRequest());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list.size() < 1) {
            return null;
        }
        for (SystemGroupData systemGroupData : list) {
            JSONObject jsonObject = JSONObject.parseObject((String)systemGroupData.getValue());
            List systemFormItemCheckRequestList = CrmebUtil.jsonToListClass((String)jsonObject.getString("fields"), SystemFormItemCheckRequest.class);
            if (systemFormItemCheckRequestList.size() < 1) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (SystemFormItemCheckRequest systemFormItemCheckRequest : systemFormItemCheckRequestList) {
                map.put(systemFormItemCheckRequest.getName(), systemFormItemCheckRequest.getValue());
            }
            map.put("id", systemGroupData.getId());
            Object t = CrmebUtil.mapToObj(map, cls);
            arrayList.add(t);
        }
        return arrayList;
    }

    @Override
    public List<HashMap<String, Object>> getListMapByGid(Integer gid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemGroupData::getGid, (Object)gid);
        lqw.eq(SystemGroupData::getStatus, (Object)true);
        ((LambdaQueryWrapper)lqw.orderByDesc(SystemGroupData::getSort)).orderByAsc(SystemGroupData::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        if (CollUtil.isEmpty((Collection)list)) {
            return arrayList;
        }
        for (SystemGroupData systemGroupData : list) {
            JSONObject jsonObject = JSONObject.parseObject((String)systemGroupData.getValue());
            List systemFormItemCheckRequestList = CrmebUtil.jsonToListClass((String)jsonObject.getString("fields"), SystemFormItemCheckRequest.class);
            if (systemFormItemCheckRequestList.size() < 1) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (SystemFormItemCheckRequest systemFormItemCheckRequest : systemFormItemCheckRequestList) {
                map.put(systemFormItemCheckRequest.getName(), systemFormItemCheckRequest.getValue());
            }
            map.put("id", systemGroupData.getId());
            arrayList.add(map);
        }
        return arrayList;
    }

    @Override
    public <T> T getNormalInfo(Integer groupDataId, Class<T> cls) {
        SystemGroupData systemGroupData = (SystemGroupData)this.getById(groupDataId);
        if (null == systemGroupData || !systemGroupData.getStatus().booleanValue()) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)systemGroupData.getValue());
        List systemFormItemCheckRequestList = CrmebUtil.jsonToListClass((String)jsonObject.getString("fields"), SystemFormItemCheckRequest.class);
        if (systemFormItemCheckRequestList.size() < 1) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SystemFormItemCheckRequest systemFormItemCheckRequest : systemFormItemCheckRequestList) {
            map.put(systemFormItemCheckRequest.getName(), systemFormItemCheckRequest.getValue());
        }
        map.put("id", systemGroupData.getId());
        Object t = CrmebUtil.mapToObj(map, cls);
        return (T)t;
    }

    @Override
    public List<SystemGroupData> findListByGid(Integer gid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemGroupData::getGid, (Object)gid);
        ((LambdaQueryWrapper)lqw.orderByDesc(SystemGroupData::getSort)).orderByAsc(SystemGroupData::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean deleteByGid(Integer gid) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(SystemGroupData::getGid, (Object)gid);
        int delete = this.dao.delete((Wrapper)luw);
        if (delete > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

