/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.record.SensitiveMethodLog;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.SensitiveMethodLogDao;
import com.zbkj.service.service.SensitiveMethodLogService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SensitiveMethodLogServiceImpl
extends ServiceImpl<SensitiveMethodLogDao, SensitiveMethodLog>
implements SensitiveMethodLogService {
    @Resource
    private SensitiveMethodLogDao dao;

    @Override
    public void addLog(SensitiveMethodLog methodLog) {
        this.save(methodLog);
    }

    private PageInfo<SensitiveMethodLog> getPageList(Integer merId, PageParamRequest pageParamRequest) {
        Page logPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SensitiveMethodLog::getMerId, (Object)merId);
        lqw.orderByDesc(SensitiveMethodLog::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)logPage, (List)list);
    }

    @Override
    public PageInfo<SensitiveMethodLog> getPlatformPageList(PageParamRequest pageParamRequest) {
        return this.getPageList(0, pageParamRequest);
    }

    @Override
    public PageInfo<SensitiveMethodLog> getMerchantPageList(PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        return this.getPageList(systemAdmin.getMerId(), pageParamRequest);
    }
}

