package com.zbkj.service.wangshang.api.domain.model.order;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 *  协议授权代扣查询结果
 * <ant.mybank.bkcloudfunds.unifiedorder.traderesult.query>
 * */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name ="body")
public class BkcloudfundsUnifiedorderTraderesultQueryRequestModel extends RequestBody {


    private static final long serialVersionUID = 917559848992066465L;

    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 当前交易操作交易号
     * */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OperateNo")
    private String operateNo;

    /**
     * 原外部订单请求流水号
     * */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;


    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOperateNo() {
        return operateNo;
    }

    public void setOperateNo(String operateNo) {
        this.operateNo = operateNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }
}