package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 行业小程序订单信息查询<ant.mybank.bkcloudfunds.unifiedorder.query>
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsUnifiedOrderQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = 2712390620021484224L;

    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 网商订单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 外部流水号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 订单类型
     */
    @XmlElement(name = "OrderType")
    private String orderType;

    /**
     * 状态
     * <p>
     * DEALING 待支付
     * CLOSE 订单关闭
     * SUCCESS 支付成功
     * FAIL 订单失败
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 预付金额(金额为分)
     */
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 币种，默认CNY
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 付方ID
     * <p>
     * 若Type为
     * MERCHANT，ID为商户号
     */
    @XmlElement(name = "PayerId")
    private String payerId;

    /**
     * 付方名称
     */
    @XmlElement(name = "PayerName")
    private String payerName;

    /**
     * 付方类型
     * <p>
     * MERCHANT
     */
    @XmlElement(name = "PayerType")
    private String payerType;

    /**
     * 收方ID
     */
    @XmlElement(name = "PayeeId")
    private String payeeId;

    /**
     * 收方类型
     */
    @XmlElement(name = "PayeeType")
    private String payeeType;


    /**
     * 合并支付时，明细单列表
     * <p>
     * map的json格式base64encode
     */
    @XmlElement(name = "SubOrderList")
    private String subOrderList;

    /**
     * 错误码
     * FAIL时出现
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 错误描述
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    /**
     * 支付方式 支付完成才会有此字段；
     * 后续产品功能升级，有新增支付工具，这个地方也会更新；
     * CLOUD_FUNDS_ACCOUNT，表示云资金余额
     * MYBANK_CURRENT_CARD，表示网商活期
     * EXTEND_BANK_CARD，表示外部他行卡
     * ALIPAY_CONNECTED_ACCOUNT，表示支付宝余额
     * UNKNOWN，未知状态，一般不会出现，属于系统数据异常；
     */
    @XmlElement(name = "PayAssetType")
    private String payAssetType;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPayerId() {
        return payerId;
    }

    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getPayerType() {
        return payerType;
    }

    public void setPayerType(String payerType) {
        this.payerType = payerType;
    }

    public String getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public String getPayeeType() {
        return payeeType;
    }

    public void setPayeeType(String payeeType) {
        this.payeeType = payeeType;
    }

    public String getSubOrderList() {
        return subOrderList;
    }

    public void setSubOrderList(String subOrderList) {
        this.subOrderList = subOrderList;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public String getPayAssetType() {
        return payAssetType;
    }

    public void setPayAssetType(String payAssetType) {
        this.payAssetType = payAssetType;
    }
}