package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradeSettlementEnchashmentRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 取现接口 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeSettlementEnchashmentRequest.class)
public class V2TradeSettlementEnchashment {

    public static V2TradeSettlementEnchashmentRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeSettlementEnchashmentRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeSettlementEnchashmentRequest.class);
//        V2TradeSettlementEnchashmentRequest request = new V2TradeSettlementEnchashmentRequest();
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 取现金额
//        request.setCashAmt("0.01");
        // 取现方ID号
//        request.setHuifuId("6666000021291985");
        // 到账日期类型
//        request.setIntoAcctDateType("T0");
        // 取现卡序列号
//        request.setTokenNo("10004053462");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 异步通知地址
        extendInfoMap.put("notify_url", map.get("notifyUrl"));
        // 备注
        // extendInfoMap.put("remark", "");
        // 账户号
        // extendInfoMap.put("acct_id", "");
        return extendInfoMap;
    }

}
