package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.response.BcxSettleBillResponse;
import com.zbkj.common.response.BcxSettleBillStatisticsResponse;

import java.util.List;
import java.util.Map;

/**
 * description: 业绩账单表 Mapper
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxSettleBillDao extends BaseMapper<BcxSettleBill> {

    /**
     * 查询渠道商业绩账单
     */
    List<BcxSettleBillResponse> selectChannelList(Map<String, Object> paramMap);

    /**
     * 查询部门业绩账单
     */
    List<BcxSettleBillResponse> selectDepartmentList(Map<String, Object> paramMap);

    /**
     * 查询部门成员业绩账单
     */
    List<BcxSettleBillResponse> selectDepartmentMemberList(Map<String, Object> paramMap);

    /**
     * 查询分销商业绩账单
     */
    List<BcxSettleBillResponse> selectFxsList(Map<String, Object> paramMap);

    /**
     * 查询分销员业绩账单
     */
    List<BcxSettleBillResponse> selectFxyList(Map<String, Object> paramMap);

    /**
     * 查询user业绩账单
     */
    List<BcxSettleBillResponse> selectUserList(Map<String, Object> paramMap);


    /**
     * 渠道商业绩账单统计
     */
    BcxSettleBillStatisticsResponse selectChannelCount(Map<String, Object> paramMap);

    /**
     * 部门业绩账单统计
     */
    BcxSettleBillStatisticsResponse selectDepartmentCount(Map<String, Object> paramMap);

    /**
     * 部门成员业绩账单统计
     */
    BcxSettleBillStatisticsResponse selectDepartmentMemberCount(Map<String, Object> paramMap);

    /**
     * 分销商业绩账单统计
     */
    BcxSettleBillStatisticsResponse selectFxsCount(Map<String, Object> paramMap);

    /**
     * 分销员业绩账单统计
     */
    BcxSettleBillStatisticsResponse selectFxyCount(Map<String, Object> paramMap);

    /**
     * user业绩账单统计
     */
    BcxSettleBillStatisticsResponse selectUserCount(Map<String, Object> paramMap);
   
}