/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.model.huifu.HuifuWalletTranslog;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.dao.HuifuWalletTranslogDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsRefundNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsRefundNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsRefundNotifyService")
public class BkcloudfundsRefundNotifyServiceImpl
implements MybankNotifyService {
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private HuifuWalletTranslogDao huifuWalletTranslogDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String xmlContext, String function) throws Exception {
        BkcloudfundsRefundNotifyRequest refundNotifyRequest = XmlConverter.getInstance().toResponse(xmlContext, BkcloudfundsRefundNotifyRequest.class);
        RequestHead head = refundNotifyRequest.getBkcloudfundsRefundNotify().getRequestHead();
        boolean flag = this.saveNotify(refundNotifyRequest.getBkcloudfundsRefundNotify().getBkcloudfundsRefundNotifyModel());
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u652f\u4ed8\u9000\u56de\u901a\u77e5\u63a5\u53e3\uff08\u5f02\u6b65\u63a5\u53e3\uff09\uff1aant.mybank.bkcloudfunds.refund.notify", "1", xmlContext, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsRefundNotifyModel model) {
        System.out.println("====== > \u63d0\u73b0\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff08\u5f02\u6b65\u63a5\u53e3\uff09\uff1a" + JSONObject.toJSONString((Object)model));
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getRefundOrderNo());
        if (!"0".equals(trade.getTradeStatus())) {
            return true;
        }
        if (trade != null) {
            this.saveAccountDetail(trade, model);
        }
        HuifuWalletTranslog translog = this.huifuWalletTranslogDao.getByTransId(model.getRefundOrderNo());
        translog.setUpdateTime(new Date());
        translog.setTransDate(model.getRefundFinishDate().substring(0, 8));
        String transStat = model.getStatus().equals("SUCCESS") ? "\u6210\u529f" : (model.getStatus().equals("FAIL") ? "\u5931\u8d25" : "\u5904\u7406\u4e2d");
        translog.setTransStat(transStat);
        translog.setTransDesc(model.getErrorDesc());
        this.huifuWalletTranslogDao.updateById(translog);
        return true;
    }

    private void saveAccountDetail(HuifuWalletTrade trade, BkcloudfundsRefundNotifyModel model) {
        if ("SUCCESS".equals(model.getStatus())) {
            trade.setUpdateTime(new Date());
            if (StringUtil.isNotEmpty((String)model.getRefundFinishDate())) {
                trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getRefundFinishDate(), (String)"yyyyMMddHHmmss")));
            }
            trade.setTradeStatus(Constants.tradeStatus((String)"S"));
        } else if ("FAIL".equals(model.getStatus())) {
            if (StringUtil.isNotEmpty((String)model.getRefundFinishDate())) {
                trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getRefundFinishDate(), (String)"yyyyMMddHHmmss")));
            }
            trade.setErrorMsg(model.getErrorDesc());
            trade.setUpdateTime(new Date());
            trade.setTradeStatus(Constants.tradeStatus((String)"F"));
        }
        this.huifuWalletTradeDao.updateById(trade);
    }
}

