package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 发票申请单请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxFapiaoApplyRequest对象", description = "发票申请单请求对象")
public class BcxFapiaoApplyRequest implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "开票时间：为空-全部,today,yesterday,lately7,lately30,week,preWeek,month,preMonth,year,preYear")
    private String fapiaoTime;

    @ApiModelProperty(value = "申请时间：为空-全部,today,yesterday,lately7,lately30,week,preWeek,month,preMonth,year,preYear")
    private String applyTime;

    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    @ApiModelProperty(value = "开票方")
    private String writer;

    @ApiModelProperty(value = "收票方")
    private String receiver;

    @ApiModelProperty(value = "费用类型：0-商品购买 1-平台服务费 2-渠道服务费 3-分销服务费")
    private Integer sourceType;

    @ApiModelProperty(value = "发票号")
    private String fapiaoNo;

    @ApiModelProperty(value = "状态 0-未开票 1-已开票 2-开票中 3-开票失败")
    private Integer fapiaoStatus;
}
