package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * description：业绩报表查询请求对象
 * author：linchunpeng
 * date：2023/8/14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPerformanceReportSearchRequest对象", description = "业绩报表查询请求对象")
public class BcxPerformanceReportSearchRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "today,yesterday,lately7,lately30,month,year,/yyyy-MM-dd hh:mm:ss,yyyy-MM-dd hh:mm:ss/")
    private String dateLimit;

    @ApiModelProperty(value = "分销员姓名/渠道商名称/部门名称/部门成员姓名")
    private String name;

    @ApiModelProperty(value = "分销员手机")
    private String brokerageUserPhone;

    @ApiModelProperty(value = "结算状态：1待生效，2冻结中，3待结算，4结算中，5已结算，6无效，多个,隔开")
    private String settleStatus;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "订单区域(只传省份，筛选条件只显示省份即可)")
    private String orderRegionCode;

    @ApiModelProperty(value = "下单客户名称")
    private String orderUserName;

    @ApiModelProperty(value = "用户id")
    private Integer userId;

    @ApiModelProperty(value = "账单id")
    private Long settleBillId;

    @ApiModelProperty(value = "结算单id")
    private Long settleId;

    @ApiModelProperty(value = "账单id列表")
    private List<Long> settleBillIdList;

    @ApiModelProperty(value = "v5平台id（v5调用商城的链接，需要必传，链接会带过来）")
    private String bcxId;

    @ApiModelProperty(value = "上级用户id")
    private Integer spreadUid;

    @ApiModelProperty(value = "查询类型：1-渠道，2-部门，3-部门成员，4-分销商，5-分销员")
    private Integer searchType;

}
