package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * description：佣金配置保存request对象
 * author：linchunpeng
 * date：2023/8/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxBrokerageConfigRequest对象", description = "佣金配置保存request对象")
public class BcxBrokerageConfigRequest {

    @ApiModelProperty(value = "商品id列表（有传就是设置商品，没传就是设置默认配置）")
    private List<Integer> productIdList;

    @ApiModelProperty(value = "佣金计算方式：0默认佣金，1单独设置")
    private Integer isSub;

    @ApiModelProperty(value = "商品最大分佣比例")
    @Range(min = 0, max = 100, message = "商品最大分佣比例请在0-100中选择")
    private Integer maxBrokerage;

    @ApiModelProperty(value = "分销一级返佣比例")
    @Range(min = 0, max = 100, message = "一级返佣比例请在0-100中选择")
    private Integer retailStoreBrokerageFirstRatio;

    @ApiModelProperty(value = "分销二级返佣比例")
    @Range(min = 0, max = 100, message = "二级返佣比例在0-100中选择")
    private Integer retailStoreBrokerageSecondRatio;

    @ApiModelProperty(value = "渠道佣金设置列表（每次修改都要传全部的给到后端，不然会认为是删除配置）")
    private List<BcxBrokerageConfigDetailRequest> configChannelList;

    @ApiModelProperty(value = "部门佣金设置列表（每次修改都要传全部的给到后端，不然会认为是删除配置）")
    private List<BcxBrokerageConfigDetailRequest> configDepartmentList;

    @ApiModelProperty(value = "部门成员佣金设置列表（每次修改都要传全部的给到后端，不然会认为是删除配置）")
    private List<BcxBrokerageConfigDetailRequest> configDepartmentMemberList;

}
