package com.zbkj.common.utils;

import cn.hutool.core.util.ZipUtil;
import org.apache.commons.io.FileUtils;

import java.io.*;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {

    /**
     * 从网络地址下载文件到本地
     *
     * @param url      网络文件地址
     * @param dir      本地目录
     * @param fileName 文件名
     * @return 下载之后的本地文件地址
     */
    public static String downloadHttpUrl(String url, String dir, String fileName) {
        try {
            URL httpurl = new URL(url);
            File dirfile = new File(dir);
            if (!dirfile.exists()) {
                dirfile.mkdirs();
            }
            FileUtils.copyURLToFile(httpurl, new File(dir + fileName));
            return dir + fileName;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File upzip(String zipFilePath, String outFileDir) {
        /**
         * 解压ZIP包
         * 第一个参数是本地文件路径
         * 第二个参数是解压后的文件路径
         */
        return ZipUtil.unzip(zipFilePath, outFileDir);
    }

    /**
     * 处理csv文件
     *
     * @param filePath charset:GBK UTF-8
     * @return 文件内容list<String>
     */
    public static List<String> readCsv(String filePath, String charset) {
        List<String> allLines = new ArrayList<>();

        try {
            File csv = new File(filePath);
            csv.setReadable(true);//设置可读
            // csv.setWritable(true);//设置可写
            BufferedReader br = null;
            InputStreamReader isr = new InputStreamReader(new FileInputStream(csv), charset);//charset=GBK UTF-8
            br = new BufferedReader(isr);
            String line = "";

            while ((line = br.readLine()) != null) {
                allLines.add(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

        return allLines;
    }
}
