package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="BcxOrderRelationResponse对象", description="订单关联响应对象")
public class BcxOrderRelationResponse {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单明细id")
    private Integer orderDetailId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "主订单号")
    private String masterOrderNo;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "实际支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty(value = "购买数量")
    private Integer payNum;

    @ApiModelProperty(value = "是否主订单")
    public boolean isMaster(){
        return orderNo.equals(masterOrderNo);
    }
}
