package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * description：结算单查询请求对象
 * author：linchunpeng
 * date：2023/8/14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSettleSearchRequest对象", description = "结算单查询请求对象")
public class BcxSettleSearchRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "分销员姓名/分销商姓名/渠道商名称/部门名称/部门成员姓名")
    private String name;

    @ApiModelProperty(value = "结算单号")
    private String settleNo;

    @ApiModelProperty(value = "结算状态：1待结算，2已结算")
    private Integer settleStatus;

    @ApiModelProperty(value = "账期-开始，yyyy-MM")
    private String billPeriodStart;

    @ApiModelProperty(value = "账期-结束，yyyy-MM")
    private String billPeriodEnd;

    @ApiModelProperty(value = "发票/结算凭证：1已上传，2未上传")
    private Integer uploadAttachments;

    @ApiModelProperty(value = "today,yesterday,lately7,lately30,month,year,/yyyy-MM-dd hh:mm:ss,yyyy-MM-dd hh:mm:ss/")
    private String dateLimit;

    @ApiModelProperty(value = "用户id")
    private Integer userId;

    @ApiModelProperty(value = "v5平台id（v5调用商城的链接，需要必传，链接会带过来）")
    private String bcxId;

    @ApiModelProperty(value = "上级用户id")
    private Integer spreadUid;

    @ApiModelProperty(value = "查询类型：1-渠道，2-部门，3-部门成员，4-分销商，5-分销员")
    private Integer searchType;

}
