package com.zbkj.common.model.user;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 用户账号关联表
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_user_relation")
@ApiModel(value = "BcxUserRelation对象", description = "用户账号关联表")
public class BcxUserRelation implements Serializable {

    private static final long serialVersionUID = 154648736546L;

    @ApiModelProperty(value = "用户账号关联id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id ;

    @ApiModelProperty(value = "用户id")
    private Integer uid ;

    @ApiModelProperty(value = "关联用户id")
    private Integer subUid ;
}
