package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * description: 渠道表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_channel")
@ApiModel(value = "BcxChannel对象", description = "渠道表")
public class BcxChannel implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "平台id")
    private String bcxId;
    
    @ApiModelProperty(value = "渠道名称")
    private String name;

    @ApiModelProperty(value = "合作开始时间，时分秒为：00:00:00")
    private Date cooperationStartTime;

    @ApiModelProperty(value = "合作结束时间，时分秒为：23:59:59")
    private Date cooperationEndTime;

    @ApiModelProperty(value = "签单人id（bcx_department_member的id）")
    private Long signPeopleId;

    @ApiModelProperty(value = "客服人员id（bcx_department_member的id）")
    private Long servePeopleId;

    @ApiModelProperty(value = "状态：0无效，1有效")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    

}