/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.wallet;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.IdcardUtils;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.ObjectUtils;
import com.bcxin.platform.domain.wallet.ComWallet;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletAccountDetail;
import com.bcxin.platform.domain.wallet.ComWalletProcess;
import com.bcxin.platform.domain.wallet.ComWalletReconciliation;
import com.bcxin.platform.domain.wallet.ComWalletTrade;
import com.bcxin.platform.dto.wallet.ComCheckTransferDTO;
import com.bcxin.platform.dto.wallet.ComSubsidyGrantEvent;
import com.bcxin.platform.dto.wallet.ComWalletAccountDTO;
import com.bcxin.platform.dto.wallet.ComWalletAccountDetailDTO;
import com.bcxin.platform.dto.wallet.ComWalletConsumeLedgerDTO;
import com.bcxin.platform.dto.wallet.ComWalletTradeDTO;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.log.SysSmsLogMapper;
import com.bcxin.platform.mapper.wallet.ComSubsidyGrantEventMapper;
import com.bcxin.platform.mapper.wallet.ComWalletAccountDetailMapper;
import com.bcxin.platform.mapper.wallet.ComWalletAccountMapper;
import com.bcxin.platform.mapper.wallet.ComWalletMapper;
import com.bcxin.platform.mapper.wallet.ComWalletProcessMapper;
import com.bcxin.platform.mapper.wallet.ComWalletReconciliationMapper;
import com.bcxin.platform.mapper.wallet.ComWalletTradeMapper;
import com.bcxin.platform.service.bbd.BbdTestService;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.ComTaskResidualAPIService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.service.wallet.ComWalletService;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.PageInfoUtils;
import com.bcxin.platform.util.ThreadPool;
import com.bcxin.platform.util.constants.PaymentServiceConst;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.bcxin.platform.util.file.BcxinFileUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="comWalletService")
@Transactional(value="transactionManager")
public class ComWalletServiceImpl
implements ComWalletService {
    @Resource
    private ComWalletMapper comWalletMapper;
    @Resource
    private ComWalletAccountMapper comWalletAccountMapper;
    @Resource
    private ComWalletAccountDetailMapper comWalletAccountDetailMapper;
    @Resource
    private ComWalletProcessMapper comWalletProcessMapper;
    @Resource
    private ComWalletTradeMapper comWalletTradeMapper;
    @Resource
    private TaskCacheService taskCacheService;
    @Resource
    private CommonService commonService;
    @Resource
    private ComTaskResidualAPIService comTaskResidualAPIService;
    @Resource
    private ComWalletReconciliationMapper comWalletReconciliationMapper;
    @Resource
    private ComSubsidyGrantEventMapper comSubsidyGrantEventMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private BbdTestService bbdTestService;
    @Resource
    private SysSmsLogMapper sysSmsLogMapper;
    @Resource
    private IdWorker idWorker;
    @Resource
    private RedisUtil redisUtil;
    private static final String TRANSFERKEY = "Transfer:";

    @Override
    public Result getComWalletServiceOpenInfo(ComWallet comWallet) throws V5BusinessException {
        if (comWallet.getComId() == null) {
            return Result.tokenExpired((String)"\u767b\u5f55\u8d85\u65f6\u6216\u8005\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        comWallet = StringUtils.isEmpty((String)comWallet.getTlkComId()) ? this.comWalletMapper.getComWalletByComId(comWallet.getComId()) : this.comWalletMapper.getComWalletByTLKComId(comWallet.getTlkComId());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (comWallet == null) {
            resultMap.put("isCompleteOpen", "0");
            resultMap.put("isAuthorize", "0");
        } else {
            resultMap.put("isCompleteOpen", comWallet.getIsCompleteOpen());
            resultMap.put("isAuthorize", "1");
        }
        return Result.success((String)"", resultMap);
    }

    @Override
    public Result getComWalletCurrentProcess(ComWalletProcess dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            return Result.tokenExpired((String)"\u767b\u5f55\u8d85\u65f6\u6216\u8005\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        ComWalletProcess processDB = this.comWalletProcessMapper.getComWalletCurrentProcess(dto.getComId());
        if (processDB == null) {
            this.comWalletProcessMapper.insertComWalletProcess(dto.getComId(), "openAccountStepDesc");
            processDB = this.comWalletProcessMapper.getComWalletCurrentProcess(dto.getComId());
        }
        return Result.success((String)"", (Object)processDB);
    }

    @Override
    public Result sendVerifyCode(ComWalletAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = this.idWorker.nextId();
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("id", this.getMemberNo(dto.getComId() + ""));
        p.put("mobilePhone", dto.getMobilePhone());
        p.put("smsType", dto.getSmsType());
        if (Integer.parseInt(dto.getSmsType()) == 12) {
            p.put("orderId", orderId + "");
            p.put("amount", dto.getAmount());
        }
        if (Integer.parseInt(dto.getSmsType()) == 13) {
            String verifyCode = this.commonService.sendCode(dto.getMobilePhone());
            this.taskCacheService.setActiveCodeSerial(dto.getMobilePhone(), verifyCode);
            return Result.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f", (Object)orderId);
        }
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/fbank/public/verify/sms"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) {
            return Result.fail((String)result.getMsg());
        }
        Map map = (Map)result.getData();
        this.taskCacheService.setActiveCodeSerial(dto.getMobilePhone(), map.get("msgInfo").toString());
        return Result.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f", (Object)orderId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result saveAccountInfo(ComWalletAccountDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty((String)activeCodeSerial)) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isEmpty((String)dto.getComName())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getFmComType())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getComCerType())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getContractPhone())) {
            throw new V5BusinessException("-1", "\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessAddress())) {
            throw new V5BusinessException("-1", "\u7ecf\u8425\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLegalRepName())) {
            throw new V5BusinessException("-1", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdCardType())) {
            throw new V5BusinessException("-1", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdCardNo())) {
            throw new V5BusinessException("-1", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(dto.getIdCardType()) && !IdcardUtils.validateCard((String)dto.getIdCardNo())) {
            throw new V5BusinessException("-1", "\u6cd5\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty((String)dto.getLegalRepPhone())) {
            throw new V5BusinessException("-1", "\u6cd5\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLegalRepPlace())) {
            throw new V5BusinessException("-1", "\u6cd5\u4eba\u5e38\u4f4f\u5730\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdCardStartDate())) {
            throw new V5BusinessException("-1", "\u8eab\u4efd\u8bc1\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdCardEndDate())) {
            throw new V5BusinessException("-1", "\u8eab\u4efd\u8bc1\u6709\u6548\u671f\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        String operType = "1";
        if (account != null) {
            operType = "2";
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.getMemberNo(dto.getComId() + ""));
        p.put("comName", dto.getComName());
        p.put("comCerType", dto.getComCerType());
        p.put("comCerNo", dto.getComCerNo());
        p.put("legalRepName", dto.getLegalRepName());
        p.put("idCardNo", dto.getIdCardNo());
        p.put("idCardType", dto.getIdCardType());
        p.put("legalRepPhone", dto.getLegalRepPhone());
        p.put("legalRepPlace", dto.getLegalRepPlace());
        p.put("mobilePhone", dto.getMobilePhone());
        p.put("bankCode", dto.getBankCode());
        p.put("bankCardNo", dto.getBankCardNo());
        String dealName = this.perBaseInfoMapper.getNameById(dto.getCreateBy());
        p.put("dealName", dealName);
        p.put("icpCode", "\u95fdICP\u590714018517\u53f7");
        p.put("operType", operType);
        p.put("callbackUrl", "");
        p.put("corporationIdStartDate", dto.getIdCardStartDate());
        p.put("corporationIdEndDate", dto.getIdCardEndDate());
        p.put("businessLocation", dto.getBusinessAddress());
        p.put("enterprisePhone", dto.getContractPhone());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/com/register"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) return Result.fail((String)result.getMsg());
        dto.setWalletAccountNo("0");
        Date now = new Date();
        if ("1".equals(operType)) {
            dto.setCreateTime(now);
            this.comWalletAccountMapper.insertComWalletAccount(dto);
            ComWalletProcess comWalletProcess = new ComWalletProcess();
            comWalletProcess.setComId(dto.getComId());
            comWalletProcess.setUpdateTime(now);
            comWalletProcess.setUpdateBy(dto.getUpdateBy());
            comWalletProcess.setStep(1);
            comWalletProcess.setIsComplete("1");
            this.comWalletProcessMapper.updateComWalletProcess(comWalletProcess);
            this.comWalletProcessMapper.insertComWalletProcess(dto.getComId(), "confirmAccountStepDesc");
            ComWallet comWallet = new ComWallet();
            comWallet.setComId(dto.getComId());
            comWallet.setCreateTime(now);
            comWallet.setCreateBy(dto.getCreateBy());
            comWallet.setIsCompleteOpen("0");
            this.comWalletMapper.insertComWallet(comWallet);
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        } else {
            if (!"2".equals(operType)) return Result.fail((String)"\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e1a\u52a1\u65e0\u6548");
            dto.setUpdateBy(dto.getUpdateBy());
            dto.setUpdateTime(now);
            this.comWalletAccountMapper.updateComWalletAccountAll(dto);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private String getMemberNo(String comId) {
        String memberNo = this.comWalletMapper.getMerchantNoByComId(Long.parseLong(comId));
        String envi = this.commonService.getSystemConfig("PLATFORM_SIGN");
        if (Objects.equals(envi, "PASP-NC")) {
            memberNo = "961981641130291200".equals(memberNo) ? "cykhdshou009" : ("948152662251671552".equals(memberNo) ? "cyk666" : ("971861431804100608".equals(memberNo) ? "yybsend101" : memberNo.substring(memberNo.length() - 15, memberNo.length())));
        } else if (memberNo.length() > 15) {
            memberNo = memberNo.substring(memberNo.length() - 15, memberNo.length());
        }
        return memberNo;
    }

    @Override
    public Result saveAccountInfoStepTwo(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)comWalletAccount.getComCerUrl())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u8bc1\u4ef6\u626b\u63cf\u4ef6\u5fc5\u987b\u4e0a\u4f20");
        }
        ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByComId(comWalletAccount.getComId());
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.getMemberNo(comWalletAccount.getComId() + ""));
        p.put("comCerType", account.getComCerType());
        p.put("comCerNo", account.getComCerNo());
        p.put("comCerUrl", comWalletAccount.getComCerUrl());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/fbank/com/material/verify"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) {
            return Result.fail((String)result.getMsg());
        }
        Date now = new Date();
        comWalletAccount.setUpdateTime(now);
        this.comWalletAccountMapper.updateComWalletAccount(comWalletAccount);
        ComWalletProcess comWalletProcess = new ComWalletProcess();
        comWalletProcess.setComId(comWalletAccount.getComId());
        comWalletProcess.setUpdateTime(now);
        comWalletProcess.setUpdateBy(comWalletAccount.getUpdateBy());
        comWalletProcess.setStep(2);
        comWalletProcess.setIsComplete("1");
        this.comWalletProcessMapper.updateComWalletProcess(comWalletProcess);
        ComWallet comWallet = new ComWallet();
        comWallet.setComId(comWalletAccount.getComId());
        comWallet.setUpdateTime(now);
        comWallet.setUpdateBy(comWalletAccount.getUpdateBy());
        comWallet.setIsCompleteOpen("1");
        comWallet.setOpenTime(now);
        this.comWalletMapper.updateComWallet(comWallet);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getComWalletAccount(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.getMemberNo(comWalletAccount.getComId() + ""));
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/query"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        ComWalletAccountDTO dto = this.comWalletAccountMapper.getComWalletAccountByComId(comWalletAccount.getComId());
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            if (map == null || map.get("account_state") == null) {
                return Result.success((String)"", (Object)dto);
            }
            String status = map.get("account_state").toString();
            String statusStr = PaymentServiceConst.getGSAccountStatus(map.get("account_state").toString());
            ComWallet comWallet = this.comWalletMapper.getComWalletByComId(comWalletAccount.getComId());
            if ("1".equals(status) && "0".equals(comWallet.getIsCompleteOpen())) {
                Date now = new Date();
                ComWalletProcess comWalletProcess = new ComWalletProcess();
                comWalletProcess.setComId(comWalletAccount.getComId());
                comWalletProcess.setUpdateTime(now);
                comWalletProcess.setUpdateBy(comWalletAccount.getUpdateBy());
                comWalletProcess.setStep(4);
                comWalletProcess.setIsComplete("1");
                this.comWalletProcessMapper.updateComWalletProcess(comWalletProcess);
                comWallet.setComId(comWalletAccount.getComId());
                comWallet.setUpdateTime(now);
                comWallet.setUpdateBy(comWalletAccount.getUpdateBy());
                comWallet.setIsCompleteOpen("1");
                comWallet.setOpenTime(now);
                this.comWalletMapper.updateComWallet(comWallet);
            }
            dto.setAccountStatus(statusStr);
            dto.setBankName(this.commonService.getConfigBank(dto.getBankCode()));
            if (StringUtil.isEmpty((String)dto.getBankName())) {
                dto.setBankName(map.get("acct_org_name").toString());
            }
            dto.setBankCardNo(dto.getBankCardNo());
            if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
                dto.setBankCardNo(map.get("acct").toString());
            }
            String walletAccountNo = dto.getWalletAccountNo();
            String cardnoGS = dto.getCardnoGS();
            dto.setWalletAccountNo(map.get("accnoEnsure").toString());
            dto.setCardnoGS(map.get("cardno").toString());
            if ("0".equals(walletAccountNo) && StringUtil.isNotEmpty((String)map.get("accnoEnsure").toString())) {
                this.comWalletAccountMapper.updateComWalletAccountNo(dto);
            }
            if (StringUtil.isEmpty((String)cardnoGS) && StringUtil.isNotEmpty((String)walletAccountNo) && walletAccountNo.length() > 5 && StringUtil.isNotEmpty((String)map.get("cardno").toString())) {
                this.comWalletAccountMapper.updateComWalletAccountNo(dto);
            }
        } else {
            return Result.fail((String)result.getMsg());
        }
        return Result.success((String)"", (Object)dto);
    }

    @Override
    public Result getAccountConfirm(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String webUrl = this.commonService.getSystemConfig("WEB_URL");
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.getMemberNo(comWalletAccount.getComId() + ""));
        p.put("returnUrl", webUrl + "/user/AuthSuccess");
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/confirm"), requestMap);
        return (Result)JSON.parseObject((String)resultStr, Result.class);
    }

    @Override
    public Result getComWalletAccountAmount(ComWalletAccount comWalletAccount) throws V5BusinessException {
        BigDecimal availableAmount;
        Map map;
        ComWalletAccountDTO account;
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        if (StringUtils.isEmpty((String)comWalletAccount.getTlkComId())) {
            account = this.comWalletAccountMapper.getComWalletAccountByComId(comWalletAccount.getComId());
            p.put("comId", this.getMemberNo(comWalletAccount.getComId() + ""));
        } else {
            account = this.comWalletAccountMapper.getComWalletAccountByTLKComId(comWalletAccount.getTlkComId());
            if (ObjectUtil.isNull((Object)account.getComId())) {
                return Result.fail((String)"\u64cd\u4f5c\u5931\u8d25:\u60a8\u7684\u516c\u53f8\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\uff01");
            }
            p.put("comId", this.getMemberNo(account.getComId() + ""));
        }
        p.put("walletAccountNo", account.getWalletAccountNo());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/balance/query"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if ("0".equals(result.getRetType())) {
            map = (Map)result.getData();
            availableAmount = BigDecimal.ZERO;
            if (map.get("ledger_bal") != null && Double.parseDouble(String.valueOf(map.get("ledger_bal"))) > 0.0) {
                availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("ledger_bal")))).subtract(BigDecimal.valueOf(Double.parseDouble(String.valueOf(account.getFrozenAmount()))));
            }
        } else {
            return Result.fail((String)result.getMsg());
        }
        String ledger_bal = String.valueOf(map.get("ledger_bal"));
        resultMap.put("totalAmount", ledger_bal);
        String aAmount = availableAmount.toString();
        resultMap.put("availableAmount", aAmount);
        resultMap.put("frozenAmount", account.getFrozenAmount());
        return Result.success((String)"", resultMap);
    }

    @Override
    public Result getComWalletAccountTradeDetail(ComWalletAccountDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new V5BusinessException("-1", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new V5BusinessException("-1", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("id", this.getMemberNo(dto.getComId() + ""));
        p.put("pageNumber", dto.getPageNumber().toString());
        p.put("pageSize", dto.getPageSize().toString());
        p.put("walletAccountNo", account.getWalletAccountNo());
        p.put("startDate", dto.getStartDate());
        p.put("endDate", dto.getEndDate());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/record/query"), requestMap);
        System.err.println("=========> \u8bf7\u6c42\u652f\u4ed8\u5e73\u53f0\u6536\u652f\u660e\u7ec6url\uff1a" + platUrl + "/pay/gongshang/account/record/query");
        System.err.println("=========> \u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u6536\u652f\u660e\u7ec6\u5b57\u7b26\u4e32\uff1a" + resultStr);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        ArrayList detailList = Lists.newArrayList();
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            if (StringUtils.isEmpty((String)map.get("total_size").toString()) || Integer.parseInt(map.get("total_size").toString()) == 0) {
                PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
                return Result.success((String)"", pageInfo);
            }
            ArrayList recordlist = (ArrayList)JSON.parseObject((String)map.get("balance_records").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
            System.err.println("=========> \u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u6536\u652f\u660e\u7ec6\u89e3\u6790\u5b57\u7b26\u4e32\uff1a" + JSON.toJSONString((Object)recordlist));
            for (Map record : recordlist) {
                ComWalletAccountDetailDTO detail = this.packComWalletAccountDetail(record);
                detailList.add(detail);
            }
            System.err.println("=========> \u6536\u652f\u660e\u7ec6\u8f6c\u6362\u540e\u5217\u8868\u5b57\u7b26\u4e32\uff1a" + JSON.toJSONString((Object)detailList));
            PageInfoUtils pageInfo = new PageInfoUtils(detailList);
            pageInfo.setPageSize(dto.getPageSize());
            pageInfo.setPageNumber(dto.getPageNumber());
            pageInfo.setTotal(Integer.parseInt(map.get("total_size").toString()));
            pageInfo.setTotalPage(Integer.parseInt(map.get("total_size").toString()) / Integer.parseInt(map.get("page_size").toString()) + 1);
            return Result.success((String)"", pageInfo);
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result thisComWalletAccountTradeDetail(ComWalletAccountDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new V5BusinessException("-1", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new V5BusinessException("-1", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<ComWalletAccountDetail> detailList = this.comWalletAccountDetailMapper.selectByComIdAndDate(dto.getComId(), dto.getStartDate(), dto.getEndDate(), "1");
        return Result.success((String)"", new PageInfoUtils<ComWalletAccountDetail>(detailList));
    }

    @Override
    public Result comWalletAccountTradeDetailSch() {
        return this.comWalletAccountTradeDetailTask("", "");
    }

    @Override
    public Result comWalletAccountTradeDetailTask(String startDate, String endDate) {
        List<ComWalletAccountDTO> accountList = this.comWalletAccountMapper.getAllComWalletAccount();
        String yesterday = DateUtil.formatDate((Date)DateUtil.yesterday());
        if (StringUtils.isEmpty((String)startDate) || StringUtils.isEmpty((String)endDate)) {
            startDate = yesterday;
            endDate = yesterday;
        }
        ArrayList detailList = Lists.newArrayList();
        ArrayList flowNoList = Lists.newArrayList();
        List<String> existsFlowNoList = this.comWalletAccountDetailMapper.selectFlowNoByDate(startDate, endDate);
        block2: for (ComWalletAccountDTO account : accountList) {
            int pageNumber = 1;
            try {
                while (true) {
                    Map map;
                    HashMap<Object, Object> p = new HashMap<Object, Object>();
                    p.put("id", this.getMemberNo(account.getComId() + ""));
                    p.put("pageNumber", pageNumber);
                    p.put("pageSize", 100);
                    p.put("walletAccountNo", account.getWalletAccountNo());
                    p.put("startDate", startDate);
                    p.put("endDate", endDate);
                    String token = JwtUtil.createJWT(p);
                    HashMap<String, String> requestMap = new HashMap<String, String>();
                    requestMap.put("token", token);
                    String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
                    String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/record/query"), requestMap);
                    Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
                    if (!"0".equals(result.getRetType()) || StringUtils.isEmpty((String)(map = (Map)result.getData()).get("total_size").toString()) || Integer.parseInt(map.get("total_size").toString()) == 0) continue block2;
                    ArrayList recordlist = (ArrayList)JSON.parseObject((String)map.get("balance_records").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
                    for (Map record : recordlist) {
                        ComWalletAccountDetailDTO detail = this.packComWalletAccountDetail(record);
                        detail.setComWalletAccountDetailId(this.idWorker.nextId());
                        detail.setComId(account.getComId());
                        detail.setWalletAccountNo(account.getWalletAccountNo());
                        if (!existsFlowNoList.contains(detail.getFlowNo())) {
                            detailList.add(detail);
                        }
                        if (flowNoList.contains(detail.getFlowNo())) continue;
                        flowNoList.add(detail.getFlowNo());
                    }
                    if (recordlist.size() < 100) continue block2;
                    ++pageNumber;
                }
            }
            catch (Exception e) {
            }
        }
        if (CollectionUtil.isEmpty((Collection)detailList)) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        this.comWalletAccountDetailMapper.insertBatch(detailList);
        for (ComWalletAccountDetailDTO detail : detailList) {
            if (!flowNoList.contains(detail.getFlowNo())) continue;
            HashMap params = Maps.newHashMap();
            params.put("detailId", detail.getComWalletAccountDetailId().toString());
            params.put("comId", this.getMemberNo(detail.getComId() + ""));
            params.put("bizOrderNo", detail.getFlowNo());
            params.put("walletAccountNo", detail.getWalletAccountNo());
            ComWalletTradeDTO dto = new ComWalletTradeDTO();
            dto.setComId(detail.getComId());
            dto.setTradeFlowNo(detail.getTradeFlowNo());
            flowNoList.remove(detail.getFlowNo());
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private ComWalletAccountDetailDTO packComWalletAccountDetail(Map<String, Object> record) {
        String fullName;
        String outWalletAccountNo = this.comWalletAccountMapper.getWalletAccountNoBybankCardNo(ObjectUtils.safeToString((Object)record.get("account_out")));
        if (StringUtils.isEmpty((String)outWalletAccountNo)) {
            outWalletAccountNo = ObjectUtils.safeToString((Object)record.get("account_out"));
        }
        String direction = PaymentServiceConst.getDirection(record.get("direction").toString());
        ComWalletAccountDetailDTO detail = new ComWalletAccountDetailDTO();
        detail.setTradeDate(record.get("trade_date").toString().substring(0, record.get("trade_date").toString().length() - 3));
        detail.setTradeFlowNo(ObjectUtils.safeToString((Object)record.get("trade_flow_no")));
        detail.setFlowNo(ObjectUtils.safeToString((Object)record.get("flow_no")));
        detail.setAccountsDealType(PaymentServiceConst.getAccountDealType(ObjectUtils.safeToString((Object)record.get("accounts_deal_type"))));
        detail.setAccountsDealDate(record.get("accounts_deal_date").toString().substring(0, record.get("accounts_deal_date").toString().length() - 3));
        detail.setAmount(ObjectUtils.safeToString((Object)record.get("amount")));
        detail.setDirection(direction);
        detail.setHandStatus(PaymentServiceConst.getHandStatus(record.get("hand_status").toString()));
        detail.setCreateDate(record.get("create_date").toString().substring(0, record.get("create_date").toString().length() - 3));
        detail.setServiceType(PaymentServiceConst.getServiceType(record.get("service_code").toString()));
        detail.setTradeType(PaymentServiceConst.getTradeType(record.get("trade_type").toString()));
        detail.setAccountIn(ObjectUtils.safeToString((Object)record.get("account_in")));
        detail.setAccountOut(outWalletAccountNo);
        if (StringUtil.isEmpty((String)record.get("account_in").toString())) {
            detail.setAccountInName("\u65e0");
        } else {
            fullName = this.getWalletAccountName(record.get("account_in").toString());
            detail.setAccountInName(StringUtils.isEmpty((String)fullName) ? "\u65e0" : fullName);
        }
        if (StringUtil.isEmpty((String)outWalletAccountNo)) {
            detail.setAccountOutName("\u65e0");
        } else {
            fullName = this.getWalletAccountName(outWalletAccountNo);
            detail.setAccountOutName(StringUtils.isEmpty((String)fullName) ? "\u65e0" : fullName);
        }
        detail.setMemo(ObjectUtils.safeToString((Object)record.get("memo")));
        return detail;
    }

    @Override
    public Result getWalletRechargeToken(ComWalletAccountDTO dto) throws V5BusinessException {
        throw new V5BusinessException("-1", "\u4e1a\u52a1\u4f18\u5316\u4e2d\uff0c\u6682\u505c\u5145\u503c\u670d\u52a1\uff01");
    }

    @Override
    public Result comWalletRegisterCallback(String token) throws V5BusinessException, ParseException {
        if (StringUtil.isEmpty((String)token)) {
            throw new V5BusinessException("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Claims claims = JwtUtil.parseJWT(token);
        String paramStr = claims.getSubject();
        Map paramMap = (Map)JSON.parseObject((String)paramStr, Map.class);
        if (StringUtil.isEmpty((String)((String)paramMap.get("memberNo")))) {
            return Result.fail((String)"\u4f1a\u5458\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)((String)paramMap.get("status")))) {
            return Result.fail((String)"\u5f00\u6237\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)((String)paramMap.get("cardNo")))) {
            return Result.fail((String)"\u7535\u5b50\u8d26\u6237\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(paramMap.get("status"))) {
            System.err.println("=====> comWalletRegisterCallback\uff08\u5de5\u5546\u5f00\u6237\u56de\u8c03\uff09\uff1a\u4f1a\u5458\u53f7\uff1a" + (String)paramMap.get("memberNo") + "\uff0c\u5b50\u8d26\u6237\u5361\u53f7\uff1a" + (String)paramMap.get("cardNo") + "\uff0c\u5f00\u6237\u72b6\u6001\uff1a" + (String)paramMap.get("status") + "\uff080-\u672a\u542f\u7528\uff0c1-\u6b63\u5e38\uff0c2-\u4f5c\u5e9f\uff0c3-\u5f85\u8ba4\u8bc1\uff0c4-\u8ba4\u8bc1\u62d2\u7edd\uff09");
        }
        ComWalletAccountDTO comWalletAccount = this.comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong((String)paramMap.get("memberNo")));
        comWalletAccount.setWalletAccountNo((String)paramMap.get("cardNo"));
        this.comWalletAccountMapper.updateComWalletAccount(comWalletAccount);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result comWalletRechargeCallback(String token) throws V5BusinessException, ParseException {
        if (StringUtil.isEmpty((String)token)) {
            throw new V5BusinessException("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        Claims claims = JwtUtil.parseJWT(token);
        String paramStr = claims.getSubject();
        Map paramMap = (Map)JSON.parseObject((String)paramStr, Map.class);
        if (StringUtil.isEmpty((String)((String)paramMap.get("walletTradeId")))) {
            return Result.fail((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)((String)paramMap.get("tradeStatus")))) {
            return Result.fail((String)"\u4ea4\u6613\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)((String)paramMap.get("updateTime")))) {
            return Result.fail((String)"\u4ea4\u6613\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(Long.parseLong((String)paramMap.get("walletTradeId")));
        comWalletTrade.setTradeStatus((String)paramMap.get("tradeStatus"));
        Date updateTime = DateUtils.parseDate((String)((String)paramMap.get("updateTime")), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        comWalletTrade.setUpdateTime(updateTime);
        this.comWalletTradeMapper.updateComWalletTrade(comWalletTrade);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getWalletTradeInfo(ComWalletTrade comWalletTrade) throws V5BusinessException {
        if (comWalletTrade.getComWalletTradeId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u94b1\u5305\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        comWalletTrade = this.comWalletTradeMapper.getComWalletTradeById(comWalletTrade.getComWalletTradeId());
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)comWalletTrade);
    }

    @Override
    public Result getComWalletTradeBySeqAndCode(ComWalletTrade comWalletTrade) throws V5BusinessException {
        if (comWalletTrade.getBusinessCode() == null) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ComWalletTrade> list = this.comWalletTradeMapper.getComWalletTradeBySeqAndCode(comWalletTrade);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result comWalletAccountExtract(ComWalletAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getWalletAccountNo())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u94b1\u5305\u8d26\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getComName())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() == null) {
            throw new V5BusinessException("-1", "\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount().compareTo(BigDecimal.ZERO) < 1) {
            throw new V5BusinessException("-1", "\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty((String)activeCodeSerial)) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        Result accRet = this.getComWalletAccountAmount(account);
        if (!"0".equals(accRet.getRetType())) throw new V5BusinessException("-1", accRet.getMsg());
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)accRet.getData()), Map.class);
        if (map == null || map.get("availableAmount") == null) throw new V5BusinessException("-1", "\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        BigDecimal availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("availableAmount"))));
        if (availableAmount.compareTo(dto.getAmount()) < 0) {
            throw new V5BusinessException("-1", "\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u4f59\u989d");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.getMemberNo(account.getComId() + ""));
        p.put("bizOrderNo", dto.getOrderId());
        p.put("amount", String.valueOf(dto.getAmount()));
        p.put("bankCode", account.getBankCode());
        p.put("bankCardNo", dto.getBankCardNo());
        p.put("walletAccountNo", account.getWalletAccountNo());
        p.put("name", account.getComName());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/withdraw"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) return Result.fail((String)result.getMsg());
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(Long.parseLong(dto.getOrderId()));
        comWalletTrade.setCreateTime(dto.getCreateTime());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setCreateBy(dto.getCreateBy());
        comWalletTrade.setComId(dto.getComId());
        comWalletTrade.setAmount(dto.getAmount());
        comWalletTrade.setTradeType("02");
        comWalletTrade.setTradeStatus("1");
        this.comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result batchExtract(ComWallet comWallet) {
        String arrVal = comWallet.getCooperateTreatyUrl();
        String[] groupAccount = arrVal.split(",");
        HashMap map = Maps.newHashMap();
        ArrayList accList = Lists.newArrayList();
        for (String acc : groupAccount) {
            String[] accArr = acc.split("#");
            map.put(accArr[0], accArr[1]);
            accList.add(accArr[0]);
        }
        List<ComWalletAccountDTO> list = this.comWalletMapper.findWalletAccounts(accList);
        ArrayList errList = Lists.newArrayList();
        for (ComWalletAccountDTO dto : list) {
            dto.setAmount(new BigDecimal((String)map.get(dto.getCardno())));
            dto.setOrderId(String.valueOf(new IdWorker().nextId()));
            dto.setCreateBy(1L);
            dto.setCreateTime(new Date());
            try {
                this.extractMock(dto);
            }
            catch (V5BusinessException e) {
                errList.add(dto.getCardno() + "#" + (String)map.get(dto.getCardno()) + "#" + e.getMsg());
                System.out.println("========> batchExtract \u6279\u91cf\u63d0\u73b0\u4e1a\u52a1\u5f02\u5e38\uff0c" + dto.getComName() + " \u63d0\u73b0\u5931\u8d25\uff0cERR:" + e.getMsg());
            }
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)errList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractMock(ComWalletAccountDTO dto) throws V5BusinessException {
        ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        Result accRet = this.getComWalletAccountAmount(account);
        if (!"0".equals(accRet.getRetType())) throw new V5BusinessException("-1", accRet.getMsg());
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)accRet.getData()), Map.class);
        if (map == null || map.get("availableAmount") == null) throw new V5BusinessException("-1", "\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        BigDecimal availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("availableAmount"))));
        if (availableAmount.compareTo(dto.getAmount()) < 0) {
            throw new V5BusinessException("-1", "\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u4f59\u989d");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.getMemberNo(account.getComId() + ""));
        p.put("bizOrderNo", dto.getOrderId());
        p.put("amount", String.valueOf(dto.getAmount()));
        p.put("bankCode", account.getBankCode());
        p.put("bankCardNo", dto.getBankCardNo());
        p.put("walletAccountNo", account.getWalletAccountNo());
        p.put("name", account.getComName());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/withdraw"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) {
            throw new V5BusinessException("-1", result.getMsg());
        }
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(Long.parseLong(dto.getOrderId()));
        comWalletTrade.setCreateTime(dto.getCreateTime());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setCreateBy(dto.getCreateBy());
        comWalletTrade.setComId(dto.getComId());
        comWalletTrade.setAmount(dto.getAmount());
        comWalletTrade.setTradeType("02");
        comWalletTrade.setTradeStatus("1");
        this.comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
    }

    @Override
    public Result comWalletAccountLock(ComWalletTransferDTO dto) throws V5BusinessException {
        String outId = dto.getOutId();
        String inId = dto.getInId();
        if ("05".equals(dto.getTradeType())) {
            outId = dto.getInId();
            inId = dto.getOutId();
        }
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.comWalletTradeMapper.getComWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new V5BusinessException("-1", "\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
                throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty((String)activeCodeSerial)) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            }
        }
        BigDecimal frozenAmount = this.extractedLock(Long.parseLong(outId), Long.parseLong(inId), dto.getBusinessCode(), dto.getTradeType(), dto.getAmount());
        this.comWalletAccountMapper.updateFrozenAmount(Long.parseLong(outId), frozenAmount.toString());
        Long orderId = this.idWorker.nextId();
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setBusinessCode(dto.getBusinessCode());
        comWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
        comWalletTrade.setCreateTime((Date)DateUtil.date());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setComment(dto.getComment());
        comWalletTrade.setComId(Long.parseLong(outId));
        comWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
        comWalletTrade.setTradeType(dto.getTradeType());
        comWalletTrade.setTradeStatus("1");
        this.comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)orderId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal extractedLock(Long outId, Long inId, String code, String tradeType, String amount) {
        Long comId = outId;
        BigDecimal updAmount = BigDecimal.valueOf(Double.parseDouble(amount));
        ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByComId(comId);
        Result accRet = this.getComWalletAccountAmount(account);
        if (!"0".equals(accRet.getRetType())) throw new V5BusinessException("-1", accRet.getMsg());
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)accRet.getData()), Map.class);
        if (map == null) throw new V5BusinessException("-1", "\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        if (map.get("availableAmount") == null) throw new V5BusinessException("-1", "\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        BigDecimal frozenAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("frozenAmount"))));
        BigDecimal availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("availableAmount"))));
        if ("04".equals(tradeType)) {
            if (availableAmount.compareTo(updAmount) >= 0) return frozenAmount.add(updAmount);
            throw new V5BusinessException("-1", "\u94b1\u5305\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
        }
        if ("05".equals(tradeType)) {
            if (frozenAmount.compareTo(updAmount) >= 0) return frozenAmount.subtract(updAmount);
            throw new V5BusinessException("-1", "\u91d1\u989d\u5212\u62e8\u4e0d\u5bf9\u7b49\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (!"03".equals(tradeType)) return frozenAmount;
        if (availableAmount.compareTo(updAmount) >= 0) return frozenAmount;
        throw new V5BusinessException("-1", "\u94b1\u5305\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
    }

    @Override
    public Result comWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        ComWalletAccountDTO inAccount;
        ComWalletAccountDTO outAccount;
        System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new V5BusinessException("-1", "\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.comWalletTradeMapper.getComWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new V5BusinessException("-1", "\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new V5BusinessException("-1", "\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
                throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty((String)activeCodeSerial)) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            }
        }
        String tradeType = StringUtils.isEmpty((String)dto.getTradeType()) ? "05" : dto.getTradeType();
        BigDecimal frozenAmount = this.extractedLock(Long.parseLong(dto.getOutId()), Long.parseLong(dto.getInId()), dto.getBusinessCode(), tradeType, dto.getAmount());
        System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u51bb\u7ed3\u91d1\u989d\uff1a" + frozenAmount);
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        if (StringUtils.isEmpty((String)dto.getTlkComId())) {
            outAccount = this.comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(dto.getOutId()));
            inAccount = this.comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(dto.getInId()));
            p.put("outId", this.getMemberNo(dto.getOutId() + ""));
            p.put("inId", this.getMemberNo(dto.getInId() + ""));
        } else {
            outAccount = this.comWalletAccountMapper.getComWalletAccountByTLKComId(dto.getOutId());
            inAccount = this.comWalletAccountMapper.getComWalletAccountByTLKComId(dto.getInId());
            p.put("outId", this.getMemberNo(outAccount.getComId() + ""));
            p.put("inId", this.getMemberNo(inAccount.getComId() + ""));
        }
        Long orderId = this.idWorker.nextId();
        p.put("outName", outAccount.getComName());
        p.put("outWalletAccountNo", outAccount.getWalletAccountNo());
        p.put("inName", inAccount.getComName());
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("inBankCardNo", inAccount.getBankCardNo());
        p.put("amount", dto.getAmount());
        p.put("bizOrderNo", orderId);
        p.put("comment", dto.getComment());
        p.put("goodsName", dto.getGoodsName());
        p.put("goodsNumber", dto.getGoodsNumber());
        p.put("goodsUnit", dto.getGoodsUnit());
        p.put("returnUrl", "");
        p.put("callbackUrl", "");
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/wallet/transfer"), requestMap);
        System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u7533\u8bf7\uff1a" + resultStr);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setBusinessCode(dto.getBusinessCode());
        comWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
        comWalletTrade.setCreateTime((Date)DateUtil.date());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setComment(dto.getComment());
        comWalletTrade.setComId(Long.parseLong(dto.getOutId()));
        comWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
        comWalletTrade.setTradeType("03");
        if ("0".equals(result.getRetType())) {
            ComCheckTransferDTO comCheckTransferDTO = new ComCheckTransferDTO();
            comCheckTransferDTO.setAmount(dto.getAmount());
            comCheckTransferDTO.setOrderId(orderId + "");
            comCheckTransferDTO.setOutId(this.getMemberNo(outAccount.getComId() + ""));
            comCheckTransferDTO.setInId(this.getMemberNo(inAccount.getComId() + ""));
            comCheckTransferDTO.setInName(inAccount.getComName());
            comCheckTransferDTO.setInWalletAccountNo(inAccount.getWalletAccountNo());
            comCheckTransferDTO.setInBankCardNo(inAccount.getBankCardNo());
            this.comTaskResidualAPIService.saveComTaskResidual("checkTransfer", "\u7533\u8bf7\u652f\u4ed8\u5b8c\u6210\u540e\u7684\u786e\u8ba4\u652f\u4ed8\u4efb\u52a1", "com.bcxin.platform.service.wallet.ComWalletService", 1, "com.bcxin.platform.dto.wallet.ComCheckTransferDTO", JSON.toJSONString((Object)comCheckTransferDTO));
            this.comWalletAccountMapper.updateFrozenAmount(Long.parseLong(dto.getOutId()), frozenAmount.toString());
            comWalletTrade.setTradeStatus("1");
            this.comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
            System.err.println("===>comWalletAccountTransfer.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)orderId);
        }
        System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u7533\u8bf7\uff1afail");
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result checkTransfer(ComCheckTransferDTO comCheckTransferDTO) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("amount", comCheckTransferDTO.getAmount());
        p.put("bizOrderNo", comCheckTransferDTO.getOrderId());
        p.put("bizOrderNoOrigin", comCheckTransferDTO.getOrderId());
        p.put("comment", "\u8ba2\u5355\uff08" + comCheckTransferDTO.getOrderId() + "\uff09\u7684\u786e\u8ba4\u652f\u4ed8");
        p.put("outId", comCheckTransferDTO.getOutId());
        p.put("inId", comCheckTransferDTO.getInId());
        p.put("inName", comCheckTransferDTO.getInName());
        p.put("inWalletAccountNo", comCheckTransferDTO.getInWalletAccountNo());
        p.put("inBankCardNo", comCheckTransferDTO.getInBankCardNo());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/wallet/confirmPayment"), requestMap);
        System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + comCheckTransferDTO.getOrderId() + ",\u652f\u4ed8\u786e\u8ba4\uff1a" + resultStr);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            String status = map.get("trade_status").toString();
            if ("2".equals(status)) {
                return Result.fail((String)"\u4ea4\u6613\u5931\u8d25");
            }
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result cancelTransfer(ComCheckTransferDTO comCheckTransferDTO) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("amount", comCheckTransferDTO.getAmount());
        p.put("bizOrderNo", comCheckTransferDTO.getOrderId());
        p.put("bizOrderNoOrigin", comCheckTransferDTO.getOrderId());
        p.put("comment", "\u8ba2\u5355\uff08" + comCheckTransferDTO.getOrderId() + "\uff09\u7684\u53d6\u6d88\u652f\u4ed8");
        p.put("outId", comCheckTransferDTO.getOutId());
        p.put("inId", comCheckTransferDTO.getInId());
        p.put("inName", comCheckTransferDTO.getInName());
        p.put("inWalletAccountNo", comCheckTransferDTO.getInWalletAccountNo());
        p.put("inBankCardNo", comCheckTransferDTO.getInBankCardNo());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/wallet/cancelPayment"), requestMap);
        System.err.println(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3comWalletAccountTransfer\uff1a" + comCheckTransferDTO.getOrderId() + ",\u53d6\u6d88\u652f\u4ed8\uff1a" + resultStr);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            String status = map.get("trade_status").toString();
            if ("2".equals(status)) {
                return Result.fail((String)"\u4ea4\u6613\u5931\u8d25");
            }
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result syncComWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.comWalletTradeMapper.getComWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new V5BusinessException("-1", "\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
                throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty((String)activeCodeSerial)) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            }
        }
        BigDecimal frozenAmount = this.extractedLock(Long.parseLong(dto.getOutId()), Long.parseLong(dto.getInId()), dto.getBusinessCode(), "05", dto.getAmount());
        this.comTaskResidualAPIService.saveComTaskResidual2("comWalletAccountTransfer", "\u4f01\u4e1a\u786e\u8ba4\u6210\u7ee9\u8f6c\u8d26\u4efb\u52a1", "com.bcxin.platform.service.wallet.ComWalletService", 1, "com.bcxin.platform.dto.wallet.ComWalletTransferDTO", JSON.toJSONString((Object)dto));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result syncPlatWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getOutId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u51fa\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getInId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u5165\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new V5BusinessException("-1", "\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
                throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty((String)activeCodeSerial)) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            }
        }
        this.comTaskResidualAPIService.saveComTaskResidual2("comWalletAccountTransfer", "\u5e73\u53f0\u5206\u8d26\u4efb\u52a1", "com.bcxin.platform.service.wallet.ComWalletService", 1, "com.bcxin.platform.dto.wallet.ComWalletTransferDTO", JSON.toJSONString((Object)dto));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result platWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getOutId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u51fa\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getInId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u5165\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException("-1", "\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new V5BusinessException("-1", "\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
                throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty((String)activeCodeSerial)) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            }
        }
        this.comTaskResidualAPIService.saveComTaskResidual("comWalletAccountTransfer", "\u5e73\u53f0\u5206\u8d26\u4efb\u52a1", "com.bcxin.platform.service.wallet.ComWalletService", 1, "com.bcxin.platform.dto.wallet.ComWalletTransferDTO", JSON.toJSONString((Object)dto));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result comWalletAccountConsumeLedger(ComWalletConsumeLedgerDTO dto) throws V5BusinessException {
        if (dto.getOutId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u51fa\u8d26ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(dto.getLedgerInfoList())) {
            throw new V5BusinessException("-1", "\u5206\u8d26\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty((String)activeCodeSerial)) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        ArrayList list = Lists.newArrayList();
        ComWalletAccountDTO outAccount = this.comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(dto.getOutId()));
        for (ComWalletConsumeLedgerDTO.LedgerInfo ledgerInfo : dto.getLedgerInfoList()) {
            ComWalletAccountDTO inAccount = this.comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(ledgerInfo.getInId()));
            HashMap map = Maps.newHashMap();
            map.put("inId", this.getMemberNo(ledgerInfo.getInId() + ""));
            map.put("inWalletAccountNo", inAccount.getWalletAccountNo());
            map.put("amount", ledgerInfo.getAmount());
            list.add(map);
        }
        Long orderId = this.idWorker.nextId();
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("outId", this.getMemberNo(dto.getOutId() + ""));
        p.put("bizOrderNo", orderId.toString());
        p.put("amount", dto.getAmount());
        p.put("outWalletAccountNo", outAccount.getWalletAccountNo());
        p.put("ledgerInfo", JSON.toJSONString((Object)list));
        p.put("activeCode", dto.getActiveCode());
        p.put("activeCodeSerial", this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone()));
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/fbank/account/consume/ledger"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setCreateTime((Date)DateUtil.date());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setComId(Long.parseLong(dto.getOutId()));
        comWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
        comWalletTrade.setTradeType("03");
        if ("0".equals(result.getRetType())) {
            comWalletTrade.setTradeStatus("1");
            this.comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        comWalletTrade.setTradeStatus("2");
        this.comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
        return Result.fail((String)result.getMsg());
    }

    @Override
    public String getComAccountTradeVoucher(ComWalletTradeDTO dto) throws V5BusinessException {
        String voucherUrl;
        HashMap p = Maps.newHashMap();
        p.put("comId", this.getMemberNo(dto.getComId() + ""));
        p.put("tradeFlowNo", dto.getTradeFlowNo());
        if (dto.getComId() != null && StringUtils.isNotEmpty((String)dto.getTradeFlowNo()) && StringUtils.isNotEmpty((String)(voucherUrl = this.comWalletAccountDetailMapper.getVoucherUrlByTradeFlowNo(dto.getTradeFlowNo(), dto.getComId())))) {
            return BcxinFileUtils.getInputStreamByUrl(voucherUrl);
        }
        String tradeDate = this.comWalletAccountDetailMapper.getTradeDateByTradeFlowNo(dto.getTradeFlowNo(), dto.getComId());
        String accountIn = this.comWalletAccountDetailMapper.getAccountInByTradeFlowNo(dto.getTradeFlowNo(), dto.getComId());
        if (StringUtils.isEmpty((String)tradeDate)) {
            throw new V5BusinessException("-2", "\u672a\u5339\u914d\u5230\u4ea4\u6613\u8bb0\u5f55");
        }
        p.put("tradeDate", tradeDate);
        p.put("accountIn", accountIn);
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platform = this.commonService.getSystemConfig("PLATFORM_SIGN");
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/trade/voucher"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            if (map != null && map.get("base_content") == null) {
                throw new V5BusinessException("-2", "\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u5931\u8d25\uff1a\u5f53\u5929\u8fdb\u884c\u7684\u4ea4\u6613\u53ea\u80fd\u6b21\u65e5\u624d\u80fd\u8fdb\u884c\u56de\u5355\u4e0b\u8f7d\uff1b\u4e0d\u662f\u4e0a\u8ff0\u60c5\u51b5\u8bf7\u8054\u7cfb\u5ba2\u670d\u53cd\u9988\u3002");
            }
            String voucherUrl2 = BcxinFileUtils.huaweiBase64Upload(map.get("base_content").toString(), dto.getTradeFlowNo() + accountIn + ".pdf", DateUtil.today(), platform);
            this.comWalletAccountDetailMapper.updateVoucherUrlByComId(dto.getComId(), voucherUrl2, dto.getTradeFlowNo());
            return map.get("base_content").toString();
        }
        throw new V5BusinessException("-2", result.getMsg());
    }

    @Override
    public Result taskTradeVoucher(String tradeDate) throws V5BusinessException {
        if (StringUtils.isEmpty((String)tradeDate)) {
            try {
                tradeDate = DateUtils.dateAdd("", DateUtils.getDate(), "yyyy-MM-dd", -1).replace("-", "");
                String tradeDate2 = DateUtils.dateAdd("", DateUtils.getDate(), "yyyy-MM-dd", -2).replace("-", "");
                new Thread(() -> {
                    try {
                        this.taskTradeVoucher(tradeDate2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HashMap p = Maps.newHashMap();
        p.put("tradeDate", tradeDate);
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/trade/voucher-batch-decompression"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            return Result.success((String)"\u6587\u4ef6\u62c9\u53d6\u6210\u529f");
        }
        return Result.fail((String)"\u6587\u4ef6\u62c9\u53d6\u5931\u8d25");
    }

    @Override
    public String getComAccountPayVoucher(ComWalletTradeDTO dto) throws V5BusinessException {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("bizOrderNo", dto.getTradeFlowNo());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/fbank/account/pay/voucher"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            return map.get("base_content").toString();
        }
        return "";
    }

    @Override
    public Result createComWalletReconciliation(String testDate) throws V5BusinessException {
        String lastDate = DateUtils.getSpecifiedDayBefore(DateUtils.getDate(), 2);
        ArrayList dateList = DateUtils.getBetweenDates(DateUtils.parseDate(lastDate), new Date());
        if (StringUtils.isNotEmpty((String)testDate)) {
            dateList = Lists.newArrayList();
            dateList.add(DateUtils.parseDate(testDate));
        }
        for (Date date : dateList) {
            Map m;
            String content;
            Map map;
            HashMap<Object, Object> p = new HashMap<Object, Object>();
            String tradeDate = DateUtils.formatDate(date, new Object[0]).replaceAll("-", "");
            p.put("date", tradeDate);
            String token = JwtUtil.createJWT(p);
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("token", token);
            String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
            String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/check/file"), requestMap);
            if (!StringUtil.isNotEmpty((String)resultStr) || (map = (Map)JSON.parseObject((String)resultStr, Map.class)).get("data") == null || !StringUtil.isNotEmpty((String)map.get("data").toString()) || !StringUtil.isNotEmpty((String)(content = (m = (Map)JSON.parseObject((String)map.get("data").toString(), Map.class)).get("content") != null ? m.get("content").toString() : null))) continue;
            String[] tradeInfoStr = content.split("\\|");
            String limit = tradeInfoStr[32].replace("\u8bb0\u5f55\u6570\uff1a", "");
            if (tradeInfoStr.length <= 0 || "0".equals(limit)) continue;
            List tradedetailStrList = StrSpliter.split((String)content, (String)"\n", (boolean)true, (boolean)true);
            tradedetailStrList.remove(0);
            tradedetailStrList.remove(0);
            tradedetailStrList.remove(0);
            if (tradedetailStrList.size() <= 0) continue;
            ArrayList<ComWalletReconciliation> list = new ArrayList<ComWalletReconciliation>();
            for (String tradedetail : tradedetailStrList) {
                String[] detailStr = tradedetail.split("\\|", -1);
                ComWalletReconciliation comWalletReconciliation = new ComWalletReconciliation();
                comWalletReconciliation.setTradeSerialNo(detailStr[1]);
                comWalletReconciliation.setMerchantNo(detailStr[0]);
                comWalletReconciliation.setRequestSerialNo(detailStr[26]);
                comWalletReconciliation.setTradeAmount(StringUtils.isEmpty((String)detailStr[7]) ? BigDecimal.ZERO : new BigDecimal(detailStr[7]));
                comWalletReconciliation.setTradeStatus(detailStr[8]);
                comWalletReconciliation.setBankTradeType(detailStr[4]);
                comWalletReconciliation.setTradeStartTime(detailStr[0]);
                comWalletReconciliation.setTradeEndTime(detailStr[0]);
                String expendAccountNo = detailStr[15];
                if (StringUtils.isNotEmpty((String)detailStr[15])) {
                    ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByWalletNoORCardnoGS(detailStr[15]);
                    if (account != null) {
                        comWalletReconciliation.setExpendComId(account.getComId());
                        expendAccountNo = account.getWalletAccountNo();
                    }
                    comWalletReconciliation.setExpendBankCode("ICBC");
                }
                comWalletReconciliation.setExpendAccountNo(expendAccountNo);
                comWalletReconciliation.setExpendAccountName(detailStr[16]);
                String incomeAccountNo = detailStr[9];
                if (StringUtils.isNotEmpty((String)detailStr[9])) {
                    ComWalletAccountDTO account = this.comWalletAccountMapper.getComWalletAccountByWalletNoORCardnoGS(detailStr[9]);
                    if (account != null) {
                        comWalletReconciliation.setIncomeComId(account.getComId());
                        incomeAccountNo = account.getWalletAccountNo();
                    }
                    comWalletReconciliation.setIncomedBankCode("ICBC");
                }
                comWalletReconciliation.setIncomeAccountNo(incomeAccountNo);
                comWalletReconciliation.setIncomeAccountName(detailStr[10]);
                comWalletReconciliation.setIncomeCerNo("");
                comWalletReconciliation.setMerchantRetain("");
                comWalletReconciliation.setAllotAccountInfo("");
                comWalletReconciliation.setAllotBenefitInfo("");
                comWalletReconciliation.setRemark("");
                comWalletReconciliation.setServiceCharge("");
                comWalletReconciliation.setGuaranteeInfo("");
                list.add(comWalletReconciliation);
            }
            if (list.size() <= 0) continue;
            this.comWalletReconciliationMapper.insertTempReconciliationList(list);
            this.comWalletReconciliationMapper.updateComWalletReconciliation(tradeDate);
            this.comWalletReconciliationMapper.insertComWalletReconciliation(tradeDate);
            this.comWalletReconciliationMapper.deleteTempWalletReconciliation();
        }
        return Result.success((String)"");
    }

    @Override
    public Result getComWalletReconciliation(ComWalletTradeDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getFundFlowType())) {
            return Result.fail((String)"\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getComId() == null) {
            return Result.fail((String)"\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.comWalletReconciliationMapper.getWalletReconciliationList(dto);
        Map<String, Object> map = this.comWalletReconciliationMapper.getWalletReconciliationSum(dto);
        PageInfoUtils<Map<String, Object>> pageInfo = new PageInfoUtils<Map<String, Object>>(list);
        if (map != null) {
            map.put("pageInfo", pageInfo);
        }
        return Result.success((String)"", map);
    }

    @Override
    public Result exportComWalletReconciliation(ComWalletTradeDTO dto, HttpServletResponse response) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getFundFlowType())) {
            return Result.fail((String)"\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getComId() == null) {
            return Result.fail((String)"\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "\u5bf9\u8d26\u6570\u636e" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u5bf9\u8d26\u6570\u636e");
            List<Map<String, Object>> list = this.comWalletReconciliationMapper.getWalletReconciliationList(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment((short)2);
            titleStyle.setVerticalAlignment((short)1);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            Map<String, Object> map = this.comWalletReconciliationMapper.getWalletReconciliationSum(dto);
            String headerTitle = "";
            headerTitle = map == null ? MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", 0, 0, 0, 0, 0, 0, 0, 0) : MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", map.get("totalCount"), map.get("sumAmount"), map.get("successCount"), map.get("successAmount"), map.get("errorCount"), map.get("errorAmount"), map.get("processingCount"), map.get("processingAmount"));
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short)11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("\u9ed1\u4f53");
            titleStyle1.setVerticalAlignment((short)1);
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0);
            rowFirst.setHeight((short)1000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = new String[]{"\u5e8f\u53f7", "\u4ea4\u6613\u6d41\u6c34\u53f7", "\u94f6\u884c\u4ea4\u6613\u7c7b\u578b", "\u4ea4\u6613\u72b6\u6001", "\u4ea4\u6613\u8ba2\u5355\u521b\u5efa\u65f6\u95f4", "\u4ea4\u6613\u91d1\u989d", "\u51fa\u8d26\u65b9\u6237\u540d", "\u51fa\u8d26\u65b9\u8d26\u53f7", "\u51fa\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u6237\u540d", "\u5165\u8d26\u65b9\u8d26\u53f7", "\u5165\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u8bc1\u4ef6\u53f7", "\u5907\u6ce8"};
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 4 ? 5000 : (i == 1 || i == 7 || i == 10 || i == 13 ? 8000 : (i == 6 || i == 9 ? 10000 : (i == 13 ? 14000 : 4000))));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index);
            CellStyle blueStyle = ExcelUtil.getColorStyle(wb, IndexedColors.BLUE.index);
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)(rowIndex - 1));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("tradeSerialNo") != null ? result.get("tradeSerialNo").toString() : null);
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("bankTradeType") != null ? result.get("bankTradeType").toString() : null);
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("tradeStatus") != null ? result.get("tradeStatus").toString() : null);
                if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u6210\u529f")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u5931\u8d25")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("tradeStartTime") != null ? result.get("tradeStartTime").toString() : null);
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("tradeAmount") != null ? result.get("tradeAmount").toString() : null);
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("expendAccountName") != null ? result.get("expendAccountName").toString() : null);
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("expendAccountNo") != null ? result.get("expendAccountNo").toString() : null);
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("expendBank") != null ? result.get("expendBank").toString() : null);
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("incomeAccountName") != null ? result.get("incomeAccountName").toString() : null);
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("incomeAccountNo") != null ? result.get("incomeAccountNo").toString() : null);
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("incomeBank") != null ? result.get("incomeBank").toString() : null);
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("incomeCerNo") != null ? result.get("incomeCerNo").toString() : null);
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("remark") != null ? result.get("remark").toString() : null);
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", e);
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return Result.success((String)"\u5bfc\u51fa\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25");
    }

    private String getWalletAccountName(String key) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":WalletAccountNo:" + key;
        Object value = null;
        if (this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            value = this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        } else {
            ComWalletAccountDTO comWalletAccount = this.comWalletAccountMapper.getComWalletAccountByWalletNo(key);
            if (comWalletAccount != null) {
                this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)comWalletAccount.getComName());
                this.stringRedisTemplate.expire((Object)redisKey, 86400000L, TimeUnit.MILLISECONDS);
                value = comWalletAccount.getComName();
            }
        }
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Result getDffSubsidyList(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getSubsidyType())) {
            return Result.fail((String)"\u8865\u8d34\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String resultStr = this.bbdTestService.bbdGetDffSubsidyList(dto);
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        Map<String, Integer> dfMap = new HashMap<String, Integer>();
        if (StringUtils.isNotEmpty((String)resultStr)) {
            Map map = (Map)JSON.parseObject((String)resultStr, Map.class);
            if (Integer.parseInt(map.get("total").toString()) == 0) {
                PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
                dfMap.put("money", 0);
                dfMap.put("count", 0);
                resultMap.put("pageInfo", pageInfo);
                resultMap.put("dfMap", (Serializable)((Object)dfMap));
                return Result.success((String)"", resultMap);
            }
            ArrayList list = (ArrayList)JSON.parseObject((String)map.get("data").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
            PageInfoUtils pageInfo = new PageInfoUtils(list);
            pageInfo.setTotal(Integer.parseInt(map.get("total").toString()));
            pageInfo.setTotalPage(Integer.parseInt(map.get("totalPage").toString()));
            dfMap = (Map)JSON.parseObject((String)map.get("userData").toString(), Map.class);
            resultMap.put("pageInfo", pageInfo);
            resultMap.put("dfMap", (Serializable)((Object)dfMap));
            return Result.success((String)"", resultMap);
        }
        PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
        dfMap.put("money", 0);
        dfMap.put("count", 0);
        resultMap.put("pageInfo", pageInfo);
        resultMap.put("dfMap", (Serializable)((Object)dfMap));
        return Result.success((String)"", resultMap);
    }

    @Override
    public Result sendsubSidyVerificationCode(ComWalletTransferDTO dto) throws V5BusinessException {
        this.commonService.sendCode(dto.getMobilePhone());
        return Result.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
    }

    @Override
    public Result getBbdSubsidyPageUrl(ComWalletTransferDTO dto) throws V5BusinessException {
        String bbdSubsidyPageUrl = this.bbdTestService.bbdGetBbdSubsidyPageUrl(dto);
        return Result.success((String)"", (Object)bbdSubsidyPageUrl);
    }

    @Override
    public Result grantBayZgzSubsidy(final ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getLastschriftAmount())) {
            return Result.fail((String)"\u5212\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBatchNo())) {
            return Result.fail((String)"\u8865\u8d34\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBatchName())) {
            return Result.fail((String)"\u8865\u8d34\u6279\u6b21\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getInId())) {
            return Result.fail((String)"\u6536\u5165\u4f01\u4e1aID\u4e0d\u80fd\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String activeCodeSerial = this.taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty((String)activeCodeSerial)) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u5931\u6548");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        dto.setNeedActiveCode("0");
        dto.setComment(dto.getBatchName() + "_\u4fdd\u5b89\u8d44\u683c\u8bc1\u8003\u52a1\u8865\u8d34\u53d1\u653e");
        dto.setOutId(dto.getComId().toString());
        dto.setGoodsName("\u4fdd\u5b89\u8d44\u683c\u8bc1\u8003\u52a1\u8865\u8d34");
        dto.setGoodsNumber("1");
        dto.setGoodsUnit("\u6279");
        Result result = this.comWalletAccountTransfer(dto);
        if (!ObjectUtils.equals((Object)result.getRetType(), (Object)"0")) {
            return result;
        }
        ComSubsidyGrantEvent comSubsidyGrantEvent = new ComSubsidyGrantEvent();
        comSubsidyGrantEvent.setComSubsidyGrantId(this.idWorker.nextId());
        comSubsidyGrantEvent.setCreateTime(new Date());
        comSubsidyGrantEvent.setCreateBy(dto.getCreateBy());
        comSubsidyGrantEvent.setSubsidyType("1");
        comSubsidyGrantEvent.setSubsidyComId(Long.parseLong(dto.getInId()));
        comSubsidyGrantEvent.setBatchNo(dto.getBatchNo());
        comSubsidyGrantEvent.setBatchName(dto.getBatchName());
        comSubsidyGrantEvent.setComId(dto.getComId());
        comSubsidyGrantEvent.setComWalletTradeId(Long.parseLong(result.getData().toString()));
        this.comSubsidyGrantEventMapper.insertComSubsidyGrantEvent(comSubsidyGrantEvent);
        ComWalletTransferDTO transferDTO = new ComWalletTransferDTO();
        transferDTO.setOutId(dto.getInId());
        transferDTO.setInId(this.commonService.getSystemConfig("PLAT_COMID"));
        transferDTO.setNeedActiveCode("0");
        transferDTO.setAmount(dto.getLastschriftAmount());
        transferDTO.setComment(dto.getBatchName() + "_\u4fdd\u5b89\u8d44\u683c\u8bc1\u8003\u52a1\u8865\u8d34\u53d1\u653e_\u5e73\u53f0\u670d\u52a1\u8d39");
        transferDTO.setGoodsName("\u4fdd\u5b89\u8d44\u683c\u8bc1\u8003\u52a1\u8865\u8d34_\u5e73\u53f0\u670d\u52a1\u8d39");
        transferDTO.setGoodsNumber("1");
        transferDTO.setGoodsUnit("\u6279");
        final Result result2 = this.comWalletAccountTransfer(transferDTO);
        if (!ObjectUtils.equals((Object)result2.getRetType(), (Object)"0")) {
            return result;
        }
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                Result result3 = ComWalletServiceImpl.this.bbdTestService.bbdSyncSubsidyGrantStatus(dto);
                if (ObjectUtils.equals((Object)result2.getRetType(), (Object)"0")) {
                    // empty if block
                }
            }
        });
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result grantZyjnpxSubsidy(final ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getLastschriftAmount())) {
            return Result.fail((String)"\u5212\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBatchNo())) {
            return Result.fail((String)"\u8865\u8d34\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBatchName())) {
            return Result.fail((String)"\u8865\u8d34\u6279\u6b21\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getInId())) {
            return Result.fail((String)"\u6536\u5165\u4f01\u4e1aID\u4e0d\u80fd\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.setNeedActiveCode("1");
        dto.setComment(dto.getBatchName() + "_\u804c\u4e1a\u6280\u80fd\u57f9\u8bad\u8865\u8d34");
        dto.setOutId(dto.getComId().toString());
        dto.setGoodsName("\u804c\u4e1a\u6280\u80fd\u57f9\u8bad\u8865\u8d34");
        dto.setGoodsNumber("1");
        dto.setGoodsUnit("\u6279");
        Result result = this.comWalletAccountTransfer(dto);
        if (!ObjectUtils.equals((Object)result.getRetType(), (Object)"0")) {
            return result;
        }
        ComSubsidyGrantEvent comSubsidyGrantEvent = new ComSubsidyGrantEvent();
        comSubsidyGrantEvent.setComSubsidyGrantId(this.idWorker.nextId());
        comSubsidyGrantEvent.setCreateTime(new Date());
        comSubsidyGrantEvent.setCreateBy(dto.getCreateBy());
        comSubsidyGrantEvent.setSubsidyType("2");
        comSubsidyGrantEvent.setSubsidyComId(Long.parseLong(dto.getInId()));
        comSubsidyGrantEvent.setBatchNo(dto.getBatchNo());
        comSubsidyGrantEvent.setBatchName(dto.getBatchName());
        comSubsidyGrantEvent.setComId(dto.getComId());
        comSubsidyGrantEvent.setComWalletTradeId(Long.parseLong(result.getData().toString()));
        this.comSubsidyGrantEventMapper.insertComSubsidyGrantEvent(comSubsidyGrantEvent);
        ComWalletTransferDTO transferDTO = new ComWalletTransferDTO();
        transferDTO.setOutId(dto.getInId());
        transferDTO.setInId(this.commonService.getSystemConfig("PLAT_COMID"));
        transferDTO.setNeedActiveCode("0");
        transferDTO.setAmount(dto.getLastschriftAmount());
        transferDTO.setComment(dto.getBatchName() + "_\u804c\u4e1a\u6280\u80fd\u57f9\u8bad\u8865\u8d34_\u5e73\u53f0\u670d\u52a1\u8d39");
        transferDTO.setGoodsName("\u804c\u4e1a\u6280\u80fd\u57f9\u8bad\u8865\u8d34_\u5e73\u53f0\u670d\u52a1\u8d39");
        transferDTO.setGoodsNumber("1");
        transferDTO.setGoodsUnit("\u6279");
        final Result result2 = this.comWalletAccountTransfer(transferDTO);
        if (!ObjectUtils.equals((Object)result2.getRetType(), (Object)"0")) {
            return result;
        }
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                Result result3 = ComWalletServiceImpl.this.bbdTestService.bbdSyncSubsidyGrantStatus(dto);
                if (ObjectUtils.equals((Object)result2.getRetType(), (Object)"0")) {
                    // empty if block
                }
            }
        });
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getYffSubsidyList(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getSubsidyType())) {
            return Result.fail((String)"\u8865\u8d34\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.comSubsidyGrantEventMapper.getYffSubsidyList(dto);
        PageInfoUtils<Map<String, Object>> pageInfo = new PageInfoUtils<Map<String, Object>>(list);
        return Result.success((String)"", pageInfo);
    }

    @Override
    public Result getYffSubsidyInfo(ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getSubsidyType())) {
            return Result.fail((String)"\u8865\u8d34\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> map = this.comSubsidyGrantEventMapper.getYffSubsidyInfo(dto);
        return Result.success((String)"", map);
    }
}

