/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.product.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.product.ProductCoupon;
import com.bcxin.platform.dto.product.ProductCouponDownloadDto;
import com.bcxin.platform.dto.product.ProductCouponDto;
import com.bcxin.platform.mapper.product.ProductCouponMapper;
import com.bcxin.platform.service.product.ProductCouponService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ProductCouponServiceImpl
implements ProductCouponService {
    @Resource
    private ProductCouponMapper productCouponMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public Result checkProductCoupon(ProductCoupon productCoupon) throws V5BusinessException {
        if (productCoupon.getProductCouponId() == null) {
            return Result.fail((String)"\u4f18\u60e0\u5238\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)productCoupon.getProductCategoryType())) {
            return Result.fail((String)"\u4ea7\u54c1\u8303\u7574\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((productCoupon = this.productCouponMapper.getProductCouponById(productCoupon.getProductCouponId(), productCoupon.getProductCategoryType())) == null) {
            return Result.fail((String)"\u4f18\u60e0\u5238\u7801\u65e0\u6548");
        }
        Date now = new Date();
        if (productCoupon.getStartTime().after(now)) {
            return Result.fail((String)"\u4f18\u60e0\u5238\u672a\u751f\u6548");
        }
        if ("1".equals(productCoupon.getCouponStatus())) {
            return Result.fail((String)"\u4f18\u60e0\u5238\u5df2\u4f7f\u7528");
        }
        if (productCoupon.getExpireTime().before(now)) {
            return Result.fail((String)"\u4f18\u60e0\u5238\u5df2\u8fc7\u671f");
        }
        return Result.success((String)"", (Object)productCoupon);
    }

    @Override
    public ProductCoupon selectProductCouponById(Long productCouponId) {
        return this.productCouponMapper.selectProductCouponById(productCouponId);
    }

    @Override
    public List<ProductCouponDownloadDto> selectProductCouponList(ProductCouponDto productCoupon) {
        return this.productCouponMapper.selectProductCouponList(productCoupon);
    }

    @Override
    public int updateProductCoupon(ProductCoupon productCoupon) {
        if (productCoupon.getProductCouponId() == null) {
            productCoupon.setCreateTime(DateUtils.getNowDate());
            productCoupon.setCreateBy(ShiroUtils.getUserId());
            productCoupon.setExpireTime(DateUtils.addSeconds((Date)DateUtils.addDays((Date)productCoupon.getStartTime(), (int)productCoupon.getExpireDays()), (int)-1));
            productCoupon.setProductCategoryType("11");
            productCoupon.setCouponStatus("0");
            productCoupon.setProductCouponId(this.idWorker.nextId());
        } else {
            ProductCoupon dbProductCoupon = this.productCouponMapper.selectProductCouponById(productCoupon.getProductCouponId());
            BeanUtils.copyPropertiesIgnore((Object)productCoupon, (Object)dbProductCoupon, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbProductCoupon, (Object)productCoupon, (Boolean)false);
        }
        productCoupon.setUpdateTime(DateUtils.getNowDate());
        return this.productCouponMapper.save(productCoupon);
    }

    @Override
    public int deleteProductCouponByIds(String ids) {
        return this.productCouponMapper.deleteProductCouponByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteProductCouponById(Long productCouponId) {
        return this.productCouponMapper.deleteProductCouponById(productCouponId);
    }
}

