/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.grant;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComGrantRecord;
import com.bcxin.platform.mapper.grant.ComGrantRecordMapper;
import com.bcxin.platform.service.grant.ComGrantRecordService;
import com.bcxin.platform.util.PageInfoUtils;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComGrantRecordServiceImpl
implements ComGrantRecordService {
    @Resource
    private ComGrantRecordMapper comGrantRecordMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public Result pageComGrantRecordList(ComGrantRecord comGrantRecord) throws V5BusinessException {
        if (comGrantRecord.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comGrantRecord.getPageNumber() == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comGrantRecord.getPageSize() == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)comGrantRecord.getPageNumber(), (int)comGrantRecord.getPageSize());
        List<Map<String, Object>> comGrantRecordList = this.comGrantRecordMapper.pageComGrantRecordList(comGrantRecord);
        PageInfoUtils<Map<String, Object>> pageInfo = new PageInfoUtils<Map<String, Object>>(comGrantRecordList);
        return Result.success((String)"", pageInfo);
    }

    @Override
    public Result saveOffLineGrantRecord(ComGrantRecord comGrantRecord) throws V5BusinessException {
        if (comGrantRecord.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comGrantRecord.getComGrantRecordId() == null) {
            comGrantRecord.setComGrantRecordId(this.idWorker.nextId());
            comGrantRecord.setGrantChannel("2");
            this.comGrantRecordMapper.insertComGrantRecord(comGrantRecord);
        } else {
            comGrantRecord.setGrantChannel("2");
            this.comGrantRecordMapper.updateComGrantRecord(comGrantRecord);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result deleteOffLineGrantRecord(ComGrantRecord comGrantRecord) throws V5BusinessException {
        if (comGrantRecord.getComGrantRecordId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u53d1\u653e\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.comGrantRecordMapper.deleteComGrantRecordById(comGrantRecord);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

