/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.grant;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.grant.ComBhGrantDetail;
import com.bcxin.platform.domain.grant.ComBhGrantInfo;
import com.bcxin.platform.domain.grant.ComBhGrantOperRecord;
import com.bcxin.platform.dto.grant.ComBhGrantInfoDTO;
import com.bcxin.platform.mapper.grant.ComBhGrantDetailMapper;
import com.bcxin.platform.mapper.grant.ComBhGrantInfoMapper;
import com.bcxin.platform.mapper.grant.ComBhGrantOperRecordMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.grant.ComBhGrantService;
import com.bcxin.platform.util.Base64Utils;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.ObjectUtils;
import com.bcxin.platform.util.PageInfoUtils;
import com.bcxin.platform.util.excel.ExcelEnum;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.bcxin.platform.util.file.BcxinFileUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(value="transactionManager")
public class ComBhGrantServiceImpl
implements ComBhGrantService {
    private static final Logger logger = LoggerFactory.getLogger(ComBhGrantServiceImpl.class);
    @Resource
    private ComBhGrantDetailMapper comBhGrantDetailMapper;
    @Resource
    private ComBhGrantInfoMapper comBhGrantInfoMapper;
    @Resource
    private ComBhGrantOperRecordMapper comBhGrantOperRecordMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private IdWorker idWorker;
    private static final String BHGRANTFILETYPE = "4";
    private static final String BHGRANTQDDM = "C5";

    @Override
    public Result pageComBhGrantInfoList(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, String>> list = this.comBhGrantInfoMapper.pageComBhGrantInfoList(dto);
        PageInfoUtils<Map<String, String>> pageInfo = new PageInfoUtils<Map<String, String>>(list);
        return Result.success((String)"", pageInfo);
    }

    @Override
    public Result saveComBhGrantInfo(ComBhGrantInfo comBhGrantInfo) throws V5BusinessException {
        if (StringUtil.isEmpty((String)comBhGrantInfo.getTitle())) {
            throw new V5BusinessException("-1", "\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)comBhGrantInfo.getGrantType())) {
            throw new V5BusinessException("-1", "\u53d1\u653e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        comBhGrantInfo.setComBhGrantId(this.idWorker.nextId());
        comBhGrantInfo.setSumAmount(BigDecimal.ZERO);
        comBhGrantInfo.setGrantCount(0);
        comBhGrantInfo.setTotalSumAmount(BigDecimal.ZERO);
        comBhGrantInfo.setTotalGrantCount(0);
        this.comBhGrantInfoMapper.insertComBhGrantInfo(comBhGrantInfo);
        ComBhGrantOperRecord record = new ComBhGrantOperRecord();
        record.setCreateBy(comBhGrantInfo.getCreateBy());
        record.setCreateTime((Date)DateUtil.date());
        record.setComId(comBhGrantInfo.getComId());
        record.setComBhGrantId(comBhGrantInfo.getComBhGrantId());
        record.setComBhGrantOperRecordId(this.idWorker.nextId());
        record.setOperGrantFuncType("1");
        record.setOperResult("\u65b0\u5efa\u201c" + comBhGrantInfo.getTitle() + "\u201d");
        this.comBhGrantOperRecordMapper.insertComBhGrantOperRecord(record);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)comBhGrantInfo);
    }

    @Override
    public Result getComBhGrantInfoById(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u6e24\u6d77\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(dto.getComBhGrantId());
        return Result.success((String)"", (Object)comBhGrantInfo);
    }

    @Override
    public Result deleteComBhGrantInfo(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u4ee3\u53d1\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(dto.getComBhGrantId());
        if (!"0".equals(comBhGrantInfo.getCommitStatus())) {
            throw new V5BusinessException("-1", "\u53ea\u5141\u8bb8\u5220\u9664\u5f85\u63d0\u4ea4\u7684\u8bb0\u5f55");
        }
        this.comBhGrantInfoMapper.deleteById(dto.getComBhGrantId());
        this.comBhGrantDetailMapper.deleteByComBhGrantId(dto.getComBhGrantId());
        this.comBhGrantOperRecordMapper.deleteGrantOperRecordByComBhGrantId(dto.getComBhGrantId());
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result pageComBhGrantDetailList(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u4ee3\u53d1\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> comGrantInfoList = this.comBhGrantDetailMapper.getComBhGrantDetailList(dto);
        PageInfoUtils<Map<String, Object>> pageInfo = new PageInfoUtils<Map<String, Object>>(comGrantInfoList);
        return Result.success((String)"", pageInfo);
    }

    @Override
    public Result exportOfflineGrantTemp(ComBhGrantInfoDTO dto, HttpServletResponse response) throws V5BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "_\u85aa\u8d44\u4ee3\u53d1\u6a21\u677f" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u85aa\u8d44\u4ee3\u53d1\u6a21\u677f");
            String headerTitle = "\u85aa\u8d44\u4ee3\u53d1\u6a21\u677f\u586b\u5199\u987b\u77e5\uff1a\n <1>\u8868\u5355\u5217\u76ee\u4e2d\u5e26*\u53f7\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff1b\n <2>\u7cfb\u7edf\u4f1a\u6839\u636e\u5bfc\u5165\u4eba\u5458\u7684\u8eab\u4efd\u8bc1\u53f7\u5339\u914d\u4fdd\u5b89\u5458\u8bc1\u8054\u540d\u5361\u8d26\u53f7\u4f5c\u4e3a\u6536\u6b3e\u8d26\u53f7\uff1b\u82e5\u4eba\u5458\u6ca1\u6709\u5f00\u901a\u4fdd\u5b89\u5458\u8bc1\u8054\u540d\u5361\uff0c\u5219\u65e0\u6cd5\u5728\u7ebf\u53d1\u85aa\uff1b\n <3>\u4e00\u4e2a\u4ee3\u53d1\u5355\u91cc\u7684\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53ea\u80fd\u4e00\u6761\uff0c\u82e5\u9700\u8981\u7ed9\u67d0\u4e2a\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53d1\u653e\u591a\u7b14\u8d44\u91d1\uff0c\u8bf7\u53e6\u5efa\u4ee3\u53d1\u5355\u53d1\u653e\uff1b\n <4>\u5f53\u9700\u8981\u66f4\u65b0\u5df2\u5bfc\u5165\u53d1\u653e\u6570\u636e\u65f6\uff0c\u8bf7\u5148\u5728\u7cfb\u7edf\u9875\u9762\u5220\u9664\u76f8\u5e94\u8bb0\u5f55\u540e\uff0c\u518d\u91cd\u65b0\u5bfc\u5165\uff1b";
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);
            HSSFRow rowFirst = sheet1.createRow(0);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            rowFirst.setHeight((short)3000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle);
            HSSFRow rowSecond = sheet1.createRow(1);
            String[] firstArr = new String[]{"*\u59d3\u540d", "*\u8eab\u4efd\u8bc1", "*\u53d1\u653e\u91d1\u989d"};
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowSecond.createCell(i);
                int column = i == 0 || i == 2 ? 4000 : 6000;
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
            }
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowSecond.createCell(i);
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(style1);
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return Result.success((String)"\u5bfc\u51fa\u85aa\u8d44\u4ee3\u53d1\u6a21\u677f\u6570\u636e\u6587\u4ef6\u6210\u529f");
    }

    @Override
    public Result importOfflineGrantTemp(MultipartFile xfile, ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGrantYears())) {
            throw new V5BusinessException("-1", "\u53d1\u653e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileType = xfile.getOriginalFilename().substring(xfile.getOriginalFilename().lastIndexOf(".") + 1).toLowerCase();
        if (xfile != null && xfile.getSize() > 0L && !fileType.equals(ExcelEnum.EXCEL_TYPE_XLS.getValue()) && !fileType.equals(ExcelEnum.EXCEL_TYPE_XLSX.getValue())) {
            return Result.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u662fExcel\u6587\u4ef6\uff01");
        }
        InputStream inputStream = null;
        Integer importCount = 0;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        ArrayList faildList = new ArrayList();
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>();
        try {
            Object row;
            inputStream = xfile.getInputStream();
            Workbook workBook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 2;
            while (flag) {
                row = sheet.getRow(i);
                if (row != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    String errorMsg = "";
                    String name = ExcelUtil.getCellValue(row.getCell(0));
                    name = name.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    hashMap.put("name", name);
                    String idCardNo = ExcelUtil.getCellValue(row.getCell(1));
                    idCardNo = idCardNo.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    if (idCardNo.contains("E") && idCardNo.contains(".")) {
                        BigDecimal bd = new BigDecimal(idCardNo);
                        idCardNo = bd.toPlainString();
                    }
                    hashMap.put("idCardNo", idCardNo);
                    String amount = ExcelUtil.getCellValue(row.getCell(2));
                    amount = amount.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    hashMap.put("amount", amount);
                    hashMap.put("bankCardNo", null);
                    if (StringUtil.isEmpty((String)name)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a" : " || \u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtil.isEmpty((String)idCardNo)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a" : " || \u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtil.isEmpty((String)amount)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a" : " || \u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                    } else if (!StringUtils.isBigDecimal((String)amount)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u53d1\u653e\u91d1\u989d\u6709\u8bef" : " || \u53d1\u653e\u91d1\u989d\u6709\u8bef");
                    } else if (new BigDecimal(amount).compareTo(BigDecimal.ZERO) < 1) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570" : " || \u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570");
                    }
                    if (StringUtil.isNotEmpty((String)errorMsg)) {
                        hashMap.put("errorMsg", errorMsg);
                        faildList.add(hashMap);
                        returnList.add(hashMap);
                    } else {
                        list.add(hashMap);
                    }
                    Integer n = importCount;
                    Integer n2 = importCount = Integer.valueOf(importCount + 1);
                } else {
                    flag = false;
                }
                ++i;
            }
            if (list.size() == 0 && faildList.size() == 0) {
                row = Result.fail((String)"\u5bfc\u5165\u6a21\u677f\u6ca1\u6709\u4fe1\u606f");
                return row;
            }
            for (Map map : list) {
                map.put("comBhGrantDetailId", String.valueOf(this.idWorker.nextId()));
            }
            if (list != null && list.size() > 0) {
                List<Map<String, String>> tempInputPerList = this.saveOfflineGrantInfo(list, importCount, dto);
                ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
                for (Map<String, String> map : tempInputPerList) {
                    if (map.get("isSuccess").equals("0")) {
                        arrayList.add(map);
                    }
                    returnList.add(map);
                }
                if (arrayList != null && arrayList.size() > 0) {
                    faildList.addAll(arrayList);
                }
            }
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException sheet) {
                    // empty catch block
                }
            }
            e.printStackTrace();
            throw new V5BusinessException("-1", "\u8868\u683c\u6570\u636e\u6709\u8bef");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String resultMsg = MessageFormat.format("\u672c\u6b21\u5bfc\u5165\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6821\u9a8c\u5931\u8d25\u6761\u6570:\u3010{1}\u3011", importCount, faildList.size());
        if (faildList.size() > 0) {
            String fileUrl = "";
            try {
                fileUrl = this.buildFaildExcel(returnList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new V5BusinessException("-1", "\u751f\u6210\u9519\u8bef\u5931\u8d25\u4eba\u5458\u6587\u4ef6\u9519\u8bef");
            }
            return Result.fail((String)resultMsg, (Object)fileUrl);
        }
        return Result.success((String)resultMsg);
    }

    public List<Map<String, String>> saveOfflineGrantInfo(List<Map<String, String>> grantList, Integer sumCount, ComBhGrantInfoDTO dto) throws V5BusinessException {
        int insertLength;
        Long importBatchId = this.idWorker.nextId();
        int i = 0;
        for (insertLength = grantList.size(); insertLength > 2000; insertLength -= 2000) {
            this.comBhGrantInfoMapper.insertTempOfflineBhGrant(grantList.subList(i, i + 2000), importBatchId);
            i += 2000;
        }
        if (insertLength > 0) {
            this.comBhGrantInfoMapper.insertTempOfflineBhGrant(grantList.subList(i, i + insertLength), importBatchId);
        }
        this.comBhGrantInfoMapper.checkIdCardNoRepeat(importBatchId);
        this.comBhGrantInfoMapper.checkExistsIdCard(importBatchId);
        this.comBhGrantInfoMapper.updateCheckPassPerId(importBatchId);
        this.comBhGrantInfoMapper.checkPerExistsJointlyCard(importBatchId);
        this.comBhGrantInfoMapper.checkExistsRecord(importBatchId, dto.getComBhGrantId());
        List<Map<String, String>> tempOfflineGrantList = this.comBhGrantInfoMapper.getTempOfflineBhGrantList(importBatchId);
        Integer checkPassCount = 0;
        for (Map<String, String> map : tempOfflineGrantList) {
            if (!map.get("isSuccess").equals("1")) continue;
            Integer n = checkPassCount;
            Integer n2 = checkPassCount = Integer.valueOf(checkPassCount + 1);
        }
        if (sumCount.equals(checkPassCount)) {
            this.comBhGrantInfoMapper.updateBhGrantInfo(importBatchId, dto.getUpdateBy(), dto.getComBhGrantId(), dto.getGrantYears(), "2");
            this.comBhGrantDetailMapper.insertBhGrantDetail(importBatchId, dto.getCreateBy(), dto.getComBhGrantId(), dto.getGrantYears());
            ComBhGrantOperRecord record = new ComBhGrantOperRecord();
            record.setCreateBy(dto.getCreateBy());
            record.setCreateTime((Date)DateUtil.date());
            record.setComId(dto.getComId());
            record.setComBhGrantId(dto.getComBhGrantId());
            record.setComBhGrantOperRecordId(this.idWorker.nextId());
            record.setOperGrantFuncType("5");
            record.setOperResult("\u5bfc\u5165\u53d1\u653e\u6570\u636e" + sumCount + "\u6761");
            this.comBhGrantOperRecordMapper.insertComBhGrantOperRecord(record);
        }
        this.comBhGrantInfoMapper.deleteTempOfflineBhGrantImport(importBatchId);
        return tempOfflineGrantList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildFaildExcel(List<Map<String, String>> failList) throws V5BusinessException {
        FileOutputStream fileOut = null;
        try {
            int i;
            Date now = new Date();
            String upload_path = this.commonService.getSystemConfig("SYS_PIC_PATH");
            String dirDate = DateUtil.today();
            String dirPaht = upload_path + "temp/" + dirDate;
            File dir = new File(dirPaht);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = now.getTime() + RandomUtil.randomNumbers((int)6) + ".xls";
            String filePath = dirPaht + "/" + fileName;
            File file = new File(filePath);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u85aa\u8d44\u4ee3\u53d1\u6a21\u677f");
            String headerTitle = "\u85aa\u8d44\u4ee3\u53d1\u6a21\u677f\u586b\u5199\u987b\u77e5\uff1a\n <1>\u8868\u5355\u5217\u76ee\u4e2d\u5e26*\u53f7\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff1b\n <2>\u7cfb\u7edf\u4f1a\u6839\u636e\u5bfc\u5165\u4eba\u5458\u7684\u8eab\u4efd\u8bc1\u53f7\u5339\u914d\u4fdd\u5b89\u5458\u8bc1\u8054\u540d\u5361\u8d26\u53f7\u4f5c\u4e3a\u6536\u6b3e\u8d26\u53f7\uff1b\u82e5\u4eba\u5458\u6ca1\u6709\u5f00\u901a\u4fdd\u5b89\u5458\u8bc1\u8054\u540d\u5361\uff0c\u5219\u65e0\u6cd5\u5728\u7ebf\u53d1\u85aa\uff1b\n <3>\u4e00\u4e2a\u4ee3\u53d1\u5355\u91cc\u7684\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53ea\u80fd\u4e00\u6761\uff0c\u82e5\u9700\u8981\u7ed9\u67d0\u4e2a\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53d1\u653e\u591a\u7b14\u8d44\u91d1\uff0c\u8bf7\u53e6\u5efa\u4ee3\u53d1\u5355\u53d1\u653e\uff1b\n <4>\u5f53\u9700\u8981\u66f4\u65b0\u5df2\u5bfc\u5165\u53d1\u653e\u6570\u636e\u65f6\uff0c\u8bf7\u5148\u5728\u7cfb\u7edf\u9875\u9762\u5220\u9664\u76f8\u5e94\u8bb0\u5f55\u540e\uff0c\u518d\u91cd\u65b0\u5bfc\u5165\uff1b";
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);
            HSSFRow rowFirst = sheet1.createRow(0);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            rowFirst.setHeight((short)3000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle);
            HSSFRow rowSecond = sheet1.createRow(1);
            String[] firstArr = new String[]{"*\u59d3\u540d", "*\u8eab\u4efd\u8bc1", "*\u53d1\u653e\u91d1\u989d", "\u9519\u8bef\u4fe1\u606f"};
            for (i = 0; i < firstArr.length; ++i) {
                int column = i == 0 || i == 2 ? 4000 : (i == 1 ? 6000 : 8000);
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
            }
            for (i = 0; i < firstArr.length; ++i) {
                HSSFCell cell = rowSecond.createCell(i);
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(style1);
            }
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, String> map : failList) {
                row = sheet1.createRow(rowIndex);
                row.createCell(0).setCellValue(map.get("name"));
                row.createCell(1).setCellValue(map.get("idCardNo"));
                row.createCell(2).setCellValue(map.get("amount"));
                row.createCell(3).setCellValue(map.get("errorMsg"));
                ++rowIndex;
            }
            fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
            String platform = this.commonService.getSystemConfig("PLATFORM_SIGN");
            String aliUrl = BcxinFileUtils.aliOSSFileTempUpload(file, platform);
            file.delete();
            String string = aliUrl;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Result exportOfflineBankGrantTemp(ComBhGrantInfoDTO dto, HttpServletResponse response) throws V5BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "_\u85aa\u8d44\u4ee3\u53d1(\u94f6\u884c\u5361)\u6a21\u677f" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u85aa\u8d44\u4ee3\u53d1(\u94f6\u884c\u5361)\u6a21\u677f");
            String headerTitle = "\u85aa\u8d44\u4ee3\u53d1(\u94f6\u884c\u5361)\u6a21\u677f\u586b\u5199\u987b\u77e5\uff1a\n <1>\u8868\u5355\u5217\u76ee\u4e2d\u5e26*\u53f7\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff1b\n <2>\u7cfb\u7edf\u6839\u636e\u5bfc\u5165\u4eba\u5458\u7684\u6536\u6b3e\u8d26\u53f7\u8fdb\u884c\u53d1\u653e\uff1b\n <3>\u4e00\u4e2a\u4ee3\u53d1\u5355\u91cc\u7684\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53ea\u80fd\u4e00\u6761\uff0c\u82e5\u9700\u8981\u7ed9\u67d0\u4e2a\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53d1\u653e\u591a\u7b14\u8d44\u91d1\uff0c\u8bf7\u53e6\u5efa\u4ee3\u53d1\u5355\u53d1\u653e\uff1b\n <4>\u5f53\u9700\u8981\u66f4\u65b0\u5df2\u5bfc\u5165\u53d1\u653e\u6570\u636e\u65f6\uff0c\u8bf7\u5148\u5728\u7cfb\u7edf\u9875\u9762\u5220\u9664\u76f8\u5e94\u8bb0\u5f55\u540e\uff0c\u518d\u91cd\u65b0\u5bfc\u5165\uff1b";
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);
            HSSFRow rowFirst = sheet1.createRow(0);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            rowFirst.setHeight((short)3000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle);
            HSSFRow rowSecond = sheet1.createRow(1);
            String[] firstArr = new String[]{"*\u59d3\u540d", "*\u8eab\u4efd\u8bc1", "*\u94f6\u884c\u5361\u53f7", "*\u53d1\u653e\u91d1\u989d"};
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowSecond.createCell(i);
                int column = i == 0 || i == 3 ? 4000 : 6000;
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
            }
            for (i = 0; i < firstArr.length; ++i) {
                cell = rowSecond.createCell(i);
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(style1);
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return Result.success((String)"\u5bfc\u51fa\u85aa\u8d44\u4ee3\u53d1(\u94f6\u884c\u5361)\u6a21\u677f\u6587\u4ef6\u6210\u529f");
    }

    @Override
    public Result importOfflineBankGrantTemp(MultipartFile xfile, ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGrantYears())) {
            throw new V5BusinessException("-1", "\u53d1\u653e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileType = xfile.getOriginalFilename().substring(xfile.getOriginalFilename().lastIndexOf(".") + 1).toLowerCase();
        if (xfile != null && xfile.getSize() > 0L && !fileType.equals(ExcelEnum.EXCEL_TYPE_XLS.getValue()) && !fileType.equals(ExcelEnum.EXCEL_TYPE_XLSX.getValue())) {
            return Result.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u662fExcel\u6587\u4ef6\uff01");
        }
        InputStream inputStream = null;
        Integer importCount = 0;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        ArrayList faildList = new ArrayList();
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>();
        try {
            Object row;
            inputStream = xfile.getInputStream();
            Workbook workBook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 2;
            while (flag) {
                row = sheet.getRow(i);
                if (row != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    String errorMsg = "";
                    String name = ExcelUtil.getCellValue(row.getCell(0));
                    name = name.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    hashMap.put("name", name);
                    String idCardNo = ExcelUtil.getCellValue(row.getCell(1));
                    idCardNo = idCardNo.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    if (idCardNo.contains("E") && idCardNo.contains(".")) {
                        BigDecimal bd = new BigDecimal(idCardNo);
                        idCardNo = bd.toPlainString();
                    }
                    hashMap.put("idCardNo", idCardNo);
                    String bankCardNo = ExcelUtil.getCellValue(row.getCell(2));
                    bankCardNo = bankCardNo.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    if (bankCardNo.contains("E") && bankCardNo.contains(".")) {
                        BigDecimal bankCardNoBd = new BigDecimal(bankCardNo);
                        bankCardNo = bankCardNoBd.toPlainString();
                    }
                    hashMap.put("bankCardNo", bankCardNo);
                    String amount = ExcelUtil.getCellValue(row.getCell(3));
                    amount = amount.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll("\u00a0", "");
                    hashMap.put("amount", amount);
                    if (StringUtil.isEmpty((String)name)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a" : " || \u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtil.isEmpty((String)idCardNo)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a" : " || \u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtil.isEmpty((String)bankCardNo)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a" : " || \u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    } else if (bankCardNo.length() <= 12 || bankCardNo.length() >= 20) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u8bf7\u786e\u8ba4\u94f6\u884c\u5361\u53f7\u662f\u5426\u6709\u6548" : " || \u8bf7\u786e\u8ba4\u94f6\u884c\u5361\u53f7\u662f\u5426\u6709\u6548");
                    }
                    if (StringUtil.isEmpty((String)amount)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a" : " || \u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                    } else if (!StringUtils.isBigDecimal((String)amount)) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u53d1\u653e\u91d1\u989d\u6709\u8bef" : " || \u53d1\u653e\u91d1\u989d\u6709\u8bef");
                    } else if (new BigDecimal(amount).compareTo(BigDecimal.ZERO) < 1) {
                        errorMsg = errorMsg + (StringUtil.isEmpty((String)errorMsg) ? "\u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570" : " || \u53d1\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a0\u6216\u8d1f\u6570");
                    }
                    if (StringUtil.isNotEmpty((String)errorMsg)) {
                        hashMap.put("errorMsg", errorMsg);
                        faildList.add(hashMap);
                        returnList.add(hashMap);
                    } else {
                        list.add(hashMap);
                    }
                    Integer n = importCount;
                    Integer n2 = importCount = Integer.valueOf(importCount + 1);
                } else {
                    flag = false;
                }
                ++i;
            }
            if (list.size() == 0 && faildList.size() == 0) {
                row = Result.fail((String)"\u5bfc\u5165\u6a21\u677f\u6ca1\u6709\u4fe1\u606f");
                return row;
            }
            for (Map map : list) {
                map.put("comBhGrantDetailId", String.valueOf(this.idWorker.nextId()));
            }
            if (list != null && list.size() > 0) {
                List<Map<String, String>> tempInputPerList = this.saveOfflineBankGrantInfo(list, importCount, dto);
                ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
                for (Map<String, String> map : tempInputPerList) {
                    if (map.get("isSuccess").equals("0")) {
                        arrayList.add(map);
                    }
                    returnList.add(map);
                }
                if (arrayList != null && arrayList.size() > 0) {
                    faildList.addAll(arrayList);
                }
            }
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException sheet) {
                    // empty catch block
                }
            }
            e.printStackTrace();
            throw new V5BusinessException("-1", "\u8868\u683c\u6570\u636e\u6709\u8bef");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String resultMsg = MessageFormat.format("\u672c\u6b21\u5bfc\u5165\u6761\u6570\u3010{0}\u3011,\u5176\u4e2d\u6821\u9a8c\u5931\u8d25\u6761\u6570:\u3010{1}\u3011", importCount, faildList.size());
        if (faildList.size() > 0) {
            String fileUrl = "";
            try {
                fileUrl = this.buildBankFaildExcel(returnList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new V5BusinessException("-1", "\u751f\u6210\u9519\u8bef\u5bfc\u5165\u6587\u4ef6\u9519\u8bef");
            }
            return Result.fail((String)resultMsg, (Object)fileUrl);
        }
        return Result.success((String)resultMsg);
    }

    public List<Map<String, String>> saveOfflineBankGrantInfo(List<Map<String, String>> grantList, Integer sumCount, ComBhGrantInfoDTO dto) throws V5BusinessException {
        int insertLength;
        Long importBatchId = this.idWorker.nextId();
        int i = 0;
        for (insertLength = grantList.size(); insertLength > 2000; insertLength -= 2000) {
            this.comBhGrantInfoMapper.insertTempOfflineBhGrant(grantList.subList(i, i + 2000), importBatchId);
            i += 2000;
        }
        if (insertLength > 0) {
            this.comBhGrantInfoMapper.insertTempOfflineBhGrant(grantList.subList(i, i + insertLength), importBatchId);
        }
        this.comBhGrantInfoMapper.checkIdCardNoRepeat(importBatchId);
        this.comBhGrantInfoMapper.checkExistsIdCard(importBatchId);
        this.comBhGrantInfoMapper.checkBankCardNoRepeat(importBatchId);
        this.comBhGrantInfoMapper.updateCheckPassPerId(importBatchId);
        this.comBhGrantInfoMapper.checkExistsRecord(importBatchId, dto.getComBhGrantId());
        List<Map<String, String>> tempOfflineGrantList = this.comBhGrantInfoMapper.getTempOfflineBhGrantList(importBatchId);
        Integer checkPassCount = 0;
        for (Map<String, String> map : tempOfflineGrantList) {
            if (!map.get("isSuccess").equals("1")) continue;
            Integer n = checkPassCount;
            Integer n2 = checkPassCount = Integer.valueOf(checkPassCount + 1);
        }
        if (sumCount.equals(checkPassCount)) {
            this.comBhGrantInfoMapper.updateBhGrantInfo(importBatchId, dto.getUpdateBy(), dto.getComBhGrantId(), dto.getGrantYears(), "2");
            this.comBhGrantDetailMapper.insertBhBankGrantDetail(importBatchId, dto.getCreateBy(), dto.getComBhGrantId(), dto.getGrantYears());
            ComBhGrantOperRecord record = new ComBhGrantOperRecord();
            record.setCreateBy(dto.getCreateBy());
            record.setCreateTime((Date)DateUtil.date());
            record.setComId(dto.getComId());
            record.setComBhGrantId(dto.getComBhGrantId());
            record.setComBhGrantOperRecordId(this.idWorker.nextId());
            record.setOperGrantFuncType("5");
            record.setOperResult("\u5bfc\u5165\u53d1\u653e\u6570\u636e" + sumCount + "\u6761");
            this.comBhGrantOperRecordMapper.insertComBhGrantOperRecord(record);
        }
        this.comBhGrantInfoMapper.deleteTempOfflineBhGrantImport(importBatchId);
        return tempOfflineGrantList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildBankFaildExcel(List<Map<String, String>> failList) throws V5BusinessException {
        FileOutputStream fileOut = null;
        try {
            int i;
            Date now = new Date();
            String upload_path = this.commonService.getSystemConfig("SYS_PIC_PATH");
            String dirDate = DateUtil.today();
            String dirPaht = upload_path + "temp/" + dirDate;
            File dir = new File(dirPaht);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = now.getTime() + RandomUtil.randomNumbers((int)6) + ".xls";
            String filePath = dirPaht + "/" + fileName;
            File file = new File(filePath);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u85aa\u8d44\u4ee3\u53d1(\u94f6\u884c\u5361)\u6a21\u677f");
            String headerTitle = "\u85aa\u8d44\u4ee3\u53d1(\u94f6\u884c\u5361)\u6a21\u677f\u586b\u5199\u987b\u77e5\uff1a\n <1>\u8868\u5355\u5217\u76ee\u4e2d\u5e26*\u53f7\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff1b\n <2>\u7cfb\u7edf\u6839\u636e\u5bfc\u5165\u4eba\u5458\u7684\u6536\u6b3e\u8d26\u53f7\u8fdb\u884c\u53d1\u653e\uff1b\n <3>\u4e00\u4e2a\u4ee3\u53d1\u5355\u91cc\u7684\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53ea\u80fd\u4e00\u6761\uff0c\u82e5\u9700\u8981\u7ed9\u67d0\u4e2a\u4eba\u5458\uff08\u6536\u6b3e\u8d26\u6237\uff09\u53d1\u653e\u591a\u7b14\u8d44\u91d1\uff0c\u8bf7\u53e6\u5efa\u4ee3\u53d1\u5355\u53d1\u653e\uff1b\n <4>\u5f53\u9700\u8981\u66f4\u65b0\u5df2\u5bfc\u5165\u53d1\u653e\u6570\u636e\u65f6\uff0c\u8bf7\u5148\u5728\u7cfb\u7edf\u9875\u9762\u5220\u9664\u76f8\u5e94\u8bb0\u5f55\u540e\uff0c\u518d\u91cd\u65b0\u5bfc\u5165\uff1b";
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);
            HSSFRow rowFirst = sheet1.createRow(0);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            rowFirst.setHeight((short)3000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle);
            HSSFRow rowSecond = sheet1.createRow(1);
            String[] firstArr = new String[]{"*\u59d3\u540d", "*\u8eab\u4efd\u8bc1", "*\u94f6\u884c\u5361\u53f7", "*\u53d1\u653e\u91d1\u989d", "\u9519\u8bef\u4fe1\u606f"};
            for (i = 0; i < firstArr.length; ++i) {
                int column = i == 0 || i == 3 ? 4000 : (i == 1 || i == 2 ? 6000 : 8000);
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
            }
            for (i = 0; i < firstArr.length; ++i) {
                HSSFCell cell = rowSecond.createCell(i);
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(style1);
            }
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, String> map : failList) {
                row = sheet1.createRow(rowIndex);
                row.createCell(0).setCellValue(map.get("name"));
                row.createCell(1).setCellValue(map.get("idCardNo"));
                row.createCell(2).setCellValue(map.get("bankCardNo"));
                row.createCell(3).setCellValue(map.get("amount"));
                row.createCell(4).setCellValue(map.get("errorMsg"));
                ++rowIndex;
            }
            fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
            String platform = this.commonService.getSystemConfig("PLATFORM_SIGN");
            String aliUrl = BcxinFileUtils.aliOSSFileTempUpload(file, platform);
            file.delete();
            String string = aliUrl;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Result deleteComBhGrantDetailById(ComBhGrantDetail comBhGrantDetail) throws V5BusinessException {
        if (comBhGrantDetail.getComBhGrantDetailId() == null) {
            throw new V5BusinessException("-1", "\u8bf7\u9009\u4e2d\u9700\u8981\u5220\u9664\u7684\u4ee3\u53d1\u8bb0\u5f55");
        }
        if ((comBhGrantDetail = this.comBhGrantDetailMapper.getComBhGrantDetailById(comBhGrantDetail.getComBhGrantDetailId())) == null) {
            throw new V5BusinessException("-1", "\u4ee3\u53d1\u8bb0\u5f55ID\u6709\u8bef");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(comBhGrantDetail.getComBhGrantId());
        comBhGrantInfo.setGrantCount(comBhGrantInfo.getGrantCount() - 1);
        comBhGrantInfo.setSumAmount(comBhGrantInfo.getSumAmount().subtract(comBhGrantDetail.getAmount()));
        comBhGrantInfo.setUpdateBy(comBhGrantDetail.getUpdateBy());
        comBhGrantInfo.setUpdateTime(comBhGrantDetail.getUpdateTime());
        this.comBhGrantInfoMapper.updateComBhGrantInfo(comBhGrantInfo);
        this.comBhGrantDetailMapper.deleteById(comBhGrantDetail.getComBhGrantDetailId());
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result commitGrantApply(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getRemark())) {
            throw new V5BusinessException("-1", "\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(dto.getComBhGrantId());
        if (comBhGrantInfo == null) {
            throw new V5BusinessException("-1", "\u53d1\u653eID\u6709\u8bef");
        }
        String txtTitle = comBhGrantInfo.getSumAmount() + "," + comBhGrantInfo.getGrantCount();
        List<Map<String, Object>> grantDetailList = this.comBhGrantDetailMapper.getComBhGrantDetailList(dto);
        if (grantDetailList == null) {
            throw new V5BusinessException("-1", "\u6ca1\u6709\u53d1\u653e\u660e\u7ec6");
        }
        Map<String, String> map = this.buildGrantFile(txtTitle, grantDetailList, dto);
        String platform = this.commonService.getSystemConfig("PLATFORM_SIGN");
        if (!ObjectUtils.equals(platform, "SAAS-QY")) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)map.get("fileUrl"));
        }
        HashMap params = Maps.newHashMap();
        params.put("dfmxPath", map.get("fileUrl"));
        String token = JwtUtil.createJWT(params);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/uploadSFTP"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            String resultFile = result.getData().toString();
            HashMap p = Maps.newHashMap();
            p.put("MerUserId", dto.getComId().toString());
            p.put("VerifyNo", dto.getActiveCode());
            p.put("VirlAcctType", "01");
            p.put("FileName", resultFile);
            p.put("NoticeType", BHGRANTFILETYPE);
            token = JwtUtil.createJWT(p);
            requestMap.put("token", token);
            platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
            resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/undertakesDetail"), (Map)requestMap);
            result = (Result)JSON.parseObject((String)resultStr, Result.class);
            if ("0".equals(result.getRetType())) {
                comBhGrantInfo.setTotalGrantCount(comBhGrantInfo.getGrantCount());
                comBhGrantInfo.setTotalSumAmount(comBhGrantInfo.getSumAmount());
                comBhGrantInfo.setUpdateBy(dto.getUpdateBy());
                comBhGrantInfo.setUpdateTime(dto.getUpdateTime());
                comBhGrantInfo.setCommitStatus("1");
                comBhGrantInfo.setFileName(map.get("fileName"));
                this.comBhGrantInfoMapper.updateComBhGrantInfo(comBhGrantInfo);
                ComBhGrantOperRecord record = new ComBhGrantOperRecord();
                record.setCreateBy(dto.getCreateBy());
                record.setCreateTime((Date)DateUtil.date());
                record.setComId(dto.getComId());
                record.setComBhGrantId(dto.getComBhGrantId());
                record.setComBhGrantOperRecordId(this.idWorker.nextId());
                record.setOperResult("\u63d0\u4ea4\u53d1\u653e\u7533\u8bf7");
                record.setOperGrantFuncType("6");
                this.comBhGrantOperRecordMapper.insertComBhGrantOperRecord(record);
                return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
            }
            return Result.fail((String)result.getMsg());
        }
        return Result.fail((String)result.getMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> buildGrantFile(String title, List<Map<String, Object>> grantDetailList, ComBhGrantInfoDTO dto) throws V5BusinessException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        BufferedWriter out = null;
        OutputStreamWriter fw = null;
        try {
            String upload_path = this.commonService.getSystemConfig("SYS_PIC_PATH");
            String dirDate = DateUtil.today();
            String dirPaht = upload_path + "temp/" + dirDate;
            File dir = new File(dirPaht);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Date date = new Date();
            String day = DateUtils.formatDate(date, "yyyyMMdd");
            String fileName = "4_" + day + "_" + BHGRANTQDDM + "_" + DateUtils.formatDate(date, "HHmmss") + ".rq";
            resultMap.put("fileName", fileName);
            String filePath = dirPaht + "/" + fileName;
            File file = new File(filePath);
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");
            out = new BufferedWriter(fw);
            String line = "\r\n";
            out.write(title + line);
            int i = 1;
            String today = DateUtils.formatDate(date, new Object[0]);
            for (Map<String, Object> map : grantDetailList) {
                String info = String.valueOf(i) + "," + fileName + "," + map.get("bankCardNo") + "," + map.get("name") + "," + map.get("amount") + "," + "01" + "," + today + "," + map.get("comBhGrantDetailId") + "," + dto.getRemark();
                if (i < grantDetailList.size()) {
                    out.write(info + line);
                } else {
                    out.write(info);
                }
                ++i;
            }
            out.flush();
            out.close();
            String platform = this.commonService.getSystemConfig("PLATFORM_SIGN");
            String aliUrl = BcxinFileUtils.aliOSSFixFileTempUpload(file, platform);
            file.delete();
            resultMap.put("fileUrl", aliUrl);
            HashMap<String, String> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Result commitGrantApplyCs(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            throw new V5BusinessException("-1", "\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(dto.getComBhGrantId());
        if (comBhGrantInfo == null) {
            throw new V5BusinessException("-1", "\u53d1\u653eID\u6709\u8bef");
        }
        HashMap requestMap = Maps.newHashMap();
        HashMap p = Maps.newHashMap();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VerifyNo", dto.getActiveCode());
        p.put("VirlAcctType", "01");
        p.put("FileName", dto.getKeyword());
        p.put("NoticeType", BHGRANTFILETYPE);
        p.put("ReMark", dto.getRemark());
        String token = JwtUtil.createJWT(p);
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/undertakesDetail"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            comBhGrantInfo.setTotalGrantCount(comBhGrantInfo.getGrantCount());
            comBhGrantInfo.setTotalSumAmount(comBhGrantInfo.getSumAmount());
            comBhGrantInfo.setUpdateBy(dto.getUpdateBy());
            comBhGrantInfo.setUpdateTime(dto.getUpdateTime());
            comBhGrantInfo.setCommitStatus("1");
            this.comBhGrantInfoMapper.updateComBhGrantInfo(comBhGrantInfo);
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result getBhGrantOperRecordList(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            return Result.fail((String)"\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Map<String, Object>> list = this.comBhGrantOperRecordMapper.getBhGrantOperRecordList(dto.getComBhGrantId());
        return Result.success((String)"", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getBhBankReceiptFileUrl(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            return Result.fail((String)"\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(dto.getComBhGrantId());
        if (comBhGrantInfo == null) {
            return Result.fail((String)"\u53d1\u653eID\u6709\u8bef");
        }
        if (StringUtil.isNotEmpty((String)comBhGrantInfo.getBankReceiptFileUrl())) {
            return Result.success((String)comBhGrantInfo.getBankReceiptFileUrl());
        }
        HashMap requestMap = Maps.newHashMap();
        HashMap p = Maps.newHashMap();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VirlAcctType", "01");
        p.put("FileName", comBhGrantInfo.getFileName());
        String token = JwtUtil.createJWT(p);
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/getPdfFileName"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            if (result.getData() == null) {
                return Result.fail((String)"\u83b7\u53d6\u7535\u5b50\u56de\u5355\u6587\u4ef6\u540d\u79f0\u5931\u8d25\uff01");
            }
            String data = String.valueOf(result.getData());
            String FileName = data.substring(2, data.length() - 2);
            HashMap params = Maps.newHashMap();
            params.put("FileName", FileName);
            token = JwtUtil.createJWT(params);
            requestMap.put("token", token);
            platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
            resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/dowloadSFTP"), (Map)requestMap);
            result = (Result)JSON.parseObject((String)resultStr, Result.class);
            if ("0".equals(result.getRetType())) {
                String fileStr = result.getData().toString();
                try {
                    String upload_path = this.commonService.getSystemConfig("SYS_PIC_PATH");
                    String dirDate = DateUtil.today();
                    String dirPaht = upload_path + "temp/" + dirDate;
                    File dir = new File(dirPaht);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    String fileName = this.idWorker.nextId() + ".pdf";
                    String filePath = dirPaht + "/" + fileName;
                    Base64Utils.decodeToFile(filePath, fileStr);
                    File file = new File(filePath);
                    String platform = this.commonService.getSystemConfig("PLATFORM_SIGN");
                    String aliUrl = BcxinFileUtils.aliOSSFixFileTempUpload(file, platform);
                    file.delete();
                    comBhGrantInfo.setBankReceiptFileUrl(aliUrl);
                    comBhGrantInfo.setUpdateTime(new Date());
                    comBhGrantInfo.setUpdateBy(dto.getUpdateBy());
                    this.comBhGrantInfoMapper.updateComBhGrantInfo(comBhGrantInfo);
                    Result result2 = Result.success((String)aliUrl);
                    return result2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Result result3 = Result.success((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u51fa\u9519");
                    return result3;
                }
            }
            return Result.fail((String)result.getMsg());
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result syncBhGrantResult(ComBhGrantInfoDTO dto) throws V5BusinessException {
        if (dto.getComBhGrantId() == null) {
            return Result.fail((String)"\u53d1\u653eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhGrantInfo comBhGrantInfo = this.comBhGrantInfoMapper.getComBhGrantInfoById(dto.getComBhGrantId());
        if (comBhGrantInfo == null) {
            return Result.fail((String)"\u4ee3\u53d1\u5355ID\u6709\u8bef");
        }
        if (ObjectUtils.equals(comBhGrantInfo.getIsSyncBankResult(), "1")) {
            return Result.fail((String)"\u4ee3\u53d1\u7ed3\u679c\u5df2\u540c\u6b65\uff0c\u65e0\u9700\u518d\u6b21\u540c\u6b65");
        }
        if (ObjectUtils.equals(comBhGrantInfo.getCommitStatus(), "1") && ObjectUtils.equals(comBhGrantInfo.getIsSyncBankResult(), "0")) {
            HashMap requestMap = Maps.newHashMap();
            HashMap p = Maps.newHashMap();
            p.put("MerUserId", dto.getComId().toString());
            p.put("VirlAcctType", "01");
            p.put("FileName", comBhGrantInfo.getFileName());
            String token = JwtUtil.createJWT(p);
            requestMap.put("token", token);
            String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
            String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/querySubstituteResult"), (Map)requestMap);
            Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
            if ("0".equals(result.getRetType())) {
                Map resultMap = (Map)result.getData();
                if (resultMap != null && resultMap.get("TransInfoList") != null) {
                    List transInfoList = JSON.parseArray((String)resultMap.get("TransInfoList").toString(), Map.class);
                    logger.info(JSON.toJSONString((Object)transInfoList));
                    ArrayList<Map> successTransInfoList = new ArrayList<Map>();
                    ArrayList<Map> failTransInfoList = new ArrayList<Map>();
                    BigDecimal totalSumAmount = new BigDecimal(0);
                    BigDecimal failSumAmount = new BigDecimal(0);
                    for (Map map : transInfoList) {
                        if (ObjectUtils.equals(map.get("HrspCode").toString(), "000000")) {
                            successTransInfoList.add(map);
                            totalSumAmount = totalSumAmount.add(new BigDecimal(map.get("Amt").toString()));
                            continue;
                        }
                        failSumAmount = failSumAmount.add(new BigDecimal(map.get("Amt").toString()));
                        failTransInfoList.add(map);
                    }
                    if (successTransInfoList != null && successTransInfoList.size() > 0) {
                        this.comBhGrantDetailMapper.updateBhGrantSuccessDetail(dto.getUpdateBy(), dto.getComBhGrantId(), successTransInfoList);
                    }
                    if (failTransInfoList != null && failTransInfoList.size() > 0) {
                        this.comBhGrantDetailMapper.updateBhGrantFailDetail(dto.getUpdateBy(), dto.getComBhGrantId(), failTransInfoList);
                    }
                    comBhGrantInfo.setTotalSumAmount(totalSumAmount);
                    comBhGrantInfo.setTotalGrantCount(successTransInfoList.size());
                    comBhGrantInfo.setFailSumAmount(failSumAmount);
                    comBhGrantInfo.setFailGrantCount(failTransInfoList.size());
                    comBhGrantInfo.setUpdateTime(new Date());
                    comBhGrantInfo.setUpdateBy(dto.getUpdateBy());
                    comBhGrantInfo.setIsSyncBankResult("1");
                    this.comBhGrantInfoMapper.updateComBhGrantInfo(comBhGrantInfo);
                    return Result.success((String)"");
                }
            } else {
                return Result.fail((String)result.getMsg());
            }
        }
        return Result.success((String)"");
    }
}

